/*
 * Decompiled with CFR 0.152.
 */
package devProjection;

import dev.geom.PuElementSetIterator;
import devProjection.PgIntrinsicPolygon;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgPointSetOnElementSet;
import jvx.geom.PgPointSetOnPolygon;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBary;
import jvx.geom.PwBoundary;
import jvx.numeric.PnJacobi;

public class PnProjection {
    private PdBaryDir m_dir = new PdBaryDir(3);
    private PdBary m_endPointBary = new PdBary(3);
    private PdBary m_nBary = new PdBary(3);
    private PdVector m_destVec = new PdVector(3);
    private PgVertexStar m_star = new PgVertexStar();
    private PdVector m_edge = new PdVector(3);

    public static PdBary[] projectPointSetOntoElementSet(PgPointSet geom, PgElementSet domain) {
        int numV = geom.getNumVertices();
        PdBary[] bary = new PdBary[numV];
        int v = 0;
        while (v < numV) {
            PdVector vertex = geom.getVertex(v);
            bary[v] = new PdBary(3);
            PwBary.projectOntoElementSet((PgElementSet)domain, (PdVector)vertex, (PdBary)bary[v]);
            PwBary.getVertex((PdVector)vertex, (PgElementSet)domain, (PdBary)bary[v]);
            ++v;
        }
        return bary;
    }

    private static int highestOneBit(int i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i - (i >>> 1);
    }

    public static PdBary[] projectPointSetOntoElementSet(PgPointSet geom, PgElementSet domain, boolean bKeepSelected) {
        if (domain == null) {
            PsDebug.warning((String)"missing domain.");
            return null;
        }
        if (geom == null) {
            PsDebug.warning((String)"missing point set.");
            return null;
        }
        if (domain.getDimOfElements() != 3) {
            PsDebug.warning((String)"Domain must be triangulated.");
            return null;
        }
        if (!domain.hasElementNormals()) {
            PsDebug.warning((String)"Domain did not have element normals - normals will be computed now.");
            domain.makeElementNormals();
        }
        boolean PRINT_EFFICIENCY = false;
        PsDebug.showStatus((String)"Shape Analysis ... ");
        int numV1 = geom.getNumVertices();
        int numV2 = domain.getNumVertices();
        int numE = domain.getNumElements();
        PdBary[] bary = new PdBary[numV1];
        PdVector diagonal = PnProjection.computePrincipalAxes(geom)[0];
        PdVector pos1 = new PdVector(numV1);
        int i = 0;
        while (i < numV1) {
            pos1.m_data[i] = diagonal.dot(geom.getVertex(i));
            ++i;
        }
        PdVector maxElemPos = new PdVector(numE);
        PdVector minElemPos = new PdVector(numE);
        PdVector centerPos = new PdVector(numE);
        int i2 = 0;
        while (i2 < numE) {
            PiVector elem = domain.getElement(i2);
            double v1 = domain.getVertex(elem.getEntry(0)).dot(diagonal);
            double v2 = domain.getVertex(elem.getEntry(1)).dot(diagonal);
            double v3 = domain.getVertex(elem.getEntry(2)).dot(diagonal);
            double max = Math.max(v1, Math.max(v2, v3));
            double min = Math.min(v1, Math.min(v2, v3));
            maxElemPos.m_data[i2] = max;
            minElemPos.m_data[i2] = min;
            centerPos.m_data[i2] = (max + min) / 2.0;
            ++i2;
        }
        int[] index = new int[numE];
        PuMath.heapsort((int)numE, (double[])centerPos.m_data, (int[])index);
        PdVector maximumSoFar = new PdVector(numE);
        double max = Double.NEGATIVE_INFINITY;
        int i3 = 0;
        while (i3 < numE) {
            maximumSoFar.m_data[i3] = max;
            if (maxElemPos.m_data[index[i3]] > max) {
                max = maxElemPos.m_data[index[i3]];
            }
            ++i3;
        }
        PdVector minimumAhead = new PdVector(numE);
        double min = Double.POSITIVE_INFINITY;
        int i4 = numE - 1;
        while (i4 >= 0) {
            minimumAhead.m_data[i4] = min;
            if (minElemPos.m_data[index[i4]] < min) {
                min = minElemPos.m_data[index[i4]];
            }
            --i4;
        }
        long numLoops = 0L;
        long t = System.currentTimeMillis();
        int v = 0;
        while (v < numV1) {
            PdVector p = new PdVector(3);
            PdBary bar = new PdBary(3);
            PdVector minVertex = new PdVector(3);
            long remainingTime = (System.currentTimeMillis() - t) * (long)(numV1 - v) / (long)(v + 1) / 1000L;
            PsDebug.showStatus((String)("Projecting ... " + (double)((long)v * 1000L / (long)numV1) / 10.0 + "%, " + "" + "time remaining: " + remainingTime + "s"));
            if (!bKeepSelected || !geom.hasTagVertex(v, 1)) {
                int bitPos = PnProjection.highestOneBit(numE);
                int startElem = 0;
                double posV = pos1.m_data[v];
                while (bitPos > 0) {
                    if (startElem + bitPos < numE && centerPos.m_data[index[startElem + bitPos]] < posV) {
                        startElem += bitPos;
                    }
                    bitPos >>= 1;
                }
                double minDist = Double.POSITIVE_INFINITY;
                int currEl = index[startElem];
                int up = startElem;
                int down = startElem;
                bary[v] = new PdBary(3);
                while (true) {
                    ++numLoops;
                    int[] elem = domain.getElement((int)currEl).m_data;
                    double dist = Math.abs(PuVectorGeom.distOfPointToPlane((PdVector)geom.getVertex(v), (PdVector)domain.getVertex(elem[0]), (PdVector)domain.getElementNormal(currEl)));
                    if (dist < minDist) {
                        PdBary.getBaryInside((PdBary)bar, (PdVector)geom.getVertex(v), (PdVector[])domain.getElementVertices(currEl));
                        bar.getVertex(p, domain.getVertex(elem[0]), domain.getVertex(elem[1]), domain.getVertex(elem[2]));
                        dist = p.dist(geom.getVertex(v));
                        if (dist < minDist) {
                            minDist = dist;
                            minVertex.copyArray(p);
                            bary[v].copy(bar);
                            bary[v].setElementInd(currEl);
                        }
                    }
                    double nextUpDist = Double.POSITIVE_INFINITY;
                    if (up != numE - 1 && minimumAhead.m_data[up] - posV <= minDist) {
                        while (minElemPos.m_data[index[up + 1]] - posV > minDist) {
                            ++up;
                        }
                        nextUpDist = centerPos.m_data[index[up + 1]] - posV;
                    }
                    double nextDownDist = Double.POSITIVE_INFINITY;
                    if (down != 0 && posV - maximumSoFar.m_data[down] <= minDist) {
                        while (posV - maxElemPos.m_data[index[down - 1]] > minDist) {
                            --down;
                        }
                        nextDownDist = posV - centerPos.m_data[index[down - 1]];
                    }
                    if (nextDownDist == Double.POSITIVE_INFINITY && nextUpDist == Double.POSITIVE_INFINITY) break;
                    if (nextUpDist < nextDownDist) {
                        currEl = index[++up];
                        continue;
                    }
                    currEl = index[--down];
                }
                geom.getVertex(v).copyArray(minVertex);
            }
            ++v;
        }
        if (geom instanceof PgElementSet) {
            ((PgElementSet)geom).makeElementNormals();
        }
        PsDebug.showStatus((String)"");
        return bary;
    }

    private static PdVector[] computePrincipalAxes(PgPointSet geom) {
        PdMatrix adjoint = new PdMatrix(3);
        PdVector center = geom.getCenterOfGravity();
        PdMatrix covariance = new PdMatrix(3);
        PdVector diff = new PdVector(3);
        int i = 0;
        while (i < geom.getNumVertices()) {
            diff.sub(geom.getVertex(i), center);
            adjoint.adjoint(diff);
            covariance.add(adjoint);
            ++i;
        }
        PdVector eigenVal = new PdVector(3);
        PdVector[] eigenVec = new PdVector[]{new PdVector(3), new PdVector(3), new PdVector(3)};
        PnJacobi.computeEigenvectors((PdMatrix)covariance, (int)3, (PdVector)eigenVal, (PdVector[])eigenVec);
        return eigenVec;
    }

    public static void projectPointSetOntoPolygon(PgPointSet pointSet, PgPolygon domain, PdBary[] bary) {
        int numV = pointSet.getNumVertices() - 1;
        int v = 0;
        while (v < numV) {
            PdVector vertex = pointSet.getVertex(v);
            PwBary.projectOntoPolygon((PdVector)vertex, (PgPolygon)domain, (PdBary)bary[v]);
            ++v;
        }
    }

    public boolean projectOntoElementSet(PgElementSet geom, PdBary startPoint, PdVector point, boolean walkAlongBoundary, PdBary outBary) {
        return this.projectLocal(geom, startPoint, point, null, true, outBary, null);
    }

    public boolean projectLocal(PgElementSet geom, PdBary bary, PdVector point, PdVector dir, boolean walkAlongBoundary, PdBary outBary, PgIntrinsicPolygon outPoly) {
        if (geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry must be triangulated");
            return false;
        }
        int e = bary.getElementInd();
        if (e < 0) {
            PsDebug.warning((String)"No element index set in bary.");
            return false;
        }
        int locEdgeInd = bary.isOnEdge(PgPolygonOnElementSet.BARYEPS);
        if (outBary != null) {
            outBary.copy(bary);
            bary = outBary;
        }
        do {
            int locVertInd;
            if ((locVertInd = bary.isOnVertex(PgPolygonOnElementSet.BARYEPS)) >= 0) {
                locEdgeInd = this.handleVertex(geom, bary, locVertInd, point, walkAlongBoundary, outPoly);
                if (locEdgeInd != -2) continue;
                return true;
            }
            if (locEdgeInd >= 0) {
                if ((locEdgeInd = this.handleEdge(geom, bary, locEdgeInd, point, walkAlongBoundary)) != -2) continue;
                return false;
            }
            locEdgeInd = -1;
        } while ((locEdgeInd = this.shootInTriangle(geom, bary, point, locEdgeInd, locEdgeInd >= 0, outPoly)) >= 0);
        return locEdgeInd == -1;
    }

    private int handleEdge(PgElementSet geom, PdBary bary, int locEdgeInd, PdVector destinationPoint, boolean walkAlongBoundary) {
        int e = bary.getElementInd();
        int ne = geom.getNeighbour((int)e).m_data[locEdgeInd];
        if (!walkAlongBoundary && ne < 0) {
            return -2;
        }
        boolean shootOnEdge = true;
        PwBary.getVertex((PdVector)this.m_destVec, (PgElementSet)geom, (PdBary)bary);
        this.m_destVec.sub(destinationPoint);
        this.m_destVec.normalize();
        this.m_destVec.multScalar(-1.0);
        double dot = Double.MAX_VALUE;
        if (PwBary.projectOntoElement((PgElementSet)geom, (int)e, (PdVector)destinationPoint, (PdBary)this.m_endPointBary) != null && this.m_endPointBary.m_data[locEdgeInd] > 0.0) {
            shootOnEdge = false;
            dot = Math.abs(this.m_destVec.dot(geom.getElementNormal(e)));
        }
        if (ne != -1 && PwBary.projectOntoElement((PgElementSet)geom, (int)ne, (PdVector)destinationPoint, (PdBary)this.m_endPointBary) != null) {
            int nLocEdgeInd = geom.getNeighbour(ne).getIndexOf(e);
            if (nLocEdgeInd < 0) {
                PsDebug.warning((String)"Invalid neighbours");
                return -2;
            }
            if (this.m_endPointBary.m_data[nLocEdgeInd] > 0.0 && Math.abs(this.m_destVec.dot(geom.getElementNormal(ne))) < dot) {
                shootOnEdge = false;
                locEdgeInd = PwBary.changeBarycentricOnEdge((PgElementSet)geom, (PdBary)bary, (int)locEdgeInd);
            }
        }
        if (shootOnEdge) {
            return locEdgeInd;
        }
        return -1;
    }

    private int handleVertex(PgElementSet geom, PdBary bary, int locVertInd, PdVector destinationPoint, boolean walkAlongBoundary, PgIntrinsicPolygon outPoly) {
        int locInd;
        int e = bary.getElementInd();
        int v = geom.getElement((int)e).m_data[locVertInd];
        this.m_star.makeVertexStar(geom, v, e);
        double dot = Double.MAX_VALUE;
        this.m_destVec.sub(destinationPoint, geom.getVertex(v));
        double len = this.m_destVec.length();
        if (len < 1.0E-10) {
            return -2;
        }
        this.m_destVec.multScalar(1.0 / len);
        PiVector elements = this.m_star.getElement();
        PiVector locInds = this.m_star.getVertexLocInd();
        PiVector link = this.m_star.getLink();
        int numE = this.m_star.getSize();
        int bestElementInd = -1;
        boolean shootOnEdge = false;
        int i = 0;
        while (i < numE) {
            double newDot;
            int ne = elements.m_data[i];
            int nLocInd = locInds.m_data[i];
            if (PwBary.projectOntoElement((PgElementSet)geom, (int)ne, (PdVector)destinationPoint, (PdBary)this.m_endPointBary) != null && this.m_endPointBary.m_data[(nLocInd + 1) % 3] > 0.0 && this.m_endPointBary.m_data[(nLocInd + 2) % 3] > 0.0 && (newDot = Math.abs(this.m_destVec.dot(geom.getElementNormal(e)))) < dot) {
                dot = newDot;
                bestElementInd = i;
                shootOnEdge = false;
            }
            ++i;
        }
        if (bestElementInd != -1) {
            int increment = 1;
            if (!this.m_star.isClosed() && bestElementInd < elements.getIndexOf(e)) {
                increment = -1;
            }
            int ind = elements.getIndexOf(e);
            while (ind != bestElementInd) {
                locInd = geom.getNeighbour(elements.m_data[ind]).getIndexOf(elements.m_data[(numE + ind + increment) % numE]);
                PwBary.changeBarycentricOnEdge((PgElementSet)geom, (PdBary)bary, (int)locInd);
                if (outPoly != null) {
                    outPoly.addVertexIntrinsic(bary);
                }
                ind = (numE + ind + increment) % numE;
            }
            return -1;
        }
        dot = 0.0;
        int bestVertexInd = -1;
        int numV = numE;
        if (!this.m_star.isClosed()) {
            ++numV;
        }
        int i2 = 0;
        while (i2 < numV) {
            this.m_edge.sub(geom.getVertex(link.m_data[i2]), geom.getVertex(v));
            double newDot = PdVector.dot((PdVector)this.m_edge, (PdVector)this.m_destVec);
            if (newDot > dot) {
                dot = newDot;
                bestVertexInd = i2;
                shootOnEdge = true;
            }
            ++i2;
        }
        if (!shootOnEdge) {
            return -2;
        }
        if (!(walkAlongBoundary || this.m_star.isClosed() || bestVertexInd != 0 && bestVertexInd != numV - 1)) {
            return -2;
        }
        int i3 = 0;
        while (i3 < numE) {
            int elInd = (e + i3) % numE;
            PiVector element = geom.getElement(elements.m_data[elInd]);
            int elementSize = element.getSize();
            if (element.m_data[(locInds.m_data[elInd] + elementSize + 1) % elementSize] == link.m_data[bestVertexInd] || element.m_data[(locInds.m_data[elInd] + elementSize - 1) % elementSize] == link.m_data[bestVertexInd]) {
                bestElementInd = elInd;
                break;
            }
            ++i3;
        }
        int increment = 1;
        if (!this.m_star.isClosed() && bestElementInd < elements.getIndexOf(e)) {
            increment = -1;
            if (bestVertexInd != 0) {
                ++bestElementInd;
            }
        }
        int ind = elements.getIndexOf(e);
        while (ind != bestElementInd) {
            locInd = geom.getNeighbour(elements.m_data[ind]).getIndexOf(elements.m_data[(numE + ind + increment) % numE]);
            PwBary.changeBarycentricOnEdge((PgElementSet)geom, (PdBary)bary, (int)locInd);
            if (outPoly != null) {
                outPoly.addVertexIntrinsic(bary);
            }
            ind = (numE + ind + increment) % numE;
        }
        locInd = geom.getElement(elements.m_data[bestElementInd]).getIndexOf(link.m_data[bestVertexInd]);
        if (locInd < 0) {
            PsDebug.warning((String)"Problem in neighbours");
            return -2;
        }
        return 3 - locInd - locInds.m_data[bestElementInd];
    }

    private int shootInTriangle(PgElementSet geom, PdBary bary, PdVector point, int locEdgeInd, boolean shootOnEdge, PgIntrinsicPolygon outPoly) {
        int e = bary.getElementInd();
        if (PwBary.projectOntoElement((PgElementSet)geom, (int)e, (PdVector)point, (PdBary)this.m_endPointBary) == null) {
            PsDebug.warning((String)"Projected polygon ends in degenerated triangle.");
            return -2;
        }
        double time = 1.0;
        if (shootOnEdge) {
            PwBary.projectOntoElementEdge((PgElementSet)geom, (PdBary)this.m_endPointBary, (int)locEdgeInd);
        }
        this.m_dir.sub(this.m_endPointBary, bary);
        int newLocEdgeInd = -1;
        int j = 0;
        while (j < 3) {
            if (j != locEdgeInd) {
                double t = -bary.m_data[j] / this.m_dir.m_data[j];
                if (this.m_dir.m_data[j] < 0.0 && t >= 0.0 && t <= time + PgPolygonOnElementSet.BARYEPS) {
                    time = Math.min(t, 1.0);
                    newLocEdgeInd = j;
                }
            }
            ++j;
        }
        locEdgeInd = newLocEdgeInd;
        if (time == 0.0) {
            PsDebug.warning((String)"Possible endlessloop detected. Abort.");
            return -2;
        }
        this.m_dir.multScalar(time);
        bary.add(this.m_dir);
        if (outPoly != null) {
            outPoly.addVertexIntrinsic(bary);
        }
        return locEdgeInd;
    }

    public boolean projectLocal2(PgElementSet geom, PdBary bary, PdVector point, PdVector dir, boolean walkAlongBoundary, PdBary outBary, PgIntrinsicPolygon outPoly) {
        int locIdx;
        double time;
        if (geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry must be triangulated");
            return false;
        }
        int prevE = -1;
        int e = bary.getElementInd();
        if (e < 0) {
            PsDebug.warning((String)"No element index set in bary.");
            return false;
        }
        if (outBary != null) {
            outBary.copy(bary);
            bary = outBary;
        }
        do {
            if (PwBary.projectOntoElement((PgElementSet)geom, (int)e, (PdVector)point, (PdBary)this.m_endPointBary) == null) {
                PsDebug.warning((String)"Projected polygon ends in degenerated triangle.");
                return true;
            }
            this.m_dir.sub(this.m_endPointBary, bary);
            time = 1.0;
            locIdx = -1;
            int j = 0;
            while (j < 3) {
                double t = -bary.m_data[j] / this.m_dir.m_data[j];
                if (this.m_dir.m_data[j] < 0.0 && t >= 0.0 && t <= time + PgPolygonOnElementSet.BARYEPS) {
                    time = Math.min(t, 1.0);
                    locIdx = j;
                }
                ++j;
            }
            this.m_dir.multScalar(time);
            bary.add(this.m_dir);
            if (locIdx < 0) continue;
            PwBary.projectOntoElementEdge((int)locIdx, (PdBary)bary);
            int ne = geom.getNeighbour((int)e).m_data[locIdx];
            if (ne < 0) {
                if (outPoly != null) {
                    outPoly.addVertexIntrinsic(bary);
                }
                if (!walkAlongBoundary) {
                    return true;
                }
                PsDebug.warning((String)"Polygon cutted at surface boundary.");
                return true;
            }
            if (outPoly != null) {
                if (ne != prevE) {
                    outPoly.addVertexIntrinsic(bary);
                } else {
                    outPoly.setNumVertices(outPoly.getNumVertices() - 1);
                }
            }
            PiVector element = geom.getElement(e);
            PiVector nElement = geom.getElement(ne);
            boolean walkBack = ne == prevE;
            prevE = !walkBack ? e : -1;
            int idx1 = (locIdx + 1) % 3;
            int nIdx1 = nElement.getIndexOf(element.m_data[idx1]);
            int idx2 = (locIdx + 2) % 3;
            int nIdx2 = nElement.getIndexOf(element.m_data[idx2]);
            this.m_nBary.set(0.0, 0.0, 0.0);
            this.m_nBary.m_data[nIdx1] = bary.m_data[idx1];
            this.m_nBary.m_data[nIdx2] = bary.m_data[idx2];
            bary.copy(this.m_nBary);
            e = ne;
            bary.setElementInd(e);
            if (!walkBack) continue;
            return false;
        } while (!(time >= 1.0));
        if (locIdx < 0) {
            outPoly.addVertexIntrinsic(bary);
        }
        return false;
    }

    public static PdBary projectLocal(PdVector point, PgPolygon polygon, PdBary projectionBary, PdVector projection) {
        if (projectionBary == null) {
            projectionBary = new PdBary(3);
        } else {
            projectionBary.setSize(3);
        }
        int numEdges = polygon.getNumVertices() - 1;
        int edge = projectionBary.getElementInd();
        int bestVertex = -1;
        while (true) {
            PdVector v1;
            PdVector v0;
            if (!PdBary.getBary((PdBary)projectionBary, (PdVector)point, (PdVector)(v0 = polygon.getVertex(edge)), (PdVector)(v1 = polygon.getVertex(edge + 1)))) {
                PsDebug.warning((String)"Polygon must not have two neighbour vertices which are at the same location");
                return null;
            }
            double t = projectionBary.m_data[1];
            if (t <= 0.0) {
                if (edge == 0 || bestVertex == edge) {
                    projectionBary.set(0.0, 1.0);
                    break;
                }
                bestVertex = edge--;
                continue;
            }
            if (!(t >= 1.0)) break;
            if (edge == numEdges - 1 || bestVertex == edge + 1) {
                projectionBary.set(1.0, 0.0);
                break;
            }
            bestVertex = edge + 1;
            ++edge;
        }
        projectionBary.setElementInd(edge);
        if (projection != null) {
            PwBary.getVertex((PdVector)projection, (PgPolygon)polygon, (PdBary)projectionBary);
        }
        return projectionBary;
    }

    public static PgIntrinsicPolygon projectPolygonOntoElementSet(PgElementSet geom, PiVector curve, PgIntrinsicPolygon outCurve, int incidentElement) {
        if (outCurve == null) {
            outCurve = new PgIntrinsicPolygon(geom);
        } else {
            outCurve.setGeometry(geom);
        }
        outCurve.setName("Projected " + curve.getName());
        int num = curve.getSize();
        int i = 0;
        while (i < num) {
            outCurve.addVertexIntrinsic(curve.m_data[i], incidentElement);
            ++i;
        }
        return outCurve;
    }

    public PgIntrinsicPolygon projectPolygonOntoElementSet(PgElementSet geom, PgPolygon curve, PdBary startPoint, boolean walkAlongBoundary, PgIntrinsicPolygon outCurve) {
        return (PgIntrinsicPolygon)this.projectPolygonOntoElementSet_(geom, curve, startPoint, walkAlongBoundary, outCurve, true);
    }

    public PgPolygonOnElementSet projectPolygonOntoElementSet(PgElementSet geom, PgPolygon curve, PdBary startPoint, boolean walkAlongBoundary, PgPolygonOnElementSet outCurve) {
        return this.projectPolygonOntoElementSet_(geom, curve, startPoint, walkAlongBoundary, outCurve, false);
    }

    private PgPolygonOnElementSet projectPolygonOntoElementSet_(PgElementSet geom, PgPolygon curve, PdBary startPoint, boolean walkAlongBoundary, PgPolygonOnElementSet outCurve, boolean intrinsic) {
        if (geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry must be triangulated");
            return null;
        }
        if (!geom.hasElementNormals()) {
            geom.makeElementNormals();
        }
        if (intrinsic) {
            if (outCurve == null) {
                outCurve = new PgIntrinsicPolygon(geom);
            } else {
                if (!(outCurve instanceof PgIntrinsicPolygon)) {
                    PsDebug.warning((String)"Polygon must derive from (PgIntrinsicPolygon)");
                    return null;
                }
                outCurve.setGeometry(geom);
            }
        } else if (outCurve == null) {
            outCurve = new PgPolygonOnElementSet(geom);
        } else {
            outCurve.setGeometry(geom);
        }
        outCurve.setName("Projected " + curve.getName());
        int numVertices = curve.getNumVertices();
        int numEdges = curve.getNumEdges();
        outCurve.setClosed(curve.isClosed());
        if (numVertices == 0) {
            return outCurve;
        }
        PdBary bary = null;
        if (startPoint == null) {
            bary = PwBary.projectOntoElementSet((PgElementSet)geom, (PdVector)curve.getVertex(0), null);
        } else {
            bary = new PdBary(3);
            this.projectLocal(geom, startPoint, curve.getVertex(0), null, walkAlongBoundary, bary, null);
        }
        if (bary == null) {
            return null;
        }
        if (numVertices > 1 && bary.isOnEdge() != -1) {
            PdBary[] baries = PwBary.getBaryDescriptions((PgElementSet)geom, (PdBary)bary, (double)PgPolygonOnElementSet.BARYEPS);
            double minDist = Double.POSITIVE_INFINITY;
            int bestIndex = -1;
            int i = 0;
            while (i < baries.length) {
                int e = baries[i].getElementInd();
                double dist = Math.abs(PuVectorGeom.distOfPointToPlane((PdVector)curve.getVertex(1), (PdVector)geom.getVertex(geom.getElement((int)e).m_data[0]), (PdVector)geom.getElementNormal(e)));
                if (dist < minDist) {
                    minDist = dist;
                    bestIndex = i;
                }
                ++i;
            }
            if (bestIndex < 0) {
                PsDebug.warning((String)"Error in projection");
                return null;
            }
            bary = baries[bestIndex];
        }
        if (intrinsic) {
            ((PgIntrinsicPolygon)outCurve).addVertexIntrinsic(bary);
        } else {
            int ind = outCurve.addVertex(new PdVector(3));
            outCurve.setVertexBary(ind, bary);
        }
        PdBary outBary = new PdBary(3);
        int i = 0;
        while (i < numEdges) {
            int endPointIdx = (i + 1) % numVertices;
            PdVector endPoint = curve.getVertex(endPointIdx);
            if (intrinsic) {
                if (!this.projectLocal(geom, bary, endPoint, null, walkAlongBoundary, outBary, (PgIntrinsicPolygon)outCurve)) {
                    return outCurve;
                }
            } else {
                if (!this.projectLocal(geom, bary, endPoint, null, walkAlongBoundary, outBary, null)) {
                    return outCurve;
                }
                int ind = outCurve.addVertex(new PdVector(3));
                outCurve.setVertexBary(ind, outBary);
            }
            bary.copy(outBary);
            ++i;
        }
        return outCurve;
    }

    public static boolean projectPointOntoElementSet(PgElementSet target, PdVector vertex, PdVector vertexNormal, int elemInd, PdBary outBary, boolean ignoreOutside) {
        boolean bDebug = true;
        int maxStep = 200;
        PiVector[] elements = target.getElements();
        PiVector[] neighbour = target.getNeighbours();
        PdVector[] elementNormal = target.getElementNormals();
        boolean done = false;
        int initialElem = elemInd;
        PgVertexStar star = new PgVertexStar();
        int prevElemInd = -1;
        PdBary bary = new PdBary(3);
        boolean didProject = false;
        boolean hitBoundary = false;
        PdVector vertexCopy = new PdVector(3);
        int step = 0;
        while (step < 200 && !done) {
            if (elemInd == -1) {
                hitBoundary = true;
                break;
            }
            if (!didProject) {
                vertexCopy.copy(vertex);
                done = PnProjection.projectVertexOntoElement(target, vertexCopy, vertexNormal, elemInd, outBary);
                if (done) break;
            }
            didProject = false;
            int edgeInd = PwBary.liesOnEdge((PdBary)outBary);
            if (edgeInd != -1) {
                double dihedral;
                int nextElemInd = neighbour[elemInd].m_data[edgeInd];
                hitBoundary = nextElemInd == -1;
                if (hitBoundary || prevElemInd == nextElemInd || (dihedral = elementNormal[nextElemInd].dot(elementNormal[elemInd])) < 1.0E-10) break;
                prevElemInd = elemInd;
                elemInd = nextElemInd;
            } else {
                int vertInd = PwBary.liesOnVertex((PdBary)outBary);
                if (vertInd == -1) {
                    PsDebug.error((String)"we should never get here!");
                }
                int[] elem = elements[elemInd].m_data;
                star.makeVertexStar(target, elem[vertInd], elemInd);
                PiVector vertexLocInd = star.getVertexLocInd();
                int[] ie = star.getElement().m_data;
                int nextElementInd = -1;
                boolean liesOnEdge = false;
                boolean alwaysLiesOnCenterVertex = true;
                int numStarElements = star.getSize();
                int i = 0;
                while (i < numStarElements) {
                    int iei = ie[i];
                    if (iei != elemInd) {
                        boolean liesOnCenterVertex;
                        vertexCopy.copy(vertex);
                        done = PnProjection.projectVertexOntoElement(target, vertexCopy, vertexNormal, iei, bary);
                        if (done) {
                            outBary.copy(bary);
                            break;
                        }
                        int onVertex = PwBary.liesOnVertex((PdBary)bary);
                        boolean bl = liesOnCenterVertex = onVertex == vertexLocInd.m_data[i];
                        if (!liesOnCenterVertex) {
                            boolean liesOnOppositeEdge;
                            alwaysLiesOnCenterVertex = false;
                            int onEdge = PwBary.liesOnEdge((PdBary)bary);
                            boolean bl2 = liesOnOppositeEdge = onEdge == vertexLocInd.m_data[i];
                            if (liesOnOppositeEdge || onVertex != -1 && !liesOnCenterVertex) {
                                nextElementInd = iei;
                                outBary.copy(bary);
                                break;
                            }
                            if (!liesOnEdge) {
                                nextElementInd = iei;
                                outBary.copy(bary);
                                liesOnEdge = true;
                            }
                        }
                    }
                    ++i;
                }
                if (alwaysLiesOnCenterVertex) {
                    boolean bl = hitBoundary = !star.isClosed();
                }
                if (done || alwaysLiesOnCenterVertex || liesOnEdge && nextElementInd == prevElemInd) break;
                prevElemInd = elemInd;
                elemInd = nextElementInd;
                didProject = true;
            }
            ++step;
        }
        boolean result = true;
        if (step == 200) {
            PsDebug.warning((String)("too many iterations, elemInd = " + initialElem));
            PwBary.projectOntoElementSet((PgElementSet)target, (PdVector)vertex, (PdBary)outBary);
        } else if (hitBoundary) {
            if (ignoreOutside) {
                outBary.set(-1, 0.0, 0.0, 0.0);
            } else {
                PwBary.projectOntoElementSet((PgElementSet)target, (PdVector)vertex, (PdBary)outBary);
            }
            result = false;
        }
        if (!ignoreOutside && outBary.m_elementInd == -1) {
            PsDebug.warning((String)"wrong output");
            result = false;
        }
        return result;
    }

    public static void convertFromBoundaryToElementSet(PgBndPolygon domain, PdBary[] bary2d, PgBndPolygon polyIn, PdBary[] bary3d) {
        int polyLen = polyIn.getNumVertices() - 1;
        int[] vertInd = polyIn.getVertexInd().m_data;
        int[] targetVertInd = domain.getVertexInd().m_data;
        int[] targetElemInd = domain.getElementInd().m_data;
        int[] targetEdgeInd = domain.getNeighbourLocInd().m_data;
        PgElementSet target = domain.getGeometry();
        PiVector[] elements = target.getElements();
        int i = 0;
        while (i < polyLen) {
            int iv = vertInd[i];
            if (bary3d[iv] == null) {
                bary3d[iv] = new PdBary(3);
            } else if (bary3d[iv].getSize() != 3) {
                bary3d[iv].setSize(3);
            }
            int edgeInd = bary2d[i].m_elementInd;
            int startVertex = targetVertInd[edgeInd];
            int elemInd = targetElemInd[edgeInd];
            int oppVertLocInd = targetEdgeInd[edgeInd];
            int v1Ind = (oppVertLocInd + 1) % 3;
            int v0Ind = (v1Ind + 1) % 3;
            int[] element = elements[elemInd].m_data;
            if (startVertex != element[v0Ind]) {
                int tmp = v0Ind;
                v0Ind = v1Ind;
                v1Ind = tmp;
            }
            bary3d[iv].setElementInd(elemInd);
            bary3d[iv].m_data[v0Ind] = bary2d[i].m_data[0];
            bary3d[iv].m_data[v1Ind] = bary2d[i].m_data[1];
            bary3d[iv].m_data[oppVertLocInd] = 0.0;
            ++i;
        }
    }

    public static PgPointSetOnPolygon[] projectSurface(PgElementSet geom, PgPointSetOnElementSet surfacePoints, PgElementSet target, PgElementSet source, boolean mapBoundaries, int startElement, boolean ignoreOutside) {
        boolean clearAllTags = true;
        boolean tag = false;
        int noe = geom.getNumElements();
        int nov = geom.getNumVertices();
        PiVector[] elements = geom.getElements();
        PdBary[] bary = PdBary.realloc(null, (int)nov, (int)3);
        surfacePoints.setVertexBary(bary);
        int i = 0;
        while (i < noe) {
            elements[i].clearTag(0);
            ++i;
        }
        PdVector[] v = geom.getVertices();
        int i2 = 0;
        while (i2 < nov) {
            v[i2].clearTag(0);
            ++i2;
        }
        PgPointSetOnPolygon[] boundaryPoint = null;
        if (mapBoundaries) {
            boundaryPoint = PnProjection.projectBoundaries(geom, target);
            PgBndPolygon[] bnd = geom.getBoundaries();
            int numBnd = bnd.length;
            int bndInd = 0;
            while (bndInd < numBnd) {
                PgPointSetOnPolygon boundaryPoints = boundaryPoint[bndInd];
                PgBndPolygon poly = bnd[bndInd];
                PiVector vertInd = poly.getVertexInd();
                PnProjection.convertFromBoundaryToElementSet((PgBndPolygon)boundaryPoints.getGeometry(), boundaryPoints.getVertexBary(), poly, bary);
                int polyLen = poly.getNumVertices() - 1;
                int i3 = 0;
                while (i3 < polyLen) {
                    int iv = vertInd.m_data[i3];
                    PdVector vertex = v[iv];
                    vertex.setTag(0);
                    ++i3;
                }
                ++bndInd;
            }
        }
        startElement = startElement >= 0 ? startElement : 0;
        PuElementSetIterator it = new PuElementSetIterator(geom, 0);
        int startVertex = geom.getElement((int)startElement).m_data[0];
        it.init(startVertex, 2);
        PdVector firstVertex = PdVector.copyNew((PdVector)v[startVertex]);
        PwBary.projectOntoElementSet((PgElementSet)target, (PdVector)geom.getVertex(startVertex), (PdBary)bary[startVertex]);
        while (it.hasNext()) {
            int v0 = it.getNext();
            int startElem = -1;
            startElem = bary[v0].m_elementInd;
            if (startElem == -1) continue;
            PiVector succ = it.getSuccessors();
            int n = 0;
            while (n < succ.getSize()) {
                int v1 = succ.getEntry(n);
                if (bary[v1].m_elementInd == -1) {
                    PdVector normal;
                    PdVector vertex = geom.getVertex(v1);
                    boolean result = PnProjection.projectPointOntoElementSet(target, vertex, normal = source != null ? geom.getVertexNormal(v1) : null, startElem, bary[v1], ignoreOutside);
                    if (!result) {
                        it.blockEdge(n);
                    }
                }
                ++n;
            }
        }
        if (bary[startVertex].m_elementInd != -1 && ignoreOutside) {
            PnProjection.projectPointOntoElementSet(target, firstVertex, geom.getVertexNormal(startVertex), bary[startVertex].m_elementInd, bary[startVertex], ignoreOutside);
        }
        return boundaryPoint;
    }

    private static PgPointSetOnPolygon[] projectBoundaries(PgElementSet geom, PgElementSet target) {
        boolean bDebug = true;
        PwBoundary.makeBoundary((PgElementSet)geom);
        PgBndPolygon[] bnd = geom.getBoundaries();
        int numBnd = bnd.length;
        PdVector[] bndCenter = new PdVector[numBnd];
        PgPointSetOnPolygon[] boundaryPoints = new PgPointSetOnPolygon[numBnd];
        PwBoundary.makeBoundary((PgElementSet)target);
        PgBndPolygon[] domainBnd = target.getBoundaries();
        PdVector[] domainBndCenter = new PdVector[domainBnd.length];
        int i = 0;
        while (i < domainBnd.length) {
            domainBndCenter[i] = domainBnd[i].getCenterOfGravity();
            ++i;
        }
        int bndInd = 0;
        while (bndInd < numBnd) {
            bnd[bndInd].setClosed(true);
            ++bndInd;
        }
        if (domainBnd.length == 0) {
            PsDebug.warning((String)"Domain has no boundaries.");
            numBnd = 0;
        }
        bndInd = 0;
        while (bndInd < numBnd) {
            PgBndPolygon poly = bnd[bndInd];
            bndCenter[bndInd] = poly.getCenterOfGravity();
            double minDist = Double.MAX_VALUE;
            int targetPolyInd = -1;
            int i2 = 0;
            while (i2 < domainBnd.length) {
                double d = bndCenter[bndInd].dist(domainBndCenter[i2]);
                if (d < minDist) {
                    minDist = d;
                    targetPolyInd = i2;
                }
                ++i2;
            }
            System.out.println("projecting " + bndInd + " onto " + targetPolyInd);
            int polyLen = poly.getNumVertices() - 1;
            PdBary[] bary2d = PdBary.realloc(null, (int)polyLen, (int)2);
            PgBndPolygon targetPoly = domainBnd[targetPolyInd];
            boundaryPoints[bndInd] = new PgPointSetOnPolygon((PgPolygon)targetPoly);
            PnProjection.projectPointSetOntoPolygon((PgPointSet)poly, (PgPolygon)targetPoly, bary2d);
            boundaryPoints[bndInd].setNumVertices(bary2d.length);
            boundaryPoints[bndInd].setVertexBary(bary2d);
            ++bndInd;
        }
        return boundaryPoints;
    }

    private static boolean projectVertexOntoElement(PgElementSet target, PdVector vertex, PdVector vertexNormal, int elemInd, PdBary outBary) {
        PdVector elementNormal = target.getElementNormal(elemInd);
        if (vertexNormal != null && Math.abs(vertexNormal.dot(elementNormal)) > 1.0E-10) {
            PdVector v0 = target.getVertex(target.getElement((int)elemInd).m_data[0]);
            double pn = 0.0;
            int dim = vertex.getSize();
            int i = 0;
            while (i < dim) {
                pn += (vertex.m_data[i] - v0.m_data[i]) * elementNormal.m_data[i];
                ++i;
            }
            double div = elementNormal.dot(vertexNormal);
            if (Math.abs(div) > 1.0E-10) {
                vertex.blendBase(vertex, -pn / div, vertexNormal);
            }
        }
        PwBary.projectOntoElement((PgElementSet)target, (int)elemInd, (PdVector)vertex, (PdBary)outBary);
        boolean done = outBary.isInside();
        if (!done) {
            PdBary.getBaryInside((PdBary)outBary, (PdVector)vertex, (PdVector[])target.getElementVertices(elemInd));
        }
        return done;
    }
}

