/*
 * Decompiled with CFR 0.152.
 */
package devProjection;

import devProjection.PgIntrinsicPolygon;
import devProjection.PnProjection;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PwBary;

public class PnIntrinsicPolygon {
    public static PgPolygonOnElementSet resamplePolygon(PgPolygonOnElementSet poly, double newEdgeLen) {
        int numPolyV = poly.getNumVertices();
        double wholeLen = poly.getLength();
        if (numPolyV < 1 || wholeLen < 1.0E-10) {
            PsDebug.warning((String)"Polygon too short");
            return null;
        }
        if (newEdgeLen > wholeLen) {
            newEdgeLen = wholeLen;
        }
        int newNumV = (int)Math.round(wholeLen / newEdgeLen) + 1;
        return PnIntrinsicPolygon.resamplePolygon_(poly, newNumV, wholeLen / (double)(newNumV - 1));
    }

    public static PgPolygonOnElementSet resamplePolygon(PgPolygonOnElementSet poly, int newNumV) {
        int numPolyV = poly.getNumVertices();
        double wholeLen = poly.getLength();
        if (numPolyV < 1 || wholeLen < 1.0E-10) {
            PsDebug.warning((String)"Polygon too short");
            return null;
        }
        if (newNumV < 2) {
            PsDebug.warning((String)"Must resample to at least 2 vertices");
            return null;
        }
        return PnIntrinsicPolygon.resamplePolygon_(poly, newNumV, wholeLen / (double)(newNumV - 1));
    }

    private static PgPolygonOnElementSet resamplePolygon_(PgPolygonOnElementSet poly, int newNumV, double x) {
        PgElementSet geom = poly.getGeometry();
        PgPolygonOnElementSet out = new PgPolygonOnElementSet(geom);
        out.setName(poly.getName());
        out.setNumVertices(newNumV);
        out.setVertexBary(0, poly.getVertexBary(0));
        PdBary polyBary = new PdBary(2);
        int polyV = 0;
        polyBary.set(polyV, 1.0, 0.0);
        int numPolyV = poly.getNumVertices();
        int i = 1;
        while (i < newNumV) {
            double t = 1.0 - polyBary.m_data[0];
            double advanceLeft = x;
            while (polyV < numPolyV - 1) {
                PdVector nextVertex = poly.getVertex(polyV + 1);
                PdVector prevVertex = poly.getVertex(polyV);
                double edgeLen = prevVertex.dist(nextVertex);
                if (!(edgeLen < 1.0E-10)) {
                    if ((t += advanceLeft / edgeLen) <= 1.0) break;
                    advanceLeft = (t - 1.0) * edgeLen;
                    t = 0.0;
                }
                ++polyV;
            }
            if (polyV == numPolyV - 1) {
                polyBary.set(numPolyV - 2, 0.0, 1.0);
            } else {
                polyBary.set(polyV, 1.0 - t, t);
            }
            out.setVertexBary(i, PnIntrinsicPolygon.getPoint(poly, polyBary));
            ++i;
        }
        out.setVertexBary(newNumV - 1, poly.getVertexBary(numPolyV - 1));
        return out;
    }

    public static PdBary getPoint(PgIntrinsicPolygon poly, PdBary bary) {
        int numV = poly.getNumVertices();
        int i = bary.getElementInd();
        if (i >= numV - 1 || bary.m_data[0] < 0.0 || bary.m_data[0] > 1.0) {
            PsDebug.warning((String)"Barycentric coordinates out of range");
            return null;
        }
        PdBary prevV = PdBary.copyNew((PdBary)poly.getVertexBary(i));
        PdBary nextV = PdBary.copyNew((PdBary)poly.getVertexBary(i + 1));
        PwBary.makeCommonBaryDescription((PgElementSet)poly.getGeometry(), (PdBary)prevV, (PdBary)nextV, (double)0.001);
        prevV.blend(bary.m_data[0], prevV, 1.0 - bary.m_data[0], nextV);
        return prevV;
    }

    public static PdBary getPoint(PgPolygonOnElementSet poly, PdBary bary) {
        int numV = poly.getNumVertices();
        int i = bary.getElementInd();
        if (i < 0 || i >= numV - 1 || bary.m_data[0] < 0.0 || bary.m_data[0] > 1.0) {
            PsDebug.warning((String)"Barycentric coordinates out of range");
            return null;
        }
        PgElementSet geom = poly.getGeometry();
        PdBary prevV = PdBary.copyNew((PdBary)poly.getVertexBary(i));
        PdBary nextV = PdBary.copyNew((PdBary)poly.getVertexBary(i + 1));
        PdVector point = PwBary.getVertex(null, (PgElementSet)geom, (PdBary)prevV);
        PdVector nPoint = PwBary.getVertex(null, (PgElementSet)geom, (PdBary)nextV);
        point.blend(bary.m_data[0], point, 1.0 - bary.m_data[0], nPoint);
        PdBary outBary = new PdBary(3);
        prevV.set(0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
        new PnProjection().projectLocal(geom, prevV, point, null, true, outBary, null);
        return outBary;
    }
}

