/*
 * Decompiled with CFR 0.152.
 */
package devProjection;

import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jvx.geom.PwBary;

public class PnIntersection {
    public static double intersectPolygons(PgPolygon poly1, int v1, PgPolygon poly2, int v2, PdBary outBary1, PdBary outBary2, PdVector outPoint) {
        int num1 = poly1.getNumVertices();
        int num2 = poly2.getNumVertices();
        if (num1 < 1 || num2 < 1) {
            PsDebug.warning((String)"Polygon is empty");
            return -1.0;
        }
        int dim = poly1.getDimOfVertices();
        if (poly2.getDimOfVertices() != dim) {
            PsDebug.warning((String)"Dimension of vertices does not match");
            return -1.0;
        }
        if (num1 == 1) {
            if (outBary2 == null) {
                outBary2 = new PdBary(2);
            }
            if (outBary1 != null) {
                outBary1.set(0, 1.0, 0.0);
            }
            PwBary.projectOntoPolygon((PdVector)poly1.getVertex(0), (PgPolygon)poly2, (PdBary)outBary2);
            if (outPoint != null) {
                PwBary.getVertex((PdVector)outPoint, (PgPolygon)poly2, (PdBary)outBary2);
                outPoint.blend(0.5, outPoint, 0.5, poly1.getVertex(0));
            }
            return 2.0 * poly1.getVertex(0).dist(outPoint);
        }
        if (num2 == 1) {
            if (outBary1 == null) {
                outBary1 = new PdBary(2);
            }
            if (outBary2 != null) {
                outBary2.set(0, 1.0, 0.0);
            }
            PwBary.projectOntoPolygon((PdVector)poly2.getVertex(0), (PgPolygon)poly1, (PdBary)outBary1);
            if (outPoint != null) {
                PwBary.getVertex((PdVector)outPoint, (PgPolygon)poly1, (PdBary)outBary1);
                outPoint.blend(0.5, outPoint, 0.5, poly2.getVertex(0));
            }
            return 2.0 * poly2.getVertex(0).dist(outPoint);
        }
        if (v1 < 0) {
            v1 = (num1 - 1) / 2;
        }
        if (v2 < 0) {
            v2 = (num2 - 1) / 2;
        }
        PdVector intersection = new PdVector(2);
        boolean advance = true;
        double dist = Double.POSITIVE_INFINITY;
        double s = 0.0;
        double t = 0.0;
        while (advance) {
            double d;
            advance = false;
            PdVector vertex1 = poly1.getVertex(v1);
            PdVector vertex2 = poly2.getVertex(v2);
            int newV1 = v1;
            int newV2 = v2;
            if (v1 < num1 - 1 && v2 < num2 - 1) {
                double d2;
                d = PnIntersection.nearestLinesegmentToLinesegment(vertex1, poly1.getVertex(v1 + 1), vertex2, poly2.getVertex(v2 + 1), intersection);
                if (d2 < dist) {
                    dist = d;
                    s = intersection.m_data[0];
                    t = intersection.m_data[1];
                    advance = false;
                    if (intersection.m_data[0] >= 1.0) {
                        if (v1 < num1 - 2) {
                            newV1 = v1 + 1;
                            s = 0.0;
                            advance = true;
                        } else {
                            s = 1.0;
                        }
                    }
                    if (intersection.m_data[1] >= 1.0) {
                        if (v2 < num2 - 2) {
                            newV2 = v2 + 1;
                            t = 0.0;
                            advance = true;
                        } else {
                            t = 1.0;
                        }
                    }
                }
            }
            if (v1 < num1 - 1 && v2 > 0) {
                double d3;
                d = PnIntersection.nearestLinesegmentToLinesegment(vertex1, poly1.getVertex(v1 + 1), vertex2, poly2.getVertex(v2 - 1), intersection);
                if (d3 < dist) {
                    dist = d;
                    s = intersection.m_data[0];
                    t = intersection.m_data[1];
                    advance = false;
                    newV1 = v1;
                    newV2 = v2;
                    if (intersection.m_data[0] >= 1.0) {
                        if (v1 < num1 - 2) {
                            newV1 = v1 + 1;
                            s = 0.0;
                            advance = true;
                        } else {
                            s = 1.0;
                        }
                    }
                    if (intersection.m_data[1] >= 1.0) {
                        newV2 = v2 - 1;
                        t = 0.0;
                        advance = true;
                    } else if (intersection.m_data[0] < 1.0) {
                        newV2 = v2 - 1;
                        t = 1.0 - t;
                    }
                }
            }
            if (v1 > 0 && v2 < num2 - 1) {
                double d4;
                d = PnIntersection.nearestLinesegmentToLinesegment(vertex1, poly1.getVertex(v1 - 1), vertex2, poly2.getVertex(v2 + 1), intersection);
                if (d4 < dist) {
                    dist = d;
                    s = intersection.m_data[0];
                    t = intersection.m_data[1];
                    advance = false;
                    newV1 = v1;
                    newV2 = v2;
                    if (intersection.m_data[0] >= 1.0) {
                        newV1 = v1 - 1;
                        s = 0.0;
                        advance = true;
                    }
                    if (intersection.m_data[1] >= 1.0) {
                        if (v2 < num2 - 2) {
                            newV2 = v2 + 1;
                            t = 0.0;
                            advance = true;
                        } else {
                            t = 1.0;
                        }
                    } else if (intersection.m_data[0] < 1.0) {
                        newV1 = v1 - 1;
                        s = 1.0 - s;
                    }
                }
            }
            if (v1 > 0 && v2 > 0) {
                double d5;
                d = PnIntersection.nearestLinesegmentToLinesegment(vertex1, poly1.getVertex(v1 - 1), vertex2, poly2.getVertex(v2 - 1), intersection);
                if (d5 < dist) {
                    dist = d;
                    s = intersection.m_data[0];
                    t = intersection.m_data[1];
                    advance = false;
                    newV1 = v1;
                    newV2 = v2;
                    if (intersection.m_data[0] >= 1.0) {
                        newV1 = v1 - 1;
                        s = 0.0;
                        advance = true;
                    }
                    if (intersection.m_data[1] >= 1.0) {
                        newV2 = v2 - 1;
                        t = 0.0;
                        advance = true;
                    } else if (intersection.m_data[0] < 1.0) {
                        newV1 = v1 - 1;
                        s = 1.0 - s;
                        newV2 = v2 - 1;
                        t = 1.0 - t;
                    }
                }
            }
            v1 = newV1;
            v2 = newV2;
        }
        if (outBary1 != null) {
            outBary1.set(v1, 1.0 - s, s);
        }
        if (outBary2 != null) {
            outBary2.set(v2, 1.0 - t, t);
        }
        if (outPoint != null) {
            outPoint.blend(0.5 - s / 2.0, poly1.getVertex(v1), s / 2.0, poly1.getVertex(v1 + 1), 0.5 - t / 2.0, poly2.getVertex(v2), t / 2.0, poly2.getVertex(v2 + 1));
        }
        return dist;
    }

    private static double nearestLinesegmentToLinesegment(PdVector start1, PdVector end1, PdVector start2, PdVector end2, PdVector s) {
        double t;
        double d;
        double e1e2 = end1.dot(end2) + start1.dot(start2) - (end1.dot(start2) + start1.dot(end2));
        double e1e1 = start1.sqrDist(end1);
        double e2e2 = start2.sqrDist(end2);
        double div = e1e1 * e2e2 - e1e2 * e1e2;
        s.setConstant(0.0);
        if (Math.abs(div) < 1.0E-10) {
            s.m_data[1] = 0.0;
            s.m_data[0] = 0.0;
            return start1.dist(start2);
        }
        int dim = start1.getSize();
        int i = dim - 1;
        while (i >= 0) {
            s.m_data[0] = s.m_data[0] + (start2.m_data[i] - start1.m_data[i]) * ((end1.m_data[i] - start1.m_data[i]) * e2e2 - e1e2 * (end2.m_data[i] - start2.m_data[i]));
            s.m_data[1] = s.m_data[1] + (start1.m_data[i] - start2.m_data[i]) * ((end2.m_data[i] - start2.m_data[i]) * e1e1 - e1e2 * (end1.m_data[i] - start1.m_data[i]));
            --i;
        }
        s.multScalar(1.0 / div);
        double dist = Double.POSITIVE_INFINITY;
        double newS = s.m_data[0];
        double newT = s.m_data[1];
        if (s.m_data[0] < 0.0 && (d = PnIntersection.distBlend(start1, start2, end2, t = PnIntersection.nearestPointToLinesegment(start1, start2, end2))) < dist) {
            dist = d;
            newS = 0.0;
            newT = t;
        }
        if (s.m_data[0] > 1.0 && (d = PnIntersection.distBlend(end1, start2, end2, t = PnIntersection.nearestPointToLinesegment(end1, start2, end2))) < dist) {
            dist = d;
            newS = 1.0;
            newT = t;
        }
        if (s.m_data[1] < 0.0 && (d = PnIntersection.distBlend(start2, start1, end1, t = PnIntersection.nearestPointToLinesegment(start2, start1, end1))) < dist) {
            dist = d;
            newS = t;
            newT = 0.0;
        }
        if (s.m_data[1] > 1.0 && (d = PnIntersection.distBlend(end2, start1, end1, t = PnIntersection.nearestPointToLinesegment(end2, start1, end1))) < dist) {
            dist = d;
            newS = t;
            newT = 1.0;
        }
        s.m_data[0] = newS;
        s.m_data[1] = newT;
        double d2 = 0.0;
        int i2 = 0;
        while (i2 < dim) {
            double r = start1.m_data[i2] * (1.0 - s.m_data[0]) + s.m_data[0] * end1.m_data[i2] - (start2.m_data[i2] * (1.0 - s.m_data[1]) + s.m_data[1] * end2.m_data[i2]);
            d2 += r * r;
            ++i2;
        }
        return Math.sqrt(d2);
    }

    private static double nearestPointToLinesegment(PdVector p, PdVector start, PdVector end) {
        double t = 0.0;
        int dim = p.getSize();
        int i = dim - 1;
        while (i >= 0) {
            t += (p.m_data[i] - start.m_data[i]) * (end.m_data[i] - start.m_data[i]);
            --i;
        }
        if (t < 0.0) {
            return 0.0;
        }
        if ((t /= start.sqrDist(end)) >= 1.0) {
            return 1.0;
        }
        return t;
    }

    private static double distBlend(PdVector p, PdVector start, PdVector end, double t) {
        double value = 0.0;
        int dim = p.getSize();
        int i = 0;
        while (i < dim) {
            double tmp = p.m_data[i] - ((1.0 - t) * start.m_data[i] + t * end.m_data[i]);
            value += tmp * tmp;
            ++i;
        }
        return Math.sqrt(value);
    }
}

