/*
 * Decompiled with CFR 0.152.
 */
package devProjection;

import devProjection.PwProjection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.loader.PgLoader;
import jv.loader.PjImportModel;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;

public class PjProjection
extends PjProject
implements ActionListener {
    public static final String DEFAULT_FILE_NAME = "models/byu/Brezel_480.byu";
    public static final String DEFAULT_DOMAIN_FILE_NAME = "models/byu/Cow_5804.byu";
    protected PjImportModel m_import = new PjImportModel();
    protected PjImportModel m_importDomain;
    protected PwProjection m_pwProjection;
    protected PgGeometryIf m_geom;
    protected PgElementSet m_domain;

    public PjProjection() {
        super("Projection Project");
        this.m_import.setTypeOfInfoPanel(1);
        this.m_import.addActionListener((ActionListener)this);
        this.m_importDomain = new PjImportModel();
        this.m_importDomain.setTypeOfInfoPanel(1);
        this.m_importDomain.addActionListener((ActionListener)this);
        this.m_pwProjection = new PwProjection();
        this.m_geom = null;
        if (this.getClass() == PjProjection.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_import.setFileName(DEFAULT_FILE_NAME);
        this.m_importDomain.setFileName(DEFAULT_DOMAIN_FILE_NAME);
        this.loadGeometry(DEFAULT_FILE_NAME);
        this.loadDomain(DEFAULT_DOMAIN_FILE_NAME);
    }

    public void setDisplay(PvDisplayIf disp) {
        super.setDisplay(disp);
        this.m_pwProjection.setDisplay(disp);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_import) {
            this.loadGeometry(this.m_import.getFileName());
        } else if (source == this.m_importDomain) {
            this.loadDomain(this.m_importDomain.getFileName());
        }
    }

    public void loadGeometry(String filename) {
        PgGeometry[] geomNew = new PgLoader().loadGeometry(null, filename);
        if (geomNew == null || geomNew.length == 0 || geomNew[0] == null) {
            PsDebug.warning((String)("loading failed, file = " + filename));
            return;
        }
        if (geomNew.length > 1) {
            PsDebug.warning((String)("only first geometry used, found = " + geomNew.length));
        }
        this.setGeometry((PgGeometryIf)geomNew[0]);
    }

    public void loadDomain(String filename) {
        PgGeometry[] geomNew = new PgLoader().loadGeometry(null, filename);
        if (geomNew == null || geomNew.length == 0 || geomNew[0] == null) {
            PsDebug.warning((String)("loading failed, file = " + filename));
            return;
        }
        if (geomNew.length > 1) {
            PsDebug.warning((String)("only first geometry used, found = " + geomNew.length));
        }
        this.setDomainGeometry((PgGeometryIf)geomNew[0]);
    }

    public boolean setGeometry(PgGeometryIf geomNew) {
        if (!(geomNew instanceof PgGeometry)) {
            PsDebug.warning((String)"Geometry must be an instance of PgGeometry.");
            return false;
        }
        if (this.m_geom != null) {
            this.removeGeometry(this.m_geom);
        }
        this.m_geom = geomNew;
        this.addGeometry(this.m_geom);
        this.selectGeometry(this.m_geom);
        this.m_pwProjection.setGeometry((PgGeometry)this.m_geom);
        return true;
    }

    public boolean setDomainGeometry(PgGeometryIf geomNew) {
        if (!(geomNew instanceof PgElementSet)) {
            PsDebug.warning((String)"Geometry must be an instance of PgElementSet.");
            return false;
        }
        if (this.m_domain != null) {
            this.removeGeometry((PgGeometryIf)this.m_domain);
        }
        this.m_domain = (PgElementSet)geomNew;
        this.addGeometry((PgGeometryIf)this.m_domain);
        if (this.m_geom != null) {
            this.selectGeometry(this.m_geom);
        }
        this.m_pwProjection.setDomainGeometry((PgPointSet)this.m_domain);
        return true;
    }
}

