/*
 * Decompiled with CFR 0.152.
 */
package devProjection;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBary;

public class PgIntrinsicPolygon
extends PgPolygonOnElementSet {
    protected PiVector m_elements = new PiVector();
    protected PiVector m_locNeighbInd = new PiVector();
    private PiVector m_backLocNeighbInd = new PiVector();

    public PgIntrinsicPolygon(PgElementSet geom) {
        super(geom);
        if (((Object)((Object)this)).getClass() == PgIntrinsicPolygon.class) {
            this.init();
        }
    }

    public PiVector getElements() {
        return this.m_elements;
    }

    public PiVector getLocNeighbInd() {
        return this.m_locNeighbInd;
    }

    public PiVector getBackLocNeighbInd() {
        return this.m_backLocNeighbInd;
    }

    public void setMaxNumVertices(int maxNumVertices) {
        this.m_elements.setSize(maxNumVertices);
        this.m_locNeighbInd.setSize(maxNumVertices);
        this.m_backLocNeighbInd.setSize(maxNumVertices);
        int v = this.m_numVertices;
        while (v < maxNumVertices) {
            this.m_locNeighbInd.m_data[v] = -1;
            this.m_backLocNeighbInd.m_data[v] = -1;
            this.m_elements.m_data[v] = -1;
            ++v;
        }
        super.setMaxNumVertices(maxNumVertices);
    }

    public void setVertexIntrinsic(int vertInd, PdBary bary, int locNeighbInd) {
        int pe;
        int e = bary.getElementInd();
        if (e < 0) {
            PsDebug.warning((String)"No element index set in bary");
            return;
        }
        int backLocNeighbInd = -1;
        if (vertInd == 0) {
            pe = this.m_elements.m_data[0] = e;
            locNeighbInd = -1;
        } else {
            pe = this.m_elements.m_data[vertInd - 1];
        }
        if (pe < 0) {
            PsDebug.warning((String)"Previous vertex not set.");
            return;
        }
        if (locNeighbInd < 0) {
            if (e != pe) {
                PsDebug.warning((String)("New vertex should lie in element " + pe));
                return;
            }
        } else {
            PiVector neighb = this.m_geom.getNeighbour(pe);
            int loc = neighb.getIndexOf(e);
            if (loc < 0) {
                PsDebug.warning((String)("Element" + pe + "is no neighbour of " + e));
                return;
            }
            if (loc != locNeighbInd) {
                PsDebug.warning((String)("Invalid local neighbour index " + locNeighbInd + ", should be " + loc));
                return;
            }
            backLocNeighbInd = this.m_geom.getNeighbour(e).getIndexOf(pe);
            if (backLocNeighbInd < 0) {
                PsDebug.warning((String)"neighbours corrupt");
                return;
            }
        }
        if (vertInd > 0) {
            this.m_locNeighbInd.m_data[vertInd - 1] = locNeighbInd;
        }
        this.m_backLocNeighbInd.m_data[vertInd] = backLocNeighbInd;
        this.m_elements.m_data[vertInd] = e;
        super.setVertexBary(vertInd, bary);
    }

    public void addVertexIntrinsic(PdBary bary) {
        int numVertices = this.getNumVertices();
        if (numVertices == 0) {
            this.addVertexIntrinsic(bary, -1);
            return;
        }
        int e = bary.getElementInd();
        if (e < 0) {
            PsDebug.warning((String)"No element index set in bary");
            return;
        }
        int pe = this.m_elements.m_data[numVertices - 1];
        if (pe < 0) {
            PsDebug.warning((String)"Previous vertex not set.");
            return;
        }
        if (e == pe) {
            this.addVertexIntrinsic(bary, -1);
            return;
        }
        PdBary pBary = this.m_vertexBary[numVertices - 1];
        int pDim = pBary.getSize();
        PiVector pNeighb = this.m_geom.getNeighbour(pe);
        int i = 0;
        while (i < pDim) {
            if (pBary.m_data[i] <= BARYEPS && pBary.m_data[i] >= -BARYEPS && pNeighb.m_data[i] == e) {
                this.addVertexIntrinsic(bary, i);
                return;
            }
            ++i;
        }
        int dim = bary.getSize();
        PiVector neighb = this.m_geom.getNeighbour(e);
        int i2 = 0;
        while (i2 < dim) {
            if (bary.m_data[i2] <= BARYEPS && bary.m_data[i2] >= -BARYEPS && neighb.m_data[i2] == pe) {
                int j = pNeighb.getIndexOf(e);
                if (j < 0) {
                    PsDebug.warning((String)"Invalid neighbours");
                    return;
                }
                this.addVertexIntrinsic(bary, i2);
                return;
            }
            ++i2;
        }
        PgVertexStar star = new PgVertexStar();
        int i3 = 0;
        while (i3 < dim) {
            if (bary.m_data[i3] <= 1.0 + BARYEPS && bary.m_data[i3] >= 1.0 - BARYEPS) {
                int v = this.m_geom.getElement((int)e).m_data[i3];
                int locInd = this.m_geom.getElement(e).getIndexOf(v);
                if (locInd >= 0) {
                    PdBary b = new PdBary(3);
                    b.copy(pBary);
                    if (this.changeElementAtVertexStar(v, pe, e, b, star)) {
                        return;
                    }
                }
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < pDim) {
            if (pBary.m_data[i3] <= 1.0 + BARYEPS && pBary.m_data[i3] >= 1.0 - BARYEPS && this.changeElementAtVertexStar(this.m_geom.getElement((int)pe).m_data[i3], pe, e, PdBary.copyNew((PdBary)pBary), star)) {
                this.addVertexIntrinsic(bary, -1);
                return;
            }
            ++i3;
        }
        PsDebug.warning((String)"New vertex is not incident to the previous one");
    }

    public int addVertexIntrinsic(PdBary bary, int locNeighbInd) {
        if (bary == null) {
            PsDebug.warning((String)"missing argument");
            return -1;
        }
        int ind = this.addVertex(new PdVector(3));
        this.setVertexIntrinsic(ind, bary, locNeighbInd);
        return ind;
    }

    public void addVertexIntrinsic(int vertInd, int incidentE) {
        int pe;
        int numVertices = this.getNumVertices();
        if (numVertices == 0) {
            if (incidentE < 0) {
                incidentE = this.getElementPerVertex(vertInd);
            }
            pe = incidentE;
        } else {
            pe = this.m_elements.m_data[numVertices - 1];
            incidentE = -1;
        }
        if (pe < 0) {
            PsDebug.warning((String)"Previous vertex not set and no incident element given.");
            return;
        }
        PiVector pElement = this.m_geom.getElement(pe);
        int ind = pElement.getIndexOf(vertInd);
        if (ind >= 0) {
            this.addVertexIntrinsic(this.newVertexBary(pe, ind), -1);
            return;
        }
        if (numVertices == 0) {
            PsDebug.warning((String)(vertInd + " is not an adjacent vertex of " + pe));
            return;
        }
        PdBary pBary = this.m_vertexBary[numVertices - 1];
        int pDim = pBary.getSize();
        PiVector pNeighb = this.m_geom.getNeighbour(pe);
        int i = 0;
        while (i < pDim) {
            int locInd;
            int e;
            if (pBary.m_data[i] <= BARYEPS && pBary.m_data[i] >= -BARYEPS && (e = pNeighb.m_data[i]) >= 0 && (locInd = this.m_geom.getElement(e).getIndexOf(vertInd)) >= 0) {
                this.addVertexIntrinsic(this.newVertexBary(e, locInd), i);
                return;
            }
            ++i;
        }
        PgVertexStar star = new PgVertexStar();
        int i2 = 0;
        while (i2 < pDim) {
            if (pBary.m_data[i2] <= 1.0 + BARYEPS && pBary.m_data[i2] >= 1.0 - BARYEPS) {
                int v = pElement.m_data[i2];
                star.makeVertexStar(this.m_geom, v, pe);
                PiVector elements = star.getElement();
                int num = elements.getSize();
                int j = 0;
                while (j < num) {
                    int locInd = this.m_geom.getElement(elements.m_data[j]).getIndexOf(vertInd);
                    if (locInd >= 0 && this.changeElementAtVertexStar(this.m_geom.getElement((int)pe).m_data[i2], pe, elements.m_data[j], PdBary.copyNew((PdBary)pBary), star)) {
                        this.addVertexIntrinsic(this.newVertexBary(elements.m_data[j], locInd));
                        return;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        PsDebug.warning((String)"New vertex is not incident to the previous one");
    }

    private int getElementPerVertex(int v) {
        int numElements = this.m_geom.getNumElements();
        int e = 0;
        while (e < numElements) {
            PiVector element = this.m_geom.getElement(e);
            int size = element.getSize();
            int i = 0;
            while (i < size) {
                if (element.m_data[i] == v) {
                    return e;
                }
                ++i;
            }
            ++e;
        }
        return -1;
    }

    private boolean changeElementAtVertexStar(int v, int pe, int e, PdBary bary, PgVertexStar star) {
        if (bary.getElementInd() != pe) {
            PsDebug.warning((String)"Invalid element index in bary");
            return false;
        }
        star.makeVertexStar(this.m_geom, v, pe);
        PiVector starElements = star.getElement();
        PiVector locVInd = star.getVertexLocInd();
        int peInd = starElements.getIndexOf(pe);
        if (peInd < 0) {
            return false;
        }
        int eInd = starElements.getIndexOf(e);
        if (eInd < 0) {
            return false;
        }
        if (star.isClosed() || peInd < eInd) {
            int dim = starElements.getSize();
            int i = peInd;
            while (i != eInd) {
                int locInd = (locVInd.m_data[i] + 1) % 3;
                PwBary.changeBarycentricOnEdge((PgElementSet)this.m_geom, (PdBary)bary, (int)locInd);
                this.addVertexIntrinsic(bary, locInd);
                i = (i + 1) % dim;
            }
        } else {
            int dim = starElements.getSize();
            int i = peInd;
            while (i != eInd) {
                int locInd = (locVInd.m_data[i] + 2) % 3;
                PwBary.changeBarycentricOnEdge((PgElementSet)this.m_geom, (PdBary)bary, (int)locInd);
                this.addVertexIntrinsic(bary, locInd);
                i = (i - 1 + dim) % dim;
            }
        }
        return true;
    }

    private PdBary newVertexBary(int element, int locVertInd) {
        PdBary bary = new PdBary(3);
        bary.setElementInd(element);
        bary.m_data[0] = 0.0;
        bary.m_data[locVertInd] = 1.0;
        return bary;
    }

    public void getEdgeBary(int ind, PdBaryDir edge) {
        PdBary v2;
        PdBary v1 = this.getVertexBary(ind);
        if (!PwBary.makeCommonBaryDescription((PgElementSet)this.m_geom, (PdBary)v1, (PdBary)(v2 = this.getVertexBary(ind + 1)), (double)1.0E-4)) {
            PsDebug.warning((String)"Error in intrinsic polygon: Vertices are not adjacent.");
            return;
        }
        edge.sub(v2, v1);
    }
}

