/*
 * Decompiled with CFR 0.152.
 */
package devParticle.physicalShape;

import devParticle.engine.PnEdgeEngine;
import devParticle.physical.PgPhysicalElementSet;
import devParticle.physical.PgPhysicalGeometryDescriptor;
import jv.vecmath.PiVector;
import jvx.geom.PwRefineElementSet;

public class PgWaveDisk
extends PgPhysicalElementSet {
    public PgWaveDisk() {
        if (((Object)((Object)this)).getClass() == PgWaveDisk.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.setName("Wave Disk");
        int n = 15;
        this.setNumVertices(n + 1);
        this.setVertex(0, 0.0, 0.0, 0.0);
        int i = 0;
        while (i < n) {
            this.setVertex(i + 1, Math.sin(Math.PI * 2 * (double)i / (double)n), Math.cos(Math.PI * 2 * (double)i / (double)n), 0.0);
            ++i;
        }
        this.m_elementSet.setNumElements(n);
        i = 1;
        while (i < n + 1) {
            PiVector piv = new PiVector(0, i, i % n + 1);
            this.setElement(i - 1, piv);
            ++i;
        }
        PwRefineElementSet refine = new PwRefineElementSet();
        refine.setGeometry(this.m_elementSet);
        refine.refineGlobalIntoFour();
        refine.refineSqrt3();
        int num = this.m_elementSet.getNumVertices();
        this.setNumVertices(num + 1);
        this.setVertex(num, 0.0, 0.0, 1.0);
        this.m_elementSet.setTagVertex(num, 1);
        int enm = this.m_elementSet.getNumElements();
        this.setNumElements(enm + 1);
        this.setElement(enm, new PiVector(0, num, 0));
        this.setNumEngines(1);
        PnEdgeEngine en = new PnEdgeEngine(0, num, 0.5, 0.0);
        en.setMin(0.9);
        en.setMax(1.0);
        this.setEngine(0, en);
        this.m_elementSet.showEdges(true);
        this.m_elementSet.showVertices(true);
        this.m_elementSet.showElements(false);
        PgPhysicalGeometryDescriptor d = new PgPhysicalGeometryDescriptor();
        d.setIterationsPerFrame(10);
        d.setStepSize(0.001);
        d.setAirFriction(1.0);
        d.setElementFriction(0.0);
        d.setPotential(50.0);
        d.setSpring(1000.0);
        d.setRestrictGradient(0);
        d.setConstrainCenter(0);
        d.setFitPotential(0);
        this.setGeometryDescriptor(d);
    }
}

