/*
 * Decompiled with CFR 0.152.
 */
package devParticle.physicalShape;

import devParticle.engine.PnEdgeEngine;
import devParticle.physical.PgPhysicalElementSet;
import devParticle.physical.PgPhysicalGeometryDescriptor;
import jv.vecmath.PiVector;

public class PgTowerGeom
extends PgPhysicalElementSet {
    public PgTowerGeom() {
        if (((Object)((Object)this)).getClass() == PgTowerGeom.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.setName("Tower");
        int n = 5;
        double d = 0.8;
        this.setNumVertices(4 * n);
        int idx = 0;
        double dm = 1.0;
        int i = 0;
        while (i < n) {
            this.setVertex(idx++, -dm, -dm, i);
            this.setVertex(idx++, -dm, dm, i);
            this.setVertex(idx++, dm, -dm, i);
            this.setVertex(idx++, dm, dm, i);
            dm *= d;
            ++i;
        }
        this.setNumElements(7 * (n - 1) + 1);
        idx = 0;
        i = 0;
        while (i < n - 1) {
            this.setElement(idx++, new PiVector(4 * i, 4 * i + 1, 4 * i + 3, 4 * i + 2));
            this.setElement(idx++, new PiVector(4 * i, 4 * i + 4, 4 * i + 1, 4 * i + 5));
            this.setElement(idx++, new PiVector(4 * i + 5, 4 * i + 1, 4 * i + 7, 4 * i + 3));
            this.setElement(idx++, new PiVector(4 * i + 7, 4 * i + 3, 4 * i + 6, 4 * i + 2));
            this.setElement(idx++, new PiVector(4 * i + 6, 4 * i + 2, 4 * i + 4, 4 * i));
            this.setElement(idx++, new PiVector(4 * i, 4 * i, 4 * i + 7));
            this.setElement(idx++, new PiVector(4 * i + 1, 4 * i + 1, 4 * i + 6));
            ++i;
        }
        this.setElement(idx++, new PiVector(4 * (n - 1), 4 * (n - 1) + 1, 4 * (n - 1) + 3, 4 * (n - 1) + 2));
        this.setNumEngines(4 * (n - 1));
        idx = 0;
        double period = 0.95;
        double amplitude = 0.1;
        int i2 = 0;
        while (i2 < n - 1) {
            int n2 = idx++;
            PnEdgeEngine engine = new PnEdgeEngine(4 * i2, 4 * i2 + 4, period, 0.0);
            this.setEngine(n2, engine);
            engine.setMin(1.0 - amplitude);
            engine.setMax(1.0 + amplitude);
            int n3 = idx++;
            engine = new PnEdgeEngine(4 * i2 + 1, 4 * i2 + 5, period, 0.0);
            this.setEngine(n3, engine);
            engine.setMin(1.0 - amplitude);
            engine.setMax(1.0 + amplitude);
            int n4 = idx++;
            engine = new PnEdgeEngine(4 * i2 + 3, 4 * i2 + 7, period, 0.5 * period);
            this.setEngine(n4, engine);
            engine.setMin(1.0 - amplitude);
            engine.setMax(1.0 + amplitude);
            int n5 = idx++;
            engine = new PnEdgeEngine(4 * i2 + 2, 4 * i2 + 6, period, 0.5 * period);
            this.setEngine(n5, engine);
            engine.setMin(1.0 - amplitude);
            engine.setMax(1.0 + amplitude);
            ++i2;
        }
        this.m_elementSet.showEdges(true);
        this.m_elementSet.showVertices(true);
        this.m_elementSet.showElements(false);
        PgPhysicalGeometryDescriptor dc = new PgPhysicalGeometryDescriptor();
        dc.setIterationsPerFrame(100);
        dc.setStepSize(1.0E-4);
        dc.setAirFriction(0.9);
        dc.setElementFriction(0.0);
        dc.setPotential(25.0);
        dc.setSpring(100000.0);
        dc.setRestrictGradient(0);
        dc.setConstrainCenter(0);
        this.setGeometryDescriptor(dc);
    }
}

