/*
 * Decompiled with CFR 0.152.
 */
package devParticle.physicalShape;

import devParticle.physical.PgPhysicalElementSet;
import devParticle.physical.PgPhysicalGeometryDescriptor;
import devParticle.physical.PgRigidUnit;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgRigidBall
extends PgPhysicalElementSet {
    public PgRigidBall() {
        if (((Object)((Object)this)).getClass() == PgRigidBall.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.setName("Rigid Ball");
        this.m_elementSet.computeSphere(7, 7, 1.0);
        PdVector[] vertices = this.m_elementSet.getVertices();
        int i = 0;
        while (i < vertices.length) {
            vertices[i].m_data[2] = vertices[i].m_data[2] + 1.2;
            ++i;
        }
        this.setNumRigidUnits(1);
        PiVector piv = new PiVector(this.m_geometry.getNumVertices());
        int i2 = 0;
        while (i2 < this.m_geometry.getNumVertices()) {
            piv.setEntry(i2, i2);
            ++i2;
        }
        this.setRigidUnit(0, new PgRigidUnit(3, piv, this.m_geometry.getVertices()));
        PgPhysicalGeometryDescriptor d = new PgPhysicalGeometryDescriptor();
        d.setIterationsPerFrame(50);
        d.setStepSize(0.001);
        d.setAirFriction(0.9);
        d.setElementFriction(0.0);
        d.setPotential(50.0);
        d.setSpring(4000.0);
        d.setRestrictGradient(0);
        d.setConstrainCenter(0);
        d.setFitPotential(1);
        this.setGeometryDescriptor(d);
    }
}

