/*
 * Decompiled with CFR 0.152.
 */
package devParticle.physicalShape;

import devParticle.engine.PnSpinningEngine;
import devParticle.physical.PgPhysicalElementSet;
import devParticle.physical.PgPhysicalGeometryDescriptor;
import devParticle.physical.PgRigidUnit;
import jv.vecmath.PiVector;

public class PgGoAround
extends PgPhysicalElementSet {
    protected double m_power = 50.0;

    public PgGoAround() {
        if (((Object)((Object)this)).getClass() == PgGoAround.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.setName("Go Around");
        int n = 5;
        double radius = 0.5;
        this.setNumVertices(6 + 2 * n);
        this.setVertex(0, 0.0, 0.0, 0.0);
        this.setVertex(1, 1.0, 0.0, 0.0);
        this.setVertex(2, 0.0, 1.0, 0.0);
        this.setVertex(3, -1.0, 0.0, 0.0);
        this.setVertex(4, 0.0, -1.0, 0.0);
        this.setVertex(5, 0.0, 0.0, 1.0);
        int i = 0;
        while (i < n) {
            double phi = Math.PI * 2 * (double)i / (double)n;
            this.setVertex(6 + i, radius * Math.cos(phi), -radius * Math.sin(phi), 1.0);
            this.setVertex(6 + n + i, radius * Math.cos(phi), -radius * Math.sin(phi), 0.2);
            ++i;
        }
        this.setNumElements(4 + 3 * n);
        this.setElement(0, new PiVector(0, 1, 0));
        this.setElement(1, new PiVector(0, 2, 0));
        this.setElement(2, new PiVector(0, 3, 0));
        this.setElement(3, new PiVector(0, 4, 0));
        i = 0;
        while (i < n) {
            this.setElement(4 + 2 * i, new PiVector(0, 6 + i, 0));
            this.setElement(4 + 2 * i + 1, new PiVector(5, 6 + i, 5));
            this.setElement(4 + 2 * n + i, new PiVector(6 + i, 6 + n + i, 6 + i));
            ++i;
        }
        this.setNumRigidUnits(2);
        PiVector piv = new PiVector(6);
        piv.setEntry(0, 0);
        piv.setEntry(1, 1);
        piv.setEntry(2, 2);
        piv.setEntry(3, 3);
        piv.setEntry(4, 4);
        piv.setEntry(5, 5);
        this.setRigidUnit(0, new PgRigidUnit(3, piv, this.m_elementSet.getVertices()));
        piv = new PiVector(n);
        int i2 = 0;
        while (i2 < n) {
            piv.setEntry(i2, 6 + i2);
            ++i2;
        }
        this.setRigidUnit(1, new PgRigidUnit(3, piv, this.m_elementSet.getVertices()));
        this.setNumEngines(n);
        i2 = 0;
        while (i2 < n) {
            this.setEngine(i2, new PnSpinningEngine(0, 1, 2, 6 + i2, this.m_power));
            ++i2;
        }
        this.m_elementSet.showEdges(true);
        this.m_elementSet.showVertices(true);
        this.m_elementSet.showElements(false);
        PgPhysicalGeometryDescriptor d = new PgPhysicalGeometryDescriptor();
        d.setIterationsPerFrame(50);
        d.setStepSize(1.0E-4);
        d.setAirFriction(0.5);
        d.setElementFriction(0.0);
        d.setPotential(50.0);
        d.setSpring(10000.0);
        d.setRestrictGradient(0);
        d.setConstrainCenter(0);
        d.setFitPotential(0);
        this.setGeometryDescriptor(d);
    }

    public void setPower(double power) {
        this.m_power = power;
        if (this.m_engines != null) {
            int i = 0;
            while (i < this.m_engines.length) {
                if (this.m_engines[i] != null && this.m_engines[i] instanceof PnSpinningEngine) {
                    ((PnSpinningEngine)this.m_engines[i]).setPower(power);
                }
                ++i;
            }
        }
    }
}

