/*
 * Decompiled with CFR 0.152.
 */
package devParticle.physicalShape;

import devParticle.engine.PnEdgeEngine;
import devParticle.physical.PgPhysicalElementSet;
import devParticle.physical.PgPhysicalGeometryDescriptor;
import devParticle.physical.PgRigidUnit;
import jv.vecmath.PiVector;

public class PgAutomobile
extends PgPhysicalElementSet {
    int m_lv = -1;
    int m_lh = -1;
    int m_r = -1;

    public PgAutomobile() {
        if (((Object)((Object)this)).getClass() == PgAutomobile.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.setName("Automobile");
        this.putTetra(-1, -1, -1, 0.0, 0.0);
    }

    private void putTetra(int lv, int lh, int r, double dx, double dy) {
        int n = 9;
        int mod = 3;
        int v = this.m_elementSet.getNumVertices();
        int e = this.m_elementSet.getNumElements();
        int rig = this.getNumRigidUnits();
        int eng = this.getNumEngines();
        int u = (lv >= 0 ? 1 : 0) + (lh >= 0 ? 1 : 0) + (r >= 0 ? 1 : 0);
        this.setNumVertices(v + 4 + n - u);
        if (lv < 0) {
            this.m_lv = lv = v;
            this.setVertex(v++, 0.0 + dx, -1.0 + dy, 0.5);
        }
        if (lh < 0) {
            this.m_lh = lh = v;
            this.setVertex(v++, 0.0 + dx, 1.0 + dy, 0.5);
        }
        if (r < 0) {
            this.m_r = r = v;
            this.setVertex(v++, 1.0 + dx, 0.0 + dy, 0.5);
        }
        int top = v;
        this.setVertex(v++, 0.3 + dx, 0.0 + dy, 1.5);
        int i = 0;
        while (i < n) {
            this.setVertex(v++, 0.3 * Math.sin(Math.PI * 2 * (double)i / (double)n) + dx, 0.0 + dy, 0.3 * Math.cos(Math.PI * 2 * (double)i / (double)n) + 0.5);
            ++i;
        }
        this.setNumElements(e + 4 + n + (int)Math.ceil(1.0 * (double)n / (double)mod));
        this.setElement(e++, new PiVector(lv, lh, r));
        this.setElement(e++, new PiVector(lv, lh, top));
        this.setElement(e++, new PiVector(lh, r, top));
        i = 0;
        while (i < n) {
            this.setElement(e++, new PiVector(lv, lh, v - n + i));
            ++i;
        }
        PiVector piv = new PiVector(3);
        int i2 = 0;
        while (i2 < n) {
            piv.setEntry(i2, v - n + i2);
            ++i2;
        }
        this.setElement(e++, piv);
        int k = 0;
        int i3 = 0;
        while (i3 < n) {
            if (i3 % mod == 0) {
                this.setElement(e++, new PiVector(r, top, v - n + i3));
                ++k;
            }
            ++i3;
        }
        this.setNumEngines(eng + 2 * (int)Math.ceil(1.0 * (double)n / (double)mod));
        k = 0;
        i3 = 0;
        while (i3 < n) {
            if (i3 % mod == 0) {
                PnEdgeEngine engine = null;
                int n2 = eng++;
                engine = new PnEdgeEngine(r, v - n + i3, 1.0, 0.041 - 1.0 * (double)i3 / (double)n);
                this.setEngine(n2, engine);
                engine.setMin(0.5);
                engine.setMax(1.5);
                this.setEdgeLength(r, v - n + i3, 1.0);
                int n3 = eng++;
                engine = new PnEdgeEngine(top, v - n + i3, 1.0, 0.791 - 1.0 * (double)i3 / (double)n);
                this.setEngine(n3, engine);
                engine.setMin(0.526);
                engine.setMax(1.474);
                this.setEdgeLength(top, v - n + i3, 1.054);
                ++k;
            }
            ++i3;
        }
        this.setNumRigidUnits(rig + 1);
        piv = new PiVector(n);
        i3 = 0;
        while (i3 < n) {
            piv.setEntry(i3, v - n + i3);
            ++i3;
        }
        this.setRigidUnit(rig++, new PgRigidUnit(3, piv, this.m_geometry.getVertices()));
        this.m_elementSet.showEdges(true);
        this.m_elementSet.showVertices(true);
        this.m_elementSet.showElements(false);
        PgPhysicalGeometryDescriptor d = new PgPhysicalGeometryDescriptor();
        d.setIterationsPerFrame(75);
        d.setStepSize(5.0E-4);
        d.setAirFriction(0.9);
        d.setElementFriction(0.0);
        d.setPotential(50.0);
        d.setSpring(4000.0);
        d.setRestrictGradient(0);
        d.setConstrainCenter(0);
        d.setFitPotential(0);
        this.setGeometryDescriptor(d);
    }
}

