/*
 * Decompiled with CFR 0.152.
 */
package devParticle.physicalShape;

import devParticle.engine.PnEdgeEngine;
import devParticle.physical.PgPhysicalElementSet;
import devParticle.physical.PgPhysicalGeometryDescriptor;
import devParticle.physical.PgRigidUnit;
import jv.vecmath.PiVector;

public class PgAutoGeom
extends PgPhysicalElementSet {
    public PgAutoGeom() {
        if (((Object)((Object)this)).getClass() == PgAutoGeom.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.setName("Auto");
        int n = 9;
        int k = 1;
        int g = 0;
        int numeng = (int)Math.ceil(n / k);
        this.setNumVertices(4 * n + 4 + g * n);
        int i = 0;
        while (i < n) {
            this.setVertex(i, 0.5 * Math.sin(Math.PI * 2 * (double)i / (double)n) - 1.0, -1.0, 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)n) + 0.5);
            this.setVertex(n + i, 0.5 * Math.sin(Math.PI * 2 * (double)i / (double)n) - 1.0, 1.0, 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)n) + 0.5);
            this.setVertex(2 * n + i, 0.5 * Math.sin(Math.PI * 2 * (double)i / (double)n) + 1.0, -1.0, 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)n) + 0.5);
            this.setVertex(3 * n + i, 0.5 * Math.sin(Math.PI * 2 * (double)i / (double)n) + 1.0, 1.0, 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)n) + 0.5);
            ++i;
        }
        this.setVertex(4 * n, -1.0, -1.0, 0.5);
        this.setVertex(4 * n + 1, -1.0, 1.0, 0.5);
        this.setVertex(4 * n + 2, 1.0, -1.0, 0.5);
        this.setVertex(4 * n + 3, 1.0, 1.0, 0.5);
        i = 0;
        while (i < g * n) {
            this.setVertex(4 * n + 4 + i, 1.0, -1.0 + 2.0 * (double)i / (double)(g * n), 0.5);
            ++i;
        }
        this.setNumElements(5 + 2 * numeng);
        PiVector piv1 = new PiVector(n);
        PiVector piv2 = new PiVector(n);
        PiVector piv3 = new PiVector(n);
        PiVector piv4 = new PiVector(n);
        int i2 = 0;
        while (i2 < n) {
            piv1.setEntry(i2, i2);
            piv2.setEntry(i2, n + i2);
            piv3.setEntry(i2, 2 * n + i2);
            piv4.setEntry(i2, 3 * n + i2);
            ++i2;
        }
        this.setElement(0, piv1);
        this.setElement(1, piv2);
        this.setElement(2, piv3);
        this.setElement(3, piv4);
        this.setElement(4, new PiVector(4 * n + 1, 4 * n + 3, 4 * n + 0, 4 * n + 2));
        i2 = 0;
        while (i2 < numeng) {
            this.setElement(5 + i2, new PiVector(4 * n, 4 * n, 2 * n + k * i2));
            this.setElement(5 + numeng + i2, new PiVector(4 * n + 1, 4 * n + 1, 3 * n + k * i2));
            ++i2;
        }
        piv1 = new PiVector(2 * n + 2);
        piv2 = new PiVector(2 * n + 2 + g * n);
        i2 = 0;
        while (i2 < 2 * n) {
            piv1.setEntry(i2, i2);
            piv2.setEntry(i2, 2 * n + i2);
            ++i2;
        }
        piv1.setEntry(2 * n, 4 * n);
        piv1.setEntry(2 * n + 1, 4 * n + 1);
        piv2.setEntry(2 * n, 4 * n + 2);
        piv2.setEntry(2 * n + 1, 4 * n + 3);
        i2 = 0;
        while (i2 < g * n) {
            piv2.setEntry(2 * n + 2 + i2, 4 * n + 4 + i2);
            ++i2;
        }
        this.setNumRigidUnits(2);
        PgRigidUnit r = new PgRigidUnit(3, piv1, this.m_geometry.getVertices());
        this.setRigidUnit(0, r);
        r.rotate(0.0, 1.0, 0.0, Math.PI * 4);
        r = new PgRigidUnit(3, piv2, this.m_geometry.getVertices());
        this.setRigidUnit(1, r);
        r.rotate(0.0, 1.0, 0.0, Math.PI * 4);
        this.setNumEngines(2 * numeng);
        int i3 = 0;
        while (i3 < numeng) {
            PnEdgeEngine eng = new PnEdgeEngine(4 * n, 2 * n + k * i3, 0.5, 0.5 * (1.0 * (double)k * (double)i3 / (double)n));
            this.setEngine(i3, eng);
            this.setEdgeLength(4 * n, 2 * n + k * i3, 2.2);
            eng.setMin(0.75);
            eng.setMax(1.25);
            eng = new PnEdgeEngine(4 * n + 1, 3 * n + k * i3, 0.5, 0.5 * (1.0 * (double)k * (double)i3 / (double)n));
            this.setEngine(numeng + i3, eng);
            this.setEdgeLength(4 * n + 1, 3 * n + k * i3, 2.2);
            eng.setMin(0.75);
            eng.setMax(1.25);
            ++i3;
        }
        this.m_elementSet.showEdges(true);
        this.m_elementSet.showVertices(true);
        this.m_elementSet.showElements(false);
        PgPhysicalGeometryDescriptor d = new PgPhysicalGeometryDescriptor();
        d.setIterationsPerFrame(100);
        d.setStepSize(1.0E-4);
        d.setAirFriction(0.9);
        d.setElementFriction(0.0);
        d.setPotential(1000.0);
        d.setSpring(100000.0);
        d.setRestrictGradient(0);
        d.setConstrainCenter(0);
        d.setFitPotential(1);
        this.setGeometryDescriptor(d);
    }
}

