/*
 * Decompiled with CFR 0.152.
 */
package devParticle.physical;

import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgRigidUnit
extends PsObject {
    public PiVector m_vertices;
    public PdVector m_center;
    public PdVector m_velocity;
    public PdMatrix m_momentum;
    public int m_dim;
    public PdMatrix m_inertiaMoment;
    public PdVector[] m_coord;

    public PgRigidUnit(int dim) {
        this.m_vertices = new PiVector(0);
    }

    public PgRigidUnit(int dim, PiVector vertices, PdVector[] coords) {
        this.m_vertices = vertices;
        this.m_dim = dim;
        this.m_center = new PdVector(this.m_dim);
        this.m_velocity = new PdVector(this.m_dim);
        this.m_momentum = new PdMatrix(this.m_dim);
        this.m_inertiaMoment = new PdMatrix(this.m_dim);
        this.m_coord = coords;
        this.calculateInertiaMoment();
    }

    public Object copyNew() {
        PgRigidUnit newObject = new PgRigidUnit(this.m_dim);
        newObject.m_vertices = PiVector.copyNew((PiVector)this.m_vertices);
        newObject.m_center = PdVector.copyNew((PdVector)this.m_center);
        newObject.m_velocity = PdVector.copyNew((PdVector)this.m_velocity);
        newObject.m_momentum = PdMatrix.copyNew((PdMatrix)this.m_momentum);
        newObject.m_inertiaMoment = PdMatrix.copyNew((PdMatrix)this.m_inertiaMoment);
        newObject.m_coord = PdVector.copyNew((PdVector[])this.m_coord);
        return newObject;
    }

    private void calculateCenter() {
        this.m_center.setConstant(0.0);
        int v = 0;
        while (v < this.m_vertices.m_data.length) {
            this.m_center.add(this.m_coord[this.m_vertices.m_data[v]]);
            ++v;
        }
        this.m_center.multScalar(1.0 / (double)this.m_vertices.m_data.length);
    }

    private void calculateInertiaMoment() {
        this.calculateCenter();
        this.m_inertiaMoment.setConstant(0.0);
        int v = 0;
        while (v < this.m_vertices.m_data.length) {
            double r2 = 0.0;
            int i = 0;
            while (i < this.m_dim) {
                r2 += (this.m_coord[this.m_vertices.m_data[v]].m_data[i] - this.m_center.m_data[i]) * (this.m_coord[this.m_vertices.m_data[v]].m_data[i] - this.m_center.m_data[i]);
                ++i;
            }
            i = 0;
            while (i < this.m_dim) {
                int j = 0;
                while (j < this.m_dim) {
                    double[] dArray = this.m_inertiaMoment.m_data[i];
                    int n = j;
                    dArray[n] = dArray[n] - (this.m_coord[this.m_vertices.m_data[v]].m_data[i] - this.m_center.m_data[i]) * (this.m_coord[this.m_vertices.m_data[v]].m_data[j] - this.m_center.m_data[j]);
                    ++j;
                }
                double[] dArray = this.m_inertiaMoment.m_data[i];
                int n = i++;
                dArray[n] = dArray[n] + r2;
            }
            ++v;
        }
    }

    public void rotate(double x, double y, double z, double omega) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            PsDebug.warning((String)"Cannot rotate around axis (0, 0, 0).");
            return;
        }
        PdVector a = new PdVector(3);
        a.setConstant(1.0);
        if (Math.abs(x) > Math.abs(y)) {
            if (Math.abs(x) > Math.abs(z)) {
                a.m_data[0] = -(y + z) / x;
            } else {
                a.m_data[2] = -(x + y) / z;
            }
        } else if (Math.abs(y) > Math.abs(z)) {
            a.m_data[1] = -(x + z) / y;
        } else {
            a.m_data[2] = -(x + y) / z;
        }
        a.normalize();
        PdVector b = new PdVector(3);
        b.m_data[0] = a.m_data[2] * y - a.m_data[1] * z;
        b.m_data[1] = a.m_data[0] * z - a.m_data[2] * x;
        b.m_data[2] = a.m_data[1] * x - a.m_data[0] * y;
        b.normalize();
        PdMatrix m = new PdMatrix(3);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                m.m_data[i][j] = omega * (-a.m_data[i] * b.m_data[j] + b.m_data[i] * a.m_data[j]);
                ++j;
            }
            ++i;
        }
        this.m_momentum.add(m);
    }
}

