/*
 * Decompiled with CFR 0.152.
 */
package devParticle.physical;

import devParticle.engine.PnEngine;
import devParticle.physical.PgPhysicalElementSet;
import devParticle.physical.PgPhysicalGeometryDescriptor;
import devParticle.physical.PgRigidUnit;
import java.awt.Component;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgPhysicalGeometry
extends PsObject {
    public PgPointSet m_geometry;
    public int m_dim;
    protected int m_numVertices;
    protected PnEngine[] m_engines;
    protected int m_numRigidUnits;
    protected PgRigidUnit[] m_rigidUnits;
    public PiVector m_ru;
    public PdVector m_vertexVelocity;
    protected PdVector[] m_vertexVelocityVectors;
    protected PgPhysicalGeometryDescriptor m_descriptor;

    public static PgPhysicalGeometry createPhysical(PgPointSet geom) {
        if (geom == null) {
            PsDebug.warning((String)"Missing geometry.");
            return null;
        }
        PgPhysicalGeometry physGeom = null;
        if (geom instanceof PgElementSet) {
            physGeom = new PgPhysicalElementSet();
            physGeom.setGeometry((PgPointSet)((PgElementSet)geom));
        } else {
            physGeom = new PgPhysicalGeometry();
            physGeom.setGeometry(geom);
        }
        return physGeom;
    }

    public PgPhysicalGeometry() {
        if (this.m_geometry == null && ((Object)((Object)this)).getClass() == PgPhysicalGeometry.class) {
            this.setGeometry(new PgPointSet(3));
        }
        if (((Object)((Object)this)).getClass() == PgPhysicalGeometry.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_vertexVelocity = null;
        this.m_ru = null;
        this.m_engines = null;
        this.m_numVertices = 0;
        this.m_numRigidUnits = 0;
        this.m_dim = 0;
        this.m_rigidUnits = null;
        this.m_vertexVelocityVectors = null;
        this.m_descriptor = null;
    }

    public void setName(String name) {
        super.setName(name);
        if (this.m_geometry != null) {
            this.m_geometry.setName(name);
        }
    }

    public void setGeometry(PgPointSet geom) {
        if (this.m_geometry != null) {
            this.m_geometry.setParent(null);
        }
        this.m_geometry = geom;
        if (this.m_geometry != null) {
            this.m_geometry.setParent((PsUpdateIf)this);
        }
        this.updateCombinatoric();
    }

    public void removeGeometry() {
        this.setGeometry(null);
    }

    public boolean update(Object event) {
        if (event == this.m_geometry) {
            super.update((Object)this);
        }
        if (event != null) {
            return true;
        }
        return super.update(event);
    }

    public void copy(PgPhysicalGeometry g) {
        int i;
        super.copy((PsObject)g);
        this.m_numVertices = g.m_numVertices;
        this.m_geometry = g.m_geometry;
        this.m_dim = g.m_dim;
        this.m_vertexVelocity = g.m_vertexVelocity == null ? null : PdVector.copyNew((PdVector)g.m_vertexVelocity);
        if (g.m_engines == null) {
            this.m_engines = null;
        } else {
            this.m_engines = new PnEngine[g.m_engines.length];
            int j = 0;
            while (j < g.m_engines.length) {
                this.m_engines[j] = g.m_engines[j].copyNew();
                ++j;
            }
        }
        this.m_ru = g.m_ru == null ? null : PiVector.copyNew((PiVector)g.m_ru);
        this.m_numRigidUnits = g.m_numRigidUnits;
        if (g.m_rigidUnits == null) {
            this.m_rigidUnits = null;
        } else {
            this.m_rigidUnits = new PgRigidUnit[g.m_rigidUnits.length];
            i = 0;
            while (i < g.m_rigidUnits.length) {
                this.m_rigidUnits[i] = (PgRigidUnit)((Object)g.m_rigidUnits[i].copyNew());
                ++i;
            }
        }
        if (g.m_vertexVelocityVectors == null) {
            this.m_vertexVelocityVectors = null;
        } else {
            this.m_vertexVelocityVectors = new PdVector[g.m_vertexVelocityVectors.length];
            i = 0;
            while (i < g.m_vertexVelocityVectors.length) {
                this.m_vertexVelocityVectors[i] = PdVector.copyNew((PdVector)g.m_vertexVelocityVectors[i]);
                ++i;
            }
        }
    }

    public PgPhysicalGeometry copyNew() {
        PgPhysicalGeometry g = new PgPhysicalGeometry();
        g.copy(this);
        return g;
    }

    public void updateCombinatoric() {
        block11: {
            if (this.m_geometry == null || this.m_geometry.getNumVertices() == 0) {
                this.m_vertexVelocity = null;
                this.m_numVertices = 0;
                return;
            }
            int numVerticesBefore = this.m_numVertices;
            this.m_numVertices = this.m_geometry.getNumVertices();
            this.m_dim = this.m_geometry.getDimOfVectors();
            if (this.m_vertexVelocity == null || this.m_dim * this.m_geometry.getNumVertices() != this.m_vertexVelocity.getSize()) {
                PdVector newVertexVelocity = new PdVector(this.m_dim * this.m_geometry.getNumVertices());
                newVertexVelocity.setConstant(0.0);
                if (this.m_vertexVelocity != null) {
                    int k = 0;
                    while (k < this.m_vertexVelocity.getSize() && k < newVertexVelocity.getSize()) {
                        newVertexVelocity.setEntry(k, this.m_vertexVelocity.getEntry(k));
                        ++k;
                    }
                }
                this.m_vertexVelocity = newVertexVelocity;
            }
            if (this.m_vertexVelocityVectors != null && this.m_vertexVelocityVectors.length != this.m_numVertices) {
                this.m_vertexVelocityVectors = null;
            }
            if (numVerticesBefore == this.m_numVertices) break block11;
            if (this.m_ru == null) {
                this.m_ru = new PiVector(this.m_numVertices);
                int i = 0;
                while (i < this.m_numVertices) {
                    this.m_ru.m_data[i] = i;
                    ++i;
                }
            } else {
                int newLength = this.m_ru.getSize();
                int pos = 0;
                while (pos < newLength) {
                    if (this.m_ru.m_data[pos] >= this.m_numVertices) {
                        this.m_ru.m_data[pos] = this.m_ru.m_data[newLength - 1];
                        --newLength;
                        continue;
                    }
                    ++pos;
                }
                this.m_ru.setSize(newLength += this.m_numVertices - numVerticesBefore);
                int i = 0;
                while (pos < newLength) {
                    this.m_ru.m_data[pos] = numVerticesBefore + i++;
                    ++pos;
                }
            }
        }
    }

    public boolean combinatoricHasChanged() {
        return this.m_geometry.getNumVertices() != this.m_numVertices || this.m_dim != this.m_geometry.getDimOfVectors();
    }

    public void reset() {
        if (this.m_vertexVelocity != null) {
            this.m_vertexVelocity.setConstant(0.0);
        }
        if (this.m_rigidUnits != null) {
            int i = 0;
            while (i < this.m_rigidUnits.length) {
                if (this.m_rigidUnits[i] != null) {
                    this.m_rigidUnits[i].m_velocity.setConstant(0.0);
                    this.m_rigidUnits[i].m_momentum.setConstant(0.0);
                }
                ++i;
            }
        }
        this.resetEngines();
    }

    public void setNumEngines(int numEngines) {
        PnEngine[] newEngines = new PnEngine[numEngines];
        if (this.m_engines != null) {
            int i = 0;
            while (i < this.m_engines.length && i < numEngines) {
                newEngines[i] = this.m_engines[i];
                ++i;
            }
        }
        this.m_engines = newEngines;
    }

    public int getNumEngines() {
        if (this.m_engines == null) {
            return 0;
        }
        return this.m_engines.length;
    }

    public void setEngine(int index, PnEngine engine) {
        if (this.m_engines == null || index < 0 || index >= this.m_engines.length) {
            PsDebug.warning((String)("Cannot set engine (" + index + "). Index out of range."));
            return;
        }
        this.m_engines[index] = engine;
        engine.setGeometry(this);
    }

    public PnEngine getEngine(int index) {
        if (this.m_engines == null || index < 0 || index >= this.m_engines.length) {
            PsDebug.warning((String)("Cannot return engine (" + index + "). Index out of range."));
            return null;
        }
        return this.m_engines[index];
    }

    public void stepEngines(double stepSize) {
        if (this.m_engines != null) {
            int i = 0;
            while (i < this.m_engines.length) {
                if (this.m_engines[i] != null) {
                    this.m_engines[i].step(stepSize);
                }
                ++i;
            }
        }
    }

    public void resetEngines() {
        if (this.m_engines == null) {
            return;
        }
        int i = 0;
        while (i < this.m_engines.length) {
            if (this.m_engines[i] != null) {
                this.m_engines[i].reset();
            }
            ++i;
        }
    }

    public void invertEngines() {
        if (this.m_engines == null) {
            return;
        }
        int i = 0;
        while (i < this.m_engines.length) {
            if (this.m_engines[i] != null) {
                this.m_engines[i].invert();
            }
            ++i;
        }
    }

    public PdVector subEngineForces(PdVector coord, PdVector gradient) {
        if (this.m_engines == null) {
            return gradient;
        }
        int numEngines = this.m_engines.length;
        int i = 0;
        while (i < numEngines) {
            if (this.m_engines[i] != null) {
                this.m_engines[i].subEngineForces(coord, gradient);
            }
            ++i;
        }
        return gradient;
    }

    public void setNumRigidUnits(int numRigidUnits) {
        if (numRigidUnits < 0) {
            PsDebug.warning((String)"number of rigid units cannot be less than 0");
            return;
        }
        if (numRigidUnits != this.m_numRigidUnits) {
            PgRigidUnit[] newUnits = new PgRigidUnit[numRigidUnits];
            int i = 0;
            while (i < numRigidUnits && i < this.m_numRigidUnits) {
                newUnits[i] = this.m_rigidUnits[i];
                ++i;
            }
            i = this.m_numRigidUnits;
            while (i < numRigidUnits) {
                newUnits[i] = null;
                ++i;
            }
            i = numRigidUnits;
            while (i < this.m_numRigidUnits) {
                this.removeRigidUnit(i);
                ++i;
            }
            this.m_rigidUnits = newUnits;
            this.m_numRigidUnits = numRigidUnits;
        }
    }

    public int getNumRigidUnits() {
        return this.m_numRigidUnits;
    }

    public PgRigidUnit getRigidUnit(int ind) {
        if (ind < 0 || ind >= this.m_numRigidUnits) {
            PsDebug.warning((String)"Index out of range of rigid unit array.");
            return null;
        }
        return this.m_rigidUnits[ind];
    }

    public void setRigidUnit(int index, PgRigidUnit rigidUnit) {
        int i;
        if (index < 0) {
            PsDebug.warning((String)"Index cannot be lower than 0 in setRigidUnit()");
            return;
        }
        if (index >= this.m_numRigidUnits) {
            PsDebug.warning((String)"Rigid unit array is not long enaugh in setRigidUnit(). It will be extended.");
            this.setNumRigidUnits(index + 1);
        }
        if (this.combinatoricHasChanged()) {
            this.updateCombinatoric();
        }
        int len = rigidUnit.m_vertices.getSize();
        int ruSize = this.m_ru.getSize();
        int numFoundVertices = 0;
        int pos = 0;
        while (pos < len) {
            i = 0;
            while (i < ruSize) {
                if (this.m_ru.m_data[i] == rigidUnit.m_vertices.m_data[pos]) {
                    ++numFoundVertices;
                }
                ++i;
            }
            ++pos;
        }
        if (numFoundVertices != rigidUnit.m_vertices.getSize()) {
            PsDebug.warning((String)"Not all vertices of rigid unit are valid. Vertices of rigid units must be disjoint.");
            return;
        }
        if (this.m_rigidUnits[index] != null) {
            this.removeRigidUnit(index);
        }
        int minPos = 0;
        i = 0;
        while (i < ruSize) {
            this.m_ru.m_data[minPos] = this.m_ru.m_data[i];
            ++minPos;
            int pos2 = 0;
            while (pos2 < len) {
                if (this.m_ru.m_data[i] == rigidUnit.m_vertices.m_data[pos2]) {
                    --minPos;
                    pos2 = len;
                }
                ++pos2;
            }
            ++i;
        }
        this.m_ru.setSize(minPos + 1);
        this.m_ru.m_data[minPos] = -index - 1;
        this.m_rigidUnits[index] = rigidUnit;
    }

    public void removeRigidUnit(int index) {
        if (index > this.m_rigidUnits.length || this.m_rigidUnits[index] == null) {
            PsDebug.warning((String)("Cannot remove rigid unit " + index + " (does not exist)"));
            return;
        }
        int oldLen = this.m_ru.getSize();
        this.m_ru.setSize(oldLen + this.m_rigidUnits[index].m_vertices.getSize());
        int rigidUnitSize = this.m_rigidUnits[index].m_vertices.getSize();
        int j = 0;
        while (j < rigidUnitSize) {
            this.m_ru.m_data[oldLen + j] = this.m_rigidUnits[index].m_vertices.m_data[j];
            ++j;
        }
        this.m_rigidUnits[index] = null;
    }

    public void setNumVertices(int numVertices) {
        if (this.m_geometry == null) {
            return;
        }
        this.m_geometry.setNumVertices(numVertices);
    }

    public void setVertex(int index, PdVector vertex) {
        if (this.m_geometry == null) {
            return;
        }
        this.m_geometry.setVertex(index, vertex);
    }

    public void setVertex(int index, double v1, double v2, double v3) {
        if (this.m_geometry == null) {
            return;
        }
        this.m_geometry.setVertex(index, v1, v2, v3);
    }

    public PdVector[] getVelocityVectors() {
        return this.m_vertexVelocityVectors;
    }

    public void setVelocityVectors(PdVector[] velocityVectors) {
        this.m_vertexVelocityVectors = velocityVectors;
    }

    public void fillVelocityVectors() {
        if (this.m_vertexVelocityVectors == null) {
            PsDebug.warning((String)"velocity vectors not set");
            return;
        }
        if (this.m_vertexVelocityVectors.length != this.m_geometry.getNumVertices()) {
            PsDebug.warning((String)"wrong number of velocity vectors.");
            return;
        }
        int ind = 0;
        int i = 0;
        while (i < this.m_vertexVelocityVectors.length) {
            int j = 0;
            while (j < this.m_dim) {
                this.m_vertexVelocityVectors[i].m_data[j] = this.m_vertexVelocity.m_data[ind++];
                ++j;
            }
            ++i;
        }
    }

    public PsPanel getEnginePanel() {
        PsPanel p = new PsPanel();
        if (this.m_engines == null || this.m_engines.length == 0) {
            return p;
        }
        int i = 0;
        while (i < this.m_engines.length) {
            PsPanel ap;
            if (this.m_engines[i] != null && (ap = this.m_engines[i].getAdjustmentPanel()) != null) {
                p.addTitle(this.m_engines[i].getName());
                p.add((Component)ap);
            }
            ++i;
        }
        return p;
    }

    public PsPanel getGeometryPanel() {
        return null;
    }

    public void setGeometryDescriptor(PgPhysicalGeometryDescriptor d) {
        this.m_descriptor = d;
    }

    public PgPhysicalGeometryDescriptor getGeometryDescriptor() {
        if (this.m_descriptor == null) {
            this.m_descriptor = new PgPhysicalGeometryDescriptor();
        }
        return this.m_descriptor;
    }

    public boolean hasGeometryDescriptor() {
        return this.m_descriptor != null;
    }
}

