/*
 * Decompiled with CFR 0.152.
 */
package devParticle.physical;

import devParticle.engine.PnEngine;
import devParticle.physical.PgPhysicalGeometry;
import jv.geom.PgBndPolygon;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgPhysicalElementSet
extends PgPhysicalGeometry {
    public PgElementSet m_elementSet;
    protected PiVector[] m_edges;
    protected int m_numEdges;
    protected double[] m_edgeLength;
    protected double[] m_edgeEngineState;
    protected int m_numberOfElements;
    protected PgBndPolygon[] m_boundary;

    public static PgPhysicalElementSet createPhysical(PgElementSet geom) {
        if (geom == null) {
            PsDebug.warning((String)"Missing geometry.");
            return null;
        }
        PgPhysicalElementSet physGeom = null;
        physGeom = new PgPhysicalElementSet();
        physGeom.setGeometry((PgPointSet)geom);
        return physGeom;
    }

    public PgPhysicalElementSet() {
        if (this.m_elementSet == null) {
            this.setGeometry((PgPointSet)new PgElementSet(3));
        }
        if (((Object)((Object)this)).getClass() == PgPhysicalElementSet.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.m_edges = null;
        this.m_numEdges = 0;
        this.m_edgeLength = null;
        this.m_edgeEngineState = null;
        this.m_numberOfElements = 0;
        this.m_boundary = null;
    }

    @Override
    public void setGeometry(PgPointSet geom) {
        if (!(geom instanceof PgElementSet)) {
            PsDebug.warning((String)"Geometry must derive from PgElementSet");
            return;
        }
        super.setGeometry(geom);
        this.m_elementSet = (PgElementSet)geom;
    }

    @Override
    public void removeGeometry() {
        this.setGeometry(null);
    }

    @Override
    public boolean update(Object event) {
        if (event == this.m_elementSet) {
            this.m_elementSet.makeElementNormals();
            super.update((Object)this);
        } else if (event != null) {
            return true;
        }
        return super.update(event);
    }

    public Object clone() {
        PgPhysicalElementSet newObject = (PgPhysicalElementSet)((Object)super.clone());
        newObject.m_numberOfElements = this.m_numberOfElements;
        newObject.m_elementSet = this.m_elementSet;
        newObject.m_numEdges = this.m_numEdges;
        newObject.m_edges = this.m_edges == null ? null : PiVector.copyNew((PiVector[])this.m_edges);
        if (this.m_edgeLength == null) {
            newObject.m_edgeLength = null;
        } else {
            newObject.m_edgeLength = new double[this.m_edgeLength.length];
            int i = 0;
            while (i < this.m_edgeLength.length) {
                newObject.m_edgeLength[i] = this.m_edgeLength[i];
                ++i;
            }
        }
        if (this.m_edgeEngineState == null) {
            newObject.m_edgeEngineState = null;
        } else {
            newObject.m_edgeEngineState = new double[this.m_edgeEngineState.length];
            int j = 0;
            while (j < this.m_edgeEngineState.length) {
                newObject.m_edgeEngineState[j] = this.m_edgeEngineState[j];
                ++j;
            }
        }
        return newObject;
    }

    @Override
    public void updateCombinatoric() {
        super.updateCombinatoric();
        if (this.m_geometry == null || this.m_geometry.getNumVertices() == 0) {
            this.m_edges = null;
            this.m_edgeLength = null;
            this.m_edgeEngineState = null;
            this.m_numEdges = 0;
            this.m_numberOfElements = 0;
            return;
        }
        this.m_numberOfElements = this.m_elementSet.getNumElements();
        this.m_boundary = this.m_elementSet.getBoundaries();
        PgEdgeStar[] newEdges = this.m_elementSet.makeEdgeStars();
        if (newEdges == null) {
            this.m_edges = null;
            this.m_numEdges = 0;
            this.m_edgeLength = null;
            this.m_edgeEngineState = null;
            return;
        }
        this.m_numEdges = newEdges.length;
        double[] newEdgeLength = new double[this.m_numEdges];
        double[] newEdgeEngineState = new double[this.m_numEdges];
        int minIndex = 0;
        PiVector[] piNewEdges = new PiVector[this.m_numEdges];
        int i = 0;
        while (i < this.m_numEdges) {
            piNewEdges[i] = new PiVector(newEdges[i].getVertexInd(0), newEdges[i].getVertexInd(1));
            boolean found = false;
            if (this.m_edges != null) {
                int j = minIndex;
                while (j < this.m_edges.length) {
                    if (this.m_edges[j].m_data[0] == newEdges[i].getVertexInd(0) && this.m_edges[j].m_data[1] == newEdges[i].getVertexInd(1) || this.m_edges[j].m_data[0] == newEdges[i].getVertexInd(1) && this.m_edges[j].m_data[1] == newEdges[i].getVertexInd(0)) {
                        found = true;
                        newEdgeLength[i] = this.m_edgeLength[j];
                        newEdgeEngineState[i] = this.m_edgeEngineState[j];
                        if (j != minIndex) break;
                        ++minIndex;
                        break;
                    }
                    ++j;
                }
            }
            if (!found) {
                PdVector vec1 = this.m_elementSet.getVertex(newEdges[i].getVertexInd(0));
                PdVector vec2 = this.m_elementSet.getVertex(newEdges[i].getVertexInd(1));
                PdVector dist = PdVector.subNew((PdVector)vec2, (PdVector)vec1);
                newEdgeLength[i] = dist.length();
                newEdgeEngineState[i] = 1.0;
            }
            ++i;
        }
        this.m_edges = piNewEdges;
        this.m_edgeLength = newEdgeLength;
        this.m_edgeEngineState = newEdgeEngineState;
        this.m_numberOfElements = this.m_elementSet.getNumElements();
    }

    @Override
    public boolean combinatoricHasChanged() {
        PgBndPolygon[] bp = this.m_elementSet.getBoundaries();
        boolean bound = false;
        if (bp != this.m_boundary) {
            bound = true;
        }
        this.m_boundary = bp;
        return this.m_elementSet.getNumElements() != this.m_numberOfElements || super.combinatoricHasChanged() || bound;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.m_edgeEngineState != null) {
            int i = 0;
            while (i < this.m_edgeEngineState.length) {
                this.m_edgeEngineState[i] = 1.0;
                ++i;
            }
        }
    }

    public int getNumStoredEdges() {
        if (this.combinatoricHasChanged()) {
            this.updateCombinatoric();
        }
        return this.m_numEdges;
    }

    public PiVector getStoredEdge(int index) {
        if (this.combinatoricHasChanged()) {
            this.updateCombinatoric();
        }
        return this.m_edges[index];
    }

    public PiVector[] getStoredEdges() {
        if (this.combinatoricHasChanged()) {
            this.updateCombinatoric();
        }
        return this.m_edges;
    }

    public double getEdgeEngineState(int edgeIndex) {
        return this.m_edgeEngineState[edgeIndex];
    }

    public void setEdgeEngineState(int edgeIndex, double state) {
        this.m_edgeEngineState[edgeIndex] = state;
    }

    public double getEdgeLength(int edgeIndex) {
        if (this.m_edgeEngineState[edgeIndex] == 1.0) {
            return this.m_edgeLength[edgeIndex];
        }
        return this.m_edgeLength[edgeIndex] * this.m_edgeEngineState[edgeIndex];
    }

    public void setEdgeLength(int vertex1, int vertex2, double length) {
        if (this.combinatoricHasChanged()) {
            this.updateCombinatoric();
        }
        int edgeIndex = -1;
        int i = 0;
        while (edgeIndex < 0 && i < this.m_numEdges) {
            if (this.m_edges[i].m_data[0] == vertex1 && this.m_edges[i].m_data[1] == vertex2 || this.m_edges[i].m_data[0] == vertex2 && this.m_edges[i].m_data[1] == vertex1) {
                edgeIndex = i;
            }
            ++i;
        }
        if (edgeIndex < 0) {
            PsDebug.warning((String)("edge (" + vertex1 + "," + vertex2 + ") does not exist in setEdgeLength()"));
            return;
        }
        this.m_edgeLength[edgeIndex] = length;
    }

    @Override
    public void setNumEngines(int numEngines) {
        PnEngine[] newEngines = new PnEngine[numEngines];
        if (this.m_engines != null) {
            int i = 0;
            while (i < this.m_engines.length && i < numEngines) {
                newEngines[i] = this.m_engines[i];
                ++i;
            }
        }
        this.m_engines = newEngines;
    }

    @Override
    public int getNumEngines() {
        if (this.m_engines == null) {
            return 0;
        }
        return this.m_engines.length;
    }

    public void setNumElements(int numElements) {
        if (this.m_elementSet == null) {
            return;
        }
        this.m_elementSet.setNumElements(numElements);
    }

    public void setElement(int index, PiVector element) {
        if (this.m_elementSet == null) {
            return;
        }
        this.m_elementSet.setElement(index, element);
    }
}

