/*
 * Decompiled with CFR 0.152.
 */
package devParticle.numerics;

import devParticle.energy.PnCenterConstraint;
import devParticle.energy.PnTotalEnergy;
import devParticle.numerics.PnEnergyIterator;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;

public class PnEnergyIterator_IP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PnEnergyIterator m_pnIterator;
    protected PsPanel m_pSlider;
    protected Button m_bIterate;
    protected Button m_bStep;
    protected boolean m_bIsRunning;
    protected TextField m_tFrameRateField;
    protected long m_frameRateValue;
    protected Checkbox m_cRestrictVelocity;
    protected Checkbox m_cConstrainCenter;
    protected Checkbox m_cPropsFromGeom;
    protected Checkbox m_cDebugRun;

    public PnEnergyIterator_IP() {
        if (this.getClass() == PnEnergyIterator_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addTitle("");
        this.m_bIsRunning = false;
        this.m_frameRateValue = 0L;
        this.m_pSlider = new PsPanel();
        this.add((Component)this.m_pSlider);
        Panel pCheckbox = new Panel(new GridLayout(2, 2));
        this.m_cRestrictVelocity = new Checkbox("Restrict velocity");
        this.m_cRestrictVelocity.addItemListener(this);
        pCheckbox.add(this.m_cRestrictVelocity);
        this.m_cConstrainCenter = new Checkbox("Preserve center");
        this.m_cConstrainCenter.addItemListener(this);
        pCheckbox.add(this.m_cConstrainCenter);
        this.m_cPropsFromGeom = new Checkbox("Props from geometry");
        this.m_cPropsFromGeom.addItemListener(this);
        pCheckbox.add(this.m_cPropsFromGeom);
        this.m_cDebugRun = new Checkbox("Debug run");
        this.m_cDebugRun.addItemListener(this);
        pCheckbox.add(this.m_cDebugRun);
        this.add(pCheckbox);
        this.m_tFrameRateField = new TextField(5);
        this.m_tFrameRateField.setEditable(false);
        this.addLabelComponent("Frame rate:", this.m_tFrameRateField);
        Panel panel = new Panel(new FlowLayout(1));
        this.m_bStep = new Button("Step");
        this.m_bStep.addActionListener(this);
        panel.add(this.m_bStep);
        this.m_bIterate = new Button("Iterate");
        this.m_bIterate.setBackground(Color.green);
        this.m_bIterate.addActionListener(this);
        panel.add(this.m_bIterate);
        this.add(panel);
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.setTitle(parent.getName());
        this.m_pnIterator = (PnEnergyIterator)parent;
        this.m_pSlider.removeAll();
        this.m_pSlider.add((Component)this.m_pnIterator.m_sIterationsPerFrame.assureInspector("Info", "_IP"));
        this.m_pSlider.add((Component)this.m_pnIterator.m_sStepSize.assureInspector("Info", "_IP"));
        this.m_pSlider.add((Component)this.m_pnIterator.m_sFriction.assureInspector("Info", "_IP"));
        this.m_pSlider.add((Component)this.m_pnIterator.m_sElementFriction.assureInspector("Info", "_IP"));
    }

    public boolean update(Object event) {
        if (this.m_pnIterator == null) {
            PsDebug.notify((String)"EnergyIterator_IP.update: missing parent");
            return true;
        }
        if (event == this.m_pnIterator) {
            PsPanel.setState((Checkbox)this.m_cRestrictVelocity, (boolean)this.m_pnIterator.m_restrictVelocity);
            PsPanel.setState((Checkbox)this.m_cConstrainCenter, (boolean)this.m_pnIterator.m_constrainCenter);
            PsPanel.setState((Checkbox)this.m_cPropsFromGeom, (boolean)this.m_pnIterator.m_propsFromGeom);
            PsPanel.setState((Checkbox)this.m_cDebugRun, (boolean)this.m_pnIterator.m_bDebugRun);
            this.m_cDebugRun.setBackground(this.m_pnIterator.m_bDebugRun ? Color.red : Color.white);
        }
        if (this.m_frameRateValue != this.m_pnIterator.m_frameRateField) {
            this.m_frameRateValue = this.m_pnIterator.m_frameRateField;
            this.m_tFrameRateField.setText("" + this.m_frameRateValue);
        }
        return super.update(event);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.m_pnIterator == null) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_bStep) {
            this.m_pnIterator.step();
            this.m_pnIterator.update(this.m_pnIterator);
        } else if (source == this.m_bIterate) {
            if (this.m_bIsRunning) {
                this.m_pnIterator.stopIteration();
                this.m_bIsRunning = false;
                this.m_bIterate.setLabel(" Iterate ");
                this.m_bIterate.setBackground(Color.green);
            } else {
                this.m_pnIterator.startIteration();
                this.m_bIsRunning = true;
                this.m_bIterate.setLabel(" Stop ");
                this.m_bIterate.setBackground(Color.red);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (this.m_pnIterator == null) {
            PsDebug.notify((String)"EnergyIterator_IP.update: missing parent");
            return;
        }
        Object source = event.getSource();
        PsDebug.notify((String)"entered");
        if (source == this.m_cRestrictVelocity) {
            this.m_pnIterator.m_restrictVelocity = this.m_cRestrictVelocity.getState();
        } else if (source == this.m_cConstrainCenter) {
            this.m_pnIterator.m_constrainCenter = this.m_cConstrainCenter.getState();
            if (this.m_pnIterator.m_energy instanceof PnTotalEnergy) {
                ((PnTotalEnergy)this.m_pnIterator.m_energy).setConstrain(this.m_pnIterator.m_constrainCenter ? new PnCenterConstraint() : null);
            }
        } else if (source == this.m_cPropsFromGeom) {
            this.m_pnIterator.m_propsFromGeom = this.m_cPropsFromGeom.getState();
        } else if (source == this.m_cDebugRun) {
            this.m_pnIterator.m_bDebugRun = this.m_cDebugRun.getState();
            this.m_cDebugRun.setBackground(this.m_pnIterator.m_bDebugRun ? Color.red : Color.white);
        }
    }
}

