/*
 * Decompiled with CFR 0.152.
 */
package devParticle.numerics;

import devParticle.energy.PnHomogenPotentialEnergy;
import devParticle.energy.PnSpringEnergy;
import devParticle.energy.PnTotalEnergy;
import devParticle.physical.PgPhysicalElementSet;
import devParticle.physical.PgPhysicalGeometry;
import devParticle.physical.PgPhysicalGeometryDescriptor;
import devParticle.physical.PgRigidUnit;
import java.util.Date;
import jv.geom.PgElementSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnEnergy;

public class PnEnergyIterator
extends PsObject
implements Runnable {
    protected static final boolean DEFAULT_DEBUG = false;
    protected static final double DEFAULT_FRICTION = 0.9;
    protected static final double DEFAULT_ELEMENT_FRICTION = 0.0;
    protected static final double DEFAULT_EPSILON = 0.001;
    protected static final int DEFAULT_NUM_ITERATIONS_PER_FRAME = 5;
    protected Thread m_thread;
    protected PuDouble m_sFriction;
    protected PuDouble m_sElementFriction;
    protected PuDouble m_sStepSize;
    protected PuInteger m_sIterationsPerFrame;
    protected long m_frameRateField;
    protected boolean m_restrictVelocity;
    protected PgPhysicalGeometry m_physGeom;
    protected int m_geomDim;
    private int dim_0;
    private PdVector[] m_geomVertex;
    private PdVector m_geomVelocity;
    protected PgElementSet m_collSurface;
    private int m_numCollElements;
    private PiVector[] m_collElement;
    private PdVector[] m_collVertex;
    private PdVector[] m_collNormal;
    protected PnEnergy m_energy;
    private PdVector m_coord;
    private PdVector m_gradient;
    protected PdVector m_force;
    protected PdVector m_center;
    protected boolean[] m_collOrientation;
    protected PdMatrix m_moment;
    protected int m_numVertices;
    protected boolean m_bIsRunning;
    protected boolean m_bIsStopped;
    protected Date m_date;
    private PdVector FOrth;
    private PdVector xS;
    private PdVector r;
    private PdVector rxN;
    private PdVector v_omega;
    private PdVector tmp;
    protected boolean m_propsFromGeom;
    private double m_stepSize;
    protected long m_frameRate;
    private double m_friction;
    private double m_elementFriction;
    protected int m_lastCollidedMarkedFace;
    protected boolean m_constrainCenter;
    protected boolean m_bDebugRun;
    protected boolean m_bStepRunning;

    public PnEnergyIterator() {
        this.setName("Iterator");
        this.m_thread = null;
        this.m_sFriction = new PuDouble("Air friction", (PsUpdateIf)this);
        this.m_sElementFriction = new PuDouble("Element friction", (PsUpdateIf)this);
        this.m_sStepSize = new PuDouble("Step size", (PsUpdateIf)this);
        this.m_sIterationsPerFrame = new PuInteger("Steps per frame", (PsUpdateIf)this);
        this.m_frameRateField = 0L;
        this.m_restrictVelocity = false;
        this.m_constrainCenter = false;
        this.m_bDebugRun = false;
        this.m_physGeom = null;
        this.m_collSurface = null;
        this.m_geomDim = 0;
        this.m_energy = null;
        this.m_coord = null;
        this.m_gradient = null;
        this.m_force = null;
        this.m_center = null;
        this.m_moment = null;
        this.m_collOrientation = null;
        this.m_numVertices = 0;
        this.m_bIsRunning = false;
        this.m_bIsStopped = false;
        this.m_date = new Date();
        this.m_stepSize = 0.0;
        this.m_frameRate = 0L;
        this.m_friction = 0.0;
        this.m_elementFriction = 0.0;
        this.m_lastCollidedMarkedFace = -1;
        this.m_propsFromGeom = true;
        this.m_bStepRunning = false;
        if (this.getClass() == PnEnergyIterator.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_sFriction.setDefValue(0.9);
        this.m_sFriction.setDefBounds(0.0, 1.0, 0.05, 0.05);
        this.m_sFriction.init();
        this.m_sElementFriction.setDefValue(0.0);
        this.m_sElementFriction.setDefBounds(0.0, 1000000.0, 10000.0, 100.0);
        this.m_sElementFriction.init();
        this.m_sStepSize.setDefValue(0.001);
        this.m_sStepSize.setDefBounds(0.0, 0.1, 0.001, 0.01);
        this.m_sStepSize.init();
        this.m_sIterationsPerFrame.setDefValue(5);
        this.m_sIterationsPerFrame.setDefBounds(0, 300, 1, 5);
        this.m_sIterationsPerFrame.init();
        this.update(this.m_sStepSize);
    }

    public void setSurface(PgPhysicalGeometry geom) {
        if (geom != null && geom.m_geometry != null && this.m_geomDim > 0 && geom.m_geometry.getDimOfVectors() != this.m_geomDim) {
            PsDebug.warning((String)"Dimension of surface and collision surface does not match.");
            return;
        }
        this.m_physGeom = geom;
        if (geom != null) {
            geom.setParent((PsUpdateIf)this);
            if (this.m_propsFromGeom && geom.hasGeometryDescriptor()) {
                int defaultConstrainCenter;
                double defaultRestrictGradient;
                double defaultElementFriction;
                double defaultAirFriction;
                double defaultStepSize;
                PgPhysicalGeometryDescriptor descr = geom.getGeometryDescriptor();
                int defaultIterationsPerFrame = descr.getIterationsPerFrame();
                if (defaultIterationsPerFrame > -1) {
                    if (defaultIterationsPerFrame > this.m_sIterationsPerFrame.getMax()) {
                        this.m_sIterationsPerFrame.setBounds(this.m_sIterationsPerFrame.getMin(), defaultIterationsPerFrame, this.m_sIterationsPerFrame.getDefLineIncr(), this.m_sIterationsPerFrame.getPageIncr());
                    }
                    this.m_sIterationsPerFrame.setValue(defaultIterationsPerFrame);
                    this.update(this.m_sIterationsPerFrame);
                }
                if ((defaultStepSize = descr.getStepSize()) > -1.0) {
                    if (defaultStepSize < this.m_sStepSize.getLineIncr()) {
                        this.m_sStepSize.setBounds(this.m_sStepSize.getMin(), this.m_sStepSize.getMax(), defaultStepSize, this.m_sStepSize.getPageIncr());
                    }
                    this.m_sStepSize.setValue(defaultStepSize);
                    this.update(this.m_sStepSize);
                }
                if ((defaultAirFriction = descr.getAirFriction()) > -1.0) {
                    if (defaultAirFriction > this.m_sFriction.getMax()) {
                        this.m_sFriction.setBounds(this.m_sFriction.getMin(), defaultAirFriction, this.m_sFriction.getDefLineIncr(), this.m_sFriction.getPageIncr());
                    }
                    this.m_sFriction.setValue(defaultAirFriction);
                    this.update(this.m_sFriction);
                }
                if ((defaultElementFriction = descr.getElementFriction()) > -1.0) {
                    if (defaultElementFriction > this.m_sElementFriction.getMax()) {
                        this.m_sElementFriction.setBounds(this.m_sElementFriction.getMin(), defaultElementFriction, this.m_sElementFriction.getDefLineIncr(), this.m_sElementFriction.getPageIncr());
                    }
                    this.m_sElementFriction.setValue(defaultElementFriction);
                    this.update(this.m_sElementFriction);
                }
                if (this.m_energy instanceof PnTotalEnergy) {
                    int defaultFitPotential;
                    double defaultSpring;
                    double defaultPotential = descr.getPotential();
                    if (defaultPotential > -1.0) {
                        ((PnTotalEnergy)this.m_energy).setWeight(PnHomogenPotentialEnergy.class, defaultPotential);
                    }
                    if ((defaultSpring = descr.getSpring()) > -1.0) {
                        ((PnTotalEnergy)this.m_energy).setWeight(PnSpringEnergy.class, defaultSpring);
                    }
                    if ((defaultFitPotential = descr.getFitPotential()) > -1) {
                        ((PnTotalEnergy)this.m_energy).setFitPotentialToCamera(defaultFitPotential != 0);
                    }
                }
                if ((defaultRestrictGradient = (double)descr.getRestrictGradient()) > -1.0) {
                    this.m_restrictVelocity = defaultRestrictGradient != 0.0;
                    this.update(this);
                }
                if ((defaultConstrainCenter = descr.getConstrainCenter()) > -1) {
                    this.m_constrainCenter = defaultConstrainCenter != 0;
                    this.update(this);
                }
            }
        }
        if (geom != null && geom.m_geometry != null) {
            this.m_numVertices = geom.m_geometry.getNumVertices();
            this.m_geomDim = geom.m_geometry.getDimOfVectors();
        } else if (this.m_collSurface == null) {
            this.m_numVertices = 0;
            this.m_geomDim = 0;
        }
        if (this.m_numVertices > 0) {
            this.m_gradient = new PdVector(this.m_geomDim * this.m_numVertices);
            this.m_coord = new PdVector(this.m_geomDim * this.m_numVertices);
            this.m_force = new PdVector(this.m_geomDim);
            this.m_center = new PdVector(this.m_geomDim);
            this.m_moment = new PdMatrix(this.m_geomDim, this.m_geomDim);
            this.FOrth = new PdVector(this.m_geomDim);
            this.xS = new PdVector(this.m_geomDim);
            this.r = new PdVector(this.m_geomDim);
            this.rxN = new PdVector(this.m_geomDim);
            this.v_omega = new PdVector(this.m_geomDim);
            this.tmp = new PdVector(this.m_geomDim);
        } else {
            this.m_gradient = null;
            this.m_coord = null;
            this.m_force = null;
            this.m_center = null;
            this.m_moment = null;
        }
    }

    public void setCollisionSurface(PgElementSet coll) {
        if (coll != null && this.m_geomDim > 0 && coll.getDimOfVectors() != this.m_geomDim) {
            PsDebug.warning((String)"Dimension of surface and collision surface does not match.");
            return;
        }
        this.m_collSurface = coll;
        if (coll == null && this.m_physGeom == null) {
            this.m_geomDim = 0;
        }
        if (coll != null) {
            this.m_geomDim = coll.getDimOfVectors();
            coll.makeElementNormals();
            coll.setParent((PsUpdateIf)this);
            this.m_collOrientation = new boolean[coll.getNumElements()];
        }
    }

    public void removeSurface() {
        this.setSurface(null);
    }

    public void removeCollisionSurface() {
        this.setCollisionSurface(null);
    }

    public void setEnergy(PnEnergy energy) {
        this.m_energy = energy;
    }

    public void step() {
        int numVertices;
        if (this.m_physGeom == null || this.m_numVertices == 0) {
            PsDebug.warning((String)"No surface set.");
            return;
        }
        if (this.m_bStepRunning) {
            return;
        }
        if (this.m_physGeom.combinatoricHasChanged()) {
            this.m_physGeom.updateCombinatoric();
            this.m_energy.update((Object)this.m_physGeom);
        }
        this.dim_0 = 0;
        if (this.m_restrictVelocity) {
            ++this.dim_0;
        }
        if (this.m_physGeom.getNumEngines() > 0) {
            this.m_physGeom.stepEngines(this.m_stepSize);
        }
        if (this.m_numVertices != (numVertices = this.m_physGeom.m_geometry.getNumVertices())) {
            this.m_coord = new PdVector(this.m_geomDim * numVertices);
            this.m_gradient = new PdVector(this.m_geomDim * numVertices);
            this.m_force = new PdVector(this.m_geomDim);
            this.m_center = new PdVector(this.m_geomDim);
            this.m_moment = new PdMatrix(this.m_geomDim, this.m_geomDim);
            this.FOrth = new PdVector(this.m_geomDim);
            this.xS = new PdVector(this.m_geomDim);
            this.r = new PdVector(this.m_geomDim);
            this.rxN = new PdVector(this.m_geomDim);
            this.v_omega = new PdVector(this.m_geomDim);
            this.tmp = new PdVector(this.m_geomDim);
            this.m_numVertices = numVertices;
        }
        this.m_geomVertex = this.m_physGeom.m_geometry.getVertices();
        this.m_geomVelocity = this.m_physGeom.m_vertexVelocity;
        if (this.m_energy != null) {
            int k = 0;
            int i = 0;
            while (i < numVertices) {
                int j = 0;
                while (j < this.m_geomDim) {
                    this.m_coord.m_data[k] = this.m_geomVertex[i].m_data[j];
                    ++k;
                    ++j;
                }
                ++i;
            }
            this.m_energy.evalGradient(this.m_coord, this.m_gradient);
        } else {
            this.m_gradient.setConstant(0.0);
        }
        this.m_physGeom.subEngineForces(this.m_coord, this.m_gradient);
        this.m_gradient.multScalar(this.m_stepSize);
        this.m_geomVelocity.multScalar(this.m_friction);
        if (this.m_elementFriction > 0.0) {
            this.applyElementFriction();
        }
        this.m_geomVelocity.sub(this.m_gradient);
        this.m_numCollElements = 0;
        this.m_collElement = null;
        this.m_collVertex = null;
        this.m_collNormal = null;
        if (this.m_collSurface != null) {
            this.m_collElement = this.m_collSurface.getElements();
            this.m_collVertex = this.m_collSurface.getVertices();
            this.m_collNormal = this.m_collSurface.getElementNormals();
            this.m_numCollElements = this.m_collSurface.getNumElements();
            if (this.m_collOrientation.length != this.m_numCollElements) {
                this.m_collOrientation = new boolean[this.m_numCollElements];
            }
        }
        int ruLen = this.m_physGeom.m_ru.m_data.length;
        int ruIdx = 0;
        while (ruIdx < ruLen) {
            int ru = this.m_physGeom.m_ru.m_data[ruIdx];
            if (ru < 0) {
                this.stepRigidUnit(-ru - 1);
            } else {
                int v = ru;
                int v3 = 3 * v;
                if (this.m_physGeom.m_geometry.hasTagVertex(v, 1)) {
                    int j = 0;
                    while (j < this.m_geomDim) {
                        this.m_geomVelocity.m_data[v3 + j] = 0.0;
                        ++j;
                    }
                } else {
                    double collisionTime = 0.0;
                    int lastCollisionFace = -1;
                    while (collisionTime + 1.0E-10 < this.m_stepSize) {
                        int minFace = -1;
                        double minTime = this.m_stepSize;
                        double minvN = 0.0;
                        int f = 0;
                        while (f < this.m_numCollElements) {
                            if (f != lastCollisionFace && this.m_collElement[f].getSize() != 0) {
                                double timeToCollision;
                                int collV = this.m_collElement[f].m_data[0];
                                double xpN = 0.0;
                                double vN = 0.0;
                                int j = this.dim_0;
                                while (j < this.m_geomDim) {
                                    xpN += (this.m_geomVertex[v].m_data[j] - this.m_collVertex[collV].m_data[j]) * this.m_collNormal[f].m_data[j];
                                    vN += this.m_geomVelocity.m_data[v3 + j] * this.m_collNormal[f].m_data[j];
                                    ++j;
                                }
                                if (lastCollisionFace < 0) {
                                    boolean bl = this.m_collOrientation[f] = xpN > 0.0;
                                }
                                if ((timeToCollision = -xpN / vN) > -1.0E-10 && timeToCollision < this.m_stepSize - collisionTime && timeToCollision < minTime) {
                                    int a = Math.abs(this.m_collNormal[f].m_data[0]) < Math.abs(this.m_collNormal[f].m_data[1]) ? 0 : 1;
                                    int b = Math.abs(this.m_collNormal[f].m_data[1 - a]) < Math.abs(this.m_collNormal[f].m_data[2]) ? 1 - a : 2;
                                    double intersection_x = this.m_geomVertex[v].m_data[a] + timeToCollision * this.m_geomVelocity.m_data[v3 + a];
                                    double intersection_y = this.m_geomVertex[v].m_data[b] + timeToCollision * this.m_geomVelocity.m_data[v3 + b];
                                    int numCorners = this.m_collElement[f].m_data.length;
                                    int m = 0;
                                    while (m < numCorners - 2) {
                                        double vx = this.m_collVertex[this.m_collElement[f].m_data[m + 1]].m_data[a] - this.m_collVertex[this.m_collElement[f].m_data[m]].m_data[a];
                                        double vy = this.m_collVertex[this.m_collElement[f].m_data[m + 1]].m_data[b] - this.m_collVertex[this.m_collElement[f].m_data[m]].m_data[b];
                                        double wx = this.m_collVertex[this.m_collElement[f].m_data[numCorners - 1]].m_data[a] - this.m_collVertex[this.m_collElement[f].m_data[m]].m_data[a];
                                        double wy = this.m_collVertex[this.m_collElement[f].m_data[numCorners - 1]].m_data[b] - this.m_collVertex[this.m_collElement[f].m_data[m]].m_data[b];
                                        double sx = intersection_x - this.m_collVertex[this.m_collElement[f].m_data[m]].m_data[a];
                                        double sy = intersection_y - this.m_collVertex[this.m_collElement[f].m_data[m]].m_data[b];
                                        double det = vx * wy - wx * vy;
                                        double lambdax = (sx * wy - sy * wx) / det;
                                        double lambday = (vx * sy - vy * sx) / det;
                                        if (lambdax > -1.0E-10 && lambday > -1.0E-10 && lambdax + lambday < 1.0000000001 && timeToCollision < minTime) {
                                            minTime = timeToCollision;
                                            minvN = vN;
                                            minFace = f;
                                            m = numCorners;
                                        }
                                        ++m;
                                    }
                                }
                            }
                            ++f;
                        }
                        if (minTime < this.m_stepSize - collisionTime) {
                            if (this.m_collSurface.hasTagElement(minFace, 0) && minFace != this.m_lastCollidedMarkedFace) {
                                this.m_physGeom.invertEngines();
                                this.m_lastCollidedMarkedFace = minFace;
                            }
                            double gN = 0.0;
                            int j = 0;
                            while (j < this.m_geomDim) {
                                gN += this.m_gradient.m_data[v3 + j] * this.m_collNormal[minFace].m_data[j];
                                ++j;
                            }
                            if (minvN * minvN < 4.0 * gN * gN) {
                                j = 0;
                                while (j < this.m_geomDim) {
                                    int n = v3 + j;
                                    this.m_geomVelocity.m_data[n] = this.m_geomVelocity.m_data[n] - 2.0 * minvN * this.m_collNormal[minFace].m_data[j];
                                    int n2 = v3 + j;
                                    this.m_geomVelocity.m_data[n2] = this.m_geomVelocity.m_data[n2] * 0.5;
                                    ++j;
                                }
                            } else {
                                j = 0;
                                while (j < this.m_geomDim) {
                                    int n = j;
                                    this.m_geomVertex[v].m_data[n] = this.m_geomVertex[v].m_data[n] + (minTime - 1.0E-10) * this.m_geomVelocity.m_data[v3 + j];
                                    int n3 = v3 + j;
                                    this.m_geomVelocity.m_data[n3] = this.m_geomVelocity.m_data[n3] - 2.0 * minvN * this.m_collNormal[minFace].m_data[j];
                                    ++j;
                                }
                                if ((Math.abs(this.m_geomVertex[v].m_data[0]) < -1.0 || Math.abs(this.m_geomVertex[v].m_data[0]) > 1.0 || Math.abs(this.m_geomVertex[v].m_data[1]) < -1.0 || Math.abs(this.m_geomVertex[v].m_data[1]) > 1.0 || Math.abs(this.m_geomVertex[v].m_data[2]) < 0.0 || Math.abs(this.m_geomVertex[v].m_data[2]) > 2.0) && this.m_bDebugRun) {
                                    PsDebug.warning((String)"out of box, after reduced step");
                                }
                            }
                        } else {
                            int j = 0;
                            while (j < this.m_geomDim) {
                                int n = j;
                                this.m_geomVertex[v].m_data[n] = this.m_geomVertex[v].m_data[n] + (this.m_stepSize - collisionTime) * this.m_geomVelocity.m_data[v3 + j];
                                ++j;
                            }
                            if ((Math.abs(this.m_geomVertex[v].m_data[0]) < -1.0 || Math.abs(this.m_geomVertex[v].m_data[0]) > 1.0 || Math.abs(this.m_geomVertex[v].m_data[1]) < -1.0 || Math.abs(this.m_geomVertex[v].m_data[1]) > 1.0 || Math.abs(this.m_geomVertex[v].m_data[2]) < 0.0 || Math.abs(this.m_geomVertex[v].m_data[2]) > 2.0) && this.m_bDebugRun) {
                                PsDebug.warning((String)"out of box, after full step");
                            }
                        }
                        collisionTime += minTime - 1.0E-10;
                        if (collisionTime < 0.0) {
                            collisionTime = 0.0;
                        }
                        lastCollisionFace = minFace;
                    }
                }
            }
            ++ruIdx;
        }
        if (this.m_physGeom.getVelocityVectors() != null) {
            this.m_physGeom.fillVelocityVectors();
        }
        this.m_bStepRunning = false;
    }

    private void stepRigidUnit(int ru) {
        PgRigidUnit ruObj = this.m_physGeom.getRigidUnit(ru);
        this.constrainRigidUnit(ruObj, true);
        double time = 0.0;
        int lastCollisionFace = -1;
        int lastCollisionVertex = -1;
        this.m_geomVertex = this.m_physGeom.m_geometry.getVertices();
        this.m_geomVelocity = this.m_physGeom.m_vertexVelocity;
        int numLoops = 0;
        while (time < this.m_stepSize) {
            if (++numLoops > 100) {
                return;
            }
            int minFace = -1;
            int minVert = -1;
            double minTime = this.m_stepSize;
            int vertexOfRU = 0;
            while (vertexOfRU < ruObj.m_vertices.m_data.length) {
                int vertex = ruObj.m_vertices.m_data[vertexOfRU];
                int v3 = 3 * vertex;
                int cFace = -1;
                int cVert = vertex;
                double cTime = this.m_stepSize;
                int f = 0;
                while (f < this.m_numCollElements) {
                    if ((f != lastCollisionFace || vertex != lastCollisionVertex) && this.m_collElement[f].getSize() != 0) {
                        double timeToCollision;
                        int collV = this.m_collElement[f].m_data[0];
                        double xpN = 0.0;
                        double vN = 0.0;
                        int j = this.dim_0;
                        while (j < this.m_geomDim) {
                            xpN += (this.m_geomVertex[vertex].m_data[j] - this.m_collVertex[collV].m_data[j]) * this.m_collNormal[f].m_data[j];
                            vN += this.m_geomVelocity.m_data[v3 + j] * this.m_collNormal[f].m_data[j];
                            ++j;
                        }
                        if (lastCollisionFace < 0) {
                            boolean bl = this.m_collOrientation[f] = xpN > 0.0;
                        }
                        if ((timeToCollision = -xpN / vN) > 0.0 && timeToCollision < this.m_stepSize - time && timeToCollision < cTime) {
                            int a = Math.abs(this.m_collNormal[f].m_data[0]) < Math.abs(this.m_collNormal[f].m_data[1]) ? 0 : 1;
                            int b = Math.abs(this.m_collNormal[f].m_data[1 - a]) < Math.abs(this.m_collNormal[f].m_data[2]) ? 1 - a : 2;
                            double intersection_x = this.m_geomVertex[vertex].m_data[a] + timeToCollision * this.m_geomVelocity.m_data[v3 + a];
                            double intersection_y = this.m_geomVertex[vertex].m_data[b] + timeToCollision * this.m_geomVelocity.m_data[v3 + b];
                            int numCorners = this.m_collElement[f].m_data.length;
                            int m = 0;
                            while (m < numCorners - 2) {
                                double vx = this.m_collVertex[this.m_collElement[f].m_data[m + 1]].m_data[a] - this.m_collVertex[this.m_collElement[f].m_data[m]].m_data[a];
                                double vy = this.m_collVertex[this.m_collElement[f].m_data[m + 1]].m_data[b] - this.m_collVertex[this.m_collElement[f].m_data[m]].m_data[b];
                                double wx = this.m_collVertex[this.m_collElement[f].m_data[numCorners - 1]].m_data[a] - this.m_collVertex[this.m_collElement[f].m_data[m]].m_data[a];
                                double wy = this.m_collVertex[this.m_collElement[f].m_data[numCorners - 1]].m_data[b] - this.m_collVertex[this.m_collElement[f].m_data[m]].m_data[b];
                                double sx = intersection_x - this.m_collVertex[this.m_collElement[f].m_data[m]].m_data[a];
                                double sy = intersection_y - this.m_collVertex[this.m_collElement[f].m_data[m]].m_data[b];
                                double det = vx * wy - wx * vy;
                                double lambdax = (sx * wy - sy * wx) / det;
                                double lambday = (vx * sy - vy * sx) / det;
                                if (lambdax > -1.0E-10 && lambday > -1.0E-10 && lambdax + lambday < 1.0000000001) {
                                    cFace = f;
                                    cVert = vertex;
                                    cTime = timeToCollision;
                                    m = numCorners;
                                }
                                ++m;
                            }
                        }
                    }
                    ++f;
                }
                if (cTime < minTime) {
                    minFace = cFace;
                    minVert = cVert;
                    minTime = cTime;
                }
                ++vertexOfRU;
            }
            double stepTime = this.m_stepSize - time;
            if (minVert >= 0 && minTime < stepTime) {
                stepTime = minTime - 1.0E-10;
            } else {
                minTime = -1.0;
            }
            int i = 0;
            while (i < ruObj.m_vertices.m_data.length) {
                int j = 0;
                while (j < this.m_geomDim) {
                    int n = j;
                    this.m_geomVertex[ruObj.m_vertices.m_data[i]].m_data[n] = this.m_geomVertex[ruObj.m_vertices.m_data[i]].m_data[n] + stepTime * this.m_geomVelocity.m_data[this.m_geomDim * ruObj.m_vertices.m_data[i] + j];
                    ++j;
                }
                ++i;
            }
            time += stepTime;
            if (minTime == -1.0) continue;
            if (this.m_collSurface.hasTagElement(minFace, 0) && minFace != this.m_lastCollidedMarkedFace) {
                this.m_physGeom.invertEngines();
                this.m_lastCollidedMarkedFace = minFace;
            }
            int vertex = minVert;
            this.r.copy(this.m_geomVertex[vertex]);
            this.r.sub(ruObj.m_center);
            double r_len = this.r.length();
            double rxNlen = 0.0;
            this.rxN.m_data[0] = this.r.m_data[1] * this.m_collNormal[minFace].m_data[2] - this.r.m_data[2] * this.m_collNormal[minFace].m_data[1];
            rxNlen += this.rxN.m_data[0] * this.rxN.m_data[0];
            this.rxN.m_data[1] = this.r.m_data[2] * this.m_collNormal[minFace].m_data[0] - this.r.m_data[0] * this.m_collNormal[minFace].m_data[2];
            rxNlen += this.rxN.m_data[1] * this.rxN.m_data[1];
            this.rxN.m_data[2] = this.r.m_data[0] * this.m_collNormal[minFace].m_data[1] - this.r.m_data[1] * this.m_collNormal[minFace].m_data[0];
            rxNlen += this.rxN.m_data[2] * this.rxN.m_data[2];
            rxNlen = Math.sqrt(rxNlen);
            this.v_omega.copy(this.r);
            this.v_omega.leftMultMatrix(ruObj.m_momentum);
            this.v_omega.add(ruObj.m_velocity);
            double s = this.v_omega.dot(this.m_collNormal[minFace]);
            double v_trans_N = ruObj.m_velocity.dot(this.m_collNormal[minFace]);
            if (Math.abs(s) < Math.abs(1.0E-10 * v_trans_N)) {
                int i2 = 0;
                while (i2 < this.m_geomDim) {
                    int n = i2;
                    ruObj.m_velocity.m_data[n] = ruObj.m_velocity.m_data[n] + Math.abs(v_trans_N) * this.m_collNormal[minFace].m_data[i2];
                    ++i2;
                }
            } else if (Math.abs(s) < 1.0E-10 && Math.abs(v_trans_N) < 1.0E-10) {
                int i3 = 0;
                while (i3 < this.m_geomDim) {
                    int n = i3;
                    ruObj.m_velocity.m_data[n] = ruObj.m_velocity.m_data[n] + 1.0E-10 * this.m_collNormal[minFace].m_data[i3];
                    ++i3;
                }
            } else {
                double p_w;
                if (s == 0.0) {
                    p_w = 0.0;
                } else {
                    p_w = r_len * rxNlen * rxNlen * rxNlen;
                    if (p_w > 1.0E-10 || p_w < -1.0E-10) {
                        this.tmp.copy(this.rxN);
                        this.tmp.leftMultMatrix(ruObj.m_inertiaMoment);
                        p_w /= this.tmp.dot(this.rxN);
                    }
                    p_w += 1.0 / (double)ruObj.m_vertices.m_data.length;
                    p_w = -2.0 * s / p_w;
                }
                p_w /= (double)ruObj.m_vertices.m_data.length;
                this.tmp.copy(this.m_collNormal[minFace]);
                this.tmp.multScalar(s);
                this.v_omega.sub(this.tmp);
                this.v_omega.multScalar(-0.5);
                this.tmp.copy(this.m_collNormal[minFace]);
                this.tmp.multScalar(p_w);
                this.tmp.add(this.v_omega);
                ruObj.m_velocity.add(this.tmp);
                double r_len2 = r_len * r_len;
                double r_pw = 0.0;
                int i4 = 0;
                while (i4 < this.m_geomDim) {
                    r_pw += this.r.m_data[i4] * this.tmp.m_data[i4];
                    ++i4;
                }
                double b = r_pw / r_len2;
                this.FOrth.setConstant(0.0);
                int i5 = 0;
                while (i5 < this.m_geomDim) {
                    this.FOrth.m_data[i5] = this.tmp.m_data[i5] - b * this.r.m_data[i5];
                    ++i5;
                }
                i5 = 0;
                while (i5 < this.m_geomDim) {
                    int j = 0;
                    while (j < this.m_geomDim) {
                        double[] dArray = ruObj.m_momentum.m_data[i5];
                        int n = j;
                        dArray[n] = dArray[n] + (this.FOrth.m_data[i5] * this.r.m_data[j] - this.r.m_data[i5] * this.FOrth.m_data[j]) / r_len2;
                        ++j;
                    }
                    ++i5;
                }
            }
            this.updateVelocities(ruObj);
        }
    }

    private void constrainRigidUnit(PgRigidUnit ru, boolean calculateAll) {
        int vertex;
        ru.m_momentum.multScalar(this.m_friction * (double)ru.m_vertices.m_data.length);
        ru.m_velocity.multScalar(this.m_friction * (double)ru.m_vertices.m_data.length);
        if (calculateAll) {
            ru.m_center.setConstant(0.0);
        }
        int v = 0;
        while (v < ru.m_vertices.m_data.length) {
            vertex = ru.m_vertices.m_data[v];
            int i = 0;
            while (i < this.m_geomDim) {
                if (calculateAll) {
                    try {
                        int n = i;
                        ru.m_center.m_data[n] = ru.m_center.m_data[n] + this.m_coord.m_data[this.m_geomDim * vertex + i];
                        int n2 = i;
                        ru.m_velocity.m_data[n2] = ru.m_velocity.m_data[n2] - this.m_gradient.m_data[this.m_geomDim * vertex + i];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                ++i;
            }
            ++v;
        }
        ru.m_center.multScalar(1.0 / (double)ru.m_vertices.m_data.length);
        ru.m_velocity.multScalar(1.0 / (double)ru.m_vertices.m_data.length);
        v = 0;
        while (v < ru.m_vertices.m_data.length) {
            vertex = ru.m_vertices.m_data[v];
            double xSLen = 0.0;
            double xS_a = 0.0;
            double xS_xS = 0.0;
            int i = 0;
            while (i < this.m_geomDim) {
                this.xS.m_data[i] = this.m_geomVertex[vertex].m_data[i] - ru.m_center.m_data[i];
                xSLen += this.xS.m_data[i] * this.xS.m_data[i];
                xS_a -= this.xS.m_data[i] * this.m_gradient.m_data[this.m_geomDim * vertex + i];
                xS_xS += this.xS.m_data[i] * this.xS.m_data[i];
                ++i;
            }
            double b = 0.0;
            if (xS_xS != 0.0) {
                b = xS_a / xS_xS;
            }
            this.FOrth.setConstant(0.0);
            int i2 = 0;
            while (i2 < this.m_geomDim) {
                this.FOrth.m_data[i2] = -this.m_gradient.m_data[this.m_geomDim * vertex + i2] - b * this.xS.m_data[i2];
                ++i2;
            }
            if (xS_xS != 0.0) {
                i2 = 0;
                while (i2 < this.m_geomDim) {
                    int j = 0;
                    while (j < this.m_geomDim) {
                        double[] dArray = ru.m_momentum.m_data[i2];
                        int n = j;
                        dArray[n] = dArray[n] + (this.FOrth.m_data[i2] * this.xS.m_data[j] - this.xS.m_data[i2] * this.FOrth.m_data[j]) / xS_xS;
                        ++j;
                    }
                    ++i2;
                }
            }
            ++v;
        }
        ru.m_momentum.multScalar(1.0 / (double)ru.m_vertices.m_data.length);
        this.updateVelocities(ru);
    }

    private void updateVelocities(PgRigidUnit ru) {
        this.m_geomVertex = this.m_physGeom.m_geometry.getVertices();
        this.m_geomVelocity = this.m_physGeom.m_vertexVelocity;
        int v = 0;
        while (v < ru.m_vertices.m_data.length) {
            int vertex = ru.m_vertices.m_data[v];
            int i = 0;
            while (i < this.m_geomDim) {
                this.m_geomVelocity.m_data[this.m_geomDim * vertex + i] = ru.m_velocity.m_data[i];
                int j = 0;
                while (j < this.m_geomDim) {
                    int n = this.m_geomDim * vertex + i;
                    this.m_geomVelocity.m_data[n] = this.m_geomVelocity.m_data[n] + ru.m_momentum.m_data[i][j] * (this.m_coord.m_data[this.m_geomDim * vertex + j] - ru.m_center.m_data[j]);
                    ++j;
                }
                ++i;
            }
            ++v;
        }
    }

    public void applyElementFriction() {
        if (!(this.m_physGeom instanceof PgPhysicalElementSet)) {
            PsDebug.warning((String)"Surface must derive from PgPhysicalElementSet to apply element friction");
            return;
        }
        PgPhysicalElementSet geom = (PgPhysicalElementSet)this.m_physGeom;
        PiVector[] elements = geom.m_elementSet.getElements();
        int numElements = elements.length;
        PdVector[] normals = geom.m_elementSet.getElementNormals();
        if (normals == null) {
            geom.m_elementSet.assureElementNormals();
            normals = geom.m_elementSet.getElementNormals();
        }
        int f = 0;
        while (f < numElements) {
            int elemLen = elements[f].getSize();
            if (elemLen > 0) {
                double p = 0.0;
                int i = 0;
                while (i < elemLen) {
                    int vi3 = this.m_geomDim * elements[f].m_data[i];
                    double ui = 0.0;
                    int k = 0;
                    while (k < this.m_geomDim) {
                        ui += normals[f].m_data[k] * geom.m_vertexVelocity.m_data[vi3 + k];
                        ++k;
                    }
                    ui = Math.abs(ui);
                    int j = 0;
                    while (j < elemLen) {
                        int vj3 = this.m_geomDim * elements[f].m_data[j];
                        double uj = 0.0;
                        int k2 = 0;
                        while (k2 < this.m_geomDim) {
                            uj += normals[f].m_data[k2] * geom.m_vertexVelocity.m_data[vj3 + k2];
                            ++k2;
                        }
                        p += ui * uj;
                        ++j;
                    }
                    ++i;
                }
                p /= (double)(elemLen * elemLen);
                i = 0;
                while (i < elemLen) {
                    int v3 = this.m_geomDim * elements[f].m_data[i];
                    int k = 0;
                    while (k < this.m_geomDim) {
                        int n = v3 + k;
                        this.m_gradient.m_data[n] = this.m_gradient.m_data[n] + normals[f].m_data[k] * p * this.m_elementFriction * this.m_stepSize * this.m_stepSize;
                        ++k;
                    }
                    ++i;
                }
            }
            ++f;
        }
    }

    public void startIteration() {
        if (!this.m_bIsRunning) {
            this.m_thread = new Thread((Runnable)this, "JavaView: Energy Iteration");
            this.m_thread.setPriority(5);
            this.m_thread.start();
        }
        this.m_bIsStopped = false;
    }

    public void stopIteration() {
        this.m_bIsStopped = true;
    }

    @Override
    public void run() {
        this.m_bIsRunning = true;
        if (this.m_bDebugRun) {
            try {
                while (!this.m_bIsStopped) {
                    this.m_date = new Date();
                    long prevTime = this.m_date.getTime();
                    if (this.m_physGeom != null) {
                        int n = this.m_sIterationsPerFrame.getValue();
                        int i = 0;
                        while (i < n) {
                            this.step();
                            ++i;
                        }
                    }
                    this.update(this);
                    this.m_date = new Date();
                    long currTime = this.m_date.getTime();
                    long duration = currTime - prevTime;
                    if (duration < 1000L) {
                        Thread.sleep(1000L - duration);
                        continue;
                    }
                    Thread.yield();
                }
            }
            catch (InterruptedException e) {
                PsDebug.warning((String)"Process interrupted (e.getMessage())");
            }
        } else {
            this.m_date = new Date();
            long time = this.m_date.getTime();
            long estTime = time + this.m_frameRate;
            try {
                while (!this.m_bIsStopped) {
                    if (this.m_physGeom != null) {
                        int n = this.m_sIterationsPerFrame.getValue();
                        int i = 0;
                        while (i < n) {
                            this.step();
                            ++i;
                        }
                    }
                    this.m_date = new Date();
                    time = this.m_date.getTime();
                    if (estTime > time) {
                        Thread.sleep(estTime - time);
                    } else {
                        this.m_frameRateField = this.m_frameRate + time - estTime;
                        estTime = time;
                        Thread.yield();
                    }
                    estTime += this.m_frameRate;
                    this.update(this);
                }
            }
            catch (InterruptedException e) {
                PsDebug.warning((String)"Process interrupted (e.getMessage())");
            }
        }
        this.m_bIsRunning = false;
    }

    public boolean isRunning() {
        return this.m_bIsRunning;
    }

    public boolean update(Object event) {
        if (event == this.m_sFriction || event == this.m_sStepSize) {
            this.m_stepSize = this.m_sStepSize.getValue();
            this.m_friction = Math.pow(1.0 - this.m_sFriction.getValue(), this.m_stepSize);
            this.m_frameRateField = this.m_frameRate = (long)((double)(1000 * this.m_sIterationsPerFrame.getValue()) * this.m_stepSize);
            return true;
        }
        if (event == this.m_sElementFriction) {
            this.m_elementFriction = this.m_sElementFriction.getValue();
            return true;
        }
        if (event == this.m_sIterationsPerFrame) {
            this.m_frameRateField = this.m_frameRate = (long)(1000.0 * this.m_stepSize * (double)this.m_sIterationsPerFrame.getValue());
            return true;
        }
        if (event != null && event == this.m_physGeom) {
            if (this.m_physGeom.m_geometry != null && this.m_physGeom instanceof PgPhysicalElementSet) {
                ((PgPhysicalElementSet)this.m_physGeom).m_elementSet.makeElementNormals();
            }
            return true;
        }
        if (event != null && event == this.m_collSurface) {
            this.m_collSurface.makeElementNormals();
            return true;
        }
        return super.update(event);
    }

    public void reset() {
        this.m_lastCollidedMarkedFace = -1;
    }
}

