/*
 * Decompiled with CFR 0.152.
 */
package devParticle.engine;

import devParticle.engine.PnEngine;
import devParticle.physical.PgPhysicalGeometry;
import jv.object.PsPanel;
import jv.vecmath.PdVector;

public class PnSpinningEngine
extends PnEngine {
    protected int m_baseVertex;
    protected int m_vertex1;
    protected int m_vertex2;
    protected int m_spinningVertex;
    protected double m_power;
    private PdVector v1;
    private PdVector v2;
    private PdVector base;
    private PdVector spin;

    public PnSpinningEngine(int baseVertex, int vertex1, int vertex2, int spinningVertex, double power) {
        this.m_baseVertex = baseVertex;
        this.m_vertex1 = vertex1;
        this.m_vertex2 = vertex2;
        this.m_spinningVertex = spinningVertex;
        this.m_power = power;
        this.v1 = new PdVector(3);
        this.v2 = new PdVector(3);
        this.spin = new PdVector(3);
        this.base = new PdVector(3);
    }

    public PnSpinningEngine(PnSpinningEngine e) {
        super(e);
        this.copy(e);
    }

    @Override
    public Object clone() {
        return new PnSpinningEngine(this);
    }

    @Override
    public boolean setGeometry(PgPhysicalGeometry geom) {
        if (!super.setGeometry(geom)) {
            return false;
        }
        this.m_geom = geom;
        return true;
    }

    @Override
    public void step(double timeStep) {
        super.step(timeStep);
    }

    @Override
    public void reset() {
        super.reset();
    }

    public void copy(PnSpinningEngine e) {
        super.copy(e);
        this.m_geom = e.m_geom;
        this.m_baseVertex = e.m_baseVertex;
        this.m_vertex1 = e.m_vertex1;
        this.m_vertex2 = e.m_vertex2;
        this.m_spinningVertex = e.m_spinningVertex;
        this.m_power = e.m_power;
        this.v1 = e.v1;
        this.v2 = e.v2;
        this.base = e.base;
        this.spin = e.spin;
    }

    @Override
    public PnEngine copyNew() {
        PnSpinningEngine e = new PnSpinningEngine(this);
        return e;
    }

    @Override
    public PdVector subEngineForces(PdVector coord, PdVector gradient) {
        PdVector[] vert = this.m_geom.m_geometry.getVertices();
        this.base.copy(vert[this.m_baseVertex]);
        this.v1.copy(vert[this.m_vertex1]);
        this.v1.sub(this.base);
        this.v2.copy(vert[this.m_vertex2]);
        this.v2.sub(this.base);
        this.spin.copy(vert[this.m_spinningVertex]);
        this.spin.sub(this.base);
        double v1v1 = this.v1.sqrLength();
        double v2v2 = this.v2.sqrLength();
        double v1v2 = this.v1.dot(this.v2);
        double vsv1 = this.v1.dot(this.spin);
        double vsv2 = this.v2.dot(this.spin);
        double vsvs = this.spin.sqrLength();
        double den = v1v1 * v2v2 - v1v2 * v1v2;
        if (den == 0.0) {
            return gradient;
        }
        double a = this.m_power * (v2v2 * vsv1 - v1v2 * vsv2) / den;
        double b = this.m_power * (v1v1 * vsv2 - v1v2 * vsv1) / den;
        this.v1.multScalar(b);
        this.v2.multScalar(-a);
        this.v1.add(this.v2);
        this.v1.multScalar(1.0 / vsvs);
        int start = 3 * this.m_spinningVertex;
        int start2 = 3 * this.m_baseVertex;
        int i = 0;
        while (i < 3) {
            int n = start + i;
            gradient.m_data[n] = gradient.m_data[n] - this.v1.m_data[i];
            int n2 = start2 + i;
            gradient.m_data[n2] = gradient.m_data[n2] + this.v1.m_data[i];
            ++i;
        }
        return gradient;
    }

    @Override
    public PsPanel getAdjustmentPanel() {
        PsPanel p = new PsPanel();
        p.addTitle("Adjustmentregler");
        return p;
    }

    public void setPower(double power) {
        this.m_power = power;
    }
}

