/*
 * Decompiled with CFR 0.152.
 */
package devParticle.engine;

import devParticle.physical.PgPhysicalGeometry;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.vecmath.PdVector;

public class PnEngine
extends PsObject {
    protected PgPhysicalGeometry m_geom;
    protected int m_dir;
    protected double m_period;
    protected double m_phase;
    protected double m_time;

    public PnEngine() {
        this(10.0, 0.0);
    }

    public PnEngine(PnEngine e) {
        this.m_period = e.m_period;
        this.m_time = e.m_time;
        this.setPhase(e.m_phase);
        this.m_geom = e.m_geom;
        this.m_dir = e.m_dir;
    }

    public PnEngine(double period, double phase) {
        this.m_time = 0.0;
        this.m_period = period;
        this.setPhase(phase);
        this.m_geom = null;
        this.m_dir = 1;
    }

    public Object clone() {
        return new PnEngine(this);
    }

    public void setPeriodLength(double period) {
        this.m_period = period;
    }

    public double getPeriodLength() {
        return this.m_period;
    }

    public void setPhase(double phase) {
        this.m_time = (this.m_time + (phase - this.m_phase)) % this.m_period;
        this.m_phase = phase;
    }

    public double getPhase() {
        return this.m_phase;
    }

    public boolean setGeometry(PgPhysicalGeometry geom) {
        this.m_geom = geom;
        return true;
    }

    public void step(double timeStep) {
        this.m_time = (this.m_time + (double)this.m_dir * timeStep) % this.m_period;
    }

    public PdVector subEngineForces(PdVector coord, PdVector gradient) {
        return gradient;
    }

    public void reset() {
        this.m_time = this.m_phase;
    }

    public void invert() {
        this.m_dir = -this.m_dir;
    }

    public void copy(PnEngine e) {
        this.m_period = e.m_period;
        this.m_phase = e.m_phase;
        this.m_time = e.m_time;
        this.m_geom = e.m_geom;
    }

    public PnEngine copyNew() {
        PnEngine e = new PnEngine();
        e.copy(this);
        return e;
    }

    public PsPanel getAdjustmentPanel() {
        return new PsPanel();
    }
}

