/*
 * Decompiled with CFR 0.152.
 */
package devParticle.engine;

import devParticle.engine.PnEngine;
import devParticle.physical.PgPhysicalElementSet;
import devParticle.physical.PgPhysicalGeometry;
import jv.geom.PgEdgeStar;
import jv.object.PsDebug;

public class PnEdgeEngine
extends PnEngine {
    protected PgPhysicalElementSet m_elementSet;
    protected int m_edgeInd;
    protected int m_vertex1;
    protected int m_vertex2;
    protected PgEdgeStar m_edge;
    protected double m_min = 0.7;
    protected double m_max = 1.4;

    PnEdgeEngine() {
    }

    public PnEdgeEngine(int edge) {
        this(edge, 10.0, 0.0);
    }

    public PnEdgeEngine(int vertex1, int vertex2) {
        this(vertex1, vertex2, 10.0, 0.0);
    }

    public PnEdgeEngine(int edge, double period, double phase) {
        super(period, phase);
        this.m_edgeInd = edge;
        this.m_edge = null;
    }

    public PnEdgeEngine(int vertex1, int vertex2, double period, double phase) {
        super(period, phase);
        this.m_edgeInd = -1;
        this.m_vertex1 = vertex1;
        this.m_vertex2 = vertex2;
        this.m_edge = null;
    }

    public PnEdgeEngine(PnEdgeEngine e) {
        super(e);
        this.m_edgeInd = e.m_edgeInd;
        this.m_edge = e.m_edge;
    }

    @Override
    public Object clone() {
        return new PnEdgeEngine(this);
    }

    @Override
    public boolean setGeometry(PgPhysicalGeometry geom) {
        if (!(geom instanceof PgPhysicalElementSet)) {
            return false;
        }
        if (!super.setGeometry(geom)) {
            return false;
        }
        this.m_elementSet = (PgPhysicalElementSet)geom;
        if (geom.m_geometry != null) {
            PgEdgeStar[] edges = ((PgPhysicalElementSet)geom).m_elementSet.makeEdgeStars();
            int i = 0;
            while (this.m_edgeInd < 0 && i < edges.length) {
                if (edges[i].getVertexInd(0) == this.m_vertex1 && edges[i].getVertexInd(1) == this.m_vertex2 || edges[i].getVertexInd(0) == this.m_vertex2 && edges[i].getVertexInd(1) == this.m_vertex1) {
                    this.m_edgeInd = i;
                }
                ++i;
            }
            if (this.m_edgeInd < 0 || this.m_edgeInd >= edges.length) {
                PsDebug.warning((String)("Edge number " + this.m_edgeInd + " does not exist in geometry."));
                this.m_edge = null;
                return false;
            }
            this.m_edge = edges[this.m_edgeInd];
        } else {
            this.m_edge = null;
        }
        return true;
    }

    @Override
    public void step(double timeStep) {
        super.step(timeStep);
        if (this.m_edge != null) {
            double newState = ((this.m_max - this.m_min) * Math.sin(this.m_time * 2.0 * Math.PI / this.m_period) + this.m_max + this.m_min) / 2.0;
            this.m_elementSet.setEdgeEngineState(this.m_edgeInd, newState);
        }
    }

    @Override
    public void reset() {
        super.reset();
    }

    public void copy(PnEdgeEngine e) {
        super.copy(e);
        this.m_elementSet = e.m_elementSet;
        this.m_edgeInd = e.m_edgeInd;
        this.m_vertex1 = e.m_vertex1;
        this.m_vertex2 = e.m_vertex2;
        this.m_edge = e.m_edge;
        this.m_min = e.m_min;
        this.m_max = e.m_max;
    }

    @Override
    public PnEngine copyNew() {
        PnEdgeEngine e = new PnEdgeEngine();
        e.copy(this);
        return e;
    }

    public void setMin(double min) {
        this.m_min = min;
    }

    public void setMax(double max) {
        this.m_max = max;
    }
}

