/*
 * Decompiled with CFR 0.152.
 */
package devParticle.energy;

import devParticle.energy.PnGradientConstraint;
import devParticle.energy.PnHomogenPotentialEnergy;
import devParticle.energy.PnPhysicalEnergy_If;
import devParticle.physical.PgPhysicalGeometry;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jvx.numeric.PnEnergy;

public class PnTotalEnergy
extends PnEnergy
implements PnPhysicalEnergy_If {
    protected PgPointSet m_psSurface = null;
    protected PgPhysicalGeometry m_physicalGeom;
    protected int m_dim;
    protected int m_numEnergies = 0;
    protected PnEnergy[] m_energy = null;
    protected PuDouble[] m_weight;
    private PdVector m_tmpGradient = new PdVector();
    protected boolean m_bFixMarkedVertices = true;
    protected PnGradientConstraint m_constraint;

    public PnTotalEnergy(int numEnergies) {
        this();
        this.setNumEnergies(numEnergies);
    }

    public PnTotalEnergy() {
        if (this.getClass() == PnTotalEnergy.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public boolean update(Object event) {
        if (event == null) {
            return super.update(null);
        }
        if (event == this.m_physicalGeom) {
            return super.setSurface(null, this.m_surface);
        }
        int i = 0;
        while (i < this.m_numEnergies) {
            if (this.m_weight[i] != null && event == this.m_weight[i]) {
                return true;
            }
            ++i;
        }
        return super.update(event);
    }

    public void setFixMarkedVertices(boolean bFixMarkedVertices) {
        this.m_bFixMarkedVertices = bFixMarkedVertices;
    }

    public boolean getFixMarkedVertices() {
        return this.m_bFixMarkedVertices;
    }

    public int getNumEnergies() {
        return this.m_numEnergies;
    }

    public void setNumEnergies(int numEnergies) {
        PnEnergy[] tmpEnergies = new PnEnergy[numEnergies];
        PuDouble[] tmpWeights = new PuDouble[numEnergies];
        if (this.m_numEnergies < numEnergies) {
            int i = 0;
            while (i < this.m_numEnergies) {
                tmpEnergies[i] = this.m_energy[i];
                tmpWeights[i] = this.m_weight[i];
                ++i;
            }
            int j = this.m_numEnergies;
            while (j < numEnergies) {
                tmpEnergies[j] = null;
                tmpWeights[j] = null;
                ++j;
            }
        } else {
            int i = 0;
            while (i < numEnergies) {
                tmpEnergies[i] = this.m_energy[i];
                tmpWeights[i] = this.m_weight[i];
                ++i;
            }
        }
        this.m_numEnergies = numEnergies;
        this.m_energy = tmpEnergies;
        this.m_weight = tmpWeights;
    }

    public PnEnergy[] getEnergies() {
        return this.m_energy;
    }

    public PnEnergy getEnergy(int ind) {
        if (this.m_energy == null || this.m_energy.length <= ind) {
            return null;
        }
        return this.m_energy[ind];
    }

    public void setEnergy(int index, PnEnergy energy) {
        if (index >= this.m_numEnergies) {
            PsDebug.message((String)"Warning: Energy index out of bounds. -> Energy not added.");
            return;
        }
        this.m_energy[index] = energy;
        this.m_weight[index] = new PuDouble(energy.getName(), (PsUpdateIf)this);
        this.m_weight[index].setDefBounds(0.0, 1000.0, 100.0, 1.0);
        this.m_weight[index].setDefValue(1.0);
        this.m_weight[index].init();
    }

    public PuDouble[] getWeights() {
        return this.m_weight;
    }

    public void setWeight(int index, String name, double val, double min, double max, double incr, double page) {
        if (index >= this.m_numEnergies) {
            PsDebug.message((String)"Warning: Weight index out of bounds. -> Weight not added.");
            return;
        }
        this.m_weight[index] = new PuDouble(name, (PsUpdateIf)this);
        this.m_weight[index].setDefBounds(min, max, incr, page);
        this.m_weight[index].setDefValue(val);
        this.m_weight[index].init();
    }

    public void addEnergy(PnEnergy energy) {
        this.setNumEnergies(this.m_numEnergies + 1);
        this.m_energy[this.m_numEnergies - 1] = energy;
    }

    public boolean removeEnergy(PnEnergy energy) {
        boolean bFound = false;
        int i = 0;
        while (i < this.m_numEnergies) {
            if (this.m_energy[i] == energy) {
                this.m_energy[i] = null;
                bFound = true;
            }
            ++i;
        }
        return bFound;
    }

    public void initSurface(PgElementSet domain, PgElementSet surface) {
        super.initSurface(domain, surface);
    }

    public boolean setSurface(PgElementSet domain, PgElementSet surface) {
        if (!super.setSurface(domain, surface)) {
            return false;
        }
        this.m_psSurface = surface;
        if (this.m_psSurface != null) {
            int dim = this.m_psSurface.getDimOfVectors();
            if (this.m_dim != dim) {
                this.m_dim = dim;
            }
            this.m_tmpGradient.setSize(dim * surface.getNumVertices());
        } else {
            this.m_dim = 0;
        }
        boolean val = true;
        int i = 0;
        while (i < this.m_numEnergies) {
            if (this.m_energy[i] != null) {
                val &= this.m_energy[i].setSurface(domain, surface);
            }
            ++i;
        }
        return val;
    }

    @Override
    public boolean setPhysicalGeometry(PgPhysicalGeometry geom) {
        if (geom == null) {
            PsDebug.warning((String)"PnTotalEnergy.setPhysicalGeometry: geom is null");
            return false;
        }
        PgPointSet surface = geom.m_geometry;
        if (surface instanceof PgElementSet && !super.setSurface(null, (PgElementSet)surface)) {
            return false;
        }
        this.m_psSurface = surface;
        this.m_physicalGeom = geom;
        if (this.m_psSurface != null) {
            int dim = this.m_psSurface.getDimOfVectors();
            if (this.m_dim != dim) {
                this.m_dim = dim;
            }
            this.m_tmpGradient.setSize(dim * surface.getNumVertices());
        } else {
            this.m_dim = 0;
        }
        boolean val = true;
        int i = 0;
        while (i < this.m_numEnergies) {
            if (this.m_energy[i] != null) {
                if (this.m_energy[i] instanceof PnPhysicalEnergy_If) {
                    val &= ((PnPhysicalEnergy_If)this.m_energy[i]).setPhysicalGeometry(geom);
                } else if (surface instanceof PgElementSet) {
                    val &= this.m_energy[i].setSurface(null, (PgElementSet)surface);
                }
            }
            ++i;
        }
        return val;
    }

    public double eval(PdVector coord) {
        double energy = 0.0;
        int i = 0;
        while (i < this.m_numEnergies) {
            double tmpEnergy = 0.0;
            if (this.m_energy[i] != null) {
                tmpEnergy = this.m_energy[i].eval(coord);
                if (this.m_weight[i] != null) {
                    tmpEnergy *= this.m_weight[i].getValue();
                }
                energy += tmpEnergy;
            }
            ++i;
        }
        return energy;
    }

    public PdVector evalGradient(PdVector coord, PdVector gradient) {
        if (this.m_psSurface == null || coord == null) {
            return null;
        }
        if (gradient == null) {
            gradient = new PdVector(this.m_dim * this.m_psSurface.getNumVertices());
        }
        gradient.setConstant(0.0);
        if (this.m_tmpGradient.getSize() != gradient.getSize()) {
            this.m_tmpGradient.setSize(gradient.getSize());
        }
        int i = 0;
        while (i < this.m_numEnergies) {
            if (this.m_energy[i] != null) {
                this.m_tmpGradient = this.m_energy[i].evalGradient(coord, this.m_tmpGradient);
                if (this.m_weight[i] != null) {
                    this.m_tmpGradient.multScalar(this.m_weight[i].getValue());
                }
                gradient.add(this.m_tmpGradient);
            }
            ++i;
        }
        if (this.m_constraint == null) {
            return this.constrainGradient(coord, gradient);
        }
        return this.m_constraint.constrainGradient(coord, gradient);
    }

    public PdMatrix evalHessian(PdMatrix hessian) {
        return hessian;
    }

    public PdVector constrainGrad(PdVector coord, PdVector gradient) {
        return this.constrainGradient(coord, gradient);
    }

    public void setConstrain(PnGradientConstraint c) {
        this.m_constraint = c;
    }

    public boolean setWeight(Class energyClass, double weight) {
        int i = 0;
        while (i < this.m_numEnergies) {
            if (this.m_energy[i] != null && this.m_energy[i].getClass() == energyClass) {
                if (weight > this.m_weight[i].getMax()) {
                    this.m_weight[i].setBounds(this.m_weight[i].getMin(), weight, this.m_weight[i].getDefLineIncr(), this.m_weight[i].getPageIncr());
                }
                this.m_weight[i].setValue(weight);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean setFitPotentialToCamera(boolean fit) {
        int i = 0;
        while (i < this.m_numEnergies) {
            if (this.m_energy[i] != null && this.m_energy[i] instanceof PnHomogenPotentialEnergy) {
                ((PnHomogenPotentialEnergy)this.m_energy[i]).setFitToCamera(fit);
                return true;
            }
            ++i;
        }
        return false;
    }
}

