/*
 * Decompiled with CFR 0.152.
 */
package devParticle.energy;

import devParticle.energy.PnPhysicalEnergy_If;
import devParticle.physical.PgPhysicalElementSet;
import devParticle.physical.PgPhysicalGeometry;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnEnergy;

public class PnSpringEnergy
extends PnEnergy
implements PnPhysicalEnergy_If {
    protected PgPhysicalElementSet m_geom;
    protected int m_dim;
    protected int m_numEdges;
    private PdVector m_vec;

    public PnSpringEnergy() {
        this.setName("Spring Energy");
        this.m_dim = 0;
        this.m_geom = null;
        if (this.getClass() == PnSpringEnergy.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public boolean setSurface(PgElementSet domain, PgElementSet surface) {
        if (!super.setSurface(domain, surface)) {
            return false;
        }
        this.m_geom = PgPhysicalElementSet.createPhysical(surface);
        if (this.m_geom != null) {
            int dim = this.m_geom.m_dim;
            if (this.m_dim != dim) {
                this.m_dim = dim;
                this.m_vec = new PdVector(this.m_dim);
            }
            this.m_numEdges = this.m_geom.getNumStoredEdges();
        }
        return true;
    }

    @Override
    public boolean setPhysicalGeometry(PgPhysicalGeometry geom) {
        if (geom == null) {
            PsDebug.warning((String)"Missing geometry argument: geom");
            return false;
        }
        if (!(geom instanceof PgPhysicalElementSet)) {
            PsDebug.warning((String)"Geometry must derive from PgPhysicalElementSet");
            return false;
        }
        this.m_geom = (PgPhysicalElementSet)geom;
        if (this.m_geom != null) {
            int dim = geom.m_geometry.getDimOfVectors();
            if (this.m_dim != dim) {
                this.m_dim = dim;
                this.m_vec = new PdVector(this.m_dim);
            }
            this.m_numEdges = ((PgPhysicalElementSet)geom).getNumStoredEdges();
        }
        return true;
    }

    public void initSurface(PgElementSet domain, PgElementSet surface) {
    }

    public double eval(PdVector coord) {
        if (this.m_geom == null || coord == null) {
            return 0.0;
        }
        double energy = 0.0;
        PiVector[] edges = this.m_geom.getStoredEdges();
        int i = 0;
        while (i < this.m_numEdges) {
            int indexI = this.m_dim * edges[i].getEntry(0);
            int indexJ = this.m_dim * edges[i].getEntry(1);
            double distance = 0.0;
            int j = 0;
            while (j < this.m_dim) {
                double sqrDistance = coord.m_data[indexI + j] - coord.m_data[indexJ + j];
                distance += sqrDistance * sqrDistance;
                ++j;
            }
            distance = Math.sqrt(distance) - this.m_geom.getEdgeLength(i);
            energy += distance * distance;
            ++i;
        }
        return energy;
    }

    public PdVector evalGradient(PdVector coord, PdVector gradient) {
        if (this.m_geom == null || coord == null) {
            return null;
        }
        if (gradient == null) {
            gradient = new PdVector(this.m_dim * this.m_geom.m_geometry.getNumVertices());
        }
        gradient.setConstant(0.0);
        PiVector[] edges = this.m_geom.getStoredEdges();
        int numEdges = this.m_geom.getNumStoredEdges();
        int i = 0;
        while (i < numEdges) {
            int indexI = this.m_dim * edges[i].getEntry(0);
            int indexJ = this.m_dim * edges[i].getEntry(1);
            int j = 0;
            while (j < this.m_dim) {
                this.m_vec.m_data[j] = coord.m_data[indexJ + j] - coord.m_data[indexI + j];
                ++j;
            }
            if (this.m_vec.length() != 0.0) {
                double f = 2.0 * (1.0 - this.m_geom.getEdgeLength(i) / this.m_vec.length());
                int j2 = 0;
                while (j2 < this.m_dim) {
                    int n = indexI + j2;
                    gradient.m_data[n] = gradient.m_data[n] - f * this.m_vec.m_data[j2];
                    int n2 = indexJ + j2;
                    gradient.m_data[n2] = gradient.m_data[n2] + f * this.m_vec.m_data[j2];
                    ++j2;
                }
            }
            ++i;
        }
        return gradient;
    }

    public PdMatrix evalHessian(PdMatrix hessian) {
        return hessian;
    }
}

