/*
 * Decompiled with CFR 0.152.
 */
package devParticle.energy;

import devParticle.energy.PnHomogenPotentialEnergy;
import java.awt.Checkbox;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PvCameraListenerIf;
import jv.vecmath.PdVector;

public class PnHomogenPotentialEnergy_IP
extends PsPanel
implements ItemListener {
    protected PnHomogenPotentialEnergy m_parentEnergy = null;
    protected boolean m_bIsRunning = false;
    protected Checkbox m_fitToCameraBox = new Checkbox("Fit potential energy to camera");

    public PnHomogenPotentialEnergy_IP() {
        this.m_fitToCameraBox.addItemListener(this);
        this.add(this.m_fitToCameraBox);
        if (this.getClass() == PnHomogenPotentialEnergy_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.m_parentEnergy == null) {
            PsDebug.warning((String)"PnHomogenPotentialEnergy_IP.actionPerformed(): Missing parent");
            return;
        }
        if (this.m_parentEnergy.m_display == null) {
            PsDebug.warning((String)"PnHomogenPotentialEnergy_IP.actionPerformed(): Missing display");
            return;
        }
        this.m_parentEnergy.m_bFitToCamera = this.m_fitToCameraBox.getState();
        if (this.m_parentEnergy.m_bFitToCamera) {
            this.m_parentEnergy.m_display.addCameraListener((PvCameraListenerIf)this.m_parentEnergy);
            PdVector up = this.m_parentEnergy.m_display.getCamera().getUpVector();
            up.multScalar(-1.0);
            this.m_parentEnergy.m_gravity.multScalar(up, -1.0);
        } else {
            this.m_parentEnergy.m_display.removeCameraListener((PvCameraListenerIf)this.m_parentEnergy);
            this.m_parentEnergy.resetGravityVector();
        }
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_parentEnergy = (PnHomogenPotentialEnergy)parent;
        if (parent == null) {
            return;
        }
        this.m_fitToCameraBox.setState(this.m_parentEnergy.m_bFitToCamera);
    }

    public boolean update(Object event) {
        if (this.m_parentEnergy == null) {
            PsDebug.notify((String)"PnHomogenPotentialEnergy_IP.update: missing parent");
            return true;
        }
        return super.update(event);
    }
}

