/*
 * Decompiled with CFR 0.152.
 */
package devParticle.energy;

import jv.geom.PgElementSet;
import jv.project.PvCameraEvent;
import jv.project.PvCameraListenerIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jvx.numeric.PnEnergy;

public class PnHomogenPotentialEnergy
extends PnEnergy
implements PvCameraListenerIf {
    protected PgElementSet m_surface;
    protected PdVector m_gravity;
    protected PdVector m_gravitySave;
    protected int m_dim;
    protected boolean m_bFitToCamera;
    protected PvDisplayIf m_display;

    public PnHomogenPotentialEnergy(int dim) {
        this.setName("Potential Energy");
        this.m_surface = null;
        this.m_gravity = new PdVector(dim);
        this.m_gravity.setEntry(dim - 1, 1.0);
        this.m_gravitySave = PdVector.copyNew((PdVector)this.m_gravity);
        this.m_dim = dim;
        this.m_display = null;
        this.m_bFitToCamera = false;
    }

    public PnHomogenPotentialEnergy(PdVector gravity) {
        this.setName("Potential");
        if (gravity == null) {
            this.m_surface = null;
            this.m_gravity = new PdVector(0);
            this.m_gravitySave = PdVector.copyNew((PdVector)this.m_gravity);
            this.m_dim = 0;
            this.m_display = null;
            return;
        }
        this.m_bFitToCamera = false;
        this.m_dim = gravity.getSize();
        this.m_gravity = new PdVector(this.m_dim);
        this.m_gravity.copy(gravity);
        this.m_gravitySave = PdVector.copyNew((PdVector)this.m_gravity);
        if (((Object)((Object)this)).getClass() == PnHomogenPotentialEnergy.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public boolean setSurface(PgElementSet domain, PgElementSet surface) {
        if (!super.setSurface(domain, surface)) {
            return false;
        }
        if (surface == null) {
            this.m_surface = null;
            this.m_display = null;
            return true;
        }
        if (surface.getDimOfVectors() != this.m_dim) {
            return false;
        }
        this.m_surface = surface;
        return true;
    }

    public void setDisplay(PvDisplayIf display) {
        this.m_display = display;
    }

    public PvDisplayIf getDisplay() {
        return this.m_display;
    }

    public void setFitToCamera(boolean fit) {
        if (this.m_bFitToCamera) {
            this.m_display.addCameraListener((PvCameraListenerIf)this);
        } else {
            this.m_display.removeCameraListener((PvCameraListenerIf)this);
        }
        this.m_bFitToCamera = fit;
        if (this.m_bFitToCamera) {
            this.m_display.addCameraListener((PvCameraListenerIf)this);
        } else {
            this.m_display.removeCameraListener((PvCameraListenerIf)this);
        }
    }

    public double eval(PdVector coord) {
        if (this.m_surface == null || coord == null) {
            return 0.0;
        }
        double energy = 0.0;
        int len = coord.getSize();
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < this.m_dim) {
                energy += this.m_gravity.m_data[j] * coord.getEntry(i + j);
                ++j;
            }
            i += this.m_dim;
        }
        return energy;
    }

    public PdVector evalGradient(PdVector coord, PdVector gradient) {
        if (this.m_surface == null || coord == null) {
            return null;
        }
        if (gradient == null) {
            gradient = new PdVector(this.m_dim * this.m_surface.getNumVertices());
        }
        int len = gradient.getSize();
        int j = 0;
        while (j < len) {
            gradient.copy(j, this.m_gravity, 0, this.m_dim);
            j += this.m_dim;
        }
        return gradient;
    }

    public PdMatrix evalHessian(PdMatrix hessian) {
        return hessian;
    }

    public void pickCamera(PvCameraEvent event) {
    }

    public void dragCamera(PvCameraEvent event) {
        PdVector up = event.getUpVector();
        up.multScalar(-1.0);
        this.m_gravity.multScalar(up, -1.0);
    }

    public void resetGravityVector() {
        this.m_gravity.copy(this.m_gravitySave);
    }
}

