/*
 * Decompiled with CFR 0.152.
 */
package devParticle.energy;

import devParticle.energy.PnGradientConstraint;
import jv.object.PsDebug;
import jv.vecmath.PdVector;

public class PnCenterConstraint
implements PnGradientConstraint {
    protected PdVector m_center;
    protected int m_dim;

    public PnCenterConstraint() {
        this(3);
    }

    public PnCenterConstraint(int dim) {
        this.m_dim = dim;
        this.m_center = new PdVector(this.m_dim);
    }

    @Override
    public PdVector constrainGradient(PdVector coord, PdVector gradient) {
        int dim;
        if (gradient == null) {
            PsDebug.warning((String)"Gradient is null");
            return gradient;
        }
        int n = gradient.getSize();
        int numVertices = n / this.m_dim;
        int i = 0;
        this.m_center.setConstant(0.0);
        int k = 0;
        while (k < numVertices) {
            dim = 0;
            while (dim < this.m_dim) {
                int n2 = dim++;
                this.m_center.m_data[n2] = this.m_center.m_data[n2] + gradient.m_data[i];
                ++i;
            }
            ++k;
        }
        this.m_center.multScalar(1.0 / (double)numVertices);
        i = 0;
        k = 0;
        while (k < numVertices) {
            dim = 0;
            while (dim < this.m_dim) {
                int n3 = i++;
                gradient.m_data[n3] = gradient.m_data[n3] - this.m_center.m_data[dim];
                ++dim;
            }
            ++k;
        }
        return gradient;
    }
}

