/*
 * Decompiled with CFR 0.152.
 */
package devParticle;

import devParticle.PwPhysicalSimulation;
import devParticle.physical.PgPhysicalGeometry_PP;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsPanel;
import jv.object.PsStackLayout;
import jv.object.PsUpdateIf;
import jvx.numeric.PnEnergy;
import jvx.project.PjWorkshop_IP;

public class PwPhysicalSimulation_IP
extends PjWorkshop_IP {
    protected PwPhysicalSimulation m_pwSimulation;
    protected PsPanel m_pGeometry;
    protected PsPanel m_pIterator;
    protected PsPanel m_pWeight;
    protected PsPanel m_pModifier;
    protected PgPhysicalGeometry_PP m_geomPropertyPanel;
    protected PsDialog m_geomPropertyDialog;
    protected Button m_bEdit;
    protected Button m_bReset;
    protected Button m_bSave;
    protected int m_numEnergies = 0;

    public PwPhysicalSimulation_IP() {
        if (((Object)((Object)this)).getClass() == PwPhysicalSimulation_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_pGeometry = new PsPanel();
        this.add((Component)this.m_pGeometry);
        this.m_pIterator = new PsPanel();
        this.add((Component)this.m_pIterator);
        this.m_pWeight = new PsPanel();
        this.m_pWeight.setLayout((LayoutManager)new PsStackLayout(2));
        this.add((Component)this.m_pWeight);
        this.m_pModifier = new PsPanel();
        this.add((Component)this.m_pModifier);
        PsPanel geometryButtons = new PsPanel((LayoutManager)new FlowLayout(1));
        this.m_bEdit = new Button("Edit Geometry");
        this.m_bEdit.addActionListener((ActionListener)((Object)this));
        geometryButtons.add((Component)this.m_bEdit);
        this.m_bSave = new Button("Save");
        this.m_bSave.addActionListener((ActionListener)((Object)this));
        geometryButtons.add((Component)this.m_bSave);
        this.m_bReset = new Button("Reset");
        this.m_bReset.addActionListener((ActionListener)((Object)this));
        geometryButtons.add((Component)this.m_bReset);
        this.add((Component)geometryButtons);
    }

    public Dimension getDialogSize() {
        return new Dimension(400, 650);
    }

    protected int getDialogButtons() {
        return 13;
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_pwSimulation = (PwPhysicalSimulation)parent;
        this.m_pIterator.add((Component)this.m_pwSimulation.m_iterator.assureInspector("Info", "_IP"));
    }

    public boolean update(Object event) {
        int numEnergies;
        if (this.m_pwSimulation == null) {
            PsDebug.notify((String)"missing workshop");
            return true;
        }
        if (event == this.m_pwSimulation && this.m_numEnergies != (numEnergies = this.m_pwSimulation.m_totalEnergy.getNumEnergies())) {
            this.m_pWeight.removeAll();
            if (numEnergies > 0) {
                this.m_pWeight.addTitle("Energies");
                PnEnergy[] energy = this.m_pwSimulation.m_totalEnergy.getEnergies();
                PuDouble[] weight = this.m_pwSimulation.m_totalEnergy.getWeights();
                int i = 0;
                while (i < numEnergies) {
                    this.m_pWeight.add((Component)weight[i].assureInspector("Info", "_IP"));
                    weight[i].setParent((PsUpdateIf)this);
                    PsPanel panel = energy[i].assureInspector("Info", "_IP");
                    if (panel != null) {
                        this.m_pWeight.add((Component)panel);
                    }
                    ++i;
                }
                this.m_numEnergies = numEnergies;
            }
            this.validate();
        }
        return super.update(event);
    }

    public void buttonPressed() {
        if (this.m_geomPropertyPanel == null) {
            this.m_geomPropertyPanel = new PgPhysicalGeometry_PP();
            this.m_geomPropertyPanel.setDisplay(this.m_pwSimulation.getDisplay());
            this.m_geomPropertyPanel.setParent((PsUpdateIf)this.m_pwSimulation.m_physicalGeom);
        }
        if (this.m_geomPropertyDialog == null) {
            this.m_geomPropertyDialog = new PsDialog(new Frame(), "Geometry properties", false);
            this.m_geomPropertyDialog.setSize(300, 500);
            this.m_geomPropertyDialog.setLayout((LayoutManager)new BorderLayout());
            this.m_geomPropertyDialog.add("Center", (Component)((Object)this.m_geomPropertyPanel));
            Button exitButton = new Button(" Close ");
            this.m_geomPropertyDialog.add("South", (Component)exitButton);
            exitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PwPhysicalSimulation_IP.this.m_geomPropertyDialog.setVisible(false);
                }
            });
        }
        this.m_geomPropertyDialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_bSave) {
            this.m_pwSimulation.save();
        } else if (source == this.m_bEdit) {
            this.buttonPressed();
        } else if (source == this.m_bReset) {
            this.m_pwSimulation.reset();
            this.m_pwSimulation.update((Object)this.m_pwSimulation);
        } else {
            super.actionPerformed(event);
        }
    }
}

