/*
 * Decompiled with CFR 0.152.
 */
package devParticle;

import devParticle.energy.PnHomogenPotentialEnergy;
import devParticle.energy.PnSpringEnergy;
import devParticle.energy.PnTotalEnergy;
import devParticle.numerics.PnEnergyIterator;
import devParticle.physical.PgPhysicalElementSet;
import devParticle.physical.PgPhysicalGeometry;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvGeometryListenerIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PdVector;
import jvx.numeric.PnEnergy;
import jvx.project.PjWorkshop;

public class PwPhysicalSimulation
extends PjWorkshop
implements PvGeometryListenerIf,
PvPickListenerIf {
    protected PgPhysicalGeometry m_physicalGeom = null;
    protected PnEnergyIterator m_iterator;
    protected PgElementSet m_collisionGeom = null;
    protected PnTotalEnergy m_totalEnergy;
    protected PgPhysicalGeometry m_physicalGeomSave = new PgPhysicalGeometry();

    public PwPhysicalSimulation(String name) {
        super(name);
        this.m_totalEnergy = new PnTotalEnergy(0);
        this.m_totalEnergy.setParent((PsUpdateIf)this);
        this.m_totalEnergy.setZeroGradientAtBounds(false);
        this.m_iterator = new PnEnergyIterator();
        this.m_iterator.setParent((PsUpdateIf)this);
        this.m_iterator.setEnergy(this.m_totalEnergy);
        if (((Object)((Object)this)).getClass() == PwPhysicalSimulation.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setGeometry(PgGeometry geom) {
        if (geom == null) {
            this.m_physicalGeom = null;
            this.m_physicalGeomSave = null;
            return;
        }
        if (!(geom instanceof PgPointSet)) {
            PsDebug.warning((String)"geometry must derive from PgPointSet");
            return;
        }
        super.setGeometry(geom);
        this.m_physicalGeom = PgPhysicalGeometry.createPhysical((PgPointSet)geom);
        this.save();
        this.initEnergies(this.m_physicalGeom);
        this.update((Object)this);
    }

    public void setGeometry(PgPhysicalGeometry physGeom) {
        if (physGeom != null) {
            PgPointSet surface = physGeom.m_geometry;
            super.setGeometry((PgGeometry)surface);
        }
        this.m_physicalGeom = physGeom;
        this.save();
        this.initEnergies(this.m_physicalGeom);
        this.update((Object)this);
    }

    public void setDisplay(PvDisplayIf display) {
        if (this.m_display != null) {
            this.m_display.removePickListener((PvPickListenerIf)this);
            this.m_display.removeGeometryListener((PvGeometryListenerIf)this);
        }
        super.setDisplay(display);
        if (this.m_display != null) {
            this.m_display.addPickListener((PvPickListenerIf)this);
            this.m_display.addGeometryListener((PvGeometryListenerIf)this);
        }
        this.setDisplayForEnergy(this.m_display);
    }

    void setDisplayForEnergy(PvDisplayIf m_display) {
        int numEnergies = this.m_totalEnergy.getNumEnergies();
        if (numEnergies > 0) {
            PnEnergy[] energy = this.m_totalEnergy.getEnergies();
            int i = 0;
            while (i < numEnergies) {
                if (energy[i] instanceof PnHomogenPotentialEnergy) {
                    ((PnHomogenPotentialEnergy)energy[i]).setDisplay(m_display);
                }
                ++i;
            }
        }
    }

    private void initEnergies(PgPhysicalGeometry physGeom) {
        boolean bPotential = physGeom instanceof PgPhysicalGeometry;
        boolean bSpring = physGeom instanceof PgPhysicalElementSet && ((PgPhysicalElementSet)physGeom).m_elementSet.getNumElements() > 0;
        int num = 0;
        this.m_totalEnergy.setNumEnergies((bPotential ? 1 : 0) + (bSpring ? 1 : 0));
        if (bPotential) {
            PnHomogenPotentialEnergy e = new PnHomogenPotentialEnergy(new PdVector(0.0, 0.0, 1.0));
            e.setDisplay(this.m_display);
            this.m_totalEnergy.setEnergy(num, e);
            this.m_totalEnergy.setWeight(num++, "Potential", 40.0, 0.0, 100.0, 0.1, 1.0);
        }
        if (bSpring) {
            this.m_totalEnergy.setEnergy(num, new PnSpringEnergy());
            this.m_totalEnergy.setWeight(num++, "Spring", 4000.0, 0.0, 10000.0, 1.0, 100.0);
        }
        this.m_totalEnergy.setPhysicalGeometry(physGeom);
        this.m_iterator.setSurface(physGeom);
    }

    public void setCollisionGeometry(PgElementSet geom) {
        this.m_collisionGeom = geom;
        this.m_iterator.setCollisionSurface(geom);
    }

    public PgPhysicalGeometry getPhysicalGeometry() {
        return this.m_physicalGeom;
    }

    public PnTotalEnergy getTotalEnergy() {
        return this.m_totalEnergy;
    }

    public void removeGeometry() {
        super.removeGeometry();
        this.m_physicalGeom = null;
        this.m_iterator.removeSurface();
    }

    public void reset() {
        super.reset();
        if (this.m_geom == null || this.m_geomSave == null || this.m_physicalGeom == null || this.m_physicalGeomSave == null) {
            return;
        }
        this.m_physicalGeom.copy(this.m_physicalGeomSave);
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.m_iterator.reset();
    }

    public void save() {
        if (this.m_geom == null || this.m_physicalGeom == null) {
            return;
        }
        this.m_geomSave.copy((PsObject)this.m_geom);
        this.m_physicalGeomSave.copy(this.m_physicalGeom);
    }

    public boolean update(Object event) {
        if (event == this.m_iterator) {
            if (this.m_physicalGeom != null && this.m_physicalGeom.m_geometry != null) {
                this.m_physicalGeom.m_geometry.update((Object)this.m_physicalGeom.m_geometry);
            }
            return true;
        }
        if (event == this.m_totalEnergy) {
            return true;
        }
        return super.update(event);
    }

    public void addGeometry(PgGeometryIf aGeom) {
    }

    public void removeGeometry(PgGeometryIf aGeom) {
    }

    public void selectGeometry(PgGeometryIf aGeom) {
    }

    public PvDisplayIf getDisplay() {
        return this.m_display;
    }

    public void pickDisplay(PvPickEvent pos) {
        if (pos.getVertexInd() != -1) {
            System.err.println("pick display: " + pos.getVertexInd());
        }
    }

    public void dragDisplay(PvPickEvent pos) {
    }

    public void pickInitial(PvPickEvent pos) {
        if (pos.getVertexInd() != -1) {
            System.err.println("pick initial: " + pos.getVertexInd());
        }
    }

    public void dragInitial(PvPickEvent pos) {
    }

    public void pickVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void dragVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void markVertices(PvPickEvent pos) {
    }

    public void unmarkVertices(PvPickEvent pos) {
    }
}

