/*
 * Decompiled with CFR 0.152.
 */
package devParticle;

import devParticle.PuCollisionHeapElement;

public class PuCollisionHeap {
    protected PuCollisionHeapElement[] heap;
    protected int lastElement;

    public PuCollisionHeap() {
        this(1);
    }

    public PuCollisionHeap(int size) {
        this.setSize(size);
        this.lastElement = 0;
    }

    public void setSize(int size) {
        this.heap = new PuCollisionHeapElement[size];
        int i = 0;
        while (i < size) {
            this.heap[i] = new PuCollisionHeapElement();
            ++i;
        }
    }

    public void add(double key, int value) {
        int element = this.lastElement;
        int father = (element - 1) / 2;
        this.heap[element].key = key;
        this.heap[element].epsilonValue = value;
        while (element > 0 && this.heap[father].key < key) {
            PuCollisionHeapElement tmp = this.heap[father];
            this.heap[father] = this.heap[element];
            this.heap[element] = tmp;
            element = father;
            father = (father - 1) / 2;
        }
        ++this.lastElement;
    }

    public PuCollisionHeapElement pop() {
        PuCollisionHeapElement returnValue = this.heap[0];
        int element = 0;
        int son = 2 * element + 1;
        while (son < this.lastElement) {
            if (son < this.lastElement - 1 && this.heap[son + 1].key > this.heap[son].key) {
                ++son;
            }
            PuCollisionHeapElement tmp = this.heap[son];
            this.heap[son] = this.heap[element];
            this.heap[element] = tmp;
            element = son;
            son = 2 * son + 1;
        }
        return returnValue;
    }

    public void clear() {
        this.lastElement = 0;
    }
}

