/*
 * Decompiled with CFR 0.152.
 */
package devParticle;

import devParticle.PgEmptySurface;
import devParticle.PjParticle;
import devParticle.collisionShape.PgBigBoxGeom;
import devParticle.collisionShape.PgBoxCollGeom;
import devParticle.collisionShape.PgInclinedPlaneCollGeom;
import devParticle.collisionShape.PgSampleBigPlaneCollGeom;
import devParticle.collisionShape.PgSampleOctaCollGeom;
import devParticle.collisionShape.PgSamplePlaneCollGeom;
import devParticle.collisionShape.PgSampleTubeCollGeom;
import devParticle.physical.PgPhysicalElementSet;
import devParticle.physicalShape.PgAutoGeom;
import devParticle.physicalShape.PgAutomobile;
import devParticle.physicalShape.PgCoatHanger;
import devParticle.physicalShape.PgRigidBall;
import devParticle.physicalShape.PgRigidSteffenSphere;
import devParticle.physicalShape.PgRotorGeom;
import devParticle.physicalShape.PgSampleBallGeom;
import devParticle.physicalShape.PgSampleEngineGeom;
import devParticle.physicalShape.PgSampleRigidGeom;
import devParticle.physicalShape.PgSampleSpringGeom;
import devParticle.physicalShape.PgSampleTetraGeom;
import devParticle.physicalShape.PgSampleWalkerGeom;
import devParticle.physicalShape.PgSpiderGeom;
import devParticle.physicalShape.PgSpinningGyro;
import devParticle.physicalShape.PgSteffenSphere;
import devParticle.physicalShape.PgTowerGeom;
import devParticle.physicalShape.PgWalkingTetra;
import devParticle.physicalShape.PgWaveDisk;
import java.awt.Choice;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.geom.PgElementSet;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject_IP;

public class PjParticle_IP
extends PjProject_IP
implements ItemListener {
    protected static final String[] simNames = new String[]{"No Simulation", "Vertex", "Spring", "Tetrahedra", "Engine", "Spider", "Walker", "Rigid sample geometry", "Rigid Ball", "Coat hanger", "Spinning gyro", "Steffen sphere", "Rigid SteffenSphere", "Walking tetrahedra", "Wave disk", "Tetra with wheel", "Auto", "Rotor", "Tower"};
    protected static final String[][] simPairs = new String[][]{{"No Model", "No Collision"}, {"Vertex", "Plane"}, {"Spring", "Plane"}, {"Tetrahedra", "No Collision"}, {"Engine", "No Collision"}, {"Spider", "Plane"}, {"Walker", "Big Box"}, {"Rigid sample geometry", "Big Box"}, {"Rigid Ball", "Big Box"}, {"Coat hanger", "Plane"}, {"Spinning gyro", "Plane"}, {"Steffen sphere", "No Collision"}, {"Rigid SteffenSphere", "No Collision"}, {"Walking tetrahedra", "Big Plane"}, {"Wave disk", "No Collision"}, {"Tetra with wheel", "Big Box"}, {"Auto", "Big Box"}, {"Rotor", "No Collision"}, {"Tower", "Big Plane"}};
    protected static final String[] geomNames = new String[]{"No Model", "Vertex", "Spring", "Tetrahedra", "Engine", "Spider", "Walker", "Rigid sample geometry", "Rigid Ball", "Coat hanger", "Spinning gyro", "Steffen sphere", "Rigid SteffenSphere", "Walking tetrahedra", "Wave disk", "Tetra with wheel", "Auto", "Rotor", "Tower"};
    protected static final Class[] geomClasses;
    protected static final String[] collNames;
    protected static final PgElementSet[] collClasses;
    protected PjParticle m_pjParticle;
    protected PsPanel m_pSimulation;
    protected Choice m_cSimulation;
    protected int m_idxSimulation;
    protected PsPanel m_pGeometry;
    protected Choice m_cGeometry;
    protected int m_idxGeometry = 0;
    protected PsPanel m_pCollision;
    protected Choice m_cCollision;
    protected int m_idxCollision = 0;

    static {
        Class[] classArray = new Class[19];
        classArray[1] = PgSampleBallGeom.class;
        classArray[2] = PgSampleSpringGeom.class;
        classArray[3] = PgSampleTetraGeom.class;
        classArray[4] = PgSampleEngineGeom.class;
        classArray[5] = PgSpiderGeom.class;
        classArray[6] = PgSampleWalkerGeom.class;
        classArray[7] = PgSampleRigidGeom.class;
        classArray[8] = PgRigidBall.class;
        classArray[9] = PgCoatHanger.class;
        classArray[10] = PgSpinningGyro.class;
        classArray[11] = PgSteffenSphere.class;
        classArray[12] = PgRigidSteffenSphere.class;
        classArray[13] = PgWalkingTetra.class;
        classArray[14] = PgWaveDisk.class;
        classArray[15] = PgAutomobile.class;
        classArray[16] = PgAutoGeom.class;
        classArray[17] = PgRotorGeom.class;
        classArray[18] = PgTowerGeom.class;
        geomClasses = classArray;
        collNames = new String[]{"No Collision", "Plane", "Big Plane", "Inclined Plane", "Slide", "Sphere", "Box", "Big Box"};
        collClasses = new PgElementSet[]{new PgEmptySurface(), new PgSamplePlaneCollGeom(), new PgSampleBigPlaneCollGeom(), new PgInclinedPlaneCollGeom(), new PgSampleTubeCollGeom(), new PgSampleOctaCollGeom(), new PgBoxCollGeom(), new PgBigBoxGeom()};
    }

    public PjParticle_IP() {
        if (this.getClass() == PjParticle_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addTitle("");
        this.addNotice(this.getNotice());
        this.m_pSimulation = new PsPanel();
        this.m_pSimulation.addTitle("Preset Simulation");
        this.add((Component)this.m_pSimulation);
        this.addLine(1);
        this.m_pGeometry = new PsPanel();
        this.m_pGeometry.addTitle("Dynamic Geometry");
        this.add((Component)this.m_pGeometry);
        this.m_pCollision = new PsPanel();
        this.m_pCollision.addTitle("Collision Surface");
        this.add((Component)this.m_pCollision);
    }

    public String getNotice() {
        String notice = "The particle project simulates the evolution of meshes under variety of physical energies, forces and side constraints. Several showcases introduce novel mesh machines and study their physical behaviour.";
        return notice;
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        super.setTitle(parent.getName());
        this.m_pjParticle = (PjParticle)parent;
        this.m_cSimulation = new Choice();
        this.m_cSimulation.addItemListener(this);
        int i = 0;
        while (i < simPairs.length) {
            this.m_cSimulation.add(String.valueOf(simPairs[i][0]) + "//" + simPairs[i][1]);
            ++i;
        }
        this.m_pSimulation.addLabelComponent("Select", (Component)this.m_cSimulation);
        this.m_cGeometry = new Choice();
        this.m_cGeometry.addItemListener(this);
        i = 0;
        while (i < geomNames.length) {
            this.m_cGeometry.add(geomNames[i]);
            ++i;
        }
        this.m_pGeometry.addLabelComponent("Select", (Component)this.m_cGeometry);
        PsPanel ipModel = this.m_pjParticle.m_import.getInfoPanel();
        ipModel.setBorderType(0);
        ipModel.removeTitle();
        this.m_pGeometry.add((Component)ipModel);
        this.m_cCollision = new Choice();
        this.m_cCollision.addItemListener(this);
        int j = 0;
        while (j < collNames.length) {
            this.m_cCollision.add(collNames[j]);
            ++j;
        }
        this.m_pCollision.addLabelComponent("Select", (Component)this.m_cCollision);
        PsPanel ipCollision = this.m_pjParticle.m_importCollision.getInfoPanel();
        ipCollision.setBorderType(0);
        ipCollision.removeTitle();
        this.m_pCollision.add((Component)ipCollision);
    }

    public boolean update(Object event) {
        if (this.m_pjParticle == null) {
            PsDebug.notify((String)"PjParticle_IP.update: missing parent");
            return true;
        }
        if (event == this.m_pjParticle) {
            this.m_cSimulation.select(this.m_idxSimulation);
            this.m_cGeometry.select(this.m_idxGeometry);
            this.m_cCollision.select(this.m_idxCollision);
        } else if (event == this.m_cSimulation) {
            this.m_cGeometry.select(this.m_idxGeometry);
            this.m_cCollision.select(this.m_idxCollision);
        } else if (event == this.m_cGeometry) {
            this.m_cSimulation.select(this.m_idxSimulation);
            this.m_cGeometry.select(this.m_idxGeometry);
        } else if (event == this.m_cCollision) {
            this.m_cSimulation.select(this.m_idxSimulation);
            this.m_cCollision.select(this.m_idxCollision);
        }
        return super.update(event);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        PsDebug.notify((String)"entered");
        if (source == this.m_cSimulation) {
            int simInd;
            this.m_idxSimulation = simInd = this.m_cSimulation.getSelectedIndex();
            String[] simPair = simPairs[simInd];
            String simGeom = simPair[0];
            String simColl = simPair[1];
            int indGeom = PuString.indexOfString((String[])geomNames, (String)simGeom);
            int indColl = PuString.indexOfString((String[])collNames, (String)simColl);
            if (indGeom > 0) {
                this.m_idxGeometry = indGeom;
                try {
                    Object geomClass = geomClasses[indGeom].newInstance();
                    if (geomClass instanceof PgElementSet) {
                        this.m_pjParticle.setGeometry((PgGeometryIf)((PgElementSet)geomClass));
                    } else if (geomClass instanceof PgPhysicalElementSet) {
                        this.m_pjParticle.setGeometry((PgPhysicalElementSet)((Object)geomClass));
                    }
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            this.m_idxCollision = indColl;
            this.m_pjParticle.setCollGeometry(collClasses[indColl]);
            this.update(this.m_cSimulation);
        } else if (source == this.m_cGeometry) {
            int idx1 = this.m_cGeometry.getSelectedIndex();
            if (idx1 != this.m_idxGeometry) {
                this.m_idxGeometry = idx1;
                if (idx1 != 0) {
                    try {
                        Object geomClass = geomClasses[idx1].newInstance();
                        if (geomClass instanceof PgElementSet) {
                            this.m_pjParticle.setGeometry((PgGeometryIf)((PgElementSet)geomClass));
                        } else if (geomClass instanceof PgPhysicalElementSet) {
                            this.m_pjParticle.setGeometry((PgPhysicalElementSet)((Object)geomClass));
                        }
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    this.m_idxSimulation = 0;
                }
            }
            this.update(this.m_cGeometry);
        } else if (source == this.m_cCollision) {
            int idx2 = this.m_cCollision.getSelectedIndex();
            if (idx2 != this.m_idxCollision) {
                this.m_idxCollision = idx2;
                this.m_pjParticle.setCollGeometry(collClasses[idx2]);
                this.m_idxSimulation = 0;
            }
            this.update(this.m_cCollision);
        }
    }
}

