/*
 * Decompiled with CFR 0.152.
 */
package devParticle;

import devParticle.PgEmptySurface;
import devParticle.PwPhysicalSimulation;
import devParticle.physical.PgPhysicalGeometry;
import devParticle.physicalShape.PgSampleGeom;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.loader.PgLoader;
import jv.loader.PjImportModel;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jvx.project.PjWorkshop_Dialog;

public class PjParticle
extends PjProject
implements ActionListener {
    protected PjImportModel m_import = new PjImportModel();
    protected PjImportModel m_importCollision;
    protected PwPhysicalSimulation m_simulation;
    protected PgPhysicalGeometry m_physGeom;
    protected PgElementSet m_coll;

    public PjParticle() {
        super("Particle Project");
        this.m_import.setName("Geometry");
        this.m_import.setTypeOfInfoPanel(1);
        this.m_import.addActionListener((ActionListener)this);
        this.m_importCollision = new PjImportModel();
        this.m_importCollision.setName("Collision Surface");
        this.m_importCollision.setTypeOfInfoPanel(1);
        this.m_importCollision.addActionListener((ActionListener)this);
        this.m_simulation = new PwPhysicalSimulation("Particle");
        this.m_physGeom = new PgSampleGeom();
        this.m_coll = new PgEmptySurface();
        if (this.getClass() == PjParticle.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_coll.showElements(false);
        this.addGeometry((PgGeometryIf)this.m_physGeom.m_geometry);
        this.addGeometry((PgGeometryIf)this.m_coll);
        this.selectGeometry((PgGeometryIf)this.m_physGeom.m_geometry);
    }

    public void start() {
        this.loadGeometry(String.valueOf(PsConfig.getCodeBase()) + "models/bd/Gergonne.bd");
        PvDisplayIf display = this.getDisplay();
        this.m_simulation.setDisplay(display);
        this.m_simulation.setGeometry(this.m_physGeom);
        this.m_simulation.setCollisionGeometry(this.m_coll);
        this.m_simulation.reset();
        this.m_simulation.update((Object)this.m_simulation);
        PjWorkshop_Dialog dialog = new PjWorkshop_Dialog(false);
        dialog.setParent((PsUpdateIf)this.m_simulation);
        dialog.update((Object)this.m_simulation);
        dialog.setVisible(true);
        super.start();
    }

    public boolean update(Object event) {
        if (event == this) {
            return super.update((Object)this);
        }
        return super.update(event);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        PsDebug.notify((String)"entered");
        Object source = event.getSource();
        if (source == this.m_import) {
            this.loadGeometry(this.m_import.getFileName());
        } else if (source == this.m_importCollision) {
            this.loadCollGeometry(this.m_importCollision.getFileName());
        }
    }

    public void loadGeometry(String filename) {
        PgGeometry[] geomNew = new PgLoader().loadGeometry(null, filename);
        if (geomNew == null || geomNew.length == 0 || geomNew[0] == null) {
            PsDebug.warning((String)("missing geometry, file = " + filename));
            return;
        }
        if (!(geomNew[0] instanceof PgPointSet)) {
            PsDebug.warning((String)"geometry does not derive from PgPointSet");
            return;
        }
        if (geomNew.length > 1) {
            PsDebug.warning((String)("only first geometry used, found = " + geomNew.length));
        }
        this.setGeometry((PgGeometryIf)geomNew[0]);
    }

    public boolean setGeometry(PgGeometryIf geom) {
        if (geom instanceof PgElementSet) {
            ((PgElementSet)geom).showEdges(true);
            ((PgElementSet)geom).showVertices(true);
            ((PgElementSet)geom).showElements(false);
        }
        this.removeGeometry(this.getGeometry());
        this.addGeometry(geom);
        this.selectGeometry(geom);
        this.m_physGeom = PgPhysicalGeometry.createPhysical((PgPointSet)geom);
        if (this.m_simulation != null) {
            this.m_simulation.setGeometry(this.m_physGeom);
        }
        return true;
    }

    public void loadCollGeometry(String filename) {
        PgGeometry[] geomNew = new PgLoader().loadGeometry(null, filename);
        if (geomNew == null || geomNew.length == 0 || geomNew[0] == null) {
            PsDebug.warning((String)("loading failed, file = " + filename));
            return;
        }
        if (!(geomNew[0] instanceof PgElementSet)) {
            PsDebug.warning((String)"geometry does not derive from PgElementSet");
            return;
        }
        if (geomNew.length > 1) {
            PsDebug.warning((String)("only first geometry used, found = " + geomNew.length));
        }
        if (geomNew[0] instanceof PgElementSet) {
            ((PgElementSet)geomNew[0]).showEdges(true);
            ((PgElementSet)geomNew[0]).showVertices(true);
            ((PgElementSet)geomNew[0]).showElements(false);
        }
        this.removeGeometry((PgGeometryIf)this.m_coll);
        this.m_coll = (PgElementSet)geomNew[0];
        this.addGeometry((PgGeometryIf)this.m_coll);
        this.selectGeometry((PgGeometryIf)this.m_physGeom.m_geometry);
        if (this.m_simulation != null) {
            this.m_simulation.setCollisionGeometry(this.m_coll);
        }
    }

    public void setGeometry(PgPhysicalGeometry geomNew) {
        this.m_physGeom = geomNew;
        if (this.m_simulation != null) {
            this.m_simulation.setGeometry(geomNew);
            this.m_simulation.reset();
        }
        this.removeGeometry(this.getGeometry());
        if (geomNew != null) {
            this.addGeometry((PgGeometryIf)this.m_physGeom.m_geometry);
            this.selectGeometry((PgGeometryIf)this.m_physGeom.m_geometry);
        }
    }

    public void setCollGeometry(PgElementSet newColl) {
        this.removeGeometry((PgGeometryIf)this.m_coll);
        if (newColl != null) {
            newColl.showEdges(true);
            newColl.showVertices(true);
            newColl.showElements(false);
            this.m_coll = newColl;
            this.addGeometry((PgGeometryIf)this.m_coll);
            this.selectGeometry((PgGeometryIf)this.m_physGeom.m_geometry);
        }
        if (this.m_simulation != null) {
            this.m_simulation.setCollisionGeometry(this.m_coll);
        }
    }
}

