/*
 * Decompiled with CFR 0.152.
 */
package devNurbs.surfaces;

import devNurbs.surfaces.PgNurbsSurface;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.loader.PgLoader;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;

public class PjNurbsSurface
extends PjProject {
    private static final long serialVersionUID = -2979980593803505883L;
    protected PgNurbsSurface m_pSurface;
    protected PgElementSet m_controlSurface;

    public PjNurbsSurface() {
        super("Nurbs Project");
        if (((Object)((Object)this)).getClass() == PjNurbsSurface.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_pSurface = new PgNurbsSurface(3);
        this.m_controlSurface = this.m_pSurface.getControlSurface();
        this.assureInspector("Info", "_IP");
    }

    public void setDisplay(PvDisplayIf disp) {
        super.setDisplay(disp);
    }

    public void initGeometry() {
        this.addGeometry((PgGeometryIf)this.m_pSurface);
        this.addGeometry((PgGeometryIf)this.m_controlSurface);
        this.selectGeometry((PgGeometryIf)this.m_controlSurface);
        this.getDisplay().getCamera().setInterest(new PdVector(0.0, 0.0, 0.0));
        this.getDisplay().setBackgroundColor(new Color(90, 90, 90));
        if (this.m_pSurface.getDimOfVertices() == 2) {
            this.getDisplay().selectCamera(1);
        }
        this.m_pSurface.update((Object)this.m_pSurface);
    }

    public void loadGeometry(String filename) {
        PgGeometry[] geomNew = new PgLoader().loadGeometry(null, filename);
        if (geomNew == null || geomNew.length == 0 || geomNew[0] == null) {
            PsDebug.warning((String)("loading failed, file = " + filename));
            return;
        }
        if (geomNew.length > 1) {
            PsDebug.warning((String)("only first geometry used, found = " + geomNew.length));
        }
    }

    public boolean setGeometry(PgNurbsSurface surfaceNew) {
        if (this.m_pSurface != null) {
            this.removeGeometry((PgGeometryIf)this.m_pSurface);
        }
        this.m_pSurface = surfaceNew;
        this.addGeometry((PgGeometryIf)this.m_pSurface);
        this.selectGeometry((PgGeometryIf)this.m_pSurface);
        return true;
    }
}

