/*
 * Decompiled with CFR 0.152.
 */
package devNurbs.surfaces;

import devNurbs.surfaces.PgNurbsSurface;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.geom.PgElementSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsTabPanel;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.viewer.PvDisplay;

public class PgNurbsSurface_CP
extends PsPanel
implements ActionListener,
PsUpdateIf,
ItemListener {
    private static final long serialVersionUID = -7704456219244121693L;
    protected PgNurbsSurface m_surface;
    protected PgElementSet m_controlSurface;
    protected PgElementSet m_baseSurface;
    protected TextField m_tName;
    protected PvDisplay m_display = new PvDisplay();
    protected TextField m_tNumVertices2;
    protected TextField m_tOrder;
    protected TextField[][] m_TextFields;
    protected Label[][] m_Labels;
    protected PsTabPanel m_tabs;
    protected PsPanel m_pDetail;
    protected PsPanel[] m_pTextFieldPanels;
    protected PsPanel[] m_pLabelPanels;
    protected Button m_bAddRow;
    protected Button m_bAddColumn;
    protected Button m_bRemoveRow;
    protected Button m_bRemoveColumn;
    protected Button m_showBaseFunction;
    protected Button m_showSurfaceNormals;
    protected PuInteger m_detail_x;
    protected PuInteger m_detail_y;
    protected PuInteger[] m_Scroller;
    protected Checkbox m_CBshowWeights;
    protected Checkbox m_CBmemSpeedup;
    protected Checkbox m_bCloseSurface_X;
    protected Checkbox m_bCloseSurface_Y;
    protected Checkbox m_CBshowBF;
    protected Checkbox m_CBshowDerivX;
    protected Checkbox m_CBshowDerivY;
    protected Checkbox m_CBshowDerivXX;
    protected Checkbox m_CBshowDerivXY;
    protected Checkbox m_CBshowDerivYY;
    protected Checkbox m_CBshowSurfaceNormals;
    private boolean isUpdateingBF;
    private int lastNumVertices = 0;
    private final int INDEX_WEIGHTVECTOR = 2;

    public PgNurbsSurface_CP() {
        this.m_display.setVisible(true);
        this.m_display.showAxes(true);
        this.m_baseSurface = new PgElementSet(3);
        this.m_baseSurface.showVertices(false);
        this.m_baseSurface.showElements(true);
        this.m_baseSurface.showEdges(true);
        this.m_display.addGeometry((PgGeometryIf)this.m_baseSurface);
        this.m_display.selectGeometry((PgGeometryIf)this.m_baseSurface);
        this.m_display.setBackgroundColor(new Color(255, 255, 255));
        this.m_detail_x = new PuInteger("Detail_X", (PsUpdateIf)this);
        this.m_detail_x.setDefBounds(4, 500, 1, 10);
        this.m_detail_x.setDefValue(10);
        this.m_detail_x.init();
        this.m_detail_y = new PuInteger("Detail_Y", (PsUpdateIf)this);
        this.m_detail_y.setDefBounds(4, 500, 1, 10);
        this.m_detail_y.setDefValue(10);
        this.m_detail_y.init();
        this.m_pLabelPanels = new PsPanel[3];
        this.m_pTextFieldPanels = new PsPanel[3];
        this.m_TextFields = new TextField[3][];
        this.m_Labels = new Label[3][];
        this.m_Scroller = new PuInteger[3];
        int i = 0;
        while (i < this.m_Scroller.length) {
            this.m_Scroller[i] = new PuInteger(" ", (PsUpdateIf)this);
            this.m_Scroller[i].setDefBounds(0, 1, 1, 1);
            this.m_Scroller[i].setDefValue(0);
            this.m_Scroller[i].init();
            ++i;
        }
        this.m_tOrder = new TextField(4);
        this.m_tOrder.setText("2");
        this.m_tOrder.addActionListener(this);
        this.m_bAddColumn = new Button("add column");
        this.m_bAddColumn.addActionListener(this);
        this.m_bAddRow = new Button("add row");
        this.m_bAddRow.addActionListener(this);
        this.m_bRemoveColumn = new Button("remove column");
        this.m_bRemoveColumn.addActionListener(this);
        this.m_bRemoveRow = new Button("remove row");
        this.m_bRemoveRow.addActionListener(this);
        this.m_showBaseFunction = new Button("show base surface for first marked vertex");
        this.m_showBaseFunction.addActionListener(this);
        this.m_CBshowWeights = new Checkbox("show weights");
        this.m_CBshowWeights.addItemListener(this);
        this.m_CBshowWeights.setState(true);
        this.m_CBmemSpeedup = new Checkbox("memory speed up");
        this.m_CBmemSpeedup.addItemListener(this);
        this.m_CBmemSpeedup.setState(true);
        this.m_CBshowBF = new Checkbox("auto updates");
        this.m_CBshowBF.addItemListener(this);
        this.m_CBshowBF.setState(false);
        this.m_bCloseSurface_X = new Checkbox("close surface X");
        this.m_bCloseSurface_X.addItemListener(this);
        this.m_bCloseSurface_X.setState(false);
        this.m_bCloseSurface_Y = new Checkbox("close surface Y");
        this.m_bCloseSurface_Y.addItemListener(this);
        this.m_bCloseSurface_Y.setState(false);
        this.m_CBshowDerivX = new Checkbox("show DerivX");
        this.m_CBshowDerivX.addItemListener(this);
        this.m_CBshowDerivX.setState(false);
        this.m_CBshowDerivY = new Checkbox("show DerivY");
        this.m_CBshowDerivY.addItemListener(this);
        this.m_CBshowDerivY.setState(false);
        this.m_CBshowDerivXY = new Checkbox("show DerivXY");
        this.m_CBshowDerivXY.addItemListener(this);
        this.m_CBshowDerivXY.setState(false);
        this.m_CBshowDerivXX = new Checkbox("show DerivXX");
        this.m_CBshowDerivXX.addItemListener(this);
        this.m_CBshowDerivXX.setState(false);
        this.m_CBshowDerivYY = new Checkbox("show DerivYY");
        this.m_CBshowDerivYY.addItemListener(this);
        this.m_CBshowDerivYY.setState(false);
        this.m_CBshowSurfaceNormals = new Checkbox("show Normals");
        this.m_CBshowSurfaceNormals.addItemListener(this);
        this.m_CBshowSurfaceNormals.setState(false);
        this.isUpdateingBF = false;
        this.m_tNumVertices2 = new TextField("", 7);
        this.m_tNumVertices2.addActionListener(this);
        this.m_tNumVertices2.setEnabled(false);
        this.m_tabs = new PsTabPanel();
        if (this.getClass() == PgNurbsSurface_CP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        PsPanel basePanel = new PsPanel();
        PsPanel extendPanel = new PsPanel();
        this.add((Component)this.m_tabs);
        this.m_tabs.addPanel("base config", basePanel);
        this.m_tabs.addPanel("show basefunctions", extendPanel);
        basePanel.setInsetSize(4);
        basePanel.setBorderType(1);
        extendPanel.setInsetSize(4);
        extendPanel.setBorderType(1);
        PsPanel pOrderPanel = new PsPanel((LayoutManager)new FlowLayout());
        pOrderPanel.add((Component)new Label("enter a new order"));
        pOrderPanel.add((Component)this.m_tOrder);
        basePanel.add((Component)pOrderPanel);
        PsPanel pButtons = new PsPanel((LayoutManager)new GridLayout(2, 2));
        basePanel.add((Component)pButtons);
        pButtons.add((Component)this.m_bAddColumn);
        pButtons.add((Component)this.m_bAddRow);
        pButtons.add((Component)this.m_bRemoveColumn);
        pButtons.add((Component)this.m_bRemoveRow);
        basePanel.addLine(1);
        PsPanel pCheckboxes = new PsPanel((LayoutManager)new GridLayout(2, 2));
        basePanel.add((Component)pCheckboxes);
        pCheckboxes.add((Component)this.m_bCloseSurface_X);
        pCheckboxes.add((Component)this.m_bCloseSurface_Y);
        pCheckboxes.add((Component)this.m_CBshowWeights);
        pCheckboxes.add((Component)this.m_CBmemSpeedup);
        basePanel.addLine(1);
        PsPanel pCheckBoxesDerivs = new PsPanel((LayoutManager)new GridLayout(1, 3));
        basePanel.add((Component)pCheckBoxesDerivs);
        pCheckBoxesDerivs.add((Component)this.m_CBshowDerivX);
        pCheckBoxesDerivs.add((Component)this.m_CBshowDerivY);
        pCheckBoxesDerivs.add((Component)this.m_CBshowSurfaceNormals);
        basePanel.addLine(1);
        PsPanel weightsPanel = new PsPanel((LayoutManager)new GridLayout(4, 1));
        basePanel.add((Component)weightsPanel);
        int i = 0;
        while (i < this.m_pTextFieldPanels.length) {
            this.m_pTextFieldPanels[i] = new PsPanel((LayoutManager)new GridLayout(1, 5));
            this.m_pLabelPanels[i] = new PsPanel((LayoutManager)new GridLayout(1, 5));
            ++i;
        }
        weightsPanel.add((Component)new Label("weights"));
        weightsPanel.add((Component)this.m_pLabelPanels[2]);
        weightsPanel.add((Component)this.m_pTextFieldPanels[2]);
        weightsPanel.add((Component)this.m_Scroller[2].assureInspector("Info", "_IP"));
        basePanel.addLine(1);
        PsPanel knotsPanel = new PsPanel((LayoutManager)new GridLayout(4, 1));
        basePanel.add((Component)knotsPanel);
        knotsPanel.add((Component)new Label("knots (x-axis)"));
        knotsPanel.add((Component)this.m_pLabelPanels[0]);
        knotsPanel.add((Component)this.m_pTextFieldPanels[0]);
        knotsPanel.add((Component)this.m_Scroller[0].assureInspector("Info", "_IP"));
        basePanel.addLine(1);
        PsPanel knotsPanel2 = new PsPanel((LayoutManager)new GridLayout(4, 1));
        basePanel.add((Component)knotsPanel2);
        knotsPanel2.add((Component)new Label("knots (y-axis)"));
        knotsPanel2.add((Component)this.m_pLabelPanels[1]);
        knotsPanel2.add((Component)this.m_pTextFieldPanels[1]);
        knotsPanel2.add((Component)this.m_Scroller[1].assureInspector("Info", "_IP"));
        basePanel.addLine(1);
        this.m_pDetail = new PsPanel((LayoutManager)new GridLayout(2, 1));
        basePanel.add((Component)this.m_pDetail);
        this.m_pDetail.add((Component)this.m_detail_x.assureInspector("Info", "_IP"));
        this.m_pDetail.add((Component)this.m_detail_y.assureInspector("Info", "_IP"));
        PsPanel dispPanel = new PsPanel();
        dispPanel.setInsetSize(4);
        dispPanel.add((Component)this.m_showBaseFunction);
        dispPanel.addLine(1);
        dispPanel.add((Component)this.m_display);
        dispPanel.addLine(1);
        dispPanel.add((Component)this.m_CBshowBF);
        extendPanel.add((Component)dispPanel);
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_surface = (PgNurbsSurface)parent;
        this.m_controlSurface = this.m_surface.getControlSurface();
        this.m_surface.initKnotVector();
        int n = this.m_controlSurface.getNumVertices();
        this.m_tNumVertices2.setText(String.valueOf(n));
        this.m_Scroller[2].setBounds(0, n > 5 ? n - 5 : 0);
        this.m_Scroller[2].setDefBounds(0, n > 5 ? n - 5 : 0, 1, 1);
        this.m_Scroller[2].init();
        int i = 0;
        while (i < 2) {
            n = this.m_surface.getKnotVector()[i].getSize();
            this.m_Scroller[i].setBounds(0, n > 5 ? n - 5 : 0);
            this.m_Scroller[i].setDefBounds(0, n > 5 ? n - 5 : 0, 1, 1);
            this.m_Scroller[i].init();
            ++i;
        }
        this.initPanels();
        this.add((Component)this.m_surface.assureInspector("Info", "_IP"));
    }

    private void initPanels() {
        int columns;
        int i = 0;
        while (i < this.m_pTextFieldPanels.length) {
            this.m_pTextFieldPanels[i].removeAll();
            this.m_pLabelPanels[i].removeAll();
            ++i;
        }
        int raws = this.m_surface.getNumControlRows();
        int n = raws * (columns = this.m_surface.getNumControlColumns());
        this.m_TextFields[2] = new TextField[n > 5 ? 5 : n];
        this.m_Labels[2] = new Label[this.m_TextFields[2].length];
        int i2 = 0;
        while (i2 < this.m_TextFields[2].length) {
            this.m_Labels[2][i2] = new Label("[" + Integer.toString(i2) + "]");
            this.m_pLabelPanels[2].add((Component)this.m_Labels[2][i2]);
            this.m_TextFields[2][i2] = new TextField(5);
            this.m_TextFields[2][i2].addActionListener(this);
            if (this.m_surface != null) {
                this.m_TextFields[2][i2].setText(String.valueOf(this.m_surface.getControlWeights().m_data[i2]));
            }
            this.m_pTextFieldPanels[2].add((Component)this.m_TextFields[2][i2]);
            ++i2;
        }
        this.m_surface.initKnotVector();
        i2 = 0;
        while (i2 < 2) {
            this.m_TextFields[i2] = new TextField[this.m_surface.getKnotVector()[i2].getSize() > 5 ? 5 : this.m_surface.getKnotVector()[i2].getSize()];
            this.m_Labels[i2] = new Label[this.m_TextFields[i2].length];
            int j = 0;
            while (j < this.m_TextFields[i2].length) {
                this.m_Labels[i2][j] = new Label("[" + Integer.toString(j) + "]");
                this.m_pLabelPanels[i2].add((Component)this.m_Labels[i2][j]);
                this.m_TextFields[i2][j] = new TextField(5);
                this.m_TextFields[i2][j].addActionListener(this);
                if (this.m_surface != null) {
                    this.m_TextFields[i2][j].setText(String.valueOf(this.m_surface.getKnotVector()[i2].getEntry(j)));
                }
                this.m_pTextFieldPanels[i2].add((Component)this.m_TextFields[i2][j]);
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_pTextFieldPanels.length) {
            this.m_pTextFieldPanels[i2].validate();
            this.m_pLabelPanels[i2].validate();
            ++i2;
        }
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        Object source = aEvent.getSource();
        if (source == this.m_bRemoveColumn) {
            this.m_surface.removeControlPointColumn();
        } else if (source == this.m_bRemoveRow) {
            this.m_surface.removeControlPointRow();
        } else if (source == this.m_bAddColumn) {
            this.m_surface.addControlPointColumn();
        } else if (source == this.m_bAddRow) {
            this.m_surface.addControlPointRow();
        } else if (source == this.m_showBaseFunction) {
            this.showBaseFunctions();
        } else if (source == this.m_tOrder) {
            int aNumber = 0;
            try {
                aNumber = Integer.parseInt(this.m_tOrder.getText());
                this.m_surface.setOrder(aNumber);
                this.updateSlider();
                this.setKnots();
                this.setWeights();
                if (this.isUpdateingBF) {
                    this.showBaseFunctions();
                }
            }
            catch (NumberFormatException aException) {
                PsDebug.warning((String)"Only integer numbers between 2 and 6 (inclusive) are allowed.");
            }
        } else {
            int j = 0;
            while (j < this.m_TextFields[2].length) {
                if (source == this.m_TextFields[2][j]) {
                    this.getWeightValues();
                    if (!this.isUpdateingBF) break;
                    this.showBaseFunctions();
                    break;
                }
                ++j;
            }
            int i = 0;
            while (i < 2) {
                int j2 = 0;
                while (j2 < this.m_TextFields[i].length) {
                    if (source == this.m_TextFields[i][j2]) {
                        this.getKnotValues();
                        if (!this.isUpdateingBF) break;
                        this.showBaseFunctions();
                        break;
                    }
                    ++j2;
                }
                ++i;
            }
        }
        if (this.m_surface.isUsingMemSpeedup()) {
            this.m_surface.calcBaseFunctions();
        }
        this.showWeights(this.isShowingWeights());
        this.m_controlSurface.update((Object)this.m_controlSurface);
    }

    public void initBaseSurfaceElements() {
        int detX = this.m_surface.getDetailX();
        int detY = this.m_surface.getDetailY();
        this.m_baseSurface.setNumElements((detX - 1) * (detY - 1));
        PiVector[] elements = this.m_baseSurface.getElements();
        int i = 0;
        while (i < detX - 1) {
            int j = 0;
            while (j < detY - 1) {
                elements[i * (detY - 1) + j] = new PiVector(j + i * detY, j + (i + 1) * detY, j + (i + 1) * detY + 1, j + i * detY + 1);
                ++j;
            }
            ++i;
        }
    }

    public boolean update(Object event) {
        if (event == this.m_detail_x) {
            this.m_surface.setDetail(this.m_detail_x.getValue(), this.m_detail_y.getValue());
            return true;
        }
        if (event == this.m_detail_y) {
            this.m_surface.setDetail(this.m_detail_x.getValue(), this.m_detail_y.getValue());
            return true;
        }
        if (event == this.m_surface) {
            if (this.m_surface.getNumControlPoints() != this.lastNumVertices) {
                if (this.m_surface.getNumControlColumns() < 5 || this.m_surface.getNumControlRows() < 5) {
                    this.initPanels();
                } else {
                    this.setWeights();
                    this.setKnots();
                }
                this.updateSlider();
                this.m_tNumVertices2.setText(String.valueOf(this.m_controlSurface.getNumVertices()));
            }
            this.lastNumVertices = this.m_surface.getNumControlPoints();
            this.showWeights(this.isShowingWeights());
            return true;
        }
        if (event == this.m_Scroller[2]) {
            this.setWeights();
            return true;
        }
        if (event == this.m_Scroller[0]) {
            this.setKnots();
            return true;
        }
        if (event == this.m_Scroller[1]) {
            this.setKnots();
            return true;
        }
        return super.update(event);
    }

    public boolean isShowingWeights() {
        return this.m_CBshowWeights.getState();
    }

    @Override
    public void itemStateChanged(ItemEvent aEvent) {
        Object source = aEvent.getSource();
        if (source == this.m_CBshowWeights) {
            this.showWeights(this.isShowingWeights());
            this.m_controlSurface.update((Object)this.m_controlSurface);
        } else if (source == this.m_CBmemSpeedup) {
            this.m_surface.useMemSpeedup(this.m_CBmemSpeedup.getState());
        } else if (source == this.m_CBshowBF) {
            this.isUpdateingBF = this.m_CBshowBF.getState();
        } else if (source == this.m_bCloseSurface_X) {
            this.m_surface.setClosedX(!this.m_surface.isClosedX());
        } else if (source == this.m_bCloseSurface_Y) {
            this.m_surface.setClosedY(!this.m_surface.isClosedY());
        } else if (source == this.m_CBshowDerivX) {
            this.m_surface.switchEvalDerivatives(0, -1, this.m_CBshowDerivX.getState());
        } else if (source == this.m_CBshowDerivY) {
            this.m_surface.switchEvalDerivatives(1, -1, this.m_CBshowDerivY.getState());
        } else if (source == this.m_CBshowSurfaceNormals) {
            this.m_surface.switchEvalNormals(this.m_CBshowSurfaceNormals.getState());
        }
        if (this.m_surface.isUsingMemSpeedup()) {
            this.m_surface.calcBaseFunctions();
        }
        if (this.m_CBshowDerivX.getState() || this.m_CBshowDerivY.getState() || this.m_CBshowSurfaceNormals.getState()) {
            this.m_surface.showVectorFields(true);
        } else {
            this.m_surface.showVectorFields(false);
        }
        this.showWeights(this.isShowingWeights());
        this.updateSlider();
        this.setKnots();
        this.m_controlSurface.update((Object)this.m_controlSurface);
        this.m_surface.update((Object)this.m_surface);
    }

    protected void showWeights(boolean isShowingWeights) {
        if (this.isShowingWeights()) {
            int i = 0;
            while (i < this.m_controlSurface.getNumVertices()) {
                this.m_controlSurface.getVertex(i).setName("[" + i + "] " + this.m_surface.getControlWeights().m_data[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.m_controlSurface.getNumVertices()) {
                this.m_controlSurface.getVertex(i).setName(String.valueOf(i));
                ++i;
            }
        }
    }

    private void updateSlider() {
        int[] tmp = new int[this.m_Scroller.length];
        int i = 0;
        while (i < 2) {
            this.m_Scroller[i].setDefBounds(0, this.m_surface.getKnotVector()[i].getSize() >= 5 ? this.m_surface.getKnotVector()[i].getSize() - 5 : 0, 1, 1);
            tmp[i] = this.m_Scroller[i].getValue();
            ++i;
        }
        this.m_Scroller[2].setDefBounds(0, this.m_controlSurface.getNumVertices() >= 5 ? this.m_controlSurface.getNumVertices() - 5 : 0, 1, 1);
        tmp[2] = this.m_Scroller[2].getValue();
        i = 0;
        while (i < tmp.length - 1) {
            if (this.m_surface.getKnotVector()[i].getSize() > 5 && tmp[i] > this.m_surface.getKnotVector()[i].getSize() - 5) {
                tmp[i] = this.m_surface.getKnotVector()[i].getSize() - 5;
            }
            ++i;
        }
        if (this.m_surface.getControlWeights().getSize() > 5 && tmp[2] > this.m_surface.getControlWeights().getSize() - 5) {
            tmp[2] = this.m_surface.getControlWeights().getSize() - 5;
        }
        i = 0;
        while (i < this.m_Scroller.length) {
            this.m_Scroller[i].init();
            this.m_Scroller[i].setValue(tmp[i]);
            ++i;
        }
    }

    private void setWeights() {
        int offset = this.m_Scroller[2].getValue();
        if (offset > this.m_controlSurface.getNumVertices() - 5 || offset < 0) {
            return;
        }
        int i = 0;
        while (i < this.m_TextFields[2].length) {
            this.m_Labels[2][i].setText("[" + Integer.toString(i + offset) + "]");
            this.m_TextFields[2][i].setText(String.valueOf(this.m_surface.getControlWeights().m_data[i + offset]));
            ++i;
        }
    }

    private void setKnots() {
        int i = 0;
        while (i < 2) {
            int offset = this.m_Scroller[i].getValue();
            if (offset > this.m_surface.getKnotVector()[i].getSize() - 5 || offset < 0) {
                return;
            }
            int j = 0;
            while (j < this.m_TextFields[i].length) {
                this.m_Labels[i][j].setText("[" + Integer.toString(j + offset) + "]");
                this.m_TextFields[i][j].setText(String.valueOf(this.m_surface.getKnotVector()[i].getEntry(j + offset)));
                ++j;
            }
            ++i;
        }
    }

    private void getWeightValues() {
        int offset = this.m_Scroller[2].getValue();
        if (offset > this.m_controlSurface.getNumVertices() - 5 || offset < 0) {
            return;
        }
        try {
            int i = 0;
            while (i < this.m_TextFields[2].length) {
                double tmpDouble;
                this.m_surface.getControlWeights().m_data[i + offset] = tmpDouble = PuDouble.parseDouble((String)this.m_TextFields[2][i].getText());
                ++i;
            }
        }
        catch (NumberFormatException aException) {
            PsDebug.warning((String)"Wrong number format.");
        }
        this.m_controlSurface.update((Object)this.m_controlSurface);
        this.setWeights();
    }

    private void getKnotValues() {
        try {
            int i = 0;
            while (i < 2) {
                int offset = this.m_Scroller[i].getValue();
                if (offset > this.m_surface.getKnotVector()[i].getSize() - 5 || offset < 0) {
                    return;
                }
                int j = 0;
                while (j < this.m_TextFields[i].length) {
                    double tmpDouble = PuDouble.parseDouble((String)this.m_TextFields[i][j].getText());
                    this.m_surface.getKnotVector()[i].setEntry(j + offset, tmpDouble);
                    ++j;
                }
                ++i;
            }
        }
        catch (NumberFormatException aException) {
            PsDebug.warning((String)"Wrong number format.");
        }
        this.m_controlSurface.update((Object)this.m_controlSurface);
        this.setKnots();
    }

    private void showBaseFunctions() {
        PiVector markedVertices = this.m_surface.getControlSurface().getMarkedVertices(1);
        int numMarked = markedVertices.getSize();
        if (numMarked > 0) {
            int actVertexIndex = markedVertices.getEntry(0);
            double firstx = 0.0;
            double lastx = 0.0;
            double firsty = 0.0;
            double lasty = 0.0;
            int detX = this.m_surface.getDetailX();
            int detY = this.m_surface.getDetailY();
            firstx = this.m_surface.getKnotVector()[0].getFirstEntry();
            lastx = this.m_surface.getKnotVector()[0].getLastEntry();
            firsty = this.m_surface.getKnotVector()[1].getFirstEntry();
            lasty = this.m_surface.getKnotVector()[1].getLastEntry();
            double stepx = (lastx - firstx) / (double)(detX - 1);
            double stepy = (lasty - firsty) / (double)(detY - 1);
            this.m_baseSurface.setNumVertices(detX * detY);
            this.initBaseSurfaceElements();
            PdVector[] vertices = this.m_baseSurface.getVertices();
            int i = 0;
            while (i < detX) {
                int j = 0;
                while (j < detY) {
                    vertices[i * detY + j].setEntry(0, firstx + (double)i * stepx);
                    vertices[i * detY + j].setEntry(1, firsty + (double)j * stepy);
                    vertices[i * detY + j].setEntry(2, this.m_surface.evalBaseFunction(actVertexIndex, firstx + (double)i * stepx, firsty + (double)j * stepy));
                    ++j;
                }
                ++i;
            }
            this.m_display.getCamera().setInterest(new PdVector((lastx - firstx) / 2.0, (lasty - firsty) / 2.0, 0.5));
            this.m_display.getCamera().setDist(2.0 * Math.min(lastx - firstx, lasty - firsty));
            this.m_baseSurface.update((Object)this.m_baseSurface);
            this.m_display.update((Object)this.m_display);
        }
    }
}

