/*
 * Decompiled with CFR 0.152.
 */
package devNurbs.surfaces;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgNurbsSurface
extends PgElementSet
implements PsUpdateIf {
    private static final long serialVersionUID = -1326461611203017062L;
    protected static final int DEFAULT_DETAIL_X = 10;
    protected static final int DEFAULT_DETAIL_Y = 10;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int NO_AXIS = -1;
    protected static final int DEFAULT_ORDER = 2;
    private int m_numControlRows;
    private int m_numControlColumns;
    private int m_order;
    private PdVector[] m_knotVector;
    private PdVector m_controlWeights;
    private PgElementSet m_controlSurface;
    private int m_detail_X;
    private int m_detail_Y;
    private boolean m_bMemSpeedUp;
    private boolean m_bIsClosedX;
    private boolean m_bIsClosedY;
    private double[][] m_RBaseSave;
    public PgVectorField m_derivX;
    public PgVectorField m_derivY;
    public PgVectorField m_normals;
    public PgVectorField m_derivXX;
    public PgVectorField m_derivXY;
    public PgVectorField m_derivYY;
    private boolean m_bIsEvalDerivX;
    private boolean m_bIsEvalDerivY;
    private boolean m_bIsEvalNormals;
    private boolean m_bIsEvalDerivXX;
    private boolean m_bIsEvalDerivXY;
    private boolean m_bIsEvalDerivYY;

    public PgNurbsSurface(int aVertexDim) {
        super(aVertexDim);
        this.setTag(10);
        this.m_controlSurface = new PgElementSet(this.m_dim);
        this.m_controlSurface.addUpdateListener((PsUpdateIf)this);
        this.m_controlSurface.setGlobalVertexSize(3.0);
        this.m_controlSurface.setGlobalEdgeSize(1.0);
        this.m_controlSurface.setGlobalEdgeColor(Color.white);
        this.m_controlSurface.setName("ControlSurface");
        this.m_controlSurface.showVertices(true);
        this.m_controlSurface.showElements(false);
        this.m_numControlRows = 0;
        this.m_numControlColumns = 0;
        this.m_order = 2;
        this.m_bIsClosedX = false;
        this.m_bIsClosedY = false;
        this.m_bMemSpeedUp = true;
        this.m_detail_X = 10;
        this.m_detail_Y = 10;
        this.m_bIsEvalDerivX = false;
        this.m_bIsEvalDerivY = false;
        this.m_bIsEvalNormals = false;
        this.m_bIsEvalDerivXX = false;
        this.m_bIsEvalDerivXY = false;
        this.m_bIsEvalDerivYY = false;
        this.m_derivX = new PgVectorField(3);
        this.m_derivX.setGlobalVectorColor(new Color(0, 200, 0));
        this.m_derivX.showIndividualMaterial(true);
        this.m_derivX.showVectorArrows(true);
        this.m_derivX.setGlobalVectorLength(0.2);
        this.m_derivX.setGlobalVectorSize(6.0);
        this.m_derivY = new PgVectorField(3);
        this.m_derivY.setGlobalVectorColor(Color.BLUE);
        this.m_derivY.showIndividualMaterial(true);
        this.m_derivY.showVectorArrows(true);
        this.m_derivY.setGlobalVectorLength(0.2);
        this.m_derivY.setGlobalVectorSize(6.0);
        this.m_normals = new PgVectorField(3);
        this.m_normals.setGlobalVectorColor(Color.RED);
        this.m_normals.showIndividualMaterial(true);
        this.m_normals.showVectorArrows(true);
        this.m_normals.setGlobalVectorLength(0.2);
        this.m_normals.setGlobalVectorSize(6.0);
        this.m_derivXX = new PgVectorField(3);
        this.m_derivXY = new PgVectorField(3);
        this.m_derivYY = new PgVectorField(3);
        this.m_derivX.setGeometry((PgPointSet)this);
        this.m_derivY.setGeometry((PgPointSet)this);
        this.m_normals.setGeometry((PgPointSet)this);
        this.m_derivXX.setGeometry((PgPointSet)this);
        this.m_derivXY.setGeometry((PgPointSet)this);
        this.m_derivYY.setGeometry((PgPointSet)this);
        this.m_knotVector = new PdVector[2];
        this.m_knotVector[0] = new PdVector();
        this.m_knotVector[1] = new PdVector();
        this.showVertices(false);
        this.setName("Nurbs Surface");
        if (((Object)((Object)this)).getClass() == PgNurbsSurface.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addBaseGeometry();
        this.initKnotVector();
        this.reevaluate();
    }

    public void copy(PsObject object) {
        super.copy(object);
        if (object == null) {
            return;
        }
        if (!(object instanceof PgNurbsSurface)) {
            return;
        }
        PgNurbsSurface s = (PgNurbsSurface)object;
        this.m_controlSurface.copy((PsObject)s.m_controlSurface);
        if (this.m_knotVector.length != 2) {
            this.m_knotVector = new PdVector[2];
        }
        int j = 0;
        while (j < this.m_knotVector.length) {
            this.m_knotVector[j].setSize(s.m_knotVector[j].getSize());
            int i = 0;
            while (i < s.m_knotVector[j].getSize()) {
                this.m_knotVector[j].setEntry(i, s.m_knotVector[j].getEntry(i));
                ++i;
            }
            ++j;
        }
        this.m_controlWeights.setSize(s.m_controlWeights.getSize());
        int i = 0;
        while (i < s.m_controlWeights.getSize()) {
            this.m_controlWeights.setEntry(i, s.m_controlWeights.getEntry(i));
            ++i;
        }
        this.m_numControlColumns = s.getNumControlColumns();
        this.m_numControlRows = s.getNumControlRows();
        this.m_bIsClosedX = s.m_bIsClosedX;
        this.m_bIsClosedY = s.m_bIsClosedY;
        this.setOrder(s.getOrder());
        this.setDetail(s.getDetailX(), s.getDetailY());
    }

    public Object clone() {
        PgNurbsSurface clone = (PgNurbsSurface)((Object)super.clone());
        if (clone == null) {
            return null;
        }
        clone.m_controlSurface = (PgElementSet)this.m_controlSurface.clone();
        clone.m_controlWeights = (PdVector)this.m_controlWeights.clone();
        clone.m_numControlColumns = this.getNumControlColumns();
        clone.m_numControlRows = this.getNumControlRows();
        clone.m_bIsClosedX = this.m_bIsClosedX;
        clone.m_bIsClosedY = this.m_bIsClosedY;
        clone.setOrder(this.getOrder());
        clone.setDetail(this.getDetailX(), this.getDetailY());
        return clone;
    }

    public void addBaseGeometry() {
        this.m_numControlRows = 2;
        this.m_numControlColumns = 2;
        this.m_controlSurface.setNumVertices(4);
        PdVector[] vertices = this.m_controlSurface.getVertices();
        vertices[0] = new PdVector(0.0, 0.0, 1.0);
        vertices[1] = new PdVector(0.0, 1.0, 1.0);
        vertices[2] = new PdVector(1.0, 0.0, 1.0);
        vertices[3] = new PdVector(1.0, 1.0, 1.0);
        this.initControlSurfaceFaces();
        this.m_controlWeights = new PdVector(this.m_numControlColumns * this.m_numControlRows);
        int i = 0;
        while (i < this.m_controlWeights.m_data.length) {
            this.m_controlWeights.m_data[i] = 1.0;
            ++i;
        }
        this.setNumVertices(this.m_detail_X * this.m_detail_Y);
        this.initFaces();
    }

    public boolean addControlPointRow() {
        ++this.m_numControlRows;
        int n = this.m_numControlColumns * this.m_numControlRows;
        this.m_controlSurface.setNumVertices(n);
        PdVector[] controlVertices = this.m_controlSurface.getVertices();
        this.m_controlWeights.setSize(n);
        int offset = this.m_numControlColumns - 1;
        int i = n - 1;
        while (i >= 0) {
            if ((i + 1) % this.m_numControlRows == 0) {
                controlVertices[i] = PdVector.subNew((PdVector)controlVertices[i - offset - 1], (PdVector)controlVertices[i - offset - 2]);
                controlVertices[i].add(controlVertices[i - offset - 1]);
                this.m_controlWeights.setEntry(i, 1.0);
            } else {
                this.m_controlWeights.setEntry(i, this.m_controlWeights.m_data[i - offset]);
                controlVertices[i] = PdVector.copyNew((PdVector)controlVertices[i - offset]);
            }
            if (i % this.m_numControlRows == 0) {
                --offset;
            }
            --i;
        }
        this.initKnotVector();
        return true;
    }

    public boolean removeControlPointRow() {
        if (this.m_numControlRows - 1 < this.m_order) {
            PsDebug.warning((String)"The number of rows cannot be reduced below the order of the surface.");
            return false;
        }
        --this.m_numControlRows;
        int n = this.m_numControlRows * this.m_numControlColumns;
        PdVector[] vertices = this.m_controlSurface.getVertices();
        int offset = 1;
        int i = this.m_numControlRows;
        while (i < n) {
            vertices[i] = PdVector.copyNew((PdVector)vertices[i + offset]);
            this.m_controlWeights.setEntry(i, this.m_controlWeights.getEntry(i + offset));
            if ((i + 1) % this.m_numControlRows == 0) {
                ++offset;
            }
            ++i;
        }
        this.m_controlSurface.setNumVertices(n);
        this.m_controlWeights.setSize(n);
        this.initKnotVector();
        return true;
    }

    public boolean addControlPointColumn() {
        ++this.m_numControlColumns;
        this.m_controlSurface.setNumVertices(this.m_numControlColumns * this.m_numControlRows);
        this.m_controlWeights.setSize(this.m_numControlColumns * this.m_numControlRows);
        PdVector[] controlVertices = this.m_controlSurface.getVertices();
        int n = this.m_numControlRows * (this.m_numControlColumns - 1);
        int i = 0;
        while (i < this.m_numControlRows) {
            PdVector pdVector = PdVector.subNew((PdVector)controlVertices[i + n - this.m_numControlRows], (PdVector)controlVertices[i + n - 2 * this.m_numControlRows]);
            controlVertices[i + n] = pdVector;
            pdVector.add(controlVertices[i + n - this.m_numControlRows]);
            this.m_controlWeights.m_data[i + n] = 1.0;
            ++i;
        }
        this.initKnotVector();
        return true;
    }

    public boolean removeControlPointColumn() {
        if (this.m_numControlColumns - 1 < this.m_order) {
            PsDebug.warning((String)"The number of columns cannot be reduced below the order of the surface.");
            return false;
        }
        --this.m_numControlColumns;
        this.m_controlSurface.setNumVertices(this.m_numControlColumns * this.m_numControlRows);
        this.m_controlWeights.setSize(this.m_numControlColumns * this.m_numControlRows);
        this.initKnotVector();
        return true;
    }

    protected void initKnotVector() {
        double actKnotVectorValue = 0.0;
        this.m_knotVector[0].setSize(this.m_numControlColumns + (this.isClosedX() ? 1 : this.m_order));
        this.m_knotVector[1].setSize(this.m_numControlRows + (this.isClosedY() ? 1 : this.m_order));
        int[] value = new int[]{this.m_numControlColumns, this.m_numControlRows};
        int j = 0;
        while (j < 2) {
            int i;
            if (this.isClosed(j)) {
                i = 0;
                while (i < this.m_knotVector[j].getSize()) {
                    double d = actKnotVectorValue;
                    actKnotVectorValue = d + 1.0;
                    this.m_knotVector[j].setEntry(i, d);
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.m_order) {
                    this.m_knotVector[j].setEntry(i, actKnotVectorValue);
                    ++i;
                }
                i = this.m_order;
                while (i < value[j]) {
                    this.m_knotVector[j].setEntry(i, actKnotVectorValue += 1.0);
                    ++i;
                }
                actKnotVectorValue += 1.0;
                i = value[j];
                while (i < value[j] + this.m_order) {
                    this.m_knotVector[j].setEntry(i, actKnotVectorValue);
                    ++i;
                }
            }
            actKnotVectorValue = 0.0;
            ++j;
        }
        if (this.m_bMemSpeedUp) {
            this.calcBaseFunctions();
        }
    }

    public boolean setKnotVector(PdVector aKnotVector) {
        if (aKnotVector.getSize() != this.m_numControlColumns + (this.isClosedX() ? 1 : this.m_order)) {
            return false;
        }
        if (aKnotVector.getSize() != this.m_numControlRows + (this.isClosedY() ? 1 : this.m_order)) {
            return false;
        }
        this.m_knotVector[0].copy(aKnotVector);
        this.m_knotVector[1].copy(aKnotVector);
        if (this.m_bMemSpeedUp) {
            this.calcBaseFunctions();
        }
        return true;
    }

    private void initFaces() {
        this.setNumElements((this.isClosedX() ? this.m_detail_X : this.m_detail_X - 1) * (this.isClosedY() ? this.m_detail_Y : this.m_detail_Y - 1));
        PiVector[] elements = this.getElements();
        int i = 0;
        while (i < (this.isClosedX() ? this.m_detail_X : this.m_detail_X - 1)) {
            int j = 0;
            while (j < (this.isClosedY() ? this.m_detail_Y : this.m_detail_Y - 1)) {
                elements[i * (this.isClosedY() ? this.m_detail_Y : this.m_detail_Y - 1) + j].setSize(4);
                elements[i * (this.isClosedY() ? this.m_detail_Y : this.m_detail_Y - 1) + j].setEntry(0, j % this.m_detail_Y + i % this.m_detail_X * this.m_detail_Y);
                elements[i * (this.isClosedY() ? this.m_detail_Y : this.m_detail_Y - 1) + j].setEntry(1, j % this.m_detail_Y + (i + 1) % this.m_detail_X * this.m_detail_Y);
                elements[i * (this.isClosedY() ? this.m_detail_Y : this.m_detail_Y - 1) + j].setEntry(2, (j + 1) % this.m_detail_Y + (i + 1) % this.m_detail_X * this.m_detail_Y);
                elements[i * (this.isClosedY() ? this.m_detail_Y : this.m_detail_Y - 1) + j].setEntry(3, (j + 1) % this.m_detail_Y + i % this.m_detail_X * this.m_detail_Y);
                ++j;
            }
            ++i;
        }
        this.makeNeighbour();
    }

    private void initControlSurfaceFaces() {
        this.m_controlSurface.setNumElements((this.isClosedX() ? this.m_numControlColumns : this.m_numControlColumns - 1) * (this.isClosedY() ? this.m_numControlRows : this.m_numControlRows - 1));
        PiVector[] elements = this.m_controlSurface.getElements();
        int i = 0;
        while (i < (this.isClosedX() ? this.m_numControlColumns : this.m_numControlColumns - 1)) {
            int j = 0;
            while (j < (this.isClosedY() ? this.m_numControlRows : this.m_numControlRows - 1)) {
                elements[i * (this.isClosedY() ? this.m_numControlRows : this.m_numControlRows - 1) + j].setSize(4);
                elements[i * (this.isClosedY() ? this.m_numControlRows : this.m_numControlRows - 1) + j].setEntry(0, j % this.m_numControlRows + i % this.m_numControlColumns * this.m_numControlRows);
                elements[i * (this.isClosedY() ? this.m_numControlRows : this.m_numControlRows - 1) + j].setEntry(1, j % this.m_numControlRows + (i + 1) % this.m_numControlColumns * this.m_numControlRows);
                elements[i * (this.isClosedY() ? this.m_numControlRows : this.m_numControlRows - 1) + j].setEntry(2, (j + 1) % this.m_numControlRows + (i + 1) % this.m_numControlColumns * this.m_numControlRows);
                elements[i * (this.isClosedY() ? this.m_numControlRows : this.m_numControlRows - 1) + j].setEntry(3, (j + 1) % this.m_numControlRows + i % this.m_numControlColumns * this.m_numControlRows);
                ++j;
            }
            ++i;
        }
        this.m_controlSurface.makeNeighbour();
    }

    public void setWeights(PdVector aWeightVector) {
        this.m_controlWeights = aWeightVector;
        this.reevaluate();
    }

    public void eval(PdVector target, double s, double t) {
        double denum = this.RBaseDenominator(this.m_order, s, t);
        if (this.isZero(denum)) {
            return;
        }
        int i = 0;
        while (i < this.m_controlSurface.getNumVertices()) {
            target.add(this.RBaseNumerator(i, this.m_order, s, t) / denum, this.m_controlSurface.getVertex(i));
            ++i;
        }
    }

    public void eval(int index, double s, double t) {
        int i;
        PdVector actVector;
        double denum = this.RBaseDenominator(this.m_order, s, t);
        double derivDenumX = 0.0;
        double erg = 0.0;
        if (this.m_bIsEvalNormals) {
            this.m_normals.setVector(index, this.getSurfaceUnitNormal(s, t));
        }
        if (this.m_bIsEvalDerivX) {
            actVector = this.m_derivX.getVector(index);
            derivDenumX = this.DRBaseDenominator(this.m_order, s, t, 0);
            actVector.setConstant(0.0);
            int i2 = 0;
            while (i2 < this.m_controlSurface.getNumVertices()) {
                erg = this.DNBase(i2, this.m_order, s, 0) * this.NBase(i2, this.m_order, t, 1) * this.m_controlWeights.getEntry(i2) * denum;
                erg -= this.NBase(i2, this.m_order, s, 0) * this.NBase(i2, this.m_order, t, 1) * this.m_controlWeights.getEntry(i2) * derivDenumX;
                actVector.add(erg /= denum * denum, this.m_controlSurface.getVertex(i2));
                ++i2;
            }
        }
        double derivDenumY = 0.0;
        if (this.m_bIsEvalDerivY) {
            derivDenumY = this.DRBaseDenominator(this.m_order, s, t, 1);
            actVector = this.m_derivY.getVector(index);
            actVector.setConstant(0.0);
            i = 0;
            while (i < this.m_controlSurface.getNumVertices()) {
                erg = this.NBase(i, this.m_order, s, 0) * this.DNBase(i, this.m_order, t, 1) * this.m_controlWeights.getEntry(i) * denum;
                erg -= this.NBase(i, this.m_order, s, 0) * this.NBase(i, this.m_order, t, 1) * this.m_controlWeights.getEntry(i) * derivDenumY;
                actVector.add(erg /= denum * denum, this.m_controlSurface.getVertex(i));
                ++i;
            }
        }
        i = 0;
        while (i < this.getVertex(index).getSize()) {
            this.getVertex((int)index).m_data[i] = 0.0;
            ++i;
        }
        if (this.isZero(denum)) {
            return;
        }
        i = 0;
        while (i < this.m_controlSurface.getNumVertices()) {
            this.getVertex(index).add(this.RBaseNumerator(i, this.m_order, s, t) / denum, this.m_controlSurface.getVertex(i));
            ++i;
        }
    }

    public double evalBaseFunction(int index, double s, double t) {
        double denominator = this.RBaseDenominator(this.m_order, s, t);
        return this.isZero(denominator) ? 0.0 : this.RBaseNumerator(index, this.m_order, s, t) / denominator;
    }

    private double RBaseNumerator(int i, int order, double s, double t) {
        return this.NBase(i, order, s, 0) * this.NBase(i, order, t, 1) * this.m_controlWeights.m_data[i];
    }

    private double RBaseDenominator(int order, double s, double t) {
        double denominator = 0.0;
        int l = 0;
        while (l < this.m_controlSurface.getNumVertices()) {
            denominator += this.NBase(l, order, s, 0) * this.NBase(l, order, t, 1) * this.m_controlWeights.m_data[l];
            ++l;
        }
        return denominator;
    }

    private double NBase(int i, int order, double t, int axis) {
        double part2;
        double part1;
        int rowIndex = i % this.m_numControlRows;
        int colIndex = i / this.m_numControlRows;
        int modulo = 0;
        int j = 0;
        if (axis == 0) {
            modulo = this.m_numControlColumns;
            j = colIndex;
        } else {
            modulo = this.m_numControlRows;
            j = rowIndex;
        }
        if (order == 1) {
            if (this.isClosed(axis) && j >= this.m_knotVector[axis].getSize() - 1) {
                if (t >= this.m_knotVector[axis].m_data[j % modulo] && t < this.m_knotVector[axis].m_data[(j + 1) % modulo]) {
                    return 1.0;
                }
                return 0.0;
            }
            if (this.isZero(t - this.m_knotVector[axis].getLastEntry()) && j == modulo - 1) {
                return 1.0;
            }
            if (t >= this.m_knotVector[axis].m_data[j] && t < this.m_knotVector[axis].m_data[j + 1]) {
                return 1.0;
            }
            return 0.0;
        }
        if (this.isClosed(axis)) {
            double a = t - this.m_knotVector[axis].m_data[j];
            double b = this.m_knotVector[axis].m_data[(j + order - 1) % modulo] - this.m_knotVector[axis].m_data[j % modulo];
            double c = this.m_knotVector[axis].m_data[(j + order) % modulo] - t;
            double d = this.m_knotVector[axis].m_data[(j + order) % modulo] - this.m_knotVector[axis].m_data[(j + 1) % modulo];
            double dist = this.m_knotVector[axis].getLastEntry() - this.m_knotVector[axis].getFirstEntry();
            if (a < 0.0) {
                a += dist;
            }
            if (b < 0.0) {
                b += dist;
            }
            if (c < 0.0) {
                c += dist;
            }
            if (d < 0.0) {
                d += dist;
            }
            rowIndex %= this.m_numControlRows;
            colIndex %= this.m_numControlColumns;
            if (axis == 0) {
                part1 = this.isZero(b) ? 0.0 : a * this.NBase(colIndex * this.m_numControlRows + rowIndex, order - 1, t, axis) / b;
                ++colIndex;
                part2 = this.isZero(d) ? 0.0 : c * this.NBase((colIndex %= this.m_numControlColumns) * this.m_numControlRows + rowIndex, order - 1, t, axis) / d;
            } else {
                part1 = this.isZero(b) ? 0.0 : a * this.NBase(colIndex * this.m_numControlRows + rowIndex, order - 1, t, axis) / b;
                ++rowIndex;
                part2 = this.isZero(d) ? 0.0 : c * this.NBase(colIndex * this.m_numControlRows + (rowIndex %= this.m_numControlRows), order - 1, t, axis) / d;
            }
        } else {
            double a = t - this.m_knotVector[axis].m_data[j];
            double b = this.m_knotVector[axis].m_data[j + order - 1] - this.m_knotVector[axis].m_data[j];
            double c = this.m_knotVector[axis].m_data[j + order] - t;
            double d = this.m_knotVector[axis].m_data[j + order] - this.m_knotVector[axis].m_data[j + 1];
            double d2 = part1 = this.isZero(b) ? 0.0 : a * this.NBase(i, order - 1, t, axis) / b;
            part2 = axis == 0 ? (this.isZero(d) ? 0.0 : c * this.NBase(i + this.m_numControlRows, order - 1, t, axis) / d) : (this.isZero(d) ? 0.0 : c * this.NBase(i + 1, order - 1, t, axis) / d);
        }
        return part1 + part2;
    }

    public void reevaluate() {
        if (this.getNumVertices() == 0) {
            return;
        }
        if (this.m_bIsEvalDerivX && this.m_derivX.getNumVectors() != this.getNumVertices()) {
            this.m_derivX.setNumVectors(this.getNumVertices());
        }
        if (this.m_bIsEvalDerivY && this.m_derivY.getNumVectors() != this.getNumVertices()) {
            this.m_derivY.setNumVectors(this.getNumVertices());
        }
        if (this.m_bIsEvalNormals && this.m_normals.getNumVectors() != this.getNumVertices()) {
            this.m_normals.setNumVectors(this.getNumVertices());
        }
        if (this.m_bIsEvalDerivXX && this.m_derivXX.getNumVectors() != this.getNumVertices()) {
            this.m_derivXX.setNumVectors(this.getNumVertices());
        }
        if (this.m_bIsEvalDerivXY && this.m_derivXY.getNumVectors() != this.getNumVertices()) {
            this.m_derivXY.setNumVectors(this.getNumVertices());
        }
        if (this.m_bIsEvalDerivYY && this.m_derivYY.getNumVectors() != this.getNumVertices()) {
            this.m_derivYY.setNumVectors(this.getNumVertices());
        }
        PdVector[] vertices = this.getVertices();
        int indexOffset = 0;
        if (this.m_bMemSpeedUp) {
            PdVector[] controlVertices = this.m_controlSurface.getVertices();
            int i = 0;
            while (i < this.m_detail_X) {
                int j = 0;
                while (j < this.m_detail_Y) {
                    indexOffset = i * this.m_detail_Y + j;
                    int k = 0;
                    while (k < vertices[indexOffset].getSize()) {
                        vertices[indexOffset].m_data[k] = 0.0;
                        ++k;
                    }
                    k = 0;
                    while (k < this.m_controlSurface.getNumVertices()) {
                        vertices[indexOffset].add(this.m_RBaseSave[indexOffset][k], controlVertices[k]);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            double last_x = this.m_knotVector[0].getLastEntry();
            double last_y = this.m_knotVector[1].getLastEntry();
            double s = this.m_knotVector[0].getFirstEntry();
            double t = this.m_knotVector[1].getFirstEntry();
            double delta_s = (last_x - s) / (double)(this.m_detail_X - 1);
            double delta_t = (last_y - t) / (double)(this.m_detail_Y - 1);
            int j = 0;
            while (j < this.m_detail_X) {
                t = this.m_knotVector[1].getFirstEntry();
                int i = 0;
                while (i < this.m_detail_Y) {
                    this.eval(j * this.m_detail_Y + i, s, t);
                    t += delta_t;
                    if (t >= last_y) {
                        t = last_y - 1.0E-10;
                    }
                    ++i;
                }
                if ((s += delta_s) >= last_x) {
                    s = last_x - 1.0E-10;
                }
                ++j;
            }
        }
    }

    private boolean isZero(double aNumber) {
        return Math.abs(aNumber) < 1.0E-10;
    }

    public boolean update(Object event) {
        if (event == this.m_controlSurface) {
            if (this.m_numControlColumns < this.m_order || this.m_numControlRows < this.m_order) {
                this.setNumVertices(0);
            } else if (this.getNumVertices() == 0) {
                this.setNumVertices(this.m_detail_Y * this.m_detail_X);
            }
            if (this.m_controlSurface.getNumElements() != (this.m_numControlRows - (this.isClosedY() ? 0 : 1)) * (this.m_numControlColumns - (this.isClosedX() ? 0 : 1))) {
                this.initControlSurfaceFaces();
            }
            if (this.getNumElements() != (this.m_detail_X - (this.isClosedX() ? 0 : 1)) * (this.m_detail_Y - (this.isClosedY() ? 0 : 1))) {
                this.initFaces();
            }
            if (this.m_bMemSpeedUp && (this.getNumVertices() != this.m_RBaseSave.length || this.m_RBaseSave.length > 0 && this.m_controlSurface.getNumVertices() != this.m_RBaseSave[0].length)) {
                this.calcBaseFunctions();
            }
            this.repairKnotVector();
            this.repairWeightVector();
            this.reevaluate();
            return this.update((Object)this);
        }
        return super.update(event);
    }

    private boolean isClosed(int axis) {
        if (axis == 0 && this.isClosedX()) {
            return true;
        }
        return axis == 1 && this.isClosedY();
    }

    /*
     * Unable to fully structure code
     */
    public boolean setControlVertices(PdVector[] vertices, int rows, int columns) {
        if (vertices.length != rows * columns) {
            return false;
        }
        if (vertices[0].getSize() != 3) {
            return false;
        }
        if (rows + this.m_order < this.m_knotVector[1].getSize()) {
            return false;
        }
        if (columns + this.m_order >= this.m_knotVector[0].getSize()) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            this.addControlPointRow();
lbl11:
            // 2 sources

            ** while (rows > this.m_numControlRows)
        }
lbl12:
        // 2 sources

        while (rows < this.m_numControlRows) {
            this.removeControlPointRow();
        }
        while (columns > this.m_numControlColumns) {
            this.addControlPointColumn();
        }
        while (columns < this.m_numControlColumns) {
            this.removeControlPointColumn();
        }
        n = this.m_controlWeights.getSize();
        if (n < rows * columns) {
            this.m_controlWeights.setSize(rows * columns);
            i = n;
            while (i < this.m_controlWeights.getSize()) {
                this.m_controlWeights.setEntry(i, 1.0);
                ++i;
            }
        } else {
            this.m_controlWeights.setSize(rows * columns);
        }
        this.m_controlSurface.setNumVertices(rows * columns);
        this.m_controlSurface.setVertices(vertices);
        this.m_controlSurface.update((Object)this.m_controlSurface);
        return true;
    }

    public int addVertex(PdVector vec) {
        return -1;
    }

    public int addElement(PiVector vec) {
        return -1;
    }

    public int[] removeElement(int numOfElement) {
        return null;
    }

    public int[] removeVertex(int numOfVertex) {
        return null;
    }

    public boolean isClosedX() {
        return this.m_bIsClosedX;
    }

    public void setClosedX(boolean isClosed) {
        this.m_bIsClosedX = isClosed;
        this.initKnotVector();
        this.initFaces();
        this.initControlSurfaceFaces();
    }

    public boolean isClosedY() {
        return this.m_bIsClosedY;
    }

    public void setClosedY(boolean isClosed) {
        this.m_bIsClosedY = isClosed;
        this.initKnotVector();
        this.initFaces();
        this.initControlSurfaceFaces();
    }

    protected void calcBaseFunctions() {
        this.m_RBaseSave = new double[this.getNumVertices()][this.m_controlSurface.getNumVertices()];
        double last_x = this.m_knotVector[0].getLastEntry();
        double last_y = this.m_knotVector[1].getLastEntry();
        double s = this.m_knotVector[0].getFirstEntry();
        double t = this.m_knotVector[1].getFirstEntry();
        double delta_s = (last_x - s) / (double)(this.m_detail_X - 1);
        double delta_t = (last_y - t) / (double)(this.m_detail_Y - 1);
        int j = 0;
        while (j < this.m_detail_X) {
            t = this.m_knotVector[1].getFirstEntry();
            int i = 0;
            while (i < this.m_detail_Y) {
                int k;
                double denominator = this.RBaseDenominator(this.m_order, s, t);
                if (this.isZero(denominator)) {
                    k = 0;
                    while (k < this.m_controlSurface.getNumVertices()) {
                        this.m_RBaseSave[j * this.m_detail_Y + i][k] = 0.0;
                        ++k;
                    }
                } else {
                    k = 0;
                    while (k < this.m_controlSurface.getNumVertices()) {
                        this.m_RBaseSave[j * this.m_detail_Y + i][k] = this.RBaseNumerator(k, this.m_order, s, t) / denominator;
                        ++k;
                    }
                }
                t += delta_t;
                if (t >= last_y) {
                    t = last_y - 1.0E-10;
                }
                ++i;
            }
            if ((s += delta_s) >= last_x) {
                s = last_x - 1.0E-10;
            }
            ++j;
        }
    }

    public boolean isUsingMemSpeedup() {
        return this.m_bMemSpeedUp;
    }

    public void useMemSpeedup(boolean useMemSpeedUp) {
        this.m_bMemSpeedUp = useMemSpeedUp;
        if (useMemSpeedUp) {
            this.calcBaseFunctions();
        }
    }

    protected void repairKnotVector() {
        if (this.m_numControlColumns + (this.isClosedX() ? 1 : this.m_order) != this.m_knotVector[0].getSize() || this.m_numControlRows + (this.isClosedY() ? 1 : this.m_order) != this.m_knotVector[1].getSize()) {
            this.initKnotVector();
        }
    }

    protected void repairWeightVector() {
        if (this.m_controlWeights.getSize() != this.m_controlSurface.getNumVertices()) {
            int maxNumWeights = this.m_controlWeights.getSize();
            int maxNumControlPoints = this.m_controlSurface.getNumVertices();
            int i = 0;
            PdVector newWeights = new PdVector(maxNumControlPoints);
            while (i < maxNumWeights && i < maxNumControlPoints) {
                newWeights.m_data[i] = this.m_controlWeights.m_data[i];
                ++i;
            }
            while (i < maxNumControlPoints) {
                newWeights.m_data[i] = 1.0;
                ++i;
            }
            this.setWeights(newWeights);
        }
    }

    public void setDetail(int xDetail, int yDetail) {
        if (xDetail <= 4) {
            xDetail = 4;
        }
        if (yDetail <= 4) {
            yDetail = 4;
        }
        this.m_detail_X = xDetail;
        this.m_detail_Y = yDetail;
        this.setNumVertices(xDetail * yDetail);
        this.initFaces();
        this.update(this.m_controlSurface);
    }

    public int getDetailX() {
        return this.m_detail_X;
    }

    public int getDetailY() {
        return this.m_detail_Y;
    }

    public PgElementSet getControlSurface() {
        return this.m_controlSurface;
    }

    public int getNumControlPoints() {
        return this.m_controlSurface.getNumVertices();
    }

    public void setNumControlRows(int aInteger) {
        if (aInteger < 0) {
            aInteger = 0;
        }
        this.m_numControlRows = aInteger;
    }

    public void setNumControlColumns(int aInteger) {
        if (aInteger < 0) {
            aInteger = 0;
        }
        this.m_numControlColumns = aInteger;
    }

    public PdVector getControlWeights() {
        return this.m_controlWeights;
    }

    public PdVector[] getControlPoints() {
        return this.m_controlSurface.getVertices();
    }

    public PdVector[] getKnotVector() {
        return this.m_knotVector;
    }

    public int getOrder() {
        return this.m_order;
    }

    public boolean setOrder(int aOrder) {
        if (aOrder < 1 || aOrder > 6) {
            PsDebug.warning((String)"Entered order is to small/big. Only 1,...,6 are allowed!");
            return false;
        }
        if (this.m_numControlColumns < aOrder || this.m_numControlRows < aOrder) {
            PsDebug.warning((String)("Supporting control surface is too small. Must have at least " + aOrder + " control point rows/columns."));
            return false;
        }
        this.m_order = aOrder;
        this.initKnotVector();
        this.m_controlSurface.update((Object)this.m_controlSurface);
        return true;
    }

    public int getNumControlColumns() {
        return this.m_numControlColumns;
    }

    public int getNumControlRows() {
        return this.m_numControlRows;
    }

    public PdVector DSurface(double s, double t, int axis) {
        PdVector erg = new PdVector(3);
        erg.setConstant(0.0);
        int i = 0;
        while (i < this.m_numControlColumns * this.m_numControlRows) {
            double tmp = this.DRBase(s, t, axis, i);
            erg.add(tmp, this.m_controlSurface.getVertex(i));
            ++i;
        }
        return erg;
    }

    public PdVector getSurfaceUnitNormal(double s, double t) {
        PdVector ds = this.DSurface(s, t, 0);
        PdVector dt = this.DSurface(s, t, 1);
        PdVector result = PdVector.crossNew((PdVector)ds, (PdVector)dt);
        System.out.println("result_length " + result.length() + " ds: " + ds.length() + " dt: " + dt.length());
        if (result.length() != 0.0) {
            result.multScalar(1.0 / result.length());
        }
        return result;
    }

    public PdVector getSurfaceNormal(double s, double t) {
        return PdVector.crossNew((PdVector)this.DSurface(s, t, 0), (PdVector)this.DSurface(s, t, 1));
    }

    public double DRBase(double s, double t, int axis, int index) {
        double Ddenum;
        double erg = 0.0;
        double denum = this.RBaseDenominator(this.m_order, s, t);
        if (axis == 0) {
            Ddenum = this.DRBaseDenominator(this.m_order, s, t, axis);
            erg = this.DNBase(index, this.m_order, s, 0) * denum;
            erg -= this.NBase(index, this.m_order, s, 0) * Ddenum;
            erg *= this.NBase(index, this.m_order, t, 1) * this.m_controlWeights.getEntry(index);
            erg /= denum * denum;
        }
        if (axis == 1) {
            erg = 0.0;
            Ddenum = this.DRBaseDenominator(this.m_order, s, t, axis);
            erg = this.DNBase(index, this.m_order, t, 1) * denum;
            erg -= this.NBase(index, this.m_order, t, 1) * Ddenum;
            erg *= this.NBase(index, this.m_order, s, 0) * this.m_controlWeights.getEntry(index);
            erg /= denum * denum;
        }
        return erg;
    }

    public double DRBaseNumerator(double s, double t, int axis, int index) {
        double erg = 0.0;
        if (axis == 0) {
            erg = this.DNBase(index, this.m_order, s, 0) * this.NBase(index, this.m_order, t, 1) * this.m_controlWeights.m_data[index];
        }
        if (axis == 1) {
            erg = this.NBase(index, this.m_order, s, 0) * this.DNBase(index, this.m_order, t, 1) * this.m_controlWeights.m_data[index];
        }
        return erg;
    }

    public double DRBaseDenominator(int order, double s, double t, int axis) {
        int i;
        double erg = 0.0;
        if (axis == 0) {
            i = 0;
            while (i < this.m_controlSurface.getNumVertices()) {
                erg += this.DNBase(i, this.m_order, s, 0) * this.NBase(i, this.m_order, t, 1) * this.m_controlWeights.getEntry(i);
                ++i;
            }
        }
        if (axis == 1) {
            i = 0;
            while (i < this.m_controlSurface.getNumVertices()) {
                erg += this.NBase(i, this.m_order, s, 0) * this.DNBase(i, this.m_order, t, 1) * this.m_controlWeights.getEntry(i);
                ++i;
            }
        }
        return erg;
    }

    public double DNBase(int index, int order, double s, int axis) {
        double erg = 0.0;
        int i = 0;
        if (axis == 0) {
            i = index / this.m_numControlRows;
        }
        if (axis == 1) {
            i = index % this.m_numControlRows;
        }
        if (order == 1) {
            return 0.0;
        }
        int shift = axis == 0 ? this.m_numControlRows : 1;
        double a1 = this.NBase(index, order - 1, s, axis) / (this.m_knotVector[axis].getEntry(i + order - 1) - this.m_knotVector[axis].getEntry(i));
        double a2 = this.DNBase(index, order - 1, s, axis) * (s - this.m_knotVector[axis].getEntry(i)) / (this.m_knotVector[axis].getEntry(i + order - 1) - this.m_knotVector[axis].getEntry(i));
        double b1 = -1.0 * this.NBase(index + shift, order - 1, s, axis) / (this.m_knotVector[axis].getEntry(i + order) - this.m_knotVector[axis].getEntry(i + 1));
        double b2 = this.DNBase(index + shift, order - 1, s, axis) * (this.m_knotVector[axis].getEntry(i + order) - s) / (this.m_knotVector[axis].getEntry(i + order) - this.m_knotVector[axis].getEntry(i + 1));
        if (Double.isInfinite(a1) || Double.isNaN(a1)) {
            a1 = 0.0;
        }
        if (Double.isInfinite(a2) || Double.isNaN(a2)) {
            a2 = 0.0;
        }
        if (Double.isInfinite(b1) || Double.isNaN(b1)) {
            b1 = 0.0;
        }
        if (Double.isInfinite(b2) || Double.isNaN(b2)) {
            b2 = 0.0;
        }
        erg = a1 + a2 + b1 + b2;
        return erg;
    }

    public void switchEvalNormals(boolean on_off) {
        this.m_bIsEvalNormals = on_off;
        if (on_off) {
            this.addVectorField(this.m_normals);
        } else {
            this.removeVectorField((PgGeometryIf)this.m_normals);
        }
        this.reevaluate();
        this.update((Object)this);
    }

    public void switchEvalDerivatives(int axis1, int axis2, boolean on_off) {
        if (axis2 == -1) {
            if (axis1 == 0) {
                this.m_bIsEvalDerivX = on_off;
                if (on_off) {
                    this.addVectorField(this.m_derivX);
                } else {
                    this.removeVectorField((PgGeometryIf)this.m_derivX);
                }
            }
            if (axis1 == 1) {
                this.m_bIsEvalDerivY = on_off;
                if (on_off) {
                    this.addVectorField(this.m_derivY);
                } else {
                    this.removeVectorField((PgGeometryIf)this.m_derivY);
                }
            }
        } else if (axis2 == 0) {
            if (axis1 == 0) {
                this.m_bIsEvalDerivXX = on_off;
                if (on_off) {
                    this.addVectorField(this.m_derivXX);
                } else {
                    this.removeVectorField((PgGeometryIf)this.m_derivXX);
                }
            }
            if (axis1 == 1) {
                this.m_bIsEvalDerivXY = on_off;
                if (on_off) {
                    this.addVectorField(this.m_derivXY);
                } else {
                    this.removeVectorField((PgGeometryIf)this.m_derivXY);
                }
            }
        } else {
            if (axis1 == 0) {
                this.m_bIsEvalDerivXY = on_off;
                if (on_off) {
                    this.addVectorField(this.m_derivXY);
                } else {
                    this.removeVectorField((PgGeometryIf)this.m_derivXY);
                }
            }
            if (axis1 == 1) {
                this.m_bIsEvalDerivYY = on_off;
                if (on_off) {
                    this.addVectorField(this.m_derivYY);
                } else {
                    this.removeVectorField((PgGeometryIf)this.m_derivYY);
                }
            }
        }
        this.reevaluate();
        this.update((Object)this);
    }
}

