/*
 * Decompiled with CFR 0.152.
 */
package devNurbs.solids;

import devNurbs.solids.PgNurbsSolids;
import java.awt.Color;
import jv.loader.PgLoader;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jvx.volume.PgCubeSet;

public class PjNurbsSolids
extends PjProject {
    private static final long serialVersionUID = 8358996733148340471L;
    protected PgNurbsSolids m_pSurface;
    protected PgCubeSet m_controlVolume;

    public PjNurbsSolids() {
        super("Nurbs Project");
        if (((Object)((Object)this)).getClass() == PjNurbsSolids.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_pSurface = new PgNurbsSolids(3);
        this.m_controlVolume = this.m_pSurface.getControlVolume();
        this.assureInspector("Info", "_IP");
    }

    public void setDisplay(PvDisplayIf disp) {
        super.setDisplay(disp);
    }

    public void initGeometry() {
        this.addGeometry((PgGeometryIf)this.m_pSurface);
        this.addGeometry((PgGeometryIf)this.m_controlVolume);
        this.selectGeometry((PgGeometryIf)this.m_controlVolume);
        this.getDisplay().getCamera().setInterest(new PdVector(0.0, 0.0, 0.0));
        this.getDisplay().setBackgroundColor(new Color(90, 90, 90));
        if (this.m_pSurface.getDimOfVertices() == 2) {
            this.getDisplay().selectCamera(1);
        }
        this.m_pSurface.update((Object)this.m_pSurface);
    }

    public void loadGeometry(String filename) {
        PgGeometry[] geomNew = new PgLoader().loadGeometry(null, filename);
        if (geomNew == null || geomNew.length == 0 || geomNew[0] == null) {
            PsDebug.warning((String)("loading failed, file = " + filename));
            return;
        }
        if (geomNew.length > 1) {
            PsDebug.warning((String)("only first geometry used, found = " + geomNew.length));
        }
    }

    public boolean setGeometry(PgNurbsSolids surfaceNew) {
        if (this.m_pSurface != null) {
            this.removeGeometry((PgGeometryIf)this.m_pSurface);
        }
        this.m_pSurface = surfaceNew;
        this.addGeometry((PgGeometryIf)this.m_pSurface);
        this.selectGeometry((PgGeometryIf)this.m_pSurface);
        return true;
    }
}

