/*
 * Decompiled with CFR 0.152.
 */
package devNurbs.solids;

import devNurbs.solids.PgNurbsSolids;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jvx.volume.PgCubeSet;

public class PgNurbsSolids_CP
extends PsPanel
implements ActionListener,
PsUpdateIf,
ItemListener {
    private static final long serialVersionUID = 1907431560280736851L;
    protected PgNurbsSolids m_volume;
    protected PgCubeSet m_controlVolume;
    protected TextField m_tName;
    protected TextField m_tNumVertices2;
    protected TextField[] m_tOrder;
    protected TextField[][] m_TextFields;
    protected Label[][] m_Labels;
    protected Panel m_pDetail;
    protected Panel[] m_pTextFieldPanels;
    protected Panel[] m_pLabelPanels;
    protected Checkbox m_CBcloseVolume_X;
    protected Checkbox m_CBcloseVolume_Y;
    protected Checkbox m_CBcloseVolume_Z;
    protected Button m_bAddRow;
    protected Button m_bAddColumn;
    protected Button m_bAddLevel;
    protected Button m_bRemoveRow;
    protected Button m_bRemoveColumn;
    protected Button m_bRemoveLevel;
    protected PuInteger m_detail_x = new PuInteger("Detail_X", (PsUpdateIf)this);
    protected PuInteger m_detail_y;
    protected PuInteger m_detail_z;
    protected PuInteger[] m_Scroller;
    protected Checkbox m_CBshowWeights;
    protected Checkbox m_CBmemSpeedup;
    private int lastNumVertices = 0;
    private final int INDEX_WEIGHTVECTOR = 3;

    public PgNurbsSolids_CP() {
        this.m_detail_x.setDefBounds(4, 500, 1, 10);
        this.m_detail_x.setDefValue(10);
        this.m_detail_x.init();
        this.m_detail_y = new PuInteger("Detail_Y", (PsUpdateIf)this);
        this.m_detail_y.setDefBounds(4, 500, 1, 10);
        this.m_detail_y.setDefValue(10);
        this.m_detail_y.init();
        this.m_detail_z = new PuInteger("Detail_Z", (PsUpdateIf)this);
        this.m_detail_z.setDefBounds(4, 500, 1, 10);
        this.m_detail_z.setDefValue(10);
        this.m_detail_z.init();
        this.m_pLabelPanels = new Panel[4];
        this.m_pTextFieldPanels = new Panel[4];
        this.m_TextFields = new TextField[4][];
        this.m_Labels = new Label[4][];
        this.m_tOrder = new TextField[3];
        this.m_Scroller = new PuInteger[4];
        int i = 0;
        while (i < this.m_Scroller.length) {
            this.m_Scroller[i] = new PuInteger(" ", (PsUpdateIf)this);
            this.m_Scroller[i].setDefBounds(0, 1, 1, 1);
            this.m_Scroller[i].setDefValue(0);
            this.m_Scroller[i].init();
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.m_tOrder[i] = new TextField(4);
            this.m_tOrder[i].setText("2");
            this.m_tOrder[i].addActionListener(this);
            ++i;
        }
        this.m_bAddColumn = new Button("Add Column");
        this.m_bAddColumn.addActionListener(this);
        this.m_bAddRow = new Button("Add Row");
        this.m_bAddRow.addActionListener(this);
        this.m_bAddLevel = new Button("Add Level");
        this.m_bAddLevel.addActionListener(this);
        this.m_bRemoveColumn = new Button("Remove Column");
        this.m_bRemoveColumn.addActionListener(this);
        this.m_bRemoveRow = new Button("Remove Row");
        this.m_bRemoveRow.addActionListener(this);
        this.m_bRemoveLevel = new Button("Remove Level");
        this.m_bRemoveLevel.addActionListener(this);
        this.m_CBshowWeights = new Checkbox("show Weights");
        this.m_CBshowWeights.addItemListener(this);
        this.m_CBshowWeights.setState(true);
        this.m_CBmemSpeedup = new Checkbox("Memory SpeedUp");
        this.m_CBmemSpeedup.addItemListener(this);
        this.m_CBmemSpeedup.setState(true);
        this.m_CBcloseVolume_X = new Checkbox("close X");
        this.m_CBcloseVolume_X.addItemListener(this);
        this.m_CBcloseVolume_X.setState(false);
        this.m_CBcloseVolume_Y = new Checkbox("close Y");
        this.m_CBcloseVolume_Y.addItemListener(this);
        this.m_CBcloseVolume_Y.setState(false);
        this.m_CBcloseVolume_Z = new Checkbox("close Z");
        this.m_CBcloseVolume_Z.addItemListener(this);
        this.m_CBcloseVolume_Z.setState(false);
        this.m_tNumVertices2 = new TextField("", 7);
        this.m_tNumVertices2.addActionListener(this);
        this.m_tNumVertices2.setEnabled(false);
        if (this.getClass() == PgNurbsSolids_CP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setInsetSize(4);
        this.setBorderType(1);
        Panel pOrderPanel = new Panel(new GridLayout(2, 3));
        pOrderPanel.add(new Label("Order X"));
        pOrderPanel.add(new Label("Order Y"));
        pOrderPanel.add(new Label("Order Z"));
        int i = 0;
        while (i < 3) {
            pOrderPanel.add(this.m_tOrder[i]);
            ++i;
        }
        this.add(pOrderPanel);
        Panel pButtons = new Panel(new GridLayout(2, 3));
        this.add(pButtons);
        pButtons.add(this.m_bAddColumn);
        pButtons.add(this.m_bAddRow);
        pButtons.add(this.m_bAddLevel);
        pButtons.add(this.m_bRemoveColumn);
        pButtons.add(this.m_bRemoveRow);
        pButtons.add(this.m_bRemoveLevel);
        this.addLine(1);
        Panel pCheckboxes = new Panel(new GridLayout(1, 2));
        this.add(pCheckboxes);
        pCheckboxes.add(this.m_CBshowWeights);
        pCheckboxes.add(this.m_CBmemSpeedup);
        Panel pCheckboxes2 = new Panel(new GridLayout(1, 3));
        this.add(pCheckboxes2);
        pCheckboxes2.add(this.m_CBcloseVolume_X);
        pCheckboxes2.add(this.m_CBcloseVolume_Y);
        pCheckboxes2.add(this.m_CBcloseVolume_Z);
        this.addLine(1);
        Panel weightsPanel = new Panel(new GridLayout(4, 1));
        this.add(weightsPanel);
        int i2 = 0;
        while (i2 < this.m_pTextFieldPanels.length) {
            this.m_pTextFieldPanels[i2] = new Panel(new GridLayout(1, 5));
            this.m_pLabelPanels[i2] = new Panel(new GridLayout(1, 5));
            ++i2;
        }
        weightsPanel.add(new Label("Weights"));
        weightsPanel.add(this.m_pLabelPanels[3]);
        weightsPanel.add(this.m_pTextFieldPanels[3]);
        weightsPanel.add((Component)this.m_Scroller[3].assureInspector("Info", "_IP"));
        this.addLine(1);
        Panel knotsPanel = new Panel(new GridLayout(4, 1));
        this.add(knotsPanel);
        knotsPanel.add(new Label("Knots (x-Axis)"));
        knotsPanel.add(this.m_pLabelPanels[0]);
        knotsPanel.add(this.m_pTextFieldPanels[0]);
        knotsPanel.add((Component)this.m_Scroller[0].assureInspector("Info", "_IP"));
        this.addLine(1);
        Panel knotsPanel2 = new Panel(new GridLayout(4, 1));
        this.add(knotsPanel2);
        knotsPanel2.add(new Label("Knots (y-Axis)"));
        knotsPanel2.add(this.m_pLabelPanels[1]);
        knotsPanel2.add(this.m_pTextFieldPanels[1]);
        knotsPanel2.add((Component)this.m_Scroller[1].assureInspector("Info", "_IP"));
        Panel knotsPanel3 = new Panel(new GridLayout(4, 1));
        this.add(knotsPanel3);
        knotsPanel3.add(new Label("Knots (z-Axis)"));
        knotsPanel3.add(this.m_pLabelPanels[2]);
        knotsPanel3.add(this.m_pTextFieldPanels[2]);
        knotsPanel3.add((Component)this.m_Scroller[2].assureInspector("Info", "_IP"));
        this.addLine(1);
        this.m_pDetail = new PsPanel((LayoutManager)new GridLayout(3, 1));
        this.add(this.m_pDetail);
        this.m_pDetail.add((Component)this.m_detail_x.assureInspector("Info", "_IP"));
        this.m_pDetail.add((Component)this.m_detail_y.assureInspector("Info", "_IP"));
        this.m_pDetail.add((Component)this.m_detail_z.assureInspector("Info", "_IP"));
        this.addLine(1);
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_volume = (PgNurbsSolids)parent;
        this.m_controlVolume = this.m_volume.getControlVolume();
        this.m_volume.initKnotVector();
        int n = this.m_controlVolume.getNumVertices();
        this.m_tNumVertices2.setText(String.valueOf(n));
        this.m_Scroller[3].setBounds(0, n > 5 ? n - 5 : 0);
        this.m_Scroller[3].setDefBounds(0, n > 5 ? n - 5 : 0, 1, 1);
        this.m_Scroller[3].init();
        int i = 0;
        while (i < 3) {
            n = this.m_volume.m_knotVector[i].getSize();
            this.m_Scroller[i].setBounds(0, n > 5 ? n - 5 : 0);
            this.m_Scroller[i].setDefBounds(0, n > 5 ? n - 5 : 0, 1, 1);
            this.m_Scroller[i].init();
            ++i;
        }
        this.initPanels();
        this.add((Component)this.m_volume.assureInspector("Info", "_IP"));
    }

    private void initPanels() {
        int columns;
        int i = 0;
        while (i < this.m_pTextFieldPanels.length) {
            this.m_pTextFieldPanels[i].removeAll();
            this.m_pLabelPanels[i].removeAll();
            ++i;
        }
        int raws = this.m_volume.getNumControlRows();
        int n = raws * (columns = this.m_volume.getNumControlColumns());
        this.m_TextFields[3] = new TextField[n > 5 ? 5 : n];
        this.m_Labels[3] = new Label[this.m_TextFields[3].length];
        int i2 = 0;
        while (i2 < this.m_TextFields[3].length) {
            this.m_Labels[3][i2] = new Label("[" + Integer.toString(i2) + "]");
            this.m_pLabelPanels[3].add(this.m_Labels[3][i2]);
            this.m_TextFields[3][i2] = new TextField(5);
            this.m_TextFields[3][i2].addActionListener(this);
            if (this.m_volume != null) {
                this.m_TextFields[3][i2].setText(String.valueOf(this.m_volume.m_controlPointWeights.m_data[i2]));
            }
            this.m_pTextFieldPanels[3].add(this.m_TextFields[3][i2]);
            ++i2;
        }
        this.m_volume.initKnotVector();
        i2 = 0;
        while (i2 < 3) {
            this.m_TextFields[i2] = new TextField[this.m_volume.m_knotVector[i2].getSize() > 5 ? 5 : this.m_volume.m_knotVector[i2].getSize()];
            this.m_Labels[i2] = new Label[this.m_TextFields[i2].length];
            int j = 0;
            while (j < this.m_TextFields[i2].length) {
                this.m_Labels[i2][j] = new Label("[" + Integer.toString(j) + "]");
                this.m_pLabelPanels[i2].add(this.m_Labels[i2][j]);
                this.m_TextFields[i2][j] = new TextField(5);
                this.m_TextFields[i2][j].addActionListener(this);
                if (this.m_volume != null) {
                    this.m_TextFields[i2][j].setText(String.valueOf(this.m_volume.m_knotVector[i2].getEntry(j)));
                }
                this.m_pTextFieldPanels[i2].add(this.m_TextFields[i2][j]);
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_pTextFieldPanels.length) {
            this.m_pTextFieldPanels[i2].validate();
            this.m_pLabelPanels[i2].validate();
            ++i2;
        }
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        Object source = aEvent.getSource();
        if (source == this.m_bRemoveColumn) {
            this.m_volume.removeControlPointColumns();
        } else if (source == this.m_bRemoveRow) {
            this.m_volume.removeControlPointRows();
        } else if (source == this.m_bAddColumn) {
            this.m_volume.addControlPointColumns();
        } else if (source == this.m_bAddRow) {
            this.m_volume.addControlPointRows();
        } else if (source == this.m_bAddLevel) {
            this.m_volume.addControlPointLevel();
        } else if (source == this.m_bRemoveLevel) {
            this.m_volume.removeControlPointLevel();
        } else if (source == this.m_tOrder[0]) {
            int aNumber = 0;
            try {
                aNumber = Integer.parseInt(this.m_tOrder[0].getText());
                this.m_volume.setOrder(aNumber, 0);
            }
            catch (NumberFormatException aException) {
                PsDebug.warning((String)"Only integer numbers between 2 and 6 are allowed");
            }
        } else if (source == this.m_tOrder[1]) {
            int aNumber = 0;
            try {
                aNumber = Integer.parseInt(this.m_tOrder[1].getText());
                this.m_volume.setOrder(aNumber, 1);
            }
            catch (NumberFormatException aException) {
                PsDebug.warning((String)"Only integer numbers between 2 and 6 are allowed");
            }
        } else if (source == this.m_tOrder[2]) {
            int aNumber = 0;
            try {
                aNumber = Integer.parseInt(this.m_tOrder[2].getText());
                this.m_volume.setOrder(aNumber, 2);
            }
            catch (NumberFormatException aException) {
                PsDebug.warning((String)"Only integer numbers between 2 and 6 are allowed.");
            }
        } else {
            int j = 0;
            while (j < this.m_TextFields[3].length) {
                if (source == this.m_TextFields[3][j]) {
                    this.getWeightValues();
                    break;
                }
                ++j;
            }
            int i = 0;
            while (i < 3) {
                int j2 = 0;
                while (j2 < this.m_TextFields[i].length) {
                    if (source == this.m_TextFields[i][j2]) {
                        this.getKnotValues();
                        break;
                    }
                    ++j2;
                }
                ++i;
            }
        }
        if (this.m_volume.m_bMemSpeedUp) {
            this.m_volume.calcBaseFunctions();
        }
        this.showWeights(this.isShowingWeights());
        this.m_controlVolume.update((Object)this.m_controlVolume);
    }

    public boolean update(Object event) {
        if (event == this.m_detail_x) {
            this.m_volume.setDetail(this.m_detail_x.getValue(), this.m_detail_y.getValue(), this.m_detail_z.getValue());
            return true;
        }
        if (event == this.m_detail_y) {
            this.m_volume.setDetail(this.m_detail_x.getValue(), this.m_detail_y.getValue(), this.m_detail_z.getValue());
            return true;
        }
        if (event == this.m_detail_z) {
            this.m_volume.setDetail(this.m_detail_x.getValue(), this.m_detail_y.getValue(), this.m_detail_z.getValue());
            return true;
        }
        if (event == this.m_volume) {
            if (this.m_volume.getNumControlPoints() != this.lastNumVertices) {
                if (this.m_volume.getNumControlPoints() <= 5) {
                    this.initPanels();
                } else {
                    this.setWeights();
                    this.setKnots();
                }
                int i = 0;
                while (i < 3) {
                    this.m_Scroller[i].setDefBounds(0, this.m_volume.m_knotVector[i].getSize() > 5 ? this.m_volume.m_knotVector[i].getSize() - 5 : 0, 1, 1);
                    ++i;
                }
                this.m_Scroller[3].setDefBounds(0, this.m_controlVolume.getNumVertices() > 5 ? this.m_controlVolume.getNumVertices() - 5 : 0, 1, 1);
                i = 0;
                while (i < this.m_Scroller.length) {
                    this.m_Scroller[i].init();
                    ++i;
                }
                this.m_tNumVertices2.setText(String.valueOf(this.m_controlVolume.getNumVertices()));
            }
            this.lastNumVertices = this.m_volume.getNumControlPoints();
            this.showWeights(this.isShowingWeights());
            return true;
        }
        if (event == this.m_Scroller[3]) {
            this.setWeights();
            return true;
        }
        if (event == this.m_Scroller[0]) {
            this.setKnots();
            return true;
        }
        if (event == this.m_Scroller[1]) {
            this.setKnots();
            return true;
        }
        if (event == this.m_Scroller[2]) {
            this.setKnots();
            return true;
        }
        return super.update(event);
    }

    public boolean isShowingWeights() {
        return this.m_CBshowWeights.getState();
    }

    @Override
    public void itemStateChanged(ItemEvent aEvent) {
        Object source = aEvent.getSource();
        if (source == this.m_CBshowWeights) {
            this.showWeights(this.isShowingWeights());
            this.m_controlVolume.update((Object)this.m_controlVolume);
        } else if (source == this.m_CBmemSpeedup) {
            this.m_volume.m_bMemSpeedUp = this.m_CBmemSpeedup.getState();
            if (this.m_volume.m_bMemSpeedUp) {
                this.m_volume.calcBaseFunctions();
            }
        } else if (source == this.m_CBcloseVolume_X) {
            this.m_volume.setClosedX(!this.m_volume.isClosedX());
        } else if (source == this.m_CBcloseVolume_Y) {
            this.m_volume.setClosedY(!this.m_volume.isClosedY());
        } else if (source == this.m_CBcloseVolume_Z) {
            this.m_volume.setClosedZ(!this.m_volume.isClosedZ());
        }
        if (this.m_volume.isUsingMemSpeedup()) {
            this.m_volume.calcBaseFunctions();
        }
        this.showWeights(this.isShowingWeights());
        this.updateSlider();
        this.setKnots();
        this.m_controlVolume.update((Object)this.m_controlVolume);
        this.m_volume.update((Object)this.m_volume);
    }

    protected void showWeights(boolean isShowingWeights) {
        if (this.isShowingWeights()) {
            int i = 0;
            while (i < this.m_controlVolume.getNumVertices()) {
                this.m_controlVolume.getVertex(i).setName("[" + i + "] " + this.m_volume.m_controlPointWeights.m_data[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.m_controlVolume.getNumVertices()) {
                this.m_controlVolume.getVertex(i).setName(String.valueOf(i));
                ++i;
            }
        }
    }

    private void setWeights() {
        int offset = this.m_Scroller[3].getValue();
        if (offset > this.m_controlVolume.getNumVertices() - 5 || offset < 0) {
            return;
        }
        int i = 0;
        while (i < this.m_TextFields[3].length) {
            this.m_Labels[3][i].setText("[" + Integer.toString(i + offset) + "]");
            this.m_TextFields[3][i].setText(String.valueOf(this.m_volume.m_controlPointWeights.m_data[i + offset]));
            ++i;
        }
        this.m_Scroller[3].setValue(offset);
    }

    private void setKnots() {
        int i = 0;
        while (i < 3) {
            int offset = this.m_Scroller[i].getValue();
            if (offset > this.m_volume.m_knotVector[i].getSize() - 5 || offset < 0) {
                return;
            }
            int j = 0;
            while (j < this.m_TextFields[i].length) {
                this.m_Labels[i][j].setText("[" + Integer.toString(j + offset) + "]");
                this.m_TextFields[i][j].setText(String.valueOf(this.m_volume.m_knotVector[i].getEntry(j + offset)));
                ++j;
            }
            this.m_Scroller[i].setValue(offset);
            ++i;
        }
    }

    private void getWeightValues() {
        int offset = this.m_Scroller[3].getValue();
        if (offset > this.m_controlVolume.getNumVertices() - 5 || offset < 0) {
            return;
        }
        try {
            int i = 0;
            while (i < this.m_TextFields[3].length) {
                double tmpDouble;
                this.m_volume.m_controlPointWeights.m_data[i + offset] = tmpDouble = PuDouble.parseDouble((String)this.m_TextFields[3][i].getText());
                ++i;
            }
        }
        catch (NumberFormatException aException) {
            PsDebug.warning((String)"Wrong number format.");
        }
        this.m_controlVolume.update((Object)this.m_controlVolume);
        this.setWeights();
    }

    private void getKnotValues() {
        try {
            int i = 0;
            while (i < 3) {
                int offset = this.m_Scroller[i].getValue();
                if (offset > this.m_volume.m_knotVector[i].getSize() - 5 || offset < 0) {
                    return;
                }
                int j = 0;
                while (j < this.m_TextFields[i].length) {
                    double tmpDouble = PuDouble.parseDouble((String)this.m_TextFields[i][j].getText());
                    this.m_volume.m_knotVector[i].setEntry(j + offset, tmpDouble);
                    ++j;
                }
                ++i;
            }
        }
        catch (NumberFormatException aException) {
            PsDebug.warning((String)"Wrong number format.");
        }
        this.m_controlVolume.update((Object)this.m_controlVolume);
        this.setKnots();
    }

    private void updateSlider() {
        int[] tmp = new int[this.m_Scroller.length];
        int i = 0;
        while (i < 3) {
            this.m_Scroller[i].setDefBounds(0, this.m_volume.getKnotVector()[i].getSize() >= 5 ? this.m_volume.getKnotVector()[i].getSize() - 5 : 0, 1, 1);
            tmp[i] = this.m_Scroller[i].getValue();
            ++i;
        }
        this.m_Scroller[3].setDefBounds(0, this.m_controlVolume.getNumVertices() >= 5 ? this.m_controlVolume.getNumVertices() - 5 : 0, 1, 1);
        tmp[3] = this.m_Scroller[3].getValue();
        i = 0;
        while (i < tmp.length - 1) {
            if (this.m_volume.getKnotVector()[i].getSize() > 5 && tmp[i] > this.m_volume.getKnotVector()[i].getSize() - 5) {
                tmp[i] = this.m_volume.getKnotVector()[i].getSize() - 5;
            }
            ++i;
        }
        if (this.m_volume.getControlWeights().getSize() > 5 && tmp[3] > this.m_volume.getControlWeights().getSize() - 5) {
            tmp[3] = this.m_volume.getControlWeights().getSize() - 5;
        }
        i = 0;
        while (i < this.m_Scroller.length) {
            this.m_Scroller[i].init();
            this.m_Scroller[i].setValue(tmp[i]);
            ++i;
        }
    }
}

