/*
 * Decompiled with CFR 0.152.
 */
package devNurbs.solids;

import java.awt.Color;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.volume.PgCubeSet;

public class PgNurbsSolids
extends PgCubeSet
implements PsUpdateIf {
    private static final long serialVersionUID = -2377188566640472773L;
    protected static final int DEFAULT_DETAIL_X = 10;
    protected static final int DEFAULT_DETAIL_Y = 10;
    protected static final int DEFAULT_DETAIL_Z = 10;
    protected static final int X_AXIS = 0;
    protected static final int Y_AXIS = 1;
    protected static final int Z_AXIS = 2;
    protected static final int DEFAULT_ORDER = 2;
    private int m_numControlRows;
    private int m_numControlColumns;
    private int m_numControlLevels;
    private int[] m_order;
    protected PdVector[] m_knotVector;
    protected PdVector m_controlPointWeights;
    protected PgCubeSet m_controlVolume;
    protected int m_detail_X;
    protected int m_detail_Y;
    protected int m_detail_Z;
    protected boolean m_bMemSpeedUp;
    private double[][] nBaseSave;
    private boolean m_bIsClosedX;
    private boolean m_bIsClosedY;
    private boolean m_bIsClosedZ;

    public PgNurbsSolids(int aVertexDim) {
        super(aVertexDim < 3 ? 3 : aVertexDim);
        this.setTag(10);
        this.m_controlVolume = new PgCubeSet();
        this.m_controlVolume.addUpdateListener((PsUpdateIf)this);
        this.m_controlVolume.setGlobalVertexSize(3.0);
        this.m_controlVolume.setGlobalVertexColor(Color.red);
        this.m_controlVolume.setGlobalEdgeSize(1.0);
        this.m_controlVolume.setGlobalEdgeColor(Color.white);
        this.m_controlVolume.setGlobalCubeColor(Color.white);
        this.m_controlVolume.setName("ControlVolume");
        this.m_controlVolume.showVertices(true);
        this.m_controlVolume.showCubes(false);
        this.m_controlVolume.showSmallCubes(false);
        this.m_bIsClosedX = false;
        this.m_bIsClosedY = false;
        this.m_bIsClosedZ = false;
        this.m_numControlRows = 0;
        this.m_numControlColumns = 0;
        this.m_numControlLevels = 0;
        this.m_detail_X = 10;
        this.m_detail_Y = 10;
        this.m_detail_Z = 10;
        this.m_knotVector = new PdVector[3];
        int i = 0;
        while (i < this.m_knotVector.length) {
            this.m_knotVector[i] = new PdVector();
            ++i;
        }
        this.m_bMemSpeedUp = true;
        this.m_controlPointWeights = new PdVector();
        this.m_order = new int[3];
        i = 0;
        while (i < this.m_order.length) {
            this.m_order[i] = 2;
            ++i;
        }
        if (((Object)((Object)this)).getClass() == PgNurbsSolids.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addTestGeom();
        this.initKnotVector();
        this.reevaluate();
        this.showVertices(false);
        this.showCubes(true);
        this.setName("Nurbs Solid");
    }

    private void addTestGeom() {
        this.m_numControlRows = 3;
        this.m_numControlColumns = 3;
        this.m_numControlLevels = 3;
        int i = 0;
        while (i < 3) {
            this.m_controlVolume.addVertex(new PdVector(0.0, 0.0, (double)i));
            this.m_controlVolume.addVertex(new PdVector(0.0, 1.0, (double)i));
            this.m_controlVolume.addVertex(new PdVector(0.0, 2.0, (double)i));
            this.m_controlVolume.addVertex(new PdVector(1.0, 0.0, (double)i));
            this.m_controlVolume.addVertex(new PdVector(1.0, 1.0, (double)i));
            this.m_controlVolume.addVertex(new PdVector(1.0, 2.0, (double)i));
            this.m_controlVolume.addVertex(new PdVector(2.0, 0.0, (double)i));
            this.m_controlVolume.addVertex(new PdVector(2.0, 1.0, (double)i));
            this.m_controlVolume.addVertex(new PdVector(2.0, 2.0, (double)i));
            ++i;
        }
        this.initControlVolumeQuads();
        this.m_controlPointWeights.setSize(this.m_numControlColumns * this.m_numControlRows * this.m_numControlLevels);
        i = 0;
        while (i < this.m_controlPointWeights.m_data.length) {
            this.m_controlPointWeights.m_data[i] = 1.0;
            ++i;
        }
        this.setNumVertices(this.m_detail_X * this.m_detail_Y * this.m_detail_Z);
        this.initQuads();
    }

    public boolean addControlPointColumns() {
        ++this.m_numControlColumns;
        this.m_controlVolume.setNumVertices(this.m_numControlColumns * this.m_numControlRows * this.m_numControlLevels);
        this.m_controlPointWeights.setSize(this.m_numControlColumns * this.m_numControlRows * this.m_numControlLevels);
        int counter = this.m_numControlRows;
        int offset = this.m_numControlLevels * this.m_numControlRows;
        int level = this.m_numControlRows * this.m_numControlColumns;
        PdVector[] controlVertices = this.m_controlVolume.getVertices();
        int i = this.m_controlVolume.getNumVertices() - 1;
        while (i >= 0) {
            if (counter > 0) {
                controlVertices[i] = PdVector.subNew((PdVector)controlVertices[i - offset], (PdVector)controlVertices[i - offset - this.m_numControlRows]);
                controlVertices[i].add(controlVertices[i - offset]);
                this.m_controlPointWeights.setEntry(i, 1.0);
                --counter;
            }
            if (counter == 0) {
                --counter;
                offset -= this.m_numControlRows;
            } else if (counter == -1) {
                controlVertices[i] = PdVector.copyNew((PdVector)controlVertices[i - offset]);
                this.m_controlPointWeights.setEntry(i, this.m_controlPointWeights.getEntry(i - offset));
            }
            if (i % level == 0) {
                counter = this.m_numControlRows;
            }
            --i;
        }
        this.initKnotVector();
        return true;
    }

    public boolean removeControlPointColumns() {
        PdVector[] vertices = this.m_controlVolume.getVertices();
        int offset = 0;
        int n = (this.m_numControlColumns - 1) * this.m_numControlRows;
        int j = 0;
        while (j < this.m_numControlLevels) {
            int i = 0;
            while (i < n) {
                vertices[i + j * n] = PdVector.copyNew((PdVector)vertices[i + j * n + offset]);
                this.m_controlPointWeights.m_data[i + j * n] = this.m_controlPointWeights.m_data[i + j * n + offset];
                ++i;
            }
            offset += this.m_numControlRows;
            ++j;
        }
        --this.m_numControlColumns;
        this.m_controlVolume.setNumVertices(this.m_numControlColumns * this.m_numControlRows * this.m_numControlLevels);
        this.m_controlPointWeights.setSize(this.m_numControlColumns * this.m_numControlRows * this.m_numControlLevels);
        this.initKnotVector();
        return true;
    }

    public boolean addControlPointRows() {
        ++this.m_numControlRows;
        this.m_controlVolume.setNumVertices(this.m_numControlColumns * this.m_numControlRows * this.m_numControlLevels);
        PdVector[] controlVertices = this.m_controlVolume.getVertices();
        this.m_controlPointWeights.setSize(this.m_controlVolume.getNumVertices());
        int offset = this.m_numControlColumns * this.m_numControlLevels;
        int i = this.m_controlVolume.getNumVertices() - 1;
        while (i >= 0) {
            if ((i + 1) % this.m_numControlRows == 0) {
                controlVertices[i] = PdVector.subNew((PdVector)controlVertices[i - 1 - --offset], (PdVector)controlVertices[i - offset - 2]);
                controlVertices[i].add(controlVertices[i - offset - 1]);
                this.m_controlPointWeights.m_data[i] = 1.0;
            } else {
                this.m_controlPointWeights.m_data[i] = this.m_controlPointWeights.m_data[i - offset];
                controlVertices[i] = PdVector.copyNew((PdVector)controlVertices[i - offset]);
            }
            --i;
        }
        this.initKnotVector();
        return true;
    }

    public boolean removeControlPointRows() {
        --this.m_numControlRows;
        int n = this.m_numControlRows * this.m_numControlColumns * this.m_numControlLevels;
        PdVector[] vertices = this.m_controlVolume.getVertices();
        int offset = 0;
        int i = 0;
        while (i < n) {
            vertices[i] = PdVector.copyNew((PdVector)vertices[i + offset]);
            this.m_controlPointWeights.setEntry(i, this.m_controlPointWeights.getEntry(i + offset));
            if ((i + 1) % this.m_numControlRows == 0) {
                ++offset;
            }
            ++i;
        }
        this.m_controlVolume.setNumVertices(n);
        this.m_controlPointWeights.setSize(n);
        this.initKnotVector();
        return true;
    }

    public boolean removeControlPointLevel() {
        --this.m_numControlLevels;
        this.m_controlVolume.setNumVertices(this.m_numControlColumns * this.m_numControlRows * this.m_numControlLevels);
        this.m_controlPointWeights.setSize(this.m_numControlColumns * this.m_numControlRows * this.m_numControlLevels);
        this.initKnotVector();
        return true;
    }

    public boolean addControlPointLevel() {
        ++this.m_numControlLevels;
        this.m_controlVolume.setNumVertices(this.m_numControlColumns * this.m_numControlRows * this.m_numControlLevels);
        this.m_controlPointWeights.setSize(this.m_numControlColumns * this.m_numControlRows * this.m_numControlLevels);
        int level = this.m_numControlColumns * this.m_numControlRows;
        PdVector[] controlVertices = this.m_controlVolume.getVertices();
        int n = this.m_numControlColumns * this.m_numControlRows * (this.m_numControlLevels - 1);
        int j = 0;
        while (j < this.m_numControlColumns) {
            int i = 0;
            while (i < this.m_numControlRows) {
                PdVector pdVector = PdVector.subNew((PdVector)controlVertices[i + j * this.m_numControlRows + n - level], (PdVector)controlVertices[i + j * this.m_numControlRows + n - 2 * level]);
                controlVertices[i + j * this.m_numControlRows + n] = pdVector;
                pdVector.add(controlVertices[i + j * this.m_numControlRows + n - level]);
                this.m_controlPointWeights.m_data[i + j * this.m_numControlRows + n] = 1.0;
                ++i;
            }
            ++j;
        }
        this.initKnotVector();
        return true;
    }

    protected void initKnotVector() {
        double actKnotVectorValue = 0.0;
        this.m_knotVector[0].setSize(this.m_numControlColumns + (this.isClosedX() ? 1 : this.m_order[0]));
        this.m_knotVector[1].setSize(this.m_numControlRows + (this.isClosedY() ? 1 : this.m_order[1]));
        this.m_knotVector[2].setSize(this.m_numControlLevels + (this.isClosedZ() ? 1 : this.m_order[2]));
        int[] value = new int[]{this.m_numControlColumns, this.m_numControlRows, this.m_numControlLevels};
        int j = 0;
        while (j < this.m_knotVector.length) {
            int i;
            if (this.isClosed(j)) {
                i = 0;
                while (i < this.m_knotVector[j].getSize()) {
                    double d = actKnotVectorValue;
                    actKnotVectorValue = d + 1.0;
                    this.m_knotVector[j].setEntry(i, d);
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.m_order[j]) {
                    this.m_knotVector[j].setEntry(i, actKnotVectorValue);
                    ++i;
                }
                i = this.m_order[j];
                while (i < value[j]) {
                    this.m_knotVector[j].setEntry(i, actKnotVectorValue += 1.0);
                    ++i;
                }
                actKnotVectorValue += 1.0;
                i = value[j];
                while (i < value[j] + this.m_order[j]) {
                    this.m_knotVector[j].setEntry(i, actKnotVectorValue);
                    ++i;
                }
            }
            actKnotVectorValue = 0.0;
            ++j;
        }
        if (this.m_bMemSpeedUp) {
            this.calcBaseFunctions();
        }
    }

    private void initQuads() {
        this.setNumCubes((this.isClosedX() ? this.m_detail_X : this.m_detail_X - 1) * (this.isClosedY() ? this.m_detail_Y : this.m_detail_Y - 1) * (this.isClosedZ() ? this.m_detail_Z : this.m_detail_Z - 1));
        PiVector[] tetras = this.getCubes();
        int k = 0;
        while (k < (this.isClosedZ() ? this.m_detail_Z : this.m_detail_Z - 1)) {
            int i = 0;
            while (i < (this.isClosedX() ? this.m_detail_X : this.m_detail_X - 1)) {
                int j = 0;
                while (j < (this.isClosedY() ? this.m_detail_Y : this.m_detail_Y - 1)) {
                    PiVector tmp = new PiVector();
                    tmp.setSize(8);
                    tmp.m_data[0] = j % this.m_detail_Y + i % this.m_detail_X * this.m_detail_Y + k % this.m_detail_Z * (this.m_detail_Y * this.m_detail_X);
                    tmp.m_data[1] = j % this.m_detail_Y + (i + 1) % this.m_detail_X * this.m_detail_Y + k % this.m_detail_Z * (this.m_detail_Y * this.m_detail_X);
                    tmp.m_data[2] = (j + 1) % this.m_detail_Y + i % this.m_detail_X * this.m_detail_Y + k % this.m_detail_Z * (this.m_detail_Y * this.m_detail_X);
                    tmp.m_data[3] = (j + 1) % this.m_detail_Y + (i + 1) % this.m_detail_X * this.m_detail_Y + k % this.m_detail_Z * (this.m_detail_Y * this.m_detail_X);
                    tmp.m_data[4] = j % this.m_detail_Y + i % this.m_detail_X * this.m_detail_Y + (k + 1) % this.m_detail_Z * (this.m_detail_Y * this.m_detail_X);
                    tmp.m_data[5] = j % this.m_detail_Y + (i + 1) % this.m_detail_X * this.m_detail_Y + (k + 1) % this.m_detail_Z * (this.m_detail_Y * this.m_detail_X);
                    tmp.m_data[6] = (j + 1) % this.m_detail_Y + i % this.m_detail_X * this.m_detail_Y + (k + 1) % this.m_detail_Z * (this.m_detail_Y * this.m_detail_X);
                    tmp.m_data[7] = (j + 1) % this.m_detail_Y + (i + 1) % this.m_detail_X * this.m_detail_Y + (k + 1) % this.m_detail_Z * (this.m_detail_Y * this.m_detail_X);
                    tetras[i * (this.isClosedY() ? this.m_detail_Y : this.m_detail_Y - 1) + j + k * ((this.isClosedY() ? this.m_detail_Y : this.m_detail_Y - 1) * (this.isClosedX() ? this.m_detail_X : this.m_detail_X - 1))].copy(tmp);
                    ++j;
                }
                ++i;
            }
            ++k;
        }
    }

    private void initControlVolumeQuads() {
        this.m_controlVolume.setNumCubes((this.isClosedX() ? this.m_numControlColumns : this.m_numControlColumns - 1) * (this.isClosedY() ? this.m_numControlRows : this.m_numControlRows - 1) * (this.isClosedZ() ? this.m_numControlLevels : this.m_numControlLevels - 1));
        PiVector[] tetras = this.m_controlVolume.getCubes();
        int k = 0;
        while (k < (this.isClosedZ() ? this.m_numControlLevels : this.m_numControlLevels - 1)) {
            int i = 0;
            while (i < (this.isClosedX() ? this.m_numControlColumns : this.m_numControlColumns - 1)) {
                int j = 0;
                while (j < (this.isClosedY() ? this.m_numControlRows : this.m_numControlRows - 1)) {
                    PiVector tmp = new PiVector();
                    tmp.setSize(8);
                    tmp.m_data[0] = j % this.m_numControlRows + i % this.m_numControlColumns * this.m_numControlRows + k % this.m_numControlLevels * (this.m_numControlRows * this.m_numControlColumns);
                    tmp.m_data[1] = j % this.m_numControlRows + (i + 1) % this.m_numControlColumns * this.m_numControlRows + k % this.m_numControlLevels * (this.m_numControlRows * this.m_numControlColumns);
                    tmp.m_data[2] = (j + 1) % this.m_numControlRows + i % this.m_numControlColumns * this.m_numControlRows + k % this.m_numControlLevels * (this.m_numControlRows * this.m_numControlColumns);
                    tmp.m_data[3] = (j + 1) % this.m_numControlRows + (i + 1) % this.m_numControlColumns * this.m_numControlRows + k % this.m_numControlLevels * (this.m_numControlRows * this.m_numControlColumns);
                    tmp.m_data[4] = j % this.m_numControlRows + i % this.m_numControlColumns * this.m_numControlRows + (k + 1) % this.m_numControlLevels * (this.m_numControlRows * this.m_numControlColumns);
                    tmp.m_data[5] = j % this.m_numControlRows + (i + 1) % this.m_numControlColumns * this.m_numControlRows + (k + 1) % this.m_numControlLevels * (this.m_numControlRows * this.m_numControlColumns);
                    tmp.m_data[6] = (j + 1) % this.m_numControlRows + i % this.m_numControlColumns * this.m_numControlRows + (k + 1) % this.m_numControlLevels * (this.m_numControlRows * this.m_numControlColumns);
                    tmp.m_data[7] = (j + 1) % this.m_numControlRows + (i + 1) % this.m_numControlColumns * this.m_numControlRows + (k + 1) % this.m_numControlLevels * (this.m_numControlRows * this.m_numControlColumns);
                    tetras[k * (this.isClosedY() ? this.m_numControlRows : this.m_numControlRows - 1) * (this.isClosedX() ? this.m_numControlColumns : this.m_numControlColumns - 1) + i * (this.isClosedY() ? this.m_numControlRows : this.m_numControlRows - 1) + j].copy(tmp);
                    ++j;
                }
                ++i;
            }
            ++k;
        }
    }

    public void setWeights(PdVector weightsVector) {
        this.m_controlPointWeights = weightsVector;
        this.initKnotVector();
    }

    public void eval(PdVector aVertex, double s, double t, double h) {
        int i = 0;
        while (i < aVertex.getSize()) {
            aVertex.m_data[i] = 0.0;
            ++i;
        }
        double denom = this.RBaseDenominator(this.m_order, s, t, h);
        if (this.isZero(denom)) {
            return;
        }
        int i2 = 0;
        while (i2 < this.m_controlVolume.getNumVertices()) {
            aVertex.add(this.RBaseNumerator(i2, this.m_order, s, t, h) / denom, this.m_controlVolume.getVertex(i2));
            ++i2;
        }
    }

    public double RBaseDenominator(int[] order, double s, double t, double h) {
        double denominator = 0.0;
        int l = 0;
        while (l < this.m_controlVolume.getNumVertices()) {
            denominator += this.NBase(l, this.m_order[0], s, 0) * this.NBase(l, this.m_order[1], t, 1) * this.NBase(l, this.m_order[2], h, 2) * this.m_controlPointWeights.m_data[l];
            ++l;
        }
        return denominator;
    }

    public double evalBaseFunction(int index, double s, double t, double h) {
        double denominator = 0.0;
        int l = 0;
        while (l < this.m_controlVolume.getNumVertices()) {
            denominator += this.NBase(l, this.m_order[0], s, 0) * this.NBase(l, this.m_order[1], t, 1) * this.NBase(l, this.m_order[2], h, 2) * this.m_controlPointWeights.m_data[l];
            ++l;
        }
        return this.isZero(denominator) ? 0.0 : this.RBaseNumerator(index, this.m_order, s, t, h) / denominator;
    }

    protected double RBaseNumerator(int i, int[] orders, double s, double t, double h) {
        return this.NBase(i, orders[0], s, 0) * this.NBase(i, orders[1], t, 1) * this.NBase(i, orders[2], h, 2) * this.m_controlPointWeights.m_data[i];
    }

    private double NBase(int i, int order, double t, int axis) {
        double part2;
        double part1;
        int rowIndex = i % this.m_numControlRows;
        int colIndex = i % (this.m_numControlRows * this.m_numControlColumns) / this.m_numControlRows;
        int lvlIndex = i / (this.m_numControlRows * this.m_numControlColumns);
        int modulo = 0;
        int j = 0;
        if (axis == 0) {
            modulo = this.m_numControlColumns;
            j = colIndex;
        } else if (axis == 1) {
            modulo = this.m_numControlRows;
            j = rowIndex;
        } else {
            modulo = this.m_numControlLevels;
            j = lvlIndex;
        }
        if (order == 1) {
            if (this.isClosed(axis) && j >= this.m_knotVector[axis].getSize() - 1) {
                if (t >= this.m_knotVector[axis].m_data[j % modulo] && t < this.m_knotVector[axis].m_data[(j + 1) % modulo]) {
                    return 1.0;
                }
                return 0.0;
            }
            if (t >= this.m_knotVector[axis].m_data[j] && t < this.m_knotVector[axis].m_data[j + 1]) {
                return 1.0;
            }
            return 0.0;
        }
        if (this.isClosed(axis)) {
            double a = t - this.m_knotVector[axis].m_data[j];
            double b = this.m_knotVector[axis].m_data[(j + order - 1) % modulo] - this.m_knotVector[axis].m_data[j % modulo];
            double c = this.m_knotVector[axis].m_data[(j + order) % modulo] - t;
            double d = this.m_knotVector[axis].m_data[(j + order) % modulo] - this.m_knotVector[axis].m_data[(j + 1) % modulo];
            double dist = this.m_knotVector[axis].getLastEntry() - this.m_knotVector[axis].getFirstEntry();
            if (a < 0.0) {
                a += dist;
            }
            if (b < 0.0) {
                b += dist;
            }
            if (c < 0.0) {
                c += dist;
            }
            if (d < 0.0) {
                d += dist;
            }
            rowIndex %= this.m_numControlRows;
            colIndex %= this.m_numControlColumns;
            lvlIndex %= this.m_numControlLevels;
            if (axis == 0) {
                part1 = this.isZero(b) ? 0.0 : a * this.NBase(lvlIndex * this.m_numControlColumns * this.m_numControlRows + colIndex * this.m_numControlRows + rowIndex, order - 1, t, axis) / b;
                ++colIndex;
                part2 = this.isZero(d) ? 0.0 : c * this.NBase(lvlIndex * this.m_numControlColumns * this.m_numControlRows + (colIndex %= this.m_numControlColumns) * this.m_numControlRows + rowIndex, order - 1, t, axis) / d;
            } else if (axis == 1) {
                part1 = this.isZero(b) ? 0.0 : a * this.NBase(lvlIndex * this.m_numControlColumns * this.m_numControlRows + colIndex * this.m_numControlRows + rowIndex, order - 1, t, axis) / b;
                ++rowIndex;
                part2 = this.isZero(d) ? 0.0 : c * this.NBase(lvlIndex * this.m_numControlColumns * this.m_numControlRows + colIndex * this.m_numControlRows + (rowIndex %= this.m_numControlRows), order - 1, t, axis) / d;
            } else {
                part1 = this.isZero(b) ? 0.0 : a * this.NBase(lvlIndex * this.m_numControlColumns * this.m_numControlRows + colIndex * this.m_numControlRows + rowIndex, order - 1, t, axis) / b;
                ++lvlIndex;
                part2 = this.isZero(d) ? 0.0 : c * this.NBase((lvlIndex %= this.m_numControlLevels) * this.m_numControlColumns * this.m_numControlRows + colIndex * this.m_numControlRows + rowIndex, order - 1, t, axis) / d;
            }
        } else {
            double a = t - this.m_knotVector[axis].m_data[j];
            double b = this.m_knotVector[axis].m_data[j + order - 1] - this.m_knotVector[axis].m_data[j];
            double c = this.m_knotVector[axis].m_data[j + order] - t;
            double d = this.m_knotVector[axis].m_data[j + order] - this.m_knotVector[axis].m_data[j + 1];
            double d2 = part1 = this.isZero(b) ? 0.0 : a * this.NBase(i, order - 1, t, axis) / b;
            part2 = axis == 0 ? (this.isZero(d) ? 0.0 : c * this.NBase(i + this.m_numControlRows, order - 1, t, axis) / d) : (axis == 1 ? (this.isZero(d) ? 0.0 : c * this.NBase(i + 1, order - 1, t, axis) / d) : (this.isZero(d) ? 0.0 : c * this.NBase(i + this.m_numControlRows * this.m_numControlColumns, order - 1, t, axis) / d));
        }
        return part1 + part2;
    }

    protected void reevaluate() {
        if (this.getNumVertices() == 0) {
            PsDebug.error((String)"No vertices to be evaluated found.");
            return;
        }
        PdVector[] vertices = this.getVertices();
        int indexOffset = 0;
        if (this.m_bMemSpeedUp) {
            PdVector[] controlVertices = this.m_controlVolume.getVertices();
            int h = 0;
            while (h < this.m_detail_Z) {
                int i = 0;
                while (i < this.m_detail_X) {
                    int j = 0;
                    while (j < this.m_detail_Y) {
                        indexOffset = h * this.m_detail_X * this.m_detail_Y + i * this.m_detail_Y + j;
                        int k = 0;
                        while (k < vertices[indexOffset].getSize()) {
                            vertices[indexOffset].m_data[k] = 0.0;
                            ++k;
                        }
                        k = 0;
                        while (k < this.m_controlVolume.getNumVertices()) {
                            vertices[indexOffset].add(this.nBaseSave[indexOffset][k], controlVertices[k]);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                ++h;
            }
        } else {
            double last_x = this.m_knotVector[0].getLastEntry();
            double last_y = this.m_knotVector[1].getLastEntry();
            double last_z = this.m_knotVector[2].getLastEntry();
            double s = this.m_knotVector[0].getFirstEntry();
            double t = this.m_knotVector[1].getFirstEntry();
            double h = this.m_knotVector[2].getFirstEntry();
            double delta_s = (last_x - s) / (double)(this.m_detail_X - 1);
            double delta_t = (last_y - t) / (double)(this.m_detail_Y - 1);
            double delta_h = (last_z - h) / (double)(this.m_detail_Z - 1);
            int k = 0;
            while (k < this.m_detail_Z) {
                s = this.m_knotVector[0].getFirstEntry();
                int j = 0;
                while (j < this.m_detail_X) {
                    t = this.m_knotVector[1].getFirstEntry();
                    int i = 0;
                    while (i < this.m_detail_Y) {
                        this.eval(vertices[k * this.m_detail_X * this.m_detail_Y + j * this.m_detail_Y + i], s, t, h);
                        t += delta_t;
                        if (t >= last_y) {
                            t = last_y - 1.0E-10;
                        }
                        ++i;
                    }
                    if ((s += delta_s) >= last_x) {
                        s = last_x - 1.0E-10;
                    }
                    ++j;
                }
                if ((h += delta_h) >= last_z) {
                    h = last_z - 1.0E-10;
                }
                ++k;
            }
        }
    }

    private boolean isZero(double aNumber) {
        return Math.abs(aNumber) < 1.0E-10;
    }

    public boolean update(Object event) {
        if (event == this.m_controlVolume) {
            if (this.m_numControlColumns < this.m_order[0] || this.m_numControlRows < this.m_order[1] || this.m_numControlLevels < this.m_order[2]) {
                this.setNumVertices(0);
            } else if (this.getNumVertices() == 0) {
                this.setNumVertices(this.m_detail_Y * this.m_detail_X * this.m_detail_Z);
            }
            if (this.m_controlVolume.getNumCubes() != (this.m_numControlRows - 1) * (this.m_numControlColumns - 1) * (this.m_numControlLevels - 1)) {
                this.initControlVolumeQuads();
            }
            if (this.getNumCubes() != (this.m_detail_X - 1) * (this.m_detail_Y - 1) * (this.m_detail_Z - 1)) {
                this.initQuads();
            }
            if (this.m_bMemSpeedUp && (this.getNumVertices() != this.nBaseSave.length || this.nBaseSave.length > 0 && this.m_controlVolume.getNumVertices() != this.nBaseSave[0].length)) {
                this.calcBaseFunctions();
            }
            this.repairKnotVector();
            this.repairWeightVector();
            this.reevaluate();
            return this.update((Object)this);
        }
        return super.update(event);
    }

    public int addVertex(PdVector vec) {
        return -1;
    }

    public int addElement(PiVector vec) {
        return -1;
    }

    public int[] removeElement(int numOfElement) {
        return null;
    }

    public int[] removeVertex(int numOfVertex) {
        return null;
    }

    protected void calcBaseFunctions() {
        this.nBaseSave = new double[this.getNumVertices()][this.m_controlVolume.getNumVertices()];
        double last_x = this.m_knotVector[0].getLastEntry();
        double last_y = this.m_knotVector[1].getLastEntry();
        double last_z = this.m_knotVector[2].getLastEntry();
        double s = this.m_knotVector[0].getFirstEntry();
        double t = this.m_knotVector[1].getFirstEntry();
        double h = this.m_knotVector[2].getFirstEntry();
        double delta_s = (last_x - s) / (double)(this.m_detail_X - 1);
        double delta_t = (last_y - t) / (double)(this.m_detail_Y - 1);
        double delta_h = (last_z - h) / (double)(this.m_detail_Z - 1);
        int m = 0;
        while (m < this.m_detail_Z) {
            s = this.m_knotVector[0].getFirstEntry();
            int j = 0;
            while (j < this.m_detail_X) {
                t = this.m_knotVector[1].getFirstEntry();
                int i = 0;
                while (i < this.m_detail_Y) {
                    int k;
                    double denominator = this.RBaseDenominator(this.m_order, s, t, h);
                    if (this.isZero(denominator)) {
                        k = 0;
                        while (k < this.m_controlVolume.getNumVertices()) {
                            this.nBaseSave[m * this.m_detail_X * this.m_detail_Y + j * this.m_detail_Y + i][k] = 0.0;
                            ++k;
                        }
                    }
                    k = 0;
                    while (k < this.m_controlVolume.getNumVertices()) {
                        this.nBaseSave[m * this.m_detail_X * this.m_detail_Y + j * this.m_detail_Y + i][k] = this.RBaseNumerator(k, this.m_order, s, t, h) / denominator;
                        ++k;
                    }
                    if ((t += delta_t) >= last_y) {
                        t = last_y - 1.0E-10;
                    }
                    ++i;
                }
                if ((s += delta_s) >= last_x) {
                    s = last_x - 1.0E-10;
                }
                ++j;
            }
            if ((h += delta_h) >= last_z) {
                h = last_z - 1.0E-10;
            }
            ++m;
        }
    }

    protected void repairKnotVector() {
        if (this.m_numControlColumns + (this.isClosedX() ? 1 : this.m_order[0]) != this.m_knotVector[0].getSize() || this.m_numControlRows + (this.isClosedY() ? 1 : this.m_order[1]) != this.m_knotVector[1].getSize() || this.m_numControlLevels + (this.isClosedZ() ? 1 : this.m_order[2]) != this.m_knotVector[2].getSize()) {
            this.initKnotVector();
        }
    }

    protected void repairWeightVector() {
        if (this.m_controlPointWeights.getSize() != this.m_controlVolume.getNumVertices()) {
            int maxNumWeights = this.m_controlPointWeights.getSize();
            int maxNumControlPoints = this.m_controlVolume.getNumVertices();
            int i = 0;
            PdVector newWeights = new PdVector(maxNumControlPoints);
            while (i < maxNumWeights && i < maxNumControlPoints) {
                newWeights.m_data[i] = this.m_controlPointWeights.m_data[i];
                ++i;
            }
            while (i < maxNumControlPoints) {
                newWeights.m_data[i] = 1.0;
                ++i;
            }
            this.setWeights(newWeights);
        }
    }

    public void setDetail(int xDetail, int yDetail, int zDetail) {
        if (xDetail < 4) {
            xDetail = 4;
        }
        if (yDetail < 4) {
            yDetail = 4;
        }
        if (zDetail < 4) {
            zDetail = 4;
        }
        this.m_detail_X = xDetail;
        this.m_detail_Y = yDetail;
        this.m_detail_Z = zDetail;
        this.setNumVertices(xDetail * yDetail * zDetail);
        this.initQuads();
        this.update(this.m_controlVolume);
    }

    public int getDetail() {
        return this.getNumVertices();
    }

    public PgCubeSet getControlVolume() {
        return this.m_controlVolume;
    }

    public int getNumControlRows() {
        return this.m_numControlRows;
    }

    public int getNumControlPoints() {
        return this.m_controlVolume.getNumVertices();
    }

    public int getNumControlColumns() {
        return this.m_numControlColumns;
    }

    public int getNumControlLevels() {
        return this.m_numControlLevels;
    }

    public PdVector getControlWeights() {
        return this.m_controlPointWeights;
    }

    public PdVector[] getControlPoints() {
        return this.m_controlVolume.getVertices();
    }

    public PdVector[] getKnotVector() {
        return this.m_knotVector;
    }

    public int[] getOrders() {
        return this.m_order;
    }

    public void setOrder(int aOrder, int axis) {
        if (aOrder < 2 || aOrder > 6) {
            PsDebug.warning((String)"Entered order is to small/big. Only 2,...,6 are allowed.");
        } else {
            this.m_order[axis] = aOrder;
            this.initKnotVector();
            this.m_controlVolume.update((Object)this.m_controlVolume);
        }
    }

    public boolean isClosedX() {
        return this.m_bIsClosedX;
    }

    public void setClosedX(boolean isClosed) {
        this.m_bIsClosedX = isClosed;
        this.initKnotVector();
        this.initQuads();
        this.initControlVolumeQuads();
    }

    public boolean isClosedY() {
        return this.m_bIsClosedY;
    }

    public void setClosedY(boolean isClosed) {
        this.m_bIsClosedY = isClosed;
        this.initKnotVector();
        this.initQuads();
        this.initControlVolumeQuads();
    }

    public boolean isClosedZ() {
        return this.m_bIsClosedZ;
    }

    public void setClosedZ(boolean isClosed) {
        this.m_bIsClosedZ = isClosed;
        this.initKnotVector();
        this.initQuads();
        this.initControlVolumeQuads();
    }

    public boolean isUsingMemSpeedup() {
        return this.m_bMemSpeedUp;
    }

    private boolean isClosed(int axis) {
        if (axis == 0 && this.isClosedX()) {
            return true;
        }
        if (axis == 1 && this.isClosedY()) {
            return true;
        }
        return axis == 2 && this.isClosedZ();
    }
}

