/*
 * Decompiled with CFR 0.152.
 */
package devNurbs.curves;

import devNurbs.curves.PgNurbsCurve;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.geom.PgPolygon;
import jv.loader.PgLoader;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;

public class PjNurbsCurve
extends PjProject
implements ActionListener {
    private static final long serialVersionUID = 4353570741885180243L;
    protected PgNurbsCurve m_pCurve;
    protected PgPolygon m_controlCurve;

    public PjNurbsCurve() {
        super("NURBS Curves");
        if (this.getClass() == PjNurbsCurve.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_pCurve = new PgNurbsCurve(3);
        this.m_controlCurve = this.m_pCurve.getControlPolygon();
        this.assureInspector("Info", "_IP");
    }

    public void setDisplay(PvDisplayIf disp) {
        super.setDisplay(disp);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void initGeometry() {
        this.addGeometry((PgGeometryIf)this.m_pCurve);
        this.addGeometry((PgGeometryIf)this.m_controlCurve);
        this.selectGeometry((PgGeometryIf)this.m_controlCurve);
        this.getDisplay().getCamera().setInterest(new PdVector(0.0, 0.0, 0.0));
        if (this.m_pCurve.getDimOfVertices() == 2) {
            this.getDisplay().selectCamera(1);
        }
        this.m_pCurve.update((Object)this.m_pCurve);
    }

    public void loadGeometry(String filename) {
        PgGeometry[] geomNew = new PgLoader().loadGeometry(null, filename);
        if (geomNew == null || geomNew.length == 0 || geomNew[0] == null) {
            PsDebug.warning((String)("loading failed, file = " + filename));
            return;
        }
        if (geomNew.length > 1) {
            PsDebug.warning((String)("only first geometry used, found = " + geomNew.length));
        }
    }

    public boolean setGeometry(PgNurbsCurve curveNew) {
        if (this.m_pCurve != null) {
            this.removeGeometry((PgGeometryIf)this.m_pCurve);
        }
        this.m_pCurve = curveNew;
        this.addGeometry((PgGeometryIf)this.m_pCurve);
        this.selectGeometry((PgGeometryIf)this.m_pCurve);
        return true;
    }
}

