/*
 * Decompiled with CFR 0.152.
 */
package devNurbs.curves;

import devNurbs.curves.PgNurbsCurve;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.viewer.PvDisplay;

public class PgNurbsCurve_CP
extends PsPanel
implements ActionListener,
PsUpdateIf,
ItemListener {
    private static final long serialVersionUID = -6260599639255608046L;
    protected PgNurbsCurve m_curve;
    protected PvDisplay m_display;
    protected PgPolygonSet m_basePolygon = new PgPolygonSet();
    protected PgPolygon m_controlCurve;
    protected TextField m_tName;
    protected TextField m_tNumVertices2;
    protected TextField m_tOrder;
    protected TextField[][] m_TextFields;
    protected Label[][] m_Labels;
    protected Panel m_pDetail;
    protected Panel[] m_pTextFieldPanels;
    protected Panel[] m_pLabelPanels;
    protected Button m_bCloseCurve;
    protected Button m_showBaseFunction;
    protected PuInteger m_detail;
    protected PuInteger[] m_Scroller;
    protected Checkbox m_CBshowWeights;
    protected Checkbox m_CBmemSpeedup;
    protected Checkbox m_CBshowBF;
    private boolean isUpdateingBF;
    private int lastNumVertices = 0;
    private final int INDEX_WEIGHTVECTOR = 1;

    public PgNurbsCurve_CP() {
        this.m_basePolygon.showVertices(false);
        this.m_basePolygon.setGlobalPolygonColor(Color.black);
        this.m_display = new PvDisplay();
        this.m_display.setVisible(true);
        this.m_display.selectCamera(1);
        this.m_display.showAxes(true);
        this.m_display.setBackgroundColor(new Color(255, 255, 255));
        this.m_display.addGeometry((PgGeometryIf)this.m_basePolygon);
        this.m_display.selectGeometry((PgGeometryIf)this.m_basePolygon);
        this.m_detail = new PuInteger("detail", (PsUpdateIf)this);
        this.m_detail.setDefBounds(4, 500, 1, 10);
        this.m_detail.setDefValue(100);
        this.m_detail.init();
        this.m_pLabelPanels = new Panel[2];
        this.m_pTextFieldPanels = new Panel[2];
        this.m_TextFields = new TextField[2][];
        this.m_Labels = new Label[2][];
        this.m_Scroller = new PuInteger[2];
        int i = 0;
        while (i < this.m_Scroller.length) {
            this.m_Scroller[i] = new PuInteger(" ", (PsUpdateIf)this);
            this.m_Scroller[i].setDefBounds(0, 1, 1, 1);
            this.m_Scroller[i].setDefValue(0);
            this.m_Scroller[i].init();
            ++i;
        }
        this.m_tOrder = new TextField(4);
        this.m_tOrder.setText("3");
        this.m_tOrder.addActionListener(this);
        this.m_bCloseCurve = new Button("close curve");
        this.m_bCloseCurve.addActionListener(this);
        this.m_showBaseFunction = new Button("show base function for marked vertices");
        this.m_showBaseFunction.addActionListener(this);
        this.m_CBshowWeights = new Checkbox("show weights");
        this.m_CBshowWeights.addItemListener(this);
        this.m_CBshowWeights.setState(true);
        this.m_CBmemSpeedup = new Checkbox("memory speed up");
        this.m_CBmemSpeedup.addItemListener(this);
        this.m_CBmemSpeedup.setState(false);
        this.m_CBshowBF = new Checkbox("auto updates");
        this.m_CBshowBF.addItemListener(this);
        this.m_CBshowBF.setState(false);
        this.isUpdateingBF = false;
        this.m_tNumVertices2 = new TextField("", 7);
        this.m_tNumVertices2.addActionListener(this);
        this.m_tNumVertices2.setEnabled(false);
        if (this.getClass() == PgNurbsCurve_CP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setInsetSize(4);
        this.setBorderType(1);
        Panel pOrderPanel = new Panel(new FlowLayout());
        pOrderPanel.add(new Label("enter a new order"));
        pOrderPanel.add(this.m_tOrder);
        this.add(pOrderPanel);
        Panel pButtons = new Panel(new GridLayout(1, 1));
        this.add(pButtons);
        pButtons.add(this.m_bCloseCurve);
        this.addLine(1);
        Panel pCheckboxes = new Panel(new GridLayout(1, 2));
        this.add(pCheckboxes);
        pCheckboxes.add(this.m_CBshowWeights);
        pCheckboxes.add(this.m_CBmemSpeedup);
        this.addLine(1);
        Panel weightsPanel = new Panel(new GridLayout(4, 1));
        this.add(weightsPanel);
        int i = 0;
        while (i < this.m_pTextFieldPanels.length) {
            this.m_pTextFieldPanels[i] = new Panel(new GridLayout(1, 5));
            this.m_pLabelPanels[i] = new Panel(new GridLayout(1, 5));
            ++i;
        }
        weightsPanel.add(new Label("weights"));
        weightsPanel.add(this.m_pLabelPanels[1]);
        weightsPanel.add(this.m_pTextFieldPanels[1]);
        weightsPanel.add((Component)this.m_Scroller[1].assureInspector("Info", "_IP"));
        this.addLine(1);
        Panel knotsPanel = new Panel(new GridLayout(4, 1));
        this.add(knotsPanel);
        knotsPanel.add(new Label("knots"));
        knotsPanel.add(this.m_pLabelPanels[0]);
        knotsPanel.add(this.m_pTextFieldPanels[0]);
        knotsPanel.add((Component)this.m_Scroller[0].assureInspector("Info", "_IP"));
        this.addLine(1);
        this.m_pDetail = new PsPanel((LayoutManager)new GridLayout(1, 1));
        this.add(this.m_pDetail);
        this.m_pDetail.add((Component)this.m_detail.assureInspector("Info", "_IP"));
        this.addLine(1);
        Panel dispPanel = new Panel(new FlowLayout());
        Panel dispButtons = new Panel(new FlowLayout());
        dispButtons.add(this.m_showBaseFunction);
        dispButtons.add(this.m_CBshowBF);
        this.add(dispPanel);
        dispPanel.add(dispButtons);
        dispPanel.add((Component)this.m_display);
        this.addLine(1);
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_curve = (PgNurbsCurve)parent;
        this.m_controlCurve = this.m_curve.getControlPolygon();
        this.m_curve.initKnotVector();
        int n = this.m_controlCurve.getNumVertices();
        this.m_tNumVertices2.setText(String.valueOf(n));
        this.m_Scroller[1].setBounds(0, n > 5 ? n - 5 : 0);
        this.m_Scroller[1].setDefBounds(0, n > 5 ? n - 5 : 0, 1, 1);
        this.m_Scroller[1].init();
        int i = 0;
        while (i < 1) {
            n = this.m_curve.m_knotVector.getSize();
            this.m_Scroller[i].setBounds(0, n > 5 ? n - 5 : 0);
            this.m_Scroller[i].setDefBounds(0, n > 5 ? n - 5 : 0, 1, 1);
            this.m_Scroller[i].init();
            ++i;
        }
        this.initPanels();
        this.add((Component)this.m_curve.assureInspector("Info", "_IP"));
    }

    private void initPanels() {
        int i = 0;
        while (i < this.m_pTextFieldPanels.length) {
            this.m_pTextFieldPanels[i].removeAll();
            this.m_pLabelPanels[i].removeAll();
            ++i;
        }
        int n = this.m_curve.getNumControlPoints();
        this.m_TextFields[1] = new TextField[n > 5 ? 5 : n];
        this.m_Labels[1] = new Label[this.m_TextFields[1].length];
        int i2 = 0;
        while (i2 < this.m_TextFields[1].length) {
            this.m_Labels[1][i2] = new Label("[" + Integer.toString(i2) + "]");
            this.m_pLabelPanels[1].add(this.m_Labels[1][i2]);
            this.m_TextFields[1][i2] = new TextField(5);
            this.m_TextFields[1][i2].addActionListener(this);
            if (this.m_curve != null) {
                this.m_TextFields[1][i2].setText(String.valueOf(this.m_curve.m_controlWeights.m_data[i2]));
            }
            this.m_pTextFieldPanels[1].add(this.m_TextFields[1][i2]);
            ++i2;
        }
        this.m_curve.initKnotVector();
        i2 = 0;
        while (i2 < 1) {
            this.m_TextFields[i2] = new TextField[this.m_curve.m_knotVector.getSize() > 5 ? 5 : this.m_curve.m_knotVector.getSize()];
            this.m_Labels[i2] = new Label[this.m_TextFields[i2].length];
            int j = 0;
            while (j < this.m_TextFields[i2].length) {
                this.m_Labels[i2][j] = new Label("[" + Integer.toString(j) + "]");
                this.m_pLabelPanels[i2].add(this.m_Labels[i2][j]);
                this.m_TextFields[i2][j] = new TextField(5);
                this.m_TextFields[i2][j].addActionListener(this);
                if (this.m_curve != null) {
                    this.m_TextFields[i2][j].setText(String.valueOf(this.m_curve.m_knotVector.getEntry(j)));
                }
                this.m_pTextFieldPanels[i2].add(this.m_TextFields[i2][j]);
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_pTextFieldPanels.length) {
            this.m_pTextFieldPanels[i2].validate();
            this.m_pLabelPanels[i2].validate();
            ++i2;
        }
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        Object source = aEvent.getSource();
        if (source == this.m_bCloseCurve) {
            this.m_curve.closeCurve();
            this.m_bCloseCurve.setLabel(this.m_curve.isClosed() ? "open curve" : "close curve");
            int offset = this.m_Scroller[0].getValue();
            this.m_Scroller[0].setDefBounds(0, this.m_curve.m_knotVector.getSize() > 5 ? this.m_curve.m_knotVector.getSize() - 5 : 0, 1, 1);
            this.m_Scroller[0].init();
            this.m_Scroller[0].setValue(offset);
            this.setKnots();
            if (this.isUpdateingBF) {
                this.showBaseFunctions();
            }
        } else if (source == this.m_showBaseFunction) {
            this.showBaseFunctions();
        } else if (source == this.m_tOrder) {
            int aNumber = 0;
            try {
                aNumber = Integer.parseInt(this.m_tOrder.getText());
                this.m_curve.setOrder(aNumber);
                int offset = this.m_Scroller[0].getValue();
                this.m_Scroller[0].setDefBounds(0, this.m_curve.m_knotVector.getSize() > 5 ? this.m_curve.m_knotVector.getSize() - 5 : 0, 1, 1);
                this.m_Scroller[0].init();
                this.m_Scroller[0].setValue(offset + 5 > this.m_curve.m_knotVector.getSize() - 1 ? this.m_curve.m_knotVector.getSize() - 5 : offset);
                this.setKnots();
                if (this.isUpdateingBF) {
                    this.showBaseFunctions();
                }
            }
            catch (NumberFormatException aException) {
                PsDebug.warning((String)"Only integer numbers between 2 and 6 (inclusive) are allowed.");
            }
        } else {
            int j = 0;
            while (j < this.m_TextFields[1].length) {
                if (source == this.m_TextFields[1][j]) {
                    this.getWeightValues();
                    break;
                }
                ++j;
            }
            int i = 0;
            while (i < 1) {
                int j2 = 0;
                while (j2 < this.m_TextFields[i].length) {
                    if (source == this.m_TextFields[i][j2]) {
                        this.getKnotValues();
                        break;
                    }
                    ++j2;
                }
                ++i;
            }
        }
        if (this.isUpdateingBF && source != this.m_showBaseFunction) {
            this.showBaseFunctions();
        }
        if (this.m_curve.m_bMemSpeedUp) {
            this.m_curve.calcBaseFunctions();
        }
        this.showWeights(this.isShowingWeights());
        this.m_controlCurve.update((Object)this.m_controlCurve);
    }

    public boolean update(Object event) {
        if (event == this.m_detail) {
            this.m_curve.setDetail(this.m_detail.getValue());
            return true;
        }
        if (event == this.m_curve) {
            if (this.m_curve.getNumControlPoints() != this.lastNumVertices) {
                if (this.m_curve.getNumControlPoints() <= 5) {
                    this.initPanels();
                } else {
                    this.setWeights();
                    this.setKnots();
                }
                int i = 0;
                while (i < 1) {
                    this.m_Scroller[i].setDefBounds(0, this.m_curve.m_knotVector.getSize() > 5 ? this.m_curve.m_knotVector.getSize() - 5 : 0, 1, 1);
                    ++i;
                }
                this.m_Scroller[1].setDefBounds(0, this.m_controlCurve.getNumVertices() > 5 ? this.m_controlCurve.getNumVertices() - 5 : 0, 1, 1);
                int[] offsets = new int[this.m_Scroller.length];
                int i2 = 0;
                while (i2 < this.m_Scroller.length) {
                    offsets[i2] = this.m_Scroller[i2].getValue();
                    this.m_Scroller[i2].init();
                    this.m_Scroller[i2].setValue(offsets[i2]);
                    ++i2;
                }
                this.m_tNumVertices2.setText(String.valueOf(this.m_controlCurve.getNumVertices()));
            }
            this.lastNumVertices = this.m_curve.getNumControlPoints();
            this.showWeights(this.isShowingWeights());
            return true;
        }
        if (event == this.m_Scroller[1]) {
            this.setWeights();
            return true;
        }
        if (event == this.m_Scroller[0]) {
            this.setKnots();
            return true;
        }
        return super.update(event);
    }

    public boolean isShowingWeights() {
        return this.m_CBshowWeights.getState();
    }

    @Override
    public void itemStateChanged(ItemEvent aEvent) {
        Object source = aEvent.getSource();
        if (source == this.m_CBshowWeights) {
            this.showWeights(this.isShowingWeights());
            this.m_controlCurve.update((Object)this.m_controlCurve);
        } else if (source == this.m_CBmemSpeedup) {
            this.m_curve.m_bMemSpeedUp = this.m_CBmemSpeedup.getState();
            if (this.m_curve.m_bMemSpeedUp) {
                this.m_curve.calcBaseFunctions();
            }
        } else if (source == this.m_CBshowBF) {
            this.isUpdateingBF = this.m_CBshowBF.getState();
        }
    }

    protected void showWeights(boolean isShowingWeights) {
        if (this.isShowingWeights()) {
            int i = 0;
            while (i < this.m_controlCurve.getNumVertices()) {
                this.m_controlCurve.getVertex(i).setName("[" + i + "] " + this.m_curve.m_controlWeights.m_data[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.m_controlCurve.getNumVertices()) {
                this.m_controlCurve.getVertex(i).setName(String.valueOf(i));
                ++i;
            }
        }
    }

    private void setWeights() {
        int offset = this.m_Scroller[1].getValue();
        if (offset > this.m_controlCurve.getNumVertices() - 5 || offset < 0) {
            return;
        }
        int i = 0;
        while (i < this.m_TextFields[1].length) {
            this.m_Labels[1][i].setText("[" + Integer.toString(i + offset) + "]");
            this.m_TextFields[1][i].setText(String.valueOf(this.m_curve.m_controlWeights.m_data[i + offset]));
            ++i;
        }
        this.m_Scroller[1].init();
        this.m_Scroller[1].setValue(offset);
    }

    private void setKnots() {
        int i = 0;
        while (i < 1) {
            int offset = this.m_Scroller[i].getValue();
            if (offset > this.m_curve.m_knotVector.getSize() - 5 || offset < 0) {
                return;
            }
            int j = 0;
            while (j < this.m_TextFields[i].length) {
                this.m_Labels[i][j].setText("[" + Integer.toString(j + offset) + "]");
                this.m_TextFields[i][j].setText(String.valueOf(this.m_curve.m_knotVector.getEntry(j + offset)));
                ++j;
            }
            this.m_Scroller[i].init();
            this.m_Scroller[i].setValue(offset);
            ++i;
        }
    }

    private void getWeightValues() {
        int offset = this.m_Scroller[1].getValue();
        if (this.m_controlCurve.getNumVertices() - 5 >= 0 && (offset > this.m_controlCurve.getNumVertices() - 5 || offset < 0)) {
            return;
        }
        try {
            int i = 0;
            while (i < this.m_TextFields[1].length) {
                double tmpDouble;
                this.m_curve.m_controlWeights.m_data[i + offset] = tmpDouble = PuDouble.parseDouble((String)this.m_TextFields[1][i].getText());
                ++i;
            }
        }
        catch (NumberFormatException aException) {
            PsDebug.warning((String)"Wrong number format");
        }
        this.m_controlCurve.update((Object)this.m_controlCurve);
        this.setWeights();
    }

    private void getKnotValues() {
        try {
            int i = 0;
            while (i < 1) {
                int offset = this.m_Scroller[i].getValue();
                if (offset > this.m_curve.m_knotVector.getSize() - 5 || offset < 0) {
                    return;
                }
                int j = 0;
                while (j < this.m_TextFields[i].length) {
                    double tmpDouble = PuDouble.parseDouble((String)this.m_TextFields[i][j].getText());
                    this.m_curve.m_knotVector.setEntry(j + offset, tmpDouble);
                    ++j;
                }
                ++i;
            }
        }
        catch (NumberFormatException aException) {
            PsDebug.warning((String)"Wrong number format");
        }
        this.m_controlCurve.update((Object)this.m_controlCurve);
        this.setKnots();
    }

    private void showBaseFunctions() {
        double first = 0.0;
        double last = 0.0;
        int n = this.m_curve.getDetail();
        PiVector markedVertices = this.m_curve.m_controlPolygon.getMarkedVertices(1);
        int numMarked = markedVertices.getSize();
        if (numMarked != 0) {
            this.m_basePolygon.setNumPolygons(numMarked);
            this.m_basePolygon.setNumVertices(n * numMarked);
            PdVector[] vertices = this.m_basePolygon.getVertices();
            int i = 0;
            while (i < numMarked) {
                PiVector actPoly = new PiVector(n);
                int j = 0;
                while (j < n) {
                    actPoly.setEntry(j, i * n + j);
                    ++j;
                }
                this.m_basePolygon.setPolygon(i, actPoly);
                first = this.m_curve.m_knotVector.getFirstEntry();
                last = this.m_curve.m_knotVector.getLastEntry();
                double step = (last - first) / (double)(n - 1);
                int markInd = markedVertices.getEntry(i);
                int j2 = 0;
                while (j2 < n - 1) {
                    vertices[i * n + j2].setEntry(0, first + step * (double)j2);
                    vertices[i * n + j2].setEntry(1, this.m_curve.RBase(markInd, this.m_curve.getOrder(), first + step * (double)j2));
                    ++j2;
                }
                vertices[i * n + n - 1].setEntry(0, last);
                vertices[i * n + n - 1].setEntry(1, this.m_curve.NBase(markInd, this.m_curve.getOrder(), last));
                ++i;
            }
            this.m_display.getCamera().setInterest(new PdVector((last - first) / 2.0, 0.0, 0.0));
            this.m_display.getCamera().setDist(2.0 * (last - first));
            this.m_basePolygon.update((Object)this.m_basePolygon);
        }
    }
}

