/*
 * Decompiled with CFR 0.152.
 */
package devNurbs.curves;

import java.awt.Color;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;

public class PgNurbsCurve
extends PgPolygon
implements PsUpdateIf {
    private static final long serialVersionUID = -7489758482052935321L;
    protected static final int DEFAULT_DETAIL = 100;
    protected static final int DEFAULT_ORDER = 3;
    private int m_numControlPoints;
    private int m_order;
    protected PdVector m_knotVector;
    protected PdVector m_controlWeights;
    protected PgPolygon m_controlPolygon;
    public static final int KNOTS = 0;
    protected boolean m_bMemSpeedUp;
    private double[][] nBaseSave;

    public PgNurbsCurve(int aVertexDim) {
        super(aVertexDim);
        this.setTag(10);
        this.m_controlWeights = new PdVector();
        this.m_controlPolygon = new PgPolygon(this.m_dim);
        this.m_controlPolygon.addUpdateListener((PsUpdateIf)this);
        this.m_controlPolygon.setGlobalVertexSize(3.0);
        this.m_controlPolygon.setGlobalVertexColor(Color.green);
        this.m_controlPolygon.setGlobalEdgeSize(2.0);
        this.m_controlPolygon.setGlobalEdgeColor(Color.green);
        this.m_controlPolygon.setName("ControlPolygon");
        this.m_knotVector = new PdVector();
        this.m_numControlPoints = 0;
        this.m_order = 3;
        if (((Object)((Object)this)).getClass() == PgNurbsCurve.class) {
            this.init();
        }
    }

    public void copy(PsObject object) {
        super.copy(object);
        if (object == null) {
            return;
        }
        if (!(object instanceof PgNurbsCurve)) {
            return;
        }
        PgNurbsCurve s = (PgNurbsCurve)object;
        this.m_controlPolygon.copy((PsObject)s.m_controlPolygon);
        if (this.m_knotVector == null) {
            this.m_knotVector = new PdVector();
        }
        this.m_knotVector.setSize(s.m_knotVector.getSize());
        int i = 0;
        while (i < s.m_knotVector.getSize()) {
            this.m_knotVector.setEntry(i, s.m_knotVector.getEntry(i));
            ++i;
        }
        this.m_controlWeights.setSize(s.m_controlWeights.getSize());
        i = 0;
        while (i < s.m_controlWeights.getSize()) {
            this.m_controlWeights.setEntry(i, s.m_controlWeights.getEntry(i));
            ++i;
        }
        this.m_numControlPoints = s.getNumControlPoints();
        this.setOrder(s.getOrder());
        this.setDetail(s.getDetail());
    }

    public Object clone() {
        PgNurbsCurve clone = (PgNurbsCurve)((Object)super.clone());
        if (clone == null) {
            return null;
        }
        clone.m_controlPolygon = (PgPolygon)this.m_controlPolygon.clone();
        clone.m_controlWeights = (PdVector)this.m_controlWeights.clone();
        clone.m_numControlPoints = this.getNumControlPoints();
        clone.setOrder(this.getOrder());
        clone.setDetail(this.getDetail());
        return clone;
    }

    public void init() {
        super.init();
        this.initKnotVector();
        this.reevaluate();
        this.showVertices(false);
        this.setName("Nurbs Curve");
    }

    public boolean addControlPoint(PdVector aVertex, double aWeight) {
        if (aWeight < 0.0 || aVertex == null || aVertex.getSize() != this.getDimOfVertices() || this.isClosed()) {
            return false;
        }
        this.m_controlPolygon.setNumVertices(this.m_controlPolygon.getNumVertices() + 1);
        this.m_controlPolygon.setVertex(this.m_controlPolygon.getNumVertices() - 1, aVertex);
        this.m_controlWeights.setSize(this.m_controlPolygon.getNumVertices());
        this.m_controlWeights.setEntry(this.m_controlPolygon.getNumVertices() - 1, aWeight);
        ++this.m_numControlPoints;
        return true;
    }

    protected void initKnotVector() {
        if (this.isClosed()) {
            int n = this.m_numControlPoints + 1;
            this.m_knotVector.setSize(n);
            double actKnotVectorValue = 0.0;
            int i = 0;
            while (i < n) {
                double d = actKnotVectorValue;
                actKnotVectorValue = d + 1.0;
                this.m_knotVector.setEntry(i, d);
                ++i;
            }
        } else {
            int n = this.m_numControlPoints;
            this.m_knotVector.setSize(n + this.m_order);
            double actKnotVectorValue = 0.0;
            int i = 0;
            while (i < this.m_order) {
                this.m_knotVector.setEntry(i, actKnotVectorValue);
                ++i;
            }
            i = this.m_order;
            while (i < n) {
                this.m_knotVector.setEntry(i, actKnotVectorValue += 1.0);
                ++i;
            }
            actKnotVectorValue += 1.0;
            i = n;
            while (i < n + this.m_order) {
                this.m_knotVector.setEntry(i, actKnotVectorValue);
                ++i;
            }
        }
    }

    public void setWeights(PdVector aWeightVector) {
        this.m_controlWeights = aWeightVector;
        this.initKnotVector();
        if (this.m_bMemSpeedUp) {
            this.calcBaseFunctions();
        }
    }

    public void eval(PdVector aVertex, double t) {
        int i = 0;
        while (i < aVertex.getSize()) {
            aVertex.m_data[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.m_numControlPoints) {
            aVertex.add(this.RBase(i, this.m_order, t), this.m_controlPolygon.getVertex(i));
            ++i;
        }
    }

    public double RBase(int i, int k, double t) {
        double nominator = this.NBase(i, k, t) * this.m_controlWeights.m_data[i];
        double denominator = 0.0;
        int n = this.m_numControlPoints;
        int j = 0;
        while (j < n) {
            denominator += this.NBase(j, k, t) * this.m_controlWeights.m_data[j];
            ++j;
        }
        return this.isZero(denominator) ? 0.0 : nominator / denominator;
    }

    protected double NBase(int i, int k, double t) {
        double part2;
        double part1;
        if (k == 1) {
            if (this.isClosed()) {
                if (i >= this.m_knotVector.getSize() - 1) {
                    if (this.isZero(t - this.m_knotVector.getLastEntry()) && i == this.m_numControlPoints - 1) {
                        return 1.0;
                    }
                    if (t >= this.m_knotVector.m_data[i % this.m_numControlPoints] && t < this.m_knotVector.m_data[(i + 1) % this.m_numControlPoints]) {
                        return 1.0;
                    }
                    return 0.0;
                }
                if (this.isZero(t - this.m_knotVector.getLastEntry()) && i == this.m_numControlPoints - 1) {
                    return 1.0;
                }
                if (t >= this.m_knotVector.m_data[i] && t < this.m_knotVector.m_data[i + 1]) {
                    return 1.0;
                }
                return 0.0;
            }
            if (this.isZero(t - this.m_knotVector.getLastEntry()) && i == this.m_numControlPoints - 1) {
                return 1.0;
            }
            if (t >= this.m_knotVector.m_data[i] && t < this.m_knotVector.m_data[i + 1]) {
                return 1.0;
            }
            return 0.0;
        }
        if (this.isClosed()) {
            int modulo = this.m_numControlPoints;
            double a = t - this.m_knotVector.m_data[i];
            double b = this.m_knotVector.m_data[(i + k - 1) % modulo] - this.m_knotVector.m_data[i % modulo];
            double c = this.m_knotVector.m_data[(i + k) % modulo] - t;
            double d = this.m_knotVector.m_data[(i + k) % modulo] - this.m_knotVector.m_data[(i + 1) % modulo];
            double dist = this.m_knotVector.getLastEntry() - this.m_knotVector.getFirstEntry();
            if (a < 0.0) {
                a += dist;
            }
            if (b < 0.0) {
                b += dist;
            }
            if (c < 0.0) {
                c += dist;
            }
            if (d < 0.0) {
                d += dist;
            }
            part1 = this.isZero(b) ? 0.0 : a * this.NBase(i % modulo, k - 1, t) / b;
            part2 = this.isZero(d) ? 0.0 : c * this.NBase((i + 1) % modulo, k - 1, t) / d;
        } else {
            double a = t - this.m_knotVector.m_data[i];
            double b = this.m_knotVector.m_data[i + k - 1] - this.m_knotVector.m_data[i];
            double c = this.m_knotVector.m_data[i + k] - t;
            double d = this.m_knotVector.m_data[i + k] - this.m_knotVector.m_data[i + 1];
            part1 = this.isZero(b) ? 0.0 : a * this.NBase(i, k - 1, t) / b;
            part2 = this.isZero(d) ? 0.0 : c * this.NBase(i + 1, k - 1, t) / d;
        }
        return part1 + part2;
    }

    public double DRBase(int i, int k, double t) {
        double sum1 = 0.0;
        int j = 0;
        while (j < this.m_numControlPoints) {
            sum1 += this.NBase(i, k, t) * this.m_controlWeights.getEntry(i);
            ++j;
        }
        double sum2 = 0.0;
        int j2 = 0;
        while (j2 < this.m_numControlPoints) {
            sum2 += this.DNBase(i, k, t) * this.m_controlWeights.getEntry(i);
            ++j2;
        }
        double nominator = this.DNBase(i, k, t) * this.m_controlWeights.getEntry(i) * sum1 - this.NBase(i, k, t) * this.m_controlWeights.getEntry(i) * sum2;
        return this.isZero(sum1) ? 0.0 : nominator / (sum1 * sum1);
    }

    private double DNBase(int i, int k, double t) {
        if (k == 1) {
            return 0.0;
        }
        double a = (t - this.m_knotVector.m_data[i]) * this.DNBase(i, k - 1, t) + this.NBase(i, k - 1, t);
        double b = this.m_knotVector.m_data[i + k - 1] - this.m_knotVector.m_data[i];
        double c = (this.m_knotVector.m_data[i + k] - t) * this.DNBase(i + 1, k - 1, t) - this.NBase(i + 1, k - 1, t);
        double d = this.m_knotVector.m_data[i + k] - this.m_knotVector.m_data[i + 1];
        double part1 = this.isZero(b) ? 0.0 : a / b;
        double part2 = this.isZero(d) ? 0.0 : c / d;
        return part1 + part2;
    }

    protected void reevaluate() {
        if (this.m_numVertices == 0) {
            return;
        }
        PdVector[] vertices = this.getVertices();
        if (this.m_bMemSpeedUp) {
            PdVector[] controlVertices = this.m_controlPolygon.getVertices();
            int j = 0;
            while (j < this.m_numVertices) {
                int k = 0;
                while (k < vertices[j].getSize()) {
                    vertices[j].m_data[k] = 0.0;
                    ++k;
                }
                k = 0;
                while (k < this.m_controlPolygon.getNumVertices()) {
                    vertices[j].add(this.nBaseSave[j][k], controlVertices[k]);
                    ++k;
                }
                ++j;
            }
        }
        double last = this.m_knotVector.getLastEntry();
        double t = this.m_knotVector.getFirstEntry();
        double delta_t = (last - t) / (double)(this.getNumVertices() - 1);
        int i = 0;
        while (i < this.m_numVertices) {
            this.eval(vertices[i], t);
            t += delta_t;
            if (t >= last) {
                t = last - 1.0E-10;
            }
            ++i;
        }
    }

    public boolean removeControlPoints(int[] tmp) {
        if (this.m_controlPolygon.getNumVertices() - tmp.length < this.getOrder() - 1) {
            PsDebug.warning((String)"Too few control points to maintain current order of the curve; delete canceled!");
            return false;
        }
        PdVector tmpVec = new PdVector(this.m_controlPolygon.getNumVertices() - tmp.length);
        int i = tmp.length - 1;
        while (i >= 0) {
            if (i > tmp.length - 1) {
                i = tmp.length - 1;
            }
            this.m_controlPolygon.removeVertex(tmp[i]);
            --i;
        }
        int k = 0;
        int i2 = 0;
        while (i2 < this.m_controlWeights.getSize()) {
            if (k < tmp.length && i2 == tmp[k]) {
                ++k;
            } else {
                tmpVec.m_data[i2 - k] = this.m_controlWeights.m_data[i2];
            }
            ++i2;
        }
        this.m_controlWeights = tmpVec;
        this.setNumControlPoints(this.getNumControlPoints() - tmp.length);
        this.initKnotVector();
        return true;
    }

    private boolean isZero(double aNumber) {
        return Math.abs(aNumber) < 1.0E-10;
    }

    public boolean update(Object event) {
        if (event == this.m_controlPolygon) {
            if (this.m_controlPolygon.getNumVertices() < this.m_order) {
                this.setNumVertices(0);
            } else if (this.getNumVertices() == 0) {
                this.setNumVertices(100);
            }
            this.repairKnotVector();
            this.repairWeightVector();
            if (this.m_bMemSpeedUp && (this.getNumVertices() != this.nBaseSave.length || this.nBaseSave.length > 0 && this.m_controlPolygon.getNumVertices() != this.nBaseSave[0].length)) {
                this.calcBaseFunctions();
            }
            this.reevaluate();
            return this.update((Object)this);
        }
        return super.update(event);
    }

    protected void repairKnotVector() {
        if (this.m_controlWeights.getSize() + (this.isClosed() ? 1 : this.m_order) != this.m_knotVector.getSize()) {
            this.initKnotVector();
        }
    }

    protected void repairWeightVector() {
        if (this.m_controlWeights.getSize() != this.m_controlPolygon.getNumVertices()) {
            int maxNumWeights = this.m_controlWeights.getSize();
            int maxNumControlPoints = this.m_controlPolygon.getNumVertices();
            int i = 0;
            PdVector newWeights = new PdVector(maxNumControlPoints);
            while (i < maxNumWeights && i < maxNumControlPoints) {
                newWeights.m_data[i] = this.m_controlWeights.m_data[i];
                ++i;
            }
            while (i < maxNumControlPoints) {
                newWeights.m_data[i] = 1.0;
                ++i;
            }
            this.m_numControlPoints = maxNumControlPoints;
            this.setWeights(newWeights);
        }
    }

    public void setDetail(int aNumber) {
        if (aNumber <= 4) {
            this.setNumVertices(4);
            return;
        }
        this.setNumVertices(aNumber);
        this.update(this.m_controlPolygon);
    }

    public int getDetail() {
        return this.getNumVertices();
    }

    public PgPolygon getControlPolygon() {
        return this.m_controlPolygon;
    }

    public int getNumControlPoints() {
        return this.m_numControlPoints;
    }

    public void setNumControlPoints(int aInteger) {
        if (aInteger < 0) {
            aInteger = 0;
        }
        this.m_numControlPoints = aInteger;
    }

    public void setKnotVector(PdVector newKnotVector) {
        if (newKnotVector.getSize() != this.m_numControlPoints + (this.isClosed() ? 1 : this.m_order)) {
            PsDebug.warning((String)"Argument vector does not match required length");
            return;
        }
        double last = newKnotVector.getFirstEntry();
        int counter = 1;
        while (counter < newKnotVector.getSize() && last <= newKnotVector.getEntry(counter)) {
            last = newKnotVector.getEntry(counter);
            ++counter;
        }
        if (counter < newKnotVector.getSize() - 1) {
            PsDebug.warning((String)"Argument vector entries are not monotonically increasing");
            return;
        }
        this.m_knotVector = newKnotVector;
        if (this.m_bMemSpeedUp) {
            this.calcBaseFunctions();
        }
    }

    public PdVector getControlPointWeights() {
        return this.m_controlWeights;
    }

    public PdVector[] getControlPoints() {
        return this.m_controlPolygon.getVertices();
    }

    public PdVector getKnotVector() {
        return this.m_knotVector;
    }

    public int getOrder() {
        return this.m_order;
    }

    public void setOrder(int aOrder) {
        if (aOrder < 1 || aOrder > 6) {
            PsDebug.warning((String)"Entered order is to small/big. Only 1,...,6 are allowed!");
        } else {
            this.m_order = aOrder;
            this.initKnotVector();
            this.update(this.m_controlPolygon);
        }
    }

    public void closeCurve() {
        this.setClosed(!this.isClosed());
        this.m_controlPolygon.setClosed(!this.m_controlPolygon.isClosed());
        this.initKnotVector();
    }

    public void useMemorySpeedup(boolean memSpeedUp) {
        this.m_bMemSpeedUp = memSpeedUp;
    }

    protected void calcBaseFunctions() {
        this.nBaseSave = new double[this.getNumVertices()][this.m_controlPolygon.getNumVertices()];
        double last = this.m_knotVector.getLastEntry();
        double s = this.m_knotVector.getFirstEntry();
        double delta_s = (last - s) / (double)(this.getNumVertices() - 1);
        double denominator = 0.0;
        int i = 0;
        while (i < this.nBaseSave.length) {
            denominator = 0.0;
            int l = 0;
            while (l < this.m_controlPolygon.getNumVertices()) {
                denominator += this.NBase(l, this.m_order, s) * this.m_controlWeights.m_data[l];
                ++l;
            }
            int k = 0;
            while (k < this.m_controlPolygon.getNumVertices()) {
                this.nBaseSave[i][k] = this.isZero(denominator) ? 0.0 : this.RBase(k, this.m_order, s) / denominator;
                ++k;
            }
            if ((s += delta_s) >= last) {
                s = last - 1.0E-10;
            }
            ++i;
        }
    }
}

