/*
 * Decompiled with CFR 0.152.
 */
package devGraph;

import devGraph.PgGraphOnElementSet;
import devGraph.PnAbstractGraph;
import devGraph.PnGraphOnElementSet;
import jv.geom.PgElementSet;
import jv.number.PuBoolean;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PvDisplayIf;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;

public class PwGraphBuilder
extends PjWorkshop {
    private PgElementSet m_geom;
    protected PuBoolean m_shortestCutGraph = new PuBoolean("Find shortest cut graph");
    private PiVector m_fixedVertices;
    private PgGraphOnElementSet m_cutGraph;
    private PgGraphOnElementSet m_elementTree;

    public PwGraphBuilder(String name) {
        super(name);
        if (((Object)((Object)this)).getClass() == PwGraphBuilder.class) {
            this.init();
        }
    }

    public PwGraphBuilder(String name, PgElementSet geom) {
        this(name);
        this.setGeometry((PgGeometry)geom);
    }

    public void init() {
        super.init();
        this.m_shortestCutGraph.setDefState(true);
        this.m_shortestCutGraph.init();
    }

    public void setGeometry(PgGeometry geom) {
        if (geom == null || !(geom instanceof PgElementSet)) {
            PsDebug.warning((String)"Geom is not an PgElementSet.");
            return;
        }
        super.setGeometry(geom);
        this.m_geom = (PgElementSet)geom;
    }

    public void setDisplay(PvDisplayIf display) {
        super.setDisplay(display);
    }

    public boolean update(Object event) {
        return super.update(event);
    }

    public String getName() {
        return "GraphBuilder workshop";
    }

    public void start() {
        this.m_elementTree = new PgGraphOnElementSet(this.m_geom, 1);
        if (this.m_shortestCutGraph.getState()) {
            if (this.m_fixedVertices == null) {
                this.m_fixedVertices = new PiVector();
            }
            this.m_cutGraph = PnGraphOnElementSet.makeShortestCutGraph(this.m_geom, null, this.m_fixedVertices);
            PgGraphOnElementSet graph = PnGraphOnElementSet.makeDualGraph(this.m_cutGraph);
            PnAbstractGraph.makeShortestPathTree(this.m_elementTree, graph, 0);
        } else {
            PnGraphOnElementSet.makeShortestPathTree(this.m_elementTree);
            this.m_cutGraph = PnGraphOnElementSet.makeDualGraph(this.m_elementTree);
        }
        this.m_elementTree.setName("Tree");
    }

    public void setFixedVertices(PiVector fixedVertices) {
        this.m_fixedVertices = fixedVertices;
    }

    public PgGraphOnElementSet getElementTree() {
        return this.m_elementTree;
    }

    public PgGraphOnElementSet getCutGraph() {
        return this.m_cutGraph;
    }
}

