/*
 * Decompiled with CFR 0.152.
 */
package devGraph;

import devGraph.PgGraphOnElementSet;
import devGraph.PnAbstractGraph;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.util.PuPriorityQueue;

public class PnGraphOnElementSet {
    public static final int ELEMENT_BASED = 1;
    public static final int VERTEX_BASED = 0;

    public static void makeShortestPathTree(PgGraphOnElementSet outTree) {
        PnGraphOnElementSet.makeShortestPathTree(outTree, new PiVector(1), true, null, null);
    }

    public static void makeShortestPathTree(PgGraphOnElementSet outTree, int root) {
        PnGraphOnElementSet.makeShortestPathTree(outTree, new PiVector(new int[]{root}), true, null, null);
    }

    public static void makeShortestPathTree(PgGraphOnElementSet outTree, PiVector roots, boolean forceMaximalTree, PiVector successors, PdVector distances) {
        PgGraphOnElementSet domain = new PgGraphOnElementSet(outTree.getGeometry(), outTree.getBasedOn());
        PnGraphOnElementSet.makeConnectivityGraph(domain);
        PnAbstractGraph.makeShortestPathTree(outTree, domain, roots, forceMaximalTree, successors, distances);
    }

    public static void makeMinimalSpanningTree(PgGraphOnElementSet outTree, PgElementSet geom, int basedOn) {
        PnGraphOnElementSet.makeMinimalSpanningTree(outTree, geom, basedOn, new PiVector(1), true, null);
    }

    public static void makeMinimalSpanningTree(PgGraphOnElementSet outTree, PgElementSet geom, int basedOn, int root) {
        PnGraphOnElementSet.makeMinimalSpanningTree(outTree, geom, basedOn, new PiVector(new int[]{root}), true, null);
    }

    public static void makeMinimalSpanningTree(PgGraphOnElementSet outTree, PgElementSet geom, int basedOn, PiVector roots, boolean forceMaximalTree, PiVector successors) {
        PgGraphOnElementSet domain = new PgGraphOnElementSet(geom, basedOn);
        PnGraphOnElementSet.makeConnectivityGraph(domain);
        PnAbstractGraph.makeMinimalSpanningTree(outTree, domain, roots, forceMaximalTree, successors);
    }

    public static void makeSteinerTreeDNH(PgGraphOnElementSet outTree, PgElementSet geom, int basedOn, int root, PiVector terminals) {
        PgGraphOnElementSet domain = new PgGraphOnElementSet(geom, basedOn);
        PnGraphOnElementSet.makeConnectivityGraph(domain);
        PnAbstractGraph.makeSteinerTreeDNH(outTree, domain, terminals, root);
    }

    public static void makeConnectivityGraph(PgGraphOnElementSet domain) {
        PiVector[] esNeighbours = domain.getElementSetNeighbours();
        int numNodes = domain.getNumNodes();
        int i = 0;
        while (i < numNodes) {
            PiVector neighbours = domain.getNeighbours(i);
            neighbours.setSize(esNeighbours[i].getSize());
            neighbours.copy(esNeighbours[i]);
            ++i;
        }
        PnGraphOnElementSet.makeEdgeWeightsFromLength(domain);
    }

    public static void makeEdgeWeightsFromLength(PgGraphOnElementSet graph) {
        PgElementSet geom = graph.m_geom;
        int numNodes = graph.getNumNodes();
        int basedOn = graph.getBasedOn();
        PdVector[] weights = new PdVector[numNodes];
        int n = 0;
        while (n < numNodes) {
            PdVector node = basedOn == 1 ? geom.getCenterOfElement(null, n) : geom.getVertex(n);
            PiVector neighbours = graph.getNeighbours(n);
            int numNeighb = neighbours.getSize();
            weights[n] = new PdVector(numNeighb);
            int i = 0;
            while (i < numNeighb) {
                int nn = neighbours.m_data[i];
                if (nn >= 0) {
                    double distance;
                    PdVector nNode = basedOn == 1 ? geom.getCenterOfElement(null, nn) : geom.getVertex(nn);
                    weights[n].m_data[i] = distance = node.dist(nNode);
                }
                ++i;
            }
            ++n;
        }
        graph.setEdgeWeights(weights);
    }

    public static PgGraphOnElementSet makeShortestCutGraph(PgElementSet geom, PdVector[] edgeWeights, PiVector basePoints) {
        basePoints = PnGraphOnElementSet.mergeBasePoints(geom, basePoints);
        PgEdgeStar[] edge = geom.getEdgeStars() != null ? geom.getEdgeStars() : geom.makeEdgeStars();
        PdVector dist = new PdVector();
        PgGraphOnElementSet tree = new PgGraphOnElementSet(geom, 0);
        tree.setEdgeWeights(edgeWeights);
        PnGraphOnElementSet.makeShortestPathTree(tree, basePoints, true, null, dist);
        tree.setName("shortest cut graph with stubs");
        PdVector edgeWeight = new PdVector(edge.length);
        int e = 0;
        while (e < edge.length) {
            if (edge[e].getValence() == 1) {
                edgeWeight.m_data[e] = 0.0;
            } else {
                int v1 = edge[e].getVertexInd(0);
                int v2 = edge[e].getVertexInd(1);
                edgeWeight.m_data[e] = PdVector.dist((PdVector)geom.getVertex(v1), (PdVector)geom.getVertex(v2)) + dist.getEntry(v1) + dist.getEntry(v2);
            }
            ++e;
        }
        PgGraphOnElementSet dual = PnGraphOnElementSet.makeDualGraph(tree);
        PnAbstractGraph.removeStubs(dual, null);
        dual.setName("dual");
        int numEdges = edge.length;
        int numElements = geom.getNumElements();
        double max = edgeWeight.max();
        PdVector[] newEdgeWeights = PdVector.realloc(null, (int)numElements);
        PiVector[] esNeighbours = geom.getNeighbours();
        int elem = 0;
        while (elem < numElements) {
            newEdgeWeights[elem].setSize(esNeighbours[elem].getSize());
            ++elem;
        }
        int e2 = 0;
        while (e2 < numEdges) {
            int e22;
            int e1;
            if (edge[e2].getValence() == 2 && dual.isAdjacent(e1 = edge[e2].getElementInd(0), e22 = edge[e2].getElementInd(1))) {
                double weight;
                newEdgeWeights[e1].m_data[dual.getNeighbours((int)e1).getIndexOf((int)e22)] = weight = max - edgeWeight.m_data[e2];
                newEdgeWeights[e22].m_data[dual.getNeighbours((int)e22).getIndexOf((int)e1)] = weight;
            }
            ++e2;
        }
        PgGraphOnElementSet dualTree = new PgGraphOnElementSet(geom, 1);
        dual.setEdgeWeights(newEdgeWeights);
        PnAbstractGraph.makeMinimalSpanningTree(dualTree, dual, null, true, null);
        dualTree.setName("dualTree");
        tree.convertToGraph();
        int e3 = 0;
        while (e3 < numEdges) {
            int e1 = edge[e3].getElementInd(0);
            int e23 = edge[e3].getElementInd(1);
            if (e1 >= 0 && e23 >= 0 && dual.isAdjacent(e1, e23) && !dualTree.isAdjacent(e1, e23)) {
                int v1 = edge[e3].getVertexInd(0);
                int v2 = edge[e3].getVertexInd(1);
                tree.addEdge(v1, v2);
            }
            ++e3;
        }
        PnAbstractGraph.removeStubs(tree, basePoints);
        return tree;
    }

    public static PiVector mergeBasePoints(PgElementSet geom, PiVector basePoints) {
        geom.markBoundary();
        int numBV = geom.getNumBoundaryVertices();
        int numVertices = geom.getNumVertices();
        PiVector bv = new PiVector(numBV + basePoints.getSize());
        int size = basePoints.getSize();
        if (size > 0) {
            System.arraycopy(basePoints.m_data, 0, bv.m_data, 0, size);
        }
        int ind = size;
        int i = 0;
        while (i < numVertices) {
            if (geom.hasTagVertex(i, 14)) {
                bv.m_data[ind++] = i;
            }
            ++i;
        }
        return bv;
    }

    public static PgPolygonSet makeLoopPolygonSet(PgGraphOnElementSet graph, int root) {
        PgElementSet geom = graph.getGeometry();
        int numElements = geom.getNumElements();
        PiVector[] cycles = PnAbstractGraph.makeLoops(graph, root, true);
        int dim = graph.getBasedOn() == 1 ? geom.getNumElements() : geom.getNumVertices();
        PgPolygonSet polySet = new PgPolygonSet(dim);
        polySet.setNumVertices(graph.getNumNodes());
        polySet.showVertices(false);
        polySet.setName("Loops in " + graph.getName());
        if (graph.m_basedOn == 0) {
            polySet.setVertices(geom.getVertices());
        } else {
            PdVector[] vertices = new PdVector[numElements];
            int i = 0;
            while (i < numElements) {
                vertices[i] = PgGeometry.getCenterOfElement(null, (PdVector[])geom.getVertices(), (int[])geom.getElement((int)i).m_data);
                ++i;
            }
            polySet.setVertices(vertices);
        }
        polySet.setNumPolygons(cycles.length);
        if (cycles.length != 0) {
            polySet.setPolygons(cycles);
        }
        return polySet;
    }

    public static boolean validate(PgGraphOnElementSet graph, boolean bShowInfo) {
        int numNodes = graph.getNumNodes();
        if (bShowInfo) {
            PsDebug.message((String)"");
            PsDebug.message((String)("Validation of " + graph.getName() + ":"));
            String base = graph.m_basedOn == 1 ? "element" : "vertex";
            PsDebug.message((String)("Graph is " + (graph.isTree() ? "a tree." : "not a tree.")));
            PsDebug.message((String)("Graph is " + base + "-based"));
            PsDebug.message((String)("Graph has " + graph.countEdges() + " edges."));
            if (graph.isTree()) {
                PsDebug.message((String)("Graph has " + graph.getRoots().getSize() + " roots: " + graph.getRoots().toShortString()));
            }
        }
        boolean correct = true;
        if (graph.isTree()) {
            int i = 0;
            while (i < numNodes) {
                if (!graph.isRoot(i) && !graph.isIsolated(i)) {
                    if (graph.getNeighbours((int)i).m_data[0] < 0 || graph.getNeighbours((int)i).m_data[0] >= numNodes) {
                        PsDebug.message((String)("Invalid parent: parent of vertex " + i + " is " + graph.getNeighbours((int)i).m_data[0]));
                        correct = false;
                    } else {
                        int parent = graph.getParent(i);
                        if (graph.getNeighbours(parent).getIndexOf(i) == -1) {
                            PsDebug.message((String)("Parent of node " + i + " is " + parent + "." + "Children of node " + parent + " are " + graph.getNeighbours(parent).toShortString()));
                            correct = false;
                        }
                        if (!graph.isRoot(parent) && graph.m_neighbour[parent].getIndexOf(i) == 0) {
                            PsDebug.message((String)("Node " + i + " and " + parent + " are parent of each other."));
                            PsDebug.message((String)("node " + i + ": " + graph.getNeighbours(i).toShortString() + "node " + parent + ":" + graph.getNeighbours(parent).toShortString()));
                            correct = false;
                        }
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < numNodes) {
                PiVector neigh = graph.getNeighbours(i);
                int size = neigh.getSize();
                int j = 0;
                while (j < size) {
                    if (neigh.m_data[j] < 0 || neigh.m_data[j] >= numNodes) {
                        PsDebug.message((String)("wrong neighbourhood at vertex " + i + ": " + neigh.toShortString()));
                        correct = false;
                    }
                    if (graph.m_neighbour[neigh.getEntry(j)].getIndexOf(i) < 0) {
                        PsDebug.message((String)("node " + neigh.getEntry(j) + " is neighbour of node " + i + ", but not vice versa."));
                        PsDebug.message((String)("neighbourhood(" + i + ")" + neigh.toShortString()));
                        PsDebug.message((String)("neighbourhood(" + neigh.getEntry(j) + ")" + graph.m_neighbour[neigh.getEntry(j)].toShortString()));
                        correct = false;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (correct && bShowInfo) {
            PsDebug.message((String)"graph is correct.");
        }
        if (!correct) {
            PsDebug.message((String)"graph is not correct.");
        }
        return correct;
    }

    public static PgGraphOnElementSet makeDualGraph(PgGraphOnElementSet graph) {
        if (graph == null) {
            PsDebug.warning((String)"Void input!");
            return null;
        }
        int basedOn = graph.getBasedOn();
        PgGraphOnElementSet dual = new PgGraphOnElementSet(graph.m_geom, 1 - basedOn);
        dual.setName("Dual of " + graph.getName());
        int numNodes = dual.getNumNodes();
        PgElementSet geom = graph.m_geom;
        PiVector incidentElements = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        PgVertexStar star = new PgVertexStar();
        int i = 0;
        while (i < numNodes) {
            int j;
            PiVector neighbours = dual.getElementSetNeighbours()[i];
            int size = neighbours.getSize();
            if (basedOn == 0) {
                PiVector element = geom.getElement(i);
                int dim = element.getSize();
                j = 0;
                while (j < size) {
                    int v1 = element.m_data[(j + 1) % dim];
                    int v2 = element.m_data[(j + 2) % dim];
                    if (!graph.isAdjacent(v1, v2)) {
                        dual.addEdge(i, neighbours.m_data[j]);
                    }
                    ++j;
                }
            } else {
                star.makeVertexStar(geom, i, incidentElements.m_data[i]);
                int starsize = star.getSize();
                int numLoops = star.isClosed() ? starsize : starsize - 1;
                j = 0;
                while (j < numLoops) {
                    int ind2;
                    int ind1 = star.getElement().getEntry(j);
                    if (!graph.isAdjacent(ind1, ind2 = star.getElement().getEntry((j + 1) % starsize))) {
                        dual.addEdge(i, star.getLink().getEntry((j + 1) % starsize));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return dual;
    }

    public static PiVector makeShortestPath(PgElementSet geom, int startV, int endV, int basedOn) {
        if (basedOn == 1) {
            return PnAbstractGraph.makeShortestPath(new PgGraphOnElementSet(geom, basedOn), startV, endV);
        }
        int numV = geom.getNumVertices();
        PuPriorityQueue queue = new PuPriorityQueue(numV);
        queue.enqueue(startV, 0.0);
        PiVector parents = new PiVector(numV);
        parents.m_data[startV] = 1;
        PgVertexStar star = new PgVertexStar();
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        while (!queue.isEmpty()) {
            double value = queue.getKeyOfMin();
            int node = queue.extractMin();
            star.makeVertexStar(geom, node, elementPerVertex.m_data[node]);
            PiVector neighb = star.getLink();
            int numNeighb = neighb.getSize();
            int i = 0;
            while (i < numNeighb) {
                int n = neighb.m_data[i];
                if (parents.m_data[n] <= 0) {
                    double edgeLen = geom.getVertex(node).dist(geom.getVertex(n));
                    queue.enqueueOrDecrease(n, value + edgeLen);
                    parents.m_data[n] = node + 2;
                    if (n == endV) {
                        int k = n;
                        int count = 0;
                        while (parents.m_data[k] >= 2) {
                            k = parents.m_data[k] - 2;
                            ++count;
                        }
                        PiVector path = new PiVector(++count);
                        k = n;
                        while (parents.m_data[k] >= 2) {
                            path.m_data[--count] = k;
                            k = parents.m_data[k] - 2;
                        }
                        path.m_data[--count] = k;
                        return path;
                    }
                }
                ++i;
            }
        }
        return null;
    }
}

