/*
 * Decompiled with CFR 0.152.
 */
package devGraph;

import dev.vecmath.PiDynVector;
import devGraph.PgAbstractGraph;
import java.util.Enumeration;
import java.util.Vector;
import jv.object.PsDebug;
import jv.vecmath.PbVector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.util.PuPriorityQueue;
import jvx.util.PuQueue;

public class PnAbstractGraph {
    private static final int EMPTY = -2;
    private static final int ROOT = -3;

    public static void removeStubs(PgAbstractGraph graph, PiVector keepNodes) {
        int numNodes = graph.getNumNodes();
        PbVector markedNodes = new PbVector(numNodes);
        if (keepNodes != null) {
            int numKept = keepNodes.getSize();
            int n = 0;
            while (n < numKept) {
                markedNodes.m_data[keepNodes.m_data[n]] = true;
                ++n;
            }
        }
        int i = 0;
        while (i < numNodes) {
            if (!markedNodes.m_data[i]) {
                PnAbstractGraph.removeStub(graph, i, markedNodes);
            }
            ++i;
        }
    }

    public static void removeStub(PgAbstractGraph graph, int index, PbVector markedNodes) {
        PiVector neigh = graph.getNeighbours(index);
        if (neigh.getSize() == 1) {
            int next = neigh.getFirstEntry();
            graph.removeEdge(next, index);
            if (!markedNodes.m_data[next]) {
                PnAbstractGraph.removeStub(graph, next, markedNodes);
            }
        }
    }

    public static PiVector makeSuccessors(PgAbstractGraph graph) {
        if (graph == null || graph.getRoots() == null) {
            PsDebug.warning((String)"Need graph with roots.");
            return null;
        }
        int numNodes = graph.getNumNodes();
        PiVector successors = new PiVector(numNodes);
        successors.setConstant(-1);
        PuQueue queue = new PuQueue(numNodes);
        PiVector roots = graph.getRoots();
        int numRoots = roots.getSize();
        int i = 0;
        while (i < numRoots) {
            queue.enqueue(roots.m_data[i]);
            ++i;
        }
        int last = -1;
        while (!queue.isEmpty()) {
            int n = queue.extractFirst();
            if (last != -1) {
                successors.m_data[last] = n;
            }
            last = n;
            PiVector children = graph.getChildren(n);
            int numChildren = children.getSize();
            int i2 = 0;
            while (i2 < numChildren) {
                queue.enqueue(children.m_data[i2]);
                ++i2;
            }
        }
        return successors;
    }

    public static PiVector makePredecessor(PiVector successor) {
        int numNodes = successor.getSize();
        PiVector predecessor = new PiVector(numNodes);
        predecessor.setConstant(-1);
        int i = 0;
        while (i < numNodes) {
            if (successor.m_data[i] != -1) {
                predecessor.m_data[successor.m_data[i]] = i;
            }
            ++i;
        }
        return predecessor;
    }

    public static void makeMinimalSpanningTree(PgAbstractGraph outTree, PgAbstractGraph domain, int root) {
        PnAbstractGraph.makeMinimalSpanningTree(outTree, domain, new PiVector(new int[]{root}), true, null);
    }

    public static void makeShortestPathTree(PgAbstractGraph outTree, PgAbstractGraph domain, int root) {
        if (root < 0) {
            PnAbstractGraph.makeShortestPathTree(outTree, domain, new PiVector(new int[1]), true, null, null);
        } else {
            PnAbstractGraph.makeShortestPathTree(outTree, domain, new PiVector(new int[]{root}), true, null, null);
        }
    }

    public static void makeShortestPathTree(PgAbstractGraph outTree, PgAbstractGraph domain, PiVector roots, boolean forceMaximalTree, PiVector successors, PdVector distances) {
        if (domain.getEdgeWeights() == null) {
            PnAbstractGraph.makeCombinatoricEdgeWeights(domain);
        }
        PnAbstractGraph.makeSubforest(outTree, domain, roots, forceMaximalTree, successors, distances, false);
    }

    public static void makeCombinatoricEdgeWeights(PgAbstractGraph graph) {
        graph.allocateEdgeWeights();
        PdVector[] ew = graph.getEdgeWeights();
        int num = ew.length;
        int i = 0;
        while (i < num) {
            ew[i].setConstant(1.0);
            ++i;
        }
    }

    public static void makeMinimalSpanningTree(PgAbstractGraph outTree, PgAbstractGraph domain, PiVector roots, boolean forceMaximalTree, PiVector successors) {
        if (domain.getEdgeWeights() == null) {
            PnAbstractGraph.makeCombinatoricEdgeWeights(domain);
        }
        PnAbstractGraph.makeSubforest(outTree, domain, roots, forceMaximalTree, successors, null, true);
    }

    /*
     * Unable to fully structure code
     */
    private static void makeSubforest(PgAbstractGraph outTree, PgAbstractGraph domain, PiVector roots, boolean forceMaximalTree, PiVector successors, PdVector distances, boolean makeMinimalSpanningTree) {
        if (outTree == null) {
            PsDebug.message((String)"Missing tree.");
            return;
        }
        v0 = providedRoots = roots == null ? 0 : roots.getSize();
        if (providedRoots == 0 && !forceMaximalTree) {
            return;
        }
        numNodes = domain.getNumNodes();
        newRoot = new PiDynVector();
        if (successors != null) {
            successors.setSize(numNodes);
            successors.setConstant(-1);
        }
        queue = new PuPriorityQueue(numNodes);
        if (providedRoots == 0) {
            queue.enqueue(0, 0.0);
            newRoot.appendEntry(0);
        } else {
            i = 0;
            while (i < providedRoots) {
                root = roots.getEntry(i);
                queue.enqueue(root, 0.0);
                newRoot.appendEntry(root);
                ++i;
            }
        }
        newNeighbours = PiVector.realloc(null, (int)numNodes, (int)0);
        edgeWeights = domain.getEdgeWeights();
        dijkstraDistance = distances;
        if (!makeMinimalSpanningTree) {
            if (distances == null) {
                dijkstraDistance = new PdVector(numNodes);
            } else {
                dijkstraDistance.setSize(numNodes);
                dijkstraDistance.setConstant(0.0);
            }
        }
        nextRoot = 0;
        lastElement = 0;
        handled = new PbVector(numNodes);
        ** GOTO lbl82
        {
            node = queue.extractMin();
            handled.m_data[node] = true;
            if (newNeighbours[node].getSize() == 1) {
                parent = newNeighbours[node].m_data[0];
                newNeighbours[parent].addEntry(node);
            }
            if (successors != null) {
                successors.m_data[lastElement] = node;
            }
            lastElement = node;
            neighbour = domain.getNeighbours(node);
            numNeighbours = neighbour.getSize();
            i = 0;
            while (i < numNeighbours) {
                child = neighbour.m_data[i];
                if (child >= 0 && !handled.m_data[child]) {
                    key = 0.0;
                    if (edgeWeights != null) {
                        key = edgeWeights[node].m_data[i];
                        if (!makeMinimalSpanningTree) {
                            key += dijkstraDistance.m_data[node];
                        }
                    }
                    if (enqueued = queue.enqueueOrDecrease(child, key)) {
                        if (!makeMinimalSpanningTree) {
                            dijkstraDistance.m_data[child] = key;
                        }
                        if (newNeighbours[child].getSize() == 0) {
                            newNeighbours[child].setSize(1);
                        }
                        newNeighbours[child].setEntry(0, node);
                    }
                }
                ++i;
            }
            do {
                if (!queue.isEmpty()) continue block1;
                if (!forceMaximalTree) continue;
                while (nextRoot < numNodes && handled.m_data[nextRoot]) {
                    ++nextRoot;
                }
                if (nextRoot >= numNodes) break block1;
                queue.enqueue(nextRoot, 0.0);
                if (!makeMinimalSpanningTree) {
                    dijkstraDistance.m_data[nextRoot] = 0.0;
                }
                newRoot.appendEntry(nextRoot);
lbl82:
                // 3 sources

            } while (!queue.isEmpty());
        }
        outTree.setName("Tree on " + domain.getName());
        outTree.setNumNodes(numNodes);
        outTree.setEdges(newNeighbours, newRoot.toPiVector());
    }

    /*
     * Unable to fully structure code
     */
    public static void makeSubtree(PgAbstractGraph outTree, PgAbstractGraph domain, PiVector roots) {
        if (outTree == null) {
            PsDebug.message((String)"Missing tree.");
            return;
        }
        numNodes = domain.getNumNodes();
        newRoot = new PiVector(0);
        queue = new PuQueue(numNodes);
        v0 = providedRoots = roots == null ? 0 : roots.getSize();
        if (providedRoots == 0) {
            queue.enqueue(0);
            newRoot.addEntry(0);
        } else {
            queue.enqueue(roots.getFirstEntry());
            newRoot.addEntry(roots.getFirstEntry());
        }
        newNeighbours = PiVector.realloc(null, (int)numNodes, (int)0);
        ** GOTO lbl41
        {
            node = queue.extractFirst();
            neighbour = domain.getNeighbours(node);
            i = 0;
            while (i < neighbour.getSize()) {
                child = neighbour.m_data[i];
                if (child >= 0 && newNeighbours[child].getSize() == 0) {
                    queue.enqueue(child);
                    newNeighbours[child].addEntry(node);
                    newNeighbours[node].addEntry(child);
                }
                ++i;
            }
            do {
                if (!queue.isEmpty()) continue block0;
                while (providedRoots > 0 && (roots.getEntry(providedRoots - 1) < 0 || roots.getEntry(providedRoots - 1) >= numNodes || newNeighbours[roots.getEntry(providedRoots - 1)].getSize() > 0 || newRoot.getIndexOf(roots.getEntry(providedRoots - 1)) >= 0)) {
                    --providedRoots;
                }
                if (providedRoots <= 0) continue;
                root = roots.getEntry(providedRoots - 1);
                queue.enqueue(root);
                newRoot.addEntry(root);
lbl41:
                // 3 sources

            } while (!queue.isEmpty());
        }
        outTree.setName("Tree on " + domain.getName());
        outTree.setNumNodes(numNodes);
        outTree.setEdges(newNeighbours, newRoot);
    }

    public static PiVector[] splitToPolygons(PgAbstractGraph graph, PbVector terminals) {
        PiVector[] neighbours = graph.m_neighbour;
        int numNodes = graph.getNumNodes();
        Vector<PiVector> polygons = new Vector<PiVector>();
        PbVector[] handled = new PbVector[numNodes];
        int n = 0;
        while (n < numNodes) {
            handled[n] = new PbVector(neighbours[n].getSize());
            ++n;
        }
        n = 0;
        while (n < numNodes) {
            int numOutgoingPolygons = neighbours[n].getSize();
            if (numOutgoingPolygons != 0 && (terminals != null && terminals.m_data[n] || numOutgoingPolygons != 2)) {
                int i = 0;
                while (i < numOutgoingPolygons) {
                    if (!handled[n].m_data[i]) {
                        PiDynVector poly = new PiDynVector();
                        int actNode = n;
                        int locNeighbour = i;
                        int nextNode = neighbours[n].m_data[i];
                        poly.appendEntry(actNode);
                        poly.appendEntry(nextNode);
                        while (!(neighbours[nextNode].getSize() != 2 || terminals != null && terminals.m_data[nextNode])) {
                            locNeighbour = neighbours[nextNode].m_data[0] == actNode ? 1 : 0;
                            actNode = nextNode;
                            nextNode = neighbours[nextNode].m_data[locNeighbour];
                            poly.appendEntry(nextNode);
                        }
                        handled[n].m_data[i] = true;
                        int j = neighbours[nextNode].getIndexOf(actNode);
                        if (j < 0) {
                            PsDebug.warning((String)"Graph is not symmetric");
                            return null;
                        }
                        handled[nextNode].m_data[j] = true;
                        polygons.addElement(poly.toPiVector());
                    }
                    ++i;
                }
            }
            ++n;
        }
        int numPolies = polygons.size();
        PiVector[] out = new PiVector[numPolies];
        Enumeration enm = polygons.elements();
        int p = 0;
        while (p < numPolies) {
            out[p] = (PiVector)enm.nextElement();
            ++p;
        }
        return out;
    }

    public static void makeSteinerTreeDNH(PgAbstractGraph outTree, PgAbstractGraph domain, PiVector terminals, int root) {
        int numTerminals = terminals.getSize();
        int numNodes = domain.getNumNodes();
        PgAbstractGraph distanceGraph = new PgAbstractGraph();
        distanceGraph.setNumNodes(numTerminals);
        PnAbstractGraph.makeCompleteGraph(distanceGraph);
        PdVector distances = new PdVector(numNodes);
        PgAbstractGraph[] shortestPaths = new PgAbstractGraph[numTerminals];
        PdVector[] edgeWeights = PdVector.realloc(null, (int)numTerminals, (int)(numTerminals - 1));
        int t = 0;
        while (t < numTerminals) {
            shortestPaths[t] = new PgAbstractGraph();
            PnAbstractGraph.makeShortestPathTree(shortestPaths[t], domain, new PiVector(new int[]{terminals.m_data[t]}), false, null, distances);
            PiVector neighbours = distanceGraph.getNeighbours(t);
            int numNeighbours = neighbours.getSize();
            int i = 0;
            while (i < numNeighbours) {
                int t2 = neighbours.m_data[i];
                edgeWeights[t].m_data[i] = distances.m_data[terminals.m_data[t2]];
                ++i;
            }
            ++t;
        }
        distanceGraph.setEdgeWeights(edgeWeights);
        PgAbstractGraph minDistanceTree = new PgAbstractGraph();
        PnAbstractGraph.makeMinimalSpanningTree(minDistanceTree, distanceGraph, 0);
        PgAbstractGraph outGraph = new PgAbstractGraph();
        outGraph.setNumNodes(numNodes);
        int t2 = 0;
        while (t2 < numTerminals) {
            PiVector neighbours = minDistanceTree.getNeighbours(t2);
            int dim = neighbours.getSize();
            int i = 0;
            while (i < dim) {
                int nt = neighbours.m_data[i];
                if (nt < t2) {
                    PiVector pathToRoot = PnAbstractGraph.pathToRoot(shortestPaths[t2], terminals.m_data[nt]);
                    int len = pathToRoot.getSize();
                    int j = 0;
                    while (j < len - 1) {
                        outGraph.addEdge(pathToRoot.m_data[j], pathToRoot.m_data[j + 1]);
                        ++j;
                    }
                }
                ++i;
            }
            ++t2;
        }
        PnAbstractGraph.makeMinimalSpanningTree(outTree, outGraph, root);
    }

    public static void makeCompleteGraph(PgAbstractGraph graph) {
        int numNodes = graph.getNumNodes();
        int i = 0;
        while (i < numNodes) {
            int j = i + 1;
            while (j < numNodes) {
                graph.addEdge(i, j);
                ++j;
            }
            ++i;
        }
    }

    public static PiVector pathToRoot(PgAbstractGraph tree, int node) {
        if (tree == null || !tree.isTree()) {
            PsDebug.warning((String)"Missing tree or graph is not a tree.");
            return null;
        }
        PiDynVector path = new PiDynVector();
        while (tree.getParent(node) >= 0) {
            path.appendEntry(node);
            node = tree.getParent(node);
        }
        path.appendEntry(node);
        return path.toPiVector();
    }

    public static PiVector pathToRoot(PiVector parent, int node) {
        PiVector path = new PiVector();
        while (parent.getEntry(node) >= 0) {
            path.addEntry(node);
            node = parent.getEntry(node);
        }
        path.addEntry(node);
        return path;
    }

    public static boolean isSameComponent(PgAbstractGraph graph, int index1, int index2) {
        if (!graph.isTree()) {
            PsDebug.warning((String)"isSameComponent works for trees only.");
            return false;
        }
        return PnAbstractGraph.pathToRoot(graph, index1).getLastEntry() == PnAbstractGraph.pathToRoot(graph, index2).getLastEntry();
    }

    /*
     * Unable to fully structure code
     */
    public static PiVector[] makeLoops(PgAbstractGraph graph, int root, boolean bFindMoreRoots) {
        if (graph.isTree()) {
            return null;
        }
        numNodes = graph.getNumNodes();
        v0 = bSimplify = root < 0 || root >= numNodes;
        if (bSimplify) {
            root = 0;
        }
        loopLeaves = new PiVector();
        numLoops = 0;
        parent = new PiVector(numNodes);
        queue = new PuQueue(numNodes);
        queue.enqueue(root);
        parent.setConstant(-2);
        parent.setEntry(root, -3);
        ** GOTO lbl42
        {
            node = queue.extractFirst();
            neigh = graph.getNeighbours(node);
            i = 0;
            while (i < neigh.getSize()) {
                child = neigh.getEntry(i);
                if (parent.getEntry(child) == -2) {
                    parent.setEntry(child, node);
                    queue.enqueue(child);
                } else if (node > child && parent.getEntry(node) != child) {
                    if (2 * numLoops >= loopLeaves.getSize()) {
                        loopLeaves.setSize(loopLeaves.getSize() * 2 + 10);
                    }
                    loopLeaves.setEntry(2 * numLoops, node);
                    loopLeaves.setEntry(2 * numLoops + 1, child);
                    ++numLoops;
                }
                ++i;
            }
            do {
                if (queue.getNumEntries() > 0) continue block0;
                if (!bFindMoreRoots) continue;
                while (root < numNodes && parent.getEntry(root) != -2) {
                    ++root;
                }
                if (root >= numNodes) continue;
                parent.setEntry(root, -3);
                queue.enqueue(root);
lbl42:
                // 4 sources

            } while (queue.getNumEntries() > 0);
        }
        cycles = new PiVector[numLoops];
        i = 0;
        while (i < numLoops) {
            node = loopLeaves.getEntry(2 * i);
            node2 = loopLeaves.getEntry(2 * i + 1);
            nodeToRoot = PnAbstractGraph.pathToRoot(parent, node);
            node2ToRoot = PnAbstractGraph.pathToRoot(parent, node2);
            node2ToRoot.invert();
            node2ToRoot.addEntry(node);
            nodeToRoot.invert();
            cycles[i] = cycle = PnAbstractGraph.mergePaths(nodeToRoot, node2ToRoot, bSimplify);
            ++i;
        }
        return cycles;
    }

    private static PiVector mergePaths(PiVector forward, PiVector backward, boolean simplifyPath) {
        int forwLength = forward.getSize();
        int backLength = backward.getSize();
        int same = 0;
        if (simplifyPath) {
            while (forwLength - 2 - same >= 0 && backLength - 2 - same >= 0 && forward.m_data[forwLength - 2 - same] == backward.m_data[backLength - 2 - same]) {
                ++same;
            }
        }
        PiVector path = new PiVector(forward.getSize() + backward.getSize() - 1 - 2 * same);
        if (forwLength - same > 0) {
            System.arraycopy(forward.m_data, 0, path.m_data, 0, forwLength - same);
        }
        int j = same;
        while (j < backLength - 1) {
            path.m_data[forwLength - same + j - same] = backward.m_data[backLength - j - 2];
            ++j;
        }
        return path;
    }

    public static PiVector makeShortestPath(PgAbstractGraph graph, int start, int end) {
        int num = graph.getNumNodes();
        PuPriorityQueue queue = new PuPriorityQueue(num);
        queue.enqueue(start, 0.0);
        PdVector[] edgeWeights = graph.getEdgeWeights();
        PiVector parents = new PiVector(num);
        parents.m_data[start] = 1;
        while (!queue.isEmpty()) {
            double value = queue.getKeyOfMin();
            int node = queue.extractMin();
            PiVector neighb = graph.getNeighbours(node);
            int numNeighb = neighb.getSize();
            int i = 0;
            while (i < numNeighb) {
                int n = neighb.m_data[i];
                if (parents.m_data[n] <= 0) {
                    queue.enqueueOrDecrease(n, value + (edgeWeights == null ? 1.0 : edgeWeights[node].m_data[i]));
                    parents.m_data[n] = node + 2;
                    if (n == end) {
                        int k = n;
                        int count = 0;
                        while (parents.m_data[k] >= 2) {
                            k = parents.m_data[k] - 2;
                            ++count;
                        }
                        PiVector path = new PiVector(++count);
                        k = n;
                        while (parents.m_data[k] >= 2) {
                            path.m_data[--count] = k;
                            k = parents.m_data[k] - 2;
                        }
                        path.m_data[--count] = k;
                        return path;
                    }
                }
                ++i;
            }
        }
        return null;
    }
}

