/*
 * Decompiled with CFR 0.152.
 */
package devGraph;

import devGraph.PgAbstractGraph;
import java.awt.Color;
import jv.geom.PgPointSet;
import jv.geom.PgTetraSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgGraphOnTetraSet
extends PgAbstractGraph {
    public static final int TETRA_BASED = 1;
    protected PgTetraSet m_geom;
    protected int m_basedOn;
    protected PiVector[] m_tetraSetNeighbours;

    public PgGraphOnTetraSet() {
        if (this.getClass() == PgGraphOnTetraSet.class) {
            this.init();
        }
        this.m_basedOn = 1;
    }

    public PgGraphOnTetraSet(PgTetraSet geom, int basedOn) {
        if (this.getClass() == PgGraphOnTetraSet.class) {
            this.init();
        }
        this.setSurface(geom, basedOn);
    }

    public void setSurface(PgTetraSet geom, int basedOn) {
        if (basedOn != 1) {
            PsDebug.warning((String)"Only tetra based graphs supported");
            return;
        }
        this.m_geom = geom;
        this.m_basedOn = basedOn;
        int numTetras = this.m_geom.getNumTetras();
        this.setNumNodes(numTetras);
        this.m_tetraSetNeighbours = basedOn == 1 ? geom.getNeighbours() : null;
    }

    @Override
    protected void init() {
        super.init();
    }

    public PgTetraSet getGeometry() {
        return this.m_geom;
    }

    @Override
    public int getNumNodes() {
        return this.m_numNodes;
    }

    public void copy(PgGraphOnTetraSet graph) {
        if (graph == null) {
            return;
        }
        super.copy(graph);
        this.m_basedOn = graph.m_basedOn;
        this.m_geom = graph.m_geom;
    }

    public static PgGraphOnTetraSet copyNew(PgGraphOnTetraSet graph) {
        if (graph == null) {
            return null;
        }
        PgGraphOnTetraSet newGraph = new PgGraphOnTetraSet(graph.getGeometry(), graph.getBasedOn());
        newGraph.copy(graph);
        return newGraph;
    }

    @Override
    public boolean addEdge(int index1, int index2) {
        if (index1 < 0 || index2 < 0) {
            return false;
        }
        if (this.m_tetraSetNeighbours != null && this.m_tetraSetNeighbours[index1].getIndexOf(index2) < 0) {
            return false;
        }
        return super.addEdge(index1, index2);
    }

    public int getBasedOn() {
        return this.m_basedOn;
    }

    public PiVector[] getTetraSetNeighbours() {
        return this.m_tetraSetNeighbours;
    }

    public PgPointSet getGraphAsPointSet() {
        int dim = this.m_geom.getDimOfVertices();
        PgPointSet points = new PgPointSet(dim);
        if (!this.getName().equals("")) {
            points.setName(this.getName());
        }
        points.setNumVertices((int)((double)this.m_numNodes * 1.1) + 100);
        points.showVertices(false);
        PgVectorField vf = new PgVectorField(dim, 0);
        vf.setGeometry(points);
        vf.setGlobalVectorSize(3.0);
        vf.setGlobalVectorColor(Color.pink);
        vf.setName("Graph on " + this.m_geom.getName());
        vf.showIndividualMaterial(true);
        points.addVectorField(vf);
        int count = 0;
        if (this.m_basedOn == 1) {
            PdVector iCenter = new PdVector(dim);
            PdVector jCenter = new PdVector(dim);
            vf.setGlobalVectorColor(Color.cyan);
            PdVector[] vertices = this.m_geom.getVertices();
            PiVector[] tetras = this.m_geom.getTetras();
            int i = 0;
            while (i < this.m_numNodes) {
                PgGeometry.getCenterOfElement((PdVector)iCenter, (PdVector[])vertices, (int[])tetras[i].m_data);
                PiVector neigh = this.getNeighbours(i);
                int size = neigh.getSize();
                int locInd = 0;
                while (locInd < size) {
                    int j = neigh.getEntry(locInd);
                    if (j > i) {
                        points.setVertex(count, PdVector.copyNew((PdVector)iCenter));
                        PgGeometry.getCenterOfElement((PdVector)jCenter, (PdVector[])vertices, (int[])tetras[j].m_data);
                        PdVector vec = PdVector.subNew((PdVector)jCenter, (PdVector)iCenter);
                        vf.setVector(count, vec);
                        ++count;
                    }
                    ++locInd;
                }
                ++i;
            }
        }
        points.setNumVertices(count);
        return points;
    }
}

