/*
 * Decompiled with CFR 0.152.
 */
package devGraph;

import devGraph.PgAbstractGraph;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;

public class PgGraphOnElementSet
extends PgAbstractGraph {
    public static final int ELEMENT_BASED = 1;
    public static final int VERTEX_BASED = 0;
    protected PgElementSet m_geom;
    protected int m_basedOn;
    protected PiVector[] m_elementSetNeighbours;

    public PgGraphOnElementSet() {
        if (this.getClass() == PgGraphOnElementSet.class) {
            this.init();
        }
        this.m_basedOn = 1;
    }

    public PgGraphOnElementSet(PgElementSet geom, int basedOn) {
        if (this.getClass() == PgGraphOnElementSet.class) {
            this.init();
        }
        this.setSurface(geom, basedOn);
    }

    public void setSurface(PgElementSet geom, int basedOn) {
        this.m_geom = geom;
        this.m_basedOn = basedOn;
        int numElements = this.m_geom.getNumElements();
        int numVertices = this.m_geom.getNumVertices();
        this.setNumNodes(this.m_basedOn == 1 ? numElements : numVertices);
        this.m_elementSetNeighbours = basedOn == 1 ? geom.getNeighbours() : PgVertexStar.makeVertexNeighbours((PgElementSet)geom);
    }

    @Override
    protected void init() {
        super.init();
    }

    public PgElementSet getGeometry() {
        return this.m_geom;
    }

    @Override
    public int getNumNodes() {
        return this.m_numNodes;
    }

    public void copy(PgGraphOnElementSet graph) {
        if (graph == null) {
            return;
        }
        super.copy(graph);
        this.m_basedOn = graph.m_basedOn;
        this.m_geom = graph.m_geom;
    }

    public static PgGraphOnElementSet copyNew(PgGraphOnElementSet graph) {
        if (graph == null) {
            return null;
        }
        PgGraphOnElementSet newGraph = new PgGraphOnElementSet(graph.getGeometry(), graph.getBasedOn());
        newGraph.copy(graph);
        return newGraph;
    }

    @Override
    public boolean addEdge(int index1, int index2) {
        if (index1 < 0 || index2 < 0) {
            return false;
        }
        if (this.m_elementSetNeighbours[index1].getIndexOf(index2) < 0) {
            return false;
        }
        return super.addEdge(index1, index2);
    }

    public int getBasedOn() {
        return this.m_basedOn;
    }

    public PiVector[] getElementSetNeighbours() {
        return this.m_elementSetNeighbours;
    }

    public PgPointSet getVisualizingGeometry() {
        int dim = this.m_geom.getDimOfVertices();
        PgPointSet points = new PgPointSet(dim);
        if (!this.getName().equals("")) {
            points.setName(this.getName());
        }
        points.setNumVertices((int)((double)this.m_numNodes * 1.1) + 100);
        points.showVertices(false);
        PgVectorField vf = new PgVectorField(dim, 0);
        vf.setName("Graph on " + this.m_geom.getName());
        vf.setGeometry(points);
        vf.setGlobalVectorSize(3.0);
        vf.showIndividualMaterial(true);
        points.addVectorField(vf);
        PdVector[] vector = vf.getVectors();
        int count = 0;
        if (this.m_basedOn == 1) {
            vf.setGlobalVectorColor(Color.cyan);
            PdVector iCenter = new PdVector(dim);
            PdVector jCenter = new PdVector(dim);
            PdVector[] vertices = this.m_geom.getVertices();
            PiVector[] elements = this.m_geom.getElements();
            int i = 0;
            while (i < this.m_numNodes) {
                PgGeometry.getCenterOfElement((PdVector)iCenter, (PdVector[])vertices, (int[])elements[i].m_data);
                PiVector neigh = this.getNeighbours(i);
                int size = neigh.getSize();
                int locInd = 0;
                while (locInd < size) {
                    int j = neigh.getEntry(locInd);
                    if (j > i) {
                        points.setVertex(count, PdVector.copyNew((PdVector)iCenter));
                        PgGeometry.getCenterOfElement((PdVector)jCenter, (PdVector[])vertices, (int[])elements[j].m_data);
                        vector[count].sub(jCenter, iCenter);
                        ++count;
                    }
                    ++locInd;
                }
                ++i;
            }
        } else {
            vf.setGlobalVectorColor(Color.pink);
            int i = 0;
            while (i < this.m_numNodes) {
                PiVector neigh = this.getNeighbours(i);
                int j = 0;
                while (j < neigh.getSize()) {
                    int jInd = neigh.getEntry(j);
                    if (jInd > i) {
                        points.setVertex(count, this.m_geom.getVertex(i));
                        vector[count].sub(this.m_geom.getVertex(jInd), this.m_geom.getVertex(i));
                        ++count;
                    }
                    ++j;
                }
                ++i;
            }
        }
        points.setNumVertices(count);
        return points;
    }

    public void addVisualizingVectorField() {
        if (!this.m_isTree) {
            PsDebug.warning((String)"graph is not a tree.");
            return;
        }
        int dim = this.m_basedOn == 1 ? this.m_geom.getNumElements() : this.m_geom.getNumVertices();
        PgVectorField vf = new PgVectorField(dim, this.m_basedOn);
        vf.setGeometry((PgPointSet)this.m_geom);
        vf.setGlobalVectorSize(3.0);
        vf.showIndividualMaterial(true);
        vf.setName(this.getName());
        if (this.m_basedOn == 1) {
            vf.setGlobalVectorColor(Color.blue);
        } else {
            vf.setGlobalVectorColor(Color.red);
        }
        this.m_geom.addVectorField(vf);
        PdVector childCenter = new PdVector(dim);
        PdVector parentCenter = new PdVector(dim);
        PdVector vecSub = new PdVector(dim);
        int i = 0;
        while (i < this.m_numNodes) {
            int parent = this.getParent(i);
            if (parent >= 0) {
                if (this.m_basedOn == 1) {
                    PgGeometry.getCenterOfElement((PdVector)childCenter, (PdVector[])this.m_geom.getVertices(), (int[])this.m_geom.getElement((int)i).m_data);
                    PgGeometry.getCenterOfElement((PdVector)parentCenter, (PdVector[])this.m_geom.getVertices(), (int[])this.m_geom.getElement((int)parent).m_data);
                    vecSub.sub(parentCenter, childCenter);
                } else {
                    vecSub.sub(this.m_geom.getVertex(parent), this.m_geom.getVertex(i));
                }
                vf.setVector(i, vecSub);
            } else if (this.isRoot(i)) {
                if (this.m_basedOn == 1) {
                    vf.setVector(i, this.m_geom.getElementNormal(i));
                } else {
                    vf.setVector(i, this.m_geom.getVertexNormal(i));
                }
            }
            ++i;
        }
    }
}

