/*
 * Decompiled with CFR 0.152.
 */
package devGraph;

import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.util.PuQueue;

public class PgAbstractGraph {
    private String m_name;
    protected int m_numNodes;
    protected PiVector[] m_neighbour;
    private PdVector[] m_edgeWeights;
    protected boolean m_isTree;
    protected PiVector m_root;

    public PgAbstractGraph() {
        this("");
    }

    public PgAbstractGraph(String name) {
        this.m_name = name;
        this.m_neighbour = new PiVector[0];
        if (this.getClass() == PgAbstractGraph.class) {
            this.init();
        }
    }

    protected void init() {
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isTree() {
        return this.m_isTree;
    }

    public int getNumNodes() {
        return this.m_numNodes;
    }

    public void setNumNodes(int numNodes) {
        if (this.m_numNodes == numNodes) {
            return;
        }
        this.m_numNodes = numNodes;
        this.m_neighbour = PiVector.realloc((PiVector[])this.m_neighbour, (int)numNodes);
    }

    public void setEdgeWeights(PdVector[] edgeWeights) {
        this.m_edgeWeights = edgeWeights;
    }

    public PdVector[] getEdgeWeights() {
        return this.m_edgeWeights;
    }

    public void setGraph() {
        this.m_isTree = false;
    }

    public void copy(PgAbstractGraph graph) {
        if (graph == null) {
            PsDebug.warning((String)"Empty graph.");
            return;
        }
        this.setName(graph.getName());
        this.m_numNodes = graph.m_numNodes;
        this.m_isTree = graph.m_isTree;
        this.m_neighbour = graph.m_neighbour == null ? null : PiVector.copyNew((PiVector[])graph.m_neighbour);
        this.m_root = graph.m_root == null ? null : PiVector.copyNew((PiVector)graph.m_root);
    }

    public void setNeighbours(PiVector[] neighbours) {
        this.m_neighbour = neighbours;
    }

    public void setNeighbours(int nodeInd, PiVector neighbours) {
        this.m_neighbour[nodeInd] = neighbours;
    }

    public boolean addEdge(int index1, int index2) {
        if (index1 < 0 || index2 < 0) {
            return false;
        }
        if (this.m_isTree) {
            PsDebug.warning((String)"Method cannot be applied to trees.");
            return false;
        }
        if (this.isAdjacent(index1, index2)) {
            return false;
        }
        this.m_neighbour[index1].addEntry(index2);
        this.m_neighbour[index2].addEntry(index1);
        return true;
    }

    public void setEdges(PiVector[] edges, PiVector roots) {
        int numNodes = edges.length;
        int i = 0;
        while (i < numNodes) {
            this.m_neighbour[i].setSize(edges[i].getSize());
            this.m_neighbour[i].copy(edges[i]);
            ++i;
        }
        this.m_isTree = roots != null;
        this.m_root = roots == null ? null : PiVector.copyNew((PiVector)roots);
    }

    public void removeAllEdges() {
        int i = 0;
        while (i < this.m_numNodes) {
            this.m_neighbour[i] = new PiVector(0);
            ++i;
        }
    }

    public boolean removeEdge(int index1, int index2) {
        if (index1 < 0 || index2 < 0 || !this.isAdjacent(index1, index2)) {
            return false;
        }
        this.removeValueFromNeighbour(index1, index2);
        this.removeValueFromNeighbour(index2, index1);
        return true;
    }

    private void removeValueFromNeighbour(int index1, int index2) {
        PiVector neigh = this.m_neighbour[index1];
        int size = neigh.getSize();
        int i = 0;
        while (i < size) {
            if (neigh.m_data[i] == index2) {
                int j = i;
                while (j < size - 1) {
                    neigh.m_data[j] = neigh.m_data[j + 1];
                    ++j;
                }
                neigh.setSize(neigh.getSize() - 1);
                return;
            }
            ++i;
        }
    }

    public boolean isAdjacent(int index1, int index2) {
        if (index1 < 0 || index2 < 0) {
            return false;
        }
        PiVector neigh = this.getNeighbours(index1);
        return neigh != null && neigh.contains(index2);
    }

    public boolean isRoot(int index) {
        return this.isTree() && this.getRoots().contains(index);
    }

    public boolean isIsolated(int index) {
        if (index < 0 || index >= this.m_numNodes) {
            PsDebug.warning((String)"Index argument is out of range.");
            return false;
        }
        return this.getValence(index) == 0;
    }

    public PiVector getRoots() {
        if (!this.isTree()) {
            return null;
        }
        return this.m_root;
    }

    public PiVector getChildren(int index) {
        if (!this.isTree()) {
            PsDebug.warning((String)"Graph is not a tree.");
            return null;
        }
        if (index < 0 || index >= this.m_numNodes) {
            PsDebug.warning((String)"Index argument is out of range.");
            return null;
        }
        if (this.isRoot(index)) {
            return this.getNeighbours(index);
        }
        PiVector neigh = this.getNeighbours(index);
        PiVector children = new PiVector(neigh.getSize() - 1);
        int i = 0;
        while (i < neigh.getSize() - 1) {
            children.m_data[i] = neigh.m_data[i + 1];
            ++i;
        }
        return children;
    }

    public boolean isLeaf(int index) {
        if (!this.isTree()) {
            PsDebug.warning((String)"Graph is not a tree.");
            return false;
        }
        if (index < 0 || index >= this.m_numNodes) {
            PsDebug.warning((String)"Index argument is out of range.");
            return false;
        }
        if (this.isRoot(index)) {
            return this.isIsolated(index);
        }
        return this.getValence(index) == 1;
    }

    public int getParent(int index) {
        if (index < 0 || index >= this.m_numNodes) {
            PsDebug.warning((String)"Index argument is out of range.");
            return -2;
        }
        if (!this.isTree() || this.isIsolated(index) || this.isRoot(index)) {
            return -1;
        }
        return this.m_neighbour[index].m_data[0];
    }

    public int getValence(int index) {
        return this.getNeighbours(index).getSize();
    }

    public PiVector getNeighbours(int index) {
        if (index >= this.m_numNodes || index < 0) {
            PsDebug.warning((String)"Index out of range.");
            return null;
        }
        return this.m_neighbour[index];
    }

    public PiVector[] getNeighbours() {
        return this.m_neighbour;
    }

    public int countEdges() {
        int edges = 0;
        int i = 0;
        while (i < this.m_numNodes) {
            edges += this.getNeighbours(i).getSize();
            ++i;
        }
        return edges / 2;
    }

    public void convertToGraph() {
        this.m_isTree = false;
    }

    public void allocateEdgeWeights() {
        this.m_edgeWeights = PdVector.realloc((PdVector[])this.m_edgeWeights, (int)this.m_numNodes);
        int n = 0;
        while (n < this.m_numNodes) {
            this.m_edgeWeights[n].setSize(this.m_neighbour[n].getSize());
            ++n;
        }
    }

    public boolean checkEdges() {
        if (this.m_neighbour == null) {
            PsDebug.message((String)"missing neighbor array.");
            return false;
        }
        boolean bCorrect = true;
        int i = 0;
        while (i < this.m_numNodes) {
            if (this.m_neighbour[i] == null) {
                PsDebug.message((String)("missing neighbor[" + i + "]."));
                return false;
            }
            int j = 0;
            while (j < this.m_neighbour[i].getSize()) {
                if (this.m_neighbour[this.m_neighbour[i].m_data[j]].getIndexOf(i) == -1) {
                    PsDebug.message((String)("adjacency between nodes " + i + " and " + j + " is not symmetric."));
                    bCorrect = false;
                }
                ++j;
            }
            ++i;
        }
        return bCorrect;
    }

    /*
     * Unable to fully structure code
     */
    public boolean checkTree() {
        queue = new PuQueue(this.m_numNodes);
        visited = new boolean[this.m_numNodes];
        root = 0;
        while (true) {
            if (root < this.m_numNodes) {
                if (!visited[root]) {
                    visited[root] = true;
                    queue.enqueue(root);
                } else {
                    ++root;
                    continue;
                }
            }
            if (!queue.isEmpty()) ** GOTO lbl31
            this.m_isTree = true;
            return true;
lbl-1000:
            // 1 sources

            {
                i = queue.extractFirst();
                neighbours = this.m_neighbour[i];
                size = neighbours.getSize();
                numVisited = 0;
                j = 0;
                while (j < size) {
                    if (visited[neighbours.m_data[j]]) {
                        ++numVisited;
                    } else {
                        queue.enqueue(neighbours.m_data[j]);
                        visited[neighbours.m_data[j]] = true;
                    }
                    ++j;
                }
                if (numVisited <= true) continue;
                this.m_isTree = false;
                return false;
lbl31:
                // 2 sources

                ** while (!queue.isEmpty())
            }
lbl32:
            // 1 sources

        }
    }
}

