/*
 * Decompiled with CFR 0.152.
 */
package devFeature;

import devFeature.PwFeature;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.objectGui.PsSlotLayout;
import jvx.project.PjWorkshop_IP;

public class PwFeature_IP
extends PjWorkshop_IP
implements ActionListener,
TextListener,
ItemListener {
    protected PwFeature m_ws;
    protected Button m_b_exSth_start;
    protected Button m_b_exSth_recompute;
    protected Checkbox m_c_exSth_onlySelected;
    protected Checkbox m_c_cuSth_visibleOnly;
    protected Checkbox m_c_offsets_flag;
    protected Checkbox m_c_offsets_useCurvature;
    protected Button m_b_cuSht_start;
    protected Button m_b_cuSth_reset;
    protected Button m_b_extractLines;
    protected Color m_buttonColor;
    protected Button m_b_saveToDisc;
    protected TextField m_t_saveToDiscBaseName;

    public PwFeature_IP() {
        this.setTitle(PsConfig.getMessage((boolean)true, (int)54000, (String)"Compute Feature Lines"));
        this.m_c_exSth_onlySelected = new Checkbox("Smooth only selected vertices");
        this.m_c_exSth_onlySelected.addItemListener(this);
        this.m_b_exSth_start = new Button("Smoothing of Extremalities");
        this.m_b_exSth_start.addActionListener(this);
        this.m_b_exSth_recompute = new Button("Recompute Extremalities");
        this.m_b_exSth_recompute.addActionListener(this);
        this.m_b_extractLines = new Button("Extract Lines");
        this.m_b_extractLines.addActionListener(this);
        this.m_c_offsets_flag = new Checkbox("Enable offset curves");
        this.m_c_offsets_flag.addItemListener(this);
        this.m_c_offsets_useCurvature = new Checkbox("Varying distances");
        this.m_c_offsets_useCurvature.addItemListener(this);
        this.m_c_cuSth_visibleOnly = new Checkbox("Smooth only visible lines");
        this.m_c_cuSth_visibleOnly.addItemListener(this);
        this.m_b_cuSht_start = new Button("Smooth Lines");
        this.m_b_cuSht_start.addActionListener(this);
        this.m_b_cuSth_reset = new Button("Reset Lines");
        this.m_b_cuSth_reset.addActionListener(this);
        this.m_b_saveToDisc = new Button("Save as Polygons");
        this.m_b_saveToDisc.addActionListener(this);
        this.m_t_saveToDiscBaseName = new TextField();
        this.m_t_saveToDiscBaseName.addTextListener(this);
        this.m_buttonColor = this.m_b_exSth_start.getBackground();
        if (this.getClass() == PwFeature_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_ws = (PwFeature)parent;
        this.addSubTitle("Smooth Extremalities");
        this.add((Component)this.m_ws.m_exSth_stepSize.assureInspector("Info", "_IP"));
        this.add((Component)this.m_ws.m_exSth_numSteps.assureInspector("Info", "_IP"));
        this.m_c_exSth_onlySelected.setState(this.m_ws.m_b_exSth_onlySelected);
        Panel panel = new Panel(new GridLayout(1, 2));
        panel.add(this.m_c_exSth_onlySelected);
        this.add(panel);
        panel = new Panel(new FlowLayout(1));
        panel.add(this.m_b_exSth_start);
        panel.add(this.m_b_exSth_recompute);
        this.add(panel);
        this.addSubTitle("Feature Line Extraction");
        this.add((Component)this.m_ws.m_LineEx_maxNumGreenVert.assureInspector("Info", "_IP"));
        panel = new Panel(new FlowLayout(1));
        panel.add(this.m_b_extractLines);
        this.add(panel);
        this.addSubTitle("Filter Lines");
        this.add((Component)this.m_ws.m_filter_curvIntegral.assureInspector("Info", "_IP"));
        this.add((Component)this.m_ws.m_filter_curvLocal.assureInspector("Info", "_IP"));
        this.addSubTitle("Offset Curves");
        panel = new Panel(new GridLayout(1, 2));
        this.m_c_offsets_flag.setState(this.m_ws.m_b_offsets_flag);
        this.m_c_offsets_useCurvature.setState(this.m_ws.m_b_offsets_useCurvature);
        panel.add(this.m_c_offsets_flag);
        this.add(panel);
        this.add((Component)this.m_ws.m_offsets_distance.assureInspector("Info", "_IP"));
        this.addSubTitle("Spatial Smoothing of Feature Lines");
        this.add((Component)this.m_ws.m_cuSth_epsilon.assureInspector("Info", "_IP"));
        panel = new Panel(new GridLayout(1, 2));
        this.m_c_cuSth_visibleOnly.setState(this.m_ws.m_b_cuSth_visibleOnly);
        panel.add(this.m_c_cuSth_visibleOnly);
        panel = new Panel(new FlowLayout(1));
        panel.add(this.m_b_cuSht_start);
        panel.add(this.m_b_cuSth_reset);
        this.add(panel);
        this.addSubTitle("Save Lines to Disc");
        panel = new Panel((LayoutManager)new PsSlotLayout(3));
        panel.add("1", this.m_b_saveToDisc);
        this.m_t_saveToDiscBaseName.setText(this.m_ws.m_saveFileBaseName);
        panel.add("2", this.m_t_saveToDiscBaseName);
        this.add(panel);
        this.validate();
    }

    public boolean update(Object event) {
        if (this.m_ws == null) {
            PsDebug.notify((String)"missing parent");
            return true;
        }
        if (event == this.m_ws) {
            if (this.m_ws.m_bStopped && !this.m_b_exSth_start.isEnabled()) {
                this.m_b_exSth_start.setBackground(this.m_buttonColor);
                this.m_b_exSth_start.setEnabled(true);
                this.m_b_exSth_start.setLabel("Smooth Extremalities");
            }
            if (this.m_ws.m_bStopped && !this.m_b_cuSht_start.isEnabled()) {
                this.m_b_cuSht_start.setBackground(this.m_buttonColor);
                this.m_b_cuSht_start.setEnabled(true);
                this.m_b_cuSht_start.setLabel("Smooth Lines");
            }
            return true;
        }
        return super.update(event);
    }

    public Dimension getDialogSize() {
        return new Dimension(400, 600);
    }

    public String getNotice() {
        return "Compute feature lines on a surface.";
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_b_extractLines) {
            this.m_ws.extractFeatureLines();
            this.m_ws.filterFeatureLines();
            this.m_ws.updateOrAddFeatureLines();
        } else if (source == this.m_b_exSth_start) {
            this.m_b_exSth_start.setBackground(Color.red);
            this.m_b_exSth_start.setEnabled(false);
            this.m_b_exSth_start.setLabel("...Smoothing...");
            this.m_ws.start();
        } else if (source == this.m_b_exSth_recompute) {
            this.m_ws.computeExtremalities();
            this.m_ws.extractFeatureLines();
            this.m_ws.filterFeatureLines();
            this.m_ws.updateOrAddFeatureLines();
        } else if (source == this.m_b_cuSht_start) {
            this.m_b_cuSht_start.setBackground(Color.red);
            this.m_b_cuSht_start.setEnabled(false);
            this.m_b_cuSht_start.setLabel("...Smoothing...");
            try {
                this.m_ws.smoothFeatureLines();
            }
            catch (Exception e) {
                PsDebug.warning((String)"Exception caught while smoothing feature lines.");
            }
            this.m_ws.updateOrAddFeatureLines();
            this.m_b_cuSht_start.setBackground(this.m_buttonColor);
            this.m_b_cuSht_start.setEnabled(true);
            this.m_b_cuSht_start.setLabel("Smooth Lines");
        } else if (source == this.m_b_cuSth_reset) {
            this.m_ws.extractFeatureLines();
            this.m_ws.filterFeatureLines();
            this.m_ws.updateOrAddFeatureLines();
        } else if (source == this.m_b_saveToDisc) {
            this.m_ws.saveToDiscAsPolygons();
        } else {
            super.actionPerformed(event);
        }
    }

    @Override
    public void textValueChanged(TextEvent event) {
        Object source = event.getSource();
        if (source == this.m_t_saveToDiscBaseName) {
            this.m_ws.m_saveFileBaseName = this.m_t_saveToDiscBaseName.getText();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.m_c_exSth_onlySelected) {
            this.m_ws.m_b_exSth_onlySelected = this.m_c_exSth_onlySelected.getState();
        } else if (source == this.m_c_cuSth_visibleOnly) {
            this.m_ws.m_b_cuSth_visibleOnly = this.m_c_cuSth_visibleOnly.getState();
        } else if (source == this.m_c_offsets_flag) {
            this.m_ws.m_b_offsets_flag = this.m_c_offsets_flag.getState();
            if (!this.m_ws.m_b_firstTime) {
                this.m_ws.filterFeatureLines();
                this.m_ws.updateOrAddFeatureLines();
            }
        } else if (source == this.m_c_offsets_useCurvature) {
            this.m_ws.m_b_offsets_useCurvature = this.m_c_offsets_useCurvature.getState();
        }
    }
}

