/*
 * Decompiled with CFR 0.152.
 */
package devFeature;

import dev.loader.PgPolyLoader;
import dev.numeric.PnFunctionSmoother;
import devFeature.PnExtremality;
import java.awt.Color;
import java.io.FileWriter;
import java.io.Writer;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.geom.PuCleanMesh;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvDisplayIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.viewer.PvDisplay;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PwBary;
import jvx.geom.PwCleanMesh;
import jvx.geom.PwCurvature;
import jvx.geom.PwRefinePolygon;
import jvx.loader.PgPlyLoader;
import jvx.numeric.PnMassMatrix;
import jvx.numeric.PnStraightestGeodesic;
import jvx.project.PjWorkshop;

public class PwFeature
extends PjWorkshop
implements Runnable {
    protected PgElementSet m_geom;
    protected PgPolygonSet[] m_dispFL;
    protected PiVector[][] m_polygons;
    protected PiVector[] m_elements;
    protected PdBary[][] m_bary;
    protected PdBaryDir[][] m_lineNormals;
    protected PiVector[] m_lineNormalsElements;
    protected PdVector[] m_extremalities;
    protected PdVector[][] m_pcDir;
    protected PdVector[] m_pcVal;
    protected int m_mode = 0;
    protected boolean m_b_exSth_onlySelected;
    protected PuInteger m_exSth_numSteps;
    protected PuDouble m_exSth_stepSize;
    protected PuDouble m_filter_curvIntegral = new PuDouble("Integral of curvature", (PsUpdateIf)this);
    protected PuDouble m_filter_curvLocal = new PuDouble("Local curvature", (PsUpdateIf)this);
    protected int m_filter_curvLocal_maxNum = 3;
    protected PuDouble m_cuSth_epsilon = new PuDouble("Constraint", (PsUpdateIf)this);
    protected boolean m_b_cuSth_visibleOnly;
    protected PuInteger m_LineEx_maxNumGreenVert;
    protected String m_saveFileBaseName;
    protected boolean m_b_offsets_flag;
    protected boolean m_b_offsets_useCurvature;
    protected PuDouble m_offsets_distance;
    private double m_averageEdgeLength;
    protected boolean m_b_firstTime = true;
    PnStraightestGeodesic m_exp;
    private PdVector[] m_tmpApproxSpline;
    protected Thread m_thread;
    protected boolean m_bRunning = false;
    protected boolean m_bStopped = true;

    public PwFeature() {
        super("Compute Feature Lines");
        this.m_exSth_stepSize = new PuDouble("Realtive size of steps", (PsUpdateIf)this);
        this.m_exSth_numSteps = new PuInteger("Number of steps", (PsUpdateIf)this);
        this.m_LineEx_maxNumGreenVert = new PuInteger("Correct vertices", (PsUpdateIf)this);
        this.m_offsets_distance = new PuDouble("Offset Distance", (PsUpdateIf)this);
        if (this.getClass() == PwFeature.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_filter_curvIntegral.setDefBounds(0.0, 5.0, 0.01, 0.1);
        this.m_filter_curvIntegral.setDefValue(0.0);
        this.m_filter_curvIntegral.init();
        this.m_filter_curvLocal.setDefBounds(0.0, 5.0, 0.01, 0.1);
        this.m_filter_curvLocal.setDefValue(0.0);
        this.m_filter_curvLocal.init();
        this.m_cuSth_epsilon.setDefBounds(0.0, 5.0, 0.01, 0.1);
        this.m_cuSth_epsilon.setDefValue(0.1);
        this.m_cuSth_epsilon.init();
        this.m_exSth_stepSize.setDefBounds(0.0, 5.0, 0.01, 0.1);
        this.m_exSth_stepSize.setDefValue(0.1);
        this.m_exSth_stepSize.init();
        this.m_exSth_numSteps.setDefBounds(0, 20, 1, 3);
        this.m_exSth_numSteps.setDefValue(1);
        this.m_exSth_numSteps.init();
        this.m_LineEx_maxNumGreenVert.setDefBounds(0, 10, 1, 2);
        this.m_LineEx_maxNumGreenVert.setDefValue(3);
        this.m_LineEx_maxNumGreenVert.init();
        this.m_offsets_distance.setDefBounds(0.0, 1.0, 0.025, 0.1);
        this.m_offsets_distance.setDefValue(0.0);
        this.m_offsets_distance.init();
        if (this.m_dispFL == null) {
            this.m_dispFL = new PgPolygonSet[2];
            this.m_dispFL[0] = new PgPolygonSet(3);
            this.m_dispFL[0].setName("Red Feature Lines");
            this.m_dispFL[0].showVertices(false);
            this.m_dispFL[0].setGlobalPolygonColor(Color.red);
            this.m_dispFL[0].setGlobalPolygonSize(1.0);
            this.m_dispFL[1] = new PgPolygonSet(3);
            this.m_dispFL[1].setName("Blue Feature Lines");
            this.m_dispFL[1].showVertices(false);
            this.m_dispFL[1].setGlobalPolygonColor(Color.blue);
            this.m_dispFL[1].setGlobalPolygonSize(1.0);
        }
        if (this.m_bary == null) {
            this.m_bary = new PdBary[2][];
        }
        if (this.m_polygons == null) {
            this.m_polygons = new PiVector[2][];
        }
        if (this.m_elements == null) {
            this.m_elements = new PiVector[2];
            this.m_elements[0] = new PiVector();
            this.m_elements[1] = new PiVector();
        }
        if (this.m_lineNormals == null) {
            this.m_lineNormals = new PdBaryDir[2][];
        }
        if (this.m_lineNormalsElements == null) {
            this.m_lineNormalsElements = new PiVector[2];
        }
        this.m_saveFileBaseName = "c:\\line";
    }

    public void cancel() {
        int i = 0;
        while (i < 2) {
            if (this.m_display.containsGeometry((PgGeometryIf)this.m_dispFL[i])) {
                this.m_display.removeGeometry((PgGeometryIf)this.m_dispFL[i]);
            }
            ++i;
        }
        this.m_display.update((Object)this.m_display);
        super.cancel();
    }

    public boolean update(Object event) {
        if (event == this.m_filter_curvIntegral) {
            if (!this.m_b_firstTime) {
                this.filterFeatureLines();
                this.updateOrAddFeatureLines();
            }
            return true;
        }
        if (event == this.m_filter_curvLocal) {
            if (!this.m_b_firstTime) {
                this.filterFeatureLines();
                this.updateOrAddFeatureLines();
            }
            return true;
        }
        if (event == this.m_cuSth_epsilon) {
            return true;
        }
        if (event == this.m_exSth_stepSize) {
            return true;
        }
        if (event == this.m_exSth_numSteps) {
            return true;
        }
        if (event == this.m_offsets_distance) {
            if (!this.m_b_firstTime) {
                this.filterFeatureLines();
                this.updateOrAddFeatureLines();
            }
            return true;
        }
        if (event == this.m_LineEx_maxNumGreenVert) {
            this.extractFeatureLines();
            this.filterFeatureLines();
            this.updateOrAddFeatureLines();
            return true;
        }
        return super.update(event);
    }

    public void setGeometry(PgElementSet geom) {
        if (geom.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)geom);
        }
        this.m_geom = geom;
        this.m_b_firstTime = true;
        this.computeCurvatures();
        this.computeExtremalities();
        this.adjustFilterSliders();
        this.m_filter_curvIntegral.update((Object)this.m_filter_curvIntegral);
        this.m_filter_curvLocal.update((Object)this.m_filter_curvLocal);
        this.adjustConstraintSlider();
        this.m_cuSth_epsilon.update((Object)this.m_cuSth_epsilon);
        double epsilon = this.m_cuSth_epsilon.getValue();
        this.m_offsets_distance.setBounds(0.0, 10.0 * epsilon, 0.25 * epsilon, epsilon);
        this.m_offsets_distance.setValue(0.0);
        this.m_offsets_distance.update((Object)this.m_offsets_distance);
    }

    public void setDisplay(PvDisplayIf display) {
        super.setDisplay(display);
        if (!display.isEnabledZBuffer()) {
            display.setEnabledZBuffer(true);
            display.update((Object)display);
        }
    }

    protected void updateOrAddFeatureLines() {
        boolean bUpdateDisplay = false;
        int i = 0;
        while (i < 2) {
            if (this.m_display != null && !this.m_display.containsGeometry((PgGeometryIf)this.m_dispFL[i])) {
                this.m_display.addGeometry((PgGeometryIf)this.m_dispFL[i]);
                bUpdateDisplay = true;
            } else {
                this.m_dispFL[i].update((Object)this.m_dispFL[i]);
            }
            ++i;
        }
        if (bUpdateDisplay) {
            this.m_display.update((Object)this.m_display);
        }
    }

    protected void computeCurvatures() {
        int nov = this.m_geom.getNumVertices();
        int dim = this.m_geom.getDimOfVertices();
        if (this.m_pcDir == null || this.m_pcDir.length < 2) {
            this.m_pcDir = new PdVector[2][];
        }
        this.m_pcDir[0] = PdVector.realloc((PdVector[])this.m_pcDir[0], (int)nov, (int)dim);
        this.m_pcDir[1] = PdVector.realloc((PdVector[])this.m_pcDir[1], (int)nov, (int)dim);
        this.m_pcVal = PdVector.realloc((PdVector[])this.m_pcVal, (int)2, (int)nov);
        PdMatrix[] shape = PdMatrix.realloc(null, (int)nov, (int)dim, (int)dim);
        PwCurvature.getPrincipalCurvatures((PgElementSet)this.m_geom, (PdMatrix[])shape, (PdVector[])this.m_pcVal, (PdVector[][])this.m_pcDir, (boolean)false);
        PnMassMatrix.multInvMassMatrix((PgElementSet)this.m_geom, (PdVector)this.m_pcVal[0], (boolean)true);
        PnMassMatrix.multInvMassMatrix((PgElementSet)this.m_geom, (PdVector)this.m_pcVal[1], (boolean)true);
    }

    protected void computeExtremalities() {
        this.m_extremalities = PdVector.realloc((PdVector[])this.m_extremalities, (int)2, (int)this.m_geom.getNumVertices());
        this.m_extremalities = PnExtremality.getExtremalities(this.m_geom, this.m_pcVal, this.m_pcDir, this.m_extremalities);
    }

    protected void smoothExtremalities() {
        PdVector[] vert = this.m_geom.getVertices();
        PdVector weight = null;
        if (this.m_b_exSth_onlySelected) {
            int nov = this.m_geom.getNumVertices();
            weight = new PdVector(nov);
            int i = 0;
            while (i < nov) {
                weight.m_data[i] = vert[i].hasTag(1) ? 1.0 : 0.0;
                ++i;
            }
        }
        int nos = this.m_exSth_numSteps.getValue();
        double stw = this.m_exSth_stepSize.getValue();
        int i = 0;
        while (i < 2) {
            if (!(this.m_mode == 2 && i == 0 || this.m_mode == 1 && i == 1)) {
                if (!this.m_b_exSth_onlySelected) {
                    PnExtremality.smoothExtremality(this.m_extremalities[i], this.m_pcDir[i], this.m_geom, stw, nos, true);
                } else {
                    PnExtremality.smoothExtremality(this.m_extremalities[i], weight, this.m_pcDir[i], this.m_geom, stw, nos, true);
                }
            }
            ++i;
        }
    }

    protected void extractFeatureLines() {
        int noe = this.m_geom.getNumElements();
        PiVector[] elem = this.m_geom.getElements();
        PiVector[] neigh = this.m_geom.getNeighbours();
        PdVector[] vert = this.m_geom.getVertices();
        boolean[] bNewVert = new boolean[3];
        boolean[] bAddVert = new boolean[3];
        int[] newVert = new int[3];
        PdVector vertex = new PdVector(this.m_geom.getDimOfVertices());
        PiVector poly = new PiVector(2);
        PdVector vhelp = new PdVector(3);
        int k = 0;
        while (k < 2) {
            if ((this.m_mode != 2 || k != 0) && (this.m_mode != 1 || k != 1) || this.m_b_firstTime) {
                int cnt;
                int size;
                int j;
                if (this.m_b_firstTime && k == 1) {
                    this.m_b_firstTime = false;
                }
                PgPolygonSet featureLines = this.m_dispFL[k];
                featureLines.setNumVertices(100);
                featureLines.setNumVertices(0);
                if (featureLines.getMaxNumVertices() == 0) {
                    featureLines.setNumVertices(100);
                    featureLines.setNumVertices(0);
                }
                featureLines.setNumPolygons(100);
                featureLines.setNumPolygons(0);
                if (featureLines.getNumPolygons() == 0) {
                    featureLines.setNumPolygons(100);
                    featureLines.setNumPolygons(0);
                }
                int i = featureLines.getMaxNumVertices();
                boolean[] bIsCrest = new boolean[i];
                this.m_elements[k].setSize(i);
                PiVector[] elem2polyVert = new PiVector[noe];
                i = 0;
                while (i < noe) {
                    int num;
                    j = 0;
                    while (j < 3) {
                        bNewVert[j] = false;
                        bAddVert[j] = false;
                        if (neigh[i].m_data[j] < i && neigh[i].m_data[j] != -1) {
                            int nei = neigh[i].m_data[j];
                            int neiLoc = this.m_geom.getOppVertexLocInd(i, j);
                            if (elem2polyVert[nei] != null && elem2polyVert[nei].m_data[neiLoc] != -1) {
                                newVert[j] = elem2polyVert[nei].m_data[neiLoc];
                                bNewVert[j] = true;
                            }
                        } else {
                            int v1 = elem[i].m_data[(j + 1) % 3];
                            int v2 = elem[i].m_data[(j + 2) % 3];
                            double x1 = this.m_extremalities[k].m_data[v1];
                            double x2 = this.m_extremalities[k].m_data[v2];
                            if (PdVector.dot((PdVector)this.m_pcDir[k][v1], (PdVector)this.m_pcDir[k][v2]) < 0.0) {
                                x1 = -x1;
                            }
                            if (x1 < 0.0 && x2 > 0.0 || x1 > 0.0 && x2 < 0.0) {
                                double l = x2 / (x2 - x1);
                                if (Math.abs(this.m_pcVal[k].m_data[v1]) > Math.abs(this.m_pcVal[(k + 1) % 2].m_data[v1])) {
                                    num = featureLines.getNumVertices();
                                    if (num == featureLines.getMaxNumVertices()) {
                                        featureLines.setNumVertices(2 * num);
                                        featureLines.setNumVertices(num);
                                        this.m_elements[k].setSize(2 * num);
                                        boolean[] old = bIsCrest;
                                        bIsCrest = new boolean[2 * num];
                                        int n = old.length;
                                        int m = 0;
                                        while (m < n) {
                                            bIsCrest[m] = old[m];
                                            ++m;
                                        }
                                    }
                                    vertex.m_data[(j + 1) % 3] = l;
                                    vertex.m_data[(j + 2) % 3] = 1.0 - l;
                                    vertex.m_data[j] = 0.0;
                                    int ind = featureLines.addVertex(vertex);
                                    bNewVert[j] = true;
                                    bAddVert[j] = true;
                                    newVert[j] = ind;
                                    this.m_elements[k].m_data[ind] = i;
                                    vhelp.sub(vert[v2], vert[v1]);
                                    if (PdVector.dot((PdVector)vhelp, (PdVector)this.m_pcDir[k][v2]) * x2 <= 0.0 || PdVector.dot((PdVector)vhelp, (PdVector)this.m_pcDir[k][v1]) * this.m_extremalities[k].m_data[v1] >= 0.0) {
                                        bIsCrest[ind] = true;
                                    }
                                }
                            }
                        }
                        ++j;
                    }
                    if (bAddVert[0] || bAddVert[1] || bAddVert[2]) {
                        elem2polyVert[i] = new PiVector(3);
                        j = 0;
                        while (j < 3) {
                            elem2polyVert[i].m_data[j] = bAddVert[j] ? newVert[j] : -1;
                            ++j;
                        }
                    }
                    num = featureLines.getNumVertices();
                    int numPoly = featureLines.getNumPolygons();
                    if (numPoly == featureLines.getMaxNumPolygons()) {
                        featureLines.setNumPolygons(2 * numPoly);
                        featureLines.setNumPolygons(numPoly);
                    }
                    if (bNewVert[0] && bNewVert[1]) {
                        poly.m_data[0] = newVert[0];
                        poly.m_data[1] = newVert[1];
                        featureLines.addPolygon(poly);
                    } else if (bNewVert[1] && bNewVert[2]) {
                        poly.m_data[0] = newVert[1];
                        poly.m_data[1] = newVert[2];
                        featureLines.addPolygon(poly);
                    } else if (bNewVert[2] && bNewVert[0]) {
                        poly.m_data[0] = newVert[2];
                        poly.m_data[1] = newVert[0];
                        featureLines.addPolygon(poly);
                    }
                    ++i;
                }
                elem2polyVert = null;
                int nv = featureLines.getNumVertices();
                this.m_elements[k].setSize(nv);
                PwCleanMesh.joinPolygons((PgPolygonSet)featureLines);
                PiVector[] polygons = featureLines.getPolygons();
                PdVector[] polyVert = featureLines.getVertices();
                int np = featureLines.getNumPolygons();
                int maxcnt = this.m_LineEx_maxNumGreenVert.getValue();
                int numOfNewPolys = 0;
                i = 0;
                while (i < np) {
                    size = polygons[i].getSize();
                    cnt = 0;
                    j = 0;
                    while (j < size) {
                        if (bIsCrest[polygons[i].m_data[j]]) {
                            if (cnt > maxcnt) {
                                cnt = 0;
                                if (maxcnt < j) {
                                    ++numOfNewPolys;
                                }
                            } else if (cnt > 0) {
                                int m = 1;
                                while (m <= cnt) {
                                    bIsCrest[polygons[i].m_data[j - m]] = true;
                                    ++m;
                                }
                                cnt = 0;
                            }
                        } else {
                            ++cnt;
                        }
                        ++j;
                    }
                    ++i;
                }
                PiVector[] newPolys = new PiVector[numOfNewPolys + np];
                polygons = featureLines.getPolygons();
                int maxpolySize = 0;
                i = 0;
                while (i < np) {
                    size = polygons[i].getSize();
                    if (size > maxpolySize) {
                        maxpolySize = size;
                    }
                    ++i;
                }
                PiVector pihelp = new PiVector(maxpolySize);
                boolean lastGreen = false;
                int polyInd = 0;
                int minNumVertices = 2;
                i = 0;
                while (i < np) {
                    size = polygons[i].getSize();
                    lastGreen = true;
                    int vertInd = 0;
                    j = 0;
                    while (j < size) {
                        if (!bIsCrest[polygons[i].m_data[j]]) {
                            if (!lastGreen) {
                                if (vertInd > minNumVertices) {
                                    newPolys[polyInd] = new PiVector(vertInd);
                                    System.arraycopy(pihelp.m_data, 0, newPolys[polyInd].m_data, 0, vertInd);
                                    ++polyInd;
                                }
                                vertInd = 0;
                                lastGreen = true;
                            }
                        } else {
                            pihelp.m_data[vertInd] = polygons[i].m_data[j];
                            ++vertInd;
                            lastGreen = false;
                        }
                        ++j;
                    }
                    if (!lastGreen) {
                        if (vertInd > minNumVertices) {
                            newPolys[polyInd] = new PiVector(vertInd);
                            System.arraycopy(pihelp.m_data, 0, newPolys[polyInd].m_data, 0, vertInd);
                            ++polyInd;
                        }
                        vertInd = 0;
                        lastGreen = true;
                    }
                    ++i;
                }
                i = 0;
                while (i < newPolys.length) {
                    if (newPolys[i] == null) break;
                    ++i;
                }
                featureLines.setNumPolygons(i);
                featureLines.setPolygons(newPolys);
                newPolys = null;
                np = featureLines.getNumPolygons();
                polygons = featureLines.getPolygons();
                boolean[] bUsed = new boolean[nv];
                i = 0;
                while (i < np) {
                    j = 0;
                    while (j < polygons[i].m_data.length) {
                        bUsed[polygons[i].m_data[j]] = true;
                        ++j;
                    }
                    ++i;
                }
                nv = featureLines.getNumVertices();
                polyVert = featureLines.getVertices();
                i = 0;
                while (i < nv) {
                    if (!bUsed[i] || !bIsCrest[i]) {
                        polyVert[i].setTag(2);
                    } else {
                        polyVert[i].clearTag(2);
                    }
                    ++i;
                }
                int[] newPos = featureLines.removeMarkedVertices();
                int nvOld = nv;
                nv = featureLines.getNumVertices();
                polyVert = featureLines.getVertices();
                if (this.m_bary[k] == null || this.m_bary.length != nv) {
                    this.m_bary[k] = new PdBary[nv];
                }
                i = 0;
                while (i < nv) {
                    if (this.m_bary[k][i] == null) {
                        this.m_bary[k][i] = new PdBary(3);
                    }
                    this.m_bary[k][i].m_data[0] = polyVert[i].m_data[0];
                    this.m_bary[k][i].m_data[1] = polyVert[i].m_data[1];
                    this.m_bary[k][i].m_data[2] = polyVert[i].m_data[2];
                    ++i;
                }
                PiVector elementsOld = this.m_elements[k];
                this.m_elements[k] = new PiVector(nv);
                cnt = 0;
                i = 0;
                while (i < nvOld) {
                    if (newPos[i] != -1) {
                        this.m_elements[k].m_data[newPos[i]] = elementsOld.m_data[i];
                    }
                    ++i;
                }
                elementsOld = null;
                i = 0;
                while (i < nv) {
                    j = this.m_elements[k].m_data[i];
                    polyVert[i].blend(this.m_bary[k][i].m_data[0], vert[elem[j].m_data[0]], this.m_bary[k][i].m_data[1], vert[elem[j].m_data[1]], this.m_bary[k][i].m_data[2], vert[elem[j].m_data[2]]);
                    ++i;
                }
                this.m_polygons[k] = PiVector.copyNew((PiVector[])featureLines.getPolygons());
            }
            ++k;
        }
    }

    private void adjustFilterSliders() {
        int nov = Math.min(10000, this.m_geom.getNumVertices());
        int[] sort = new int[nov];
        PuMath.heapsort((int)nov, (double[])this.m_pcVal[0].m_data, (int[])sort);
        double max1 = Math.max(Math.abs(this.m_pcVal[0].m_data[sort[nov - nov / 10]]), Math.abs(this.m_pcVal[0].m_data[sort[nov / 10]]));
        PuMath.heapsort((int)nov, (double[])this.m_pcVal[1].m_data, (int[])sort);
        double max2 = Math.max(Math.abs(this.m_pcVal[1].m_data[sort[nov - nov / 10]]), Math.abs(this.m_pcVal[1].m_data[sort[nov / 10]]));
        double max = Math.max(max1, max2);
        this.m_filter_curvLocal.setBounds(0.0, max, max * 0.025, max * 0.1);
        this.m_filter_curvLocal.setValue(max * 0.1);
        double diam = this.m_geom.getDiameter();
        this.m_filter_curvIntegral.setBounds(0.0, max *= diam, max * 0.01, max * 0.1);
        this.m_filter_curvIntegral.setValue(0.0);
    }

    private void adjustConstraintSlider() {
        double l;
        int noe = Math.min(10000, this.m_geom.getNumElements());
        int num = 0;
        double totalLength = 0.0;
        PdVector tmp = new PdVector(this.m_geom.getDimOfVertices());
        PiVector[] elem = this.m_geom.getElements();
        PdVector[] vert = this.m_geom.getVertices();
        int i = 0;
        while (i < noe) {
            int size = elem[i].m_data.length;
            int j = 0;
            while (j < size) {
                tmp.sub(vert[elem[i].m_data[j]], vert[elem[i].m_data[(j + 1) % size]]);
                totalLength += tmp.length();
                ++num;
                ++j;
            }
            ++i;
        }
        this.m_averageEdgeLength = l = totalLength / (double)num;
        this.m_cuSth_epsilon.setBounds(0.0, 10.0 * l, l * 0.2, l);
        this.m_cuSth_epsilon.setValue(l);
    }

    protected void filterFeatureLines() {
        double curvLocalThres = this.m_filter_curvLocal.getValue();
        double curvIntThres = this.m_filter_curvIntegral.getValue();
        int maxNum = this.m_filter_curvLocal_maxNum;
        PiVector[] elements = this.m_geom.getElements();
        PdVector[] vertices = this.m_geom.getVertices();
        boolean[][] bIsFiltered = new boolean[2][];
        int[] npDispFL = new int[2];
        PdVector v1 = new PdVector(3);
        PdVector v2 = new PdVector(3);
        int k = 0;
        while (k < 2) {
            if (!(this.m_mode == 2 && k == 0 || this.m_mode == 1 && k == 1)) {
                int np = this.m_polygons[k].length;
                bIsFiltered[k] = new boolean[np];
                int i = 0;
                while (i < np) {
                    double curvLocal;
                    int nv = this.m_polygons[k][i].getSize();
                    int num = 0;
                    double curvInt = 0.0;
                    double l2 = 0.0;
                    int vert = this.m_polygons[k][i].m_data[0];
                    int[] elem = elements[this.m_elements[k].m_data[vert]].m_data;
                    v2.blend(this.m_bary[k][vert].m_data[0], vertices[elem[0]], this.m_bary[k][vert].m_data[1], vertices[elem[1]], this.m_bary[k][vert].m_data[2], vertices[elem[2]]);
                    int j = 0;
                    while (j < nv - 1) {
                        vert = this.m_polygons[k][i].m_data[j];
                        elem = elements[this.m_elements[k].m_data[vert]].m_data;
                        curvLocal = Math.abs(this.m_bary[k][vert].m_data[0] * this.m_pcVal[k].m_data[elem[0]] + this.m_bary[k][vert].m_data[1] * this.m_pcVal[k].m_data[elem[1]] + this.m_bary[k][vert].m_data[2] * this.m_pcVal[k].m_data[elem[2]]);
                        if (curvLocal > curvLocalThres) {
                            ++num;
                        }
                        vert = this.m_polygons[k][i].m_data[j + 1];
                        elem = elements[this.m_elements[k].m_data[vert]].m_data;
                        v1.copyArray(v2);
                        double l1 = l2;
                        v2.blend(this.m_bary[k][vert].m_data[0], vertices[elem[0]], this.m_bary[k][vert].m_data[1], vertices[elem[1]], this.m_bary[k][vert].m_data[2], vertices[elem[2]]);
                        v1.sub(v2);
                        l2 = v1.length();
                        curvInt += curvLocal * (l1 += l2);
                        ++j;
                    }
                    vert = this.m_polygons[k][i].m_data[j];
                    elem = elements[this.m_elements[k].m_data[vert]].m_data;
                    curvLocal = Math.abs(this.m_bary[k][vert].m_data[0] * this.m_pcVal[k].m_data[elem[0]] + this.m_bary[k][vert].m_data[1] * this.m_pcVal[k].m_data[elem[1]] + this.m_bary[k][vert].m_data[2] * this.m_pcVal[k].m_data[elem[2]]);
                    if (curvLocal > curvLocalThres) {
                        ++num;
                    }
                    curvInt += curvLocal * l2;
                    curvInt *= 0.5;
                    if (num > maxNum && curvInt > curvIntThres) {
                        bIsFiltered[k][i] = true;
                        int n = k;
                        npDispFL[n] = npDispFL[n] + 1;
                    }
                    ++i;
                }
            }
            ++k;
        }
        if (this.m_b_offsets_flag) {
            this.buildOffsetCurves(bIsFiltered, npDispFL);
        } else {
            this.buildFeatureLines(bIsFiltered, npDispFL);
        }
    }

    private void buildFeatureLines(boolean[][] bIsFiltered, int[] npDispFL) {
        PdVector[] vertices = this.m_geom.getVertices();
        PiVector[] elements = this.m_geom.getElements();
        int k = 0;
        while (k < 2) {
            if (!(this.m_mode == 2 && k == 0 || this.m_mode == 1 && k == 1)) {
                int j;
                int nv = this.m_elements[k].m_data.length;
                this.m_dispFL[k].setNumVertices(nv);
                PdVector[] polyVert = this.m_dispFL[k].getVertices();
                int i = 0;
                while (i < nv) {
                    j = this.m_elements[k].m_data[i];
                    polyVert[i].blend(this.m_bary[k][i].m_data[0], vertices[elements[j].m_data[0]], this.m_bary[k][i].m_data[1], vertices[elements[j].m_data[1]], this.m_bary[k][i].m_data[2], vertices[elements[j].m_data[2]]);
                    ++i;
                }
                this.m_dispFL[k].setNumPolygons(npDispFL[k]);
                PiVector[] poly = this.m_dispFL[k].getPolygons();
                int np = this.m_polygons[k].length;
                j = 0;
                i = 0;
                while (i < np) {
                    if (bIsFiltered[k][i]) {
                        poly[j].setSize(this.m_polygons[k][i].getSize());
                        poly[j].copyArray(this.m_polygons[k][i]);
                        ++j;
                    }
                    ++i;
                }
                this.m_dispFL[k].removeUnusedVertices();
            }
            ++k;
        }
    }

    private void buildOffsetCurves(boolean[][] bIsFiltered, int[] npDispFL) {
        double dist = this.m_offsets_distance.getValue();
        if (dist == 0.0) {
            this.buildFeatureLines(bIsFiltered, npDispFL);
            return;
        }
        PgPolygonOnElementSet polyES = new PgPolygonOnElementSet(this.m_geom);
        PiVector normalsElements = new PiVector();
        PdVector distVec = new PdVector();
        PdVector[] vertices = this.m_geom.getVertices();
        PiVector[] elements = this.m_geom.getElements();
        PdVector orthoCurvFunc = new PdVector();
        PdVector gaps = new PdVector();
        int dim = this.m_geom.getDimOfVertices();
        PdVector edge = new PdVector(dim);
        PdVector point = new PdVector(dim);
        PgPolygonOnElementSet orthoGeod = new PgPolygonOnElementSet(this.m_geom);
        int k = 0;
        while (k < 2) {
            if (!(this.m_mode == 2 && k == 0 || this.m_mode == 1 && k == 1)) {
                int m;
                int j;
                int np = this.m_polygons[k].length;
                int nv = this.m_elements[k].m_data.length;
                this.m_dispFL[k].setNumVertices(2 * nv);
                PdVector[] polyVert = this.m_dispFL[k].getVertices();
                int i = 0;
                while (i < np) {
                    if (bIsFiltered[k][i]) {
                        int actElem;
                        double l;
                        double lenInv;
                        double len;
                        double av1;
                        int n;
                        double av0;
                        int actVert;
                        nv = this.m_polygons[k][i].m_data.length;
                        normalsElements.setSize(nv);
                        PdBaryDir[] normals = new PdBaryDir[nv];
                        j = 0;
                        while (j < nv) {
                            normals[j] = new PdBaryDir(3);
                            ++j;
                        }
                        distVec.setSize(nv);
                        polyES.setNumVertices(nv);
                        PiVector pES_elements = polyES.getVertexElemInd();
                        PdBary[] pES_bary = polyES.getVertexBary();
                        j = 0;
                        while (j < nv) {
                            actVert = this.m_polygons[k][i].m_data[j];
                            pES_elements.m_data[j] = this.m_elements[k].m_data[actVert];
                            m = 0;
                            while (m < 3) {
                                pES_bary[j].m_data[m] = this.m_bary[k][actVert].m_data[m];
                                normals[j].m_data[m] = this.m_lineNormals[k][actVert].m_data[m];
                                ++m;
                            }
                            normalsElements.m_data[j] = this.m_lineNormalsElements[k].m_data[actVert];
                            ++j;
                        }
                        if (this.m_b_offsets_useCurvature) {
                            orthoCurvFunc.setSize(nv);
                            j = 0;
                            while (j < nv) {
                                orthoCurvFunc.m_data[j] = this.computeOrthCurvGrad(pES_bary[j], pES_elements.m_data[j], 2.0 * this.m_averageEdgeLength, k, orthoGeod, normals[j]);
                                ++j;
                            }
                            gaps.setSize(nv - 1);
                            j = 0;
                            edge.blend(pES_bary[j].m_data[0], vertices[elements[pES_elements.m_data[j]].m_data[0]], pES_bary[j].m_data[1], vertices[elements[pES_elements.m_data[j]].m_data[1]], pES_bary[j].m_data[2], vertices[elements[pES_elements.m_data[j]].m_data[2]]);
                            j = 1;
                            while (j < nv) {
                                point.blend(pES_bary[j].m_data[0], vertices[elements[pES_elements.m_data[j]].m_data[0]], pES_bary[j].m_data[1], vertices[elements[pES_elements.m_data[j]].m_data[1]], pES_bary[j].m_data[2], vertices[elements[pES_elements.m_data[j]].m_data[2]]);
                                edge.sub(point);
                                gaps.m_data[j - 1] = edge.length();
                                edge.copyArray(point);
                                ++j;
                            }
                            this.smoothFunction(gaps, orthoCurvFunc);
                            av0 = 0.0;
                            n = nv / 2;
                            j = 0;
                            while (j < n) {
                                av0 += orthoCurvFunc.m_data[j];
                                ++j;
                            }
                            av0 /= (double)n;
                            av1 = 0.0;
                            j = n;
                            while (j < nv) {
                                av1 += orthoCurvFunc.m_data[j];
                                ++j;
                            }
                            av1 /= (double)n;
                            len = 0.0;
                            j = 0;
                            while (j < nv - 1) {
                                len += gaps.m_data[j];
                                ++j;
                            }
                            lenInv = 1.0 / len;
                            l = 0.0;
                            orthoCurvFunc.m_data[0] = av0;
                            j = 1;
                            while (j < nv) {
                                orthoCurvFunc.m_data[j] = ((l += gaps.m_data[j - 1]) * av1 + (len - l) * av0) * lenInv;
                                ++j;
                            }
                            j = 0;
                            while (j < nv) {
                                distVec.m_data[j] = Math.abs(orthoCurvFunc.m_data[j]) * dist;
                                ++j;
                            }
                        } else {
                            distVec.setConstant(dist);
                        }
                        PwBary.translatePolygonOnElementSet((PgPolygonOnElementSet)polyES, (PdBaryDir[])normals, (PiVector)normalsElements, (PdVector)distVec);
                        j = 0;
                        while (j < nv) {
                            actElem = pES_elements.m_data[j];
                            actVert = this.m_polygons[k][i].m_data[j];
                            polyVert[actVert].blend(pES_bary[j].m_data[0], vertices[elements[actElem].m_data[0]], pES_bary[j].m_data[1], vertices[elements[actElem].m_data[1]], pES_bary[j].m_data[2], vertices[elements[actElem].m_data[2]]);
                            ++j;
                        }
                        j = 0;
                        while (j < nv) {
                            actVert = this.m_polygons[k][i].m_data[j];
                            pES_elements.m_data[j] = this.m_elements[k].m_data[actVert];
                            m = 0;
                            while (m < 3) {
                                pES_bary[j].m_data[m] = this.m_bary[k][actVert].m_data[m];
                                normals[j].m_data[m] = -this.m_lineNormals[k][actVert].m_data[m];
                                ++m;
                            }
                            normalsElements.m_data[j] = this.m_lineNormalsElements[k].m_data[actVert];
                            ++j;
                        }
                        if (this.m_b_offsets_useCurvature) {
                            orthoCurvFunc.setSize(nv);
                            j = 0;
                            while (j < nv) {
                                orthoCurvFunc.m_data[j] = this.computeOrthCurvGrad(pES_bary[j], pES_elements.m_data[j], 2.0 * this.m_averageEdgeLength, k, orthoGeod, normals[j]);
                                ++j;
                            }
                            gaps.setSize(nv - 1);
                            j = 0;
                            edge.blend(pES_bary[j].m_data[0], vertices[elements[pES_elements.m_data[j]].m_data[0]], pES_bary[j].m_data[1], vertices[elements[pES_elements.m_data[j]].m_data[1]], pES_bary[j].m_data[2], vertices[elements[pES_elements.m_data[j]].m_data[2]]);
                            j = 1;
                            while (j < nv) {
                                point.blend(pES_bary[j].m_data[0], vertices[elements[pES_elements.m_data[j]].m_data[0]], pES_bary[j].m_data[1], vertices[elements[pES_elements.m_data[j]].m_data[1]], pES_bary[j].m_data[2], vertices[elements[pES_elements.m_data[j]].m_data[2]]);
                                edge.sub(point);
                                gaps.m_data[j - 1] = edge.length();
                                edge.copyArray(point);
                                ++j;
                            }
                            this.smoothFunction(gaps, orthoCurvFunc);
                            av0 = 0.0;
                            n = nv / 2;
                            j = 0;
                            while (j < n) {
                                av0 += orthoCurvFunc.m_data[j];
                                ++j;
                            }
                            av0 /= (double)n;
                            av1 = 0.0;
                            j = n;
                            while (j < nv) {
                                av1 += orthoCurvFunc.m_data[j];
                                ++j;
                            }
                            av1 /= (double)n;
                            len = 0.0;
                            j = 0;
                            while (j < nv - 1) {
                                len += gaps.m_data[j];
                                ++j;
                            }
                            lenInv = 1.0 / len;
                            l = 0.0;
                            orthoCurvFunc.m_data[0] = av0;
                            j = 1;
                            while (j < nv) {
                                orthoCurvFunc.m_data[j] = ((l += gaps.m_data[j - 1]) * av1 + (len - l) * av0) * lenInv;
                                ++j;
                            }
                            j = 0;
                            while (j < nv) {
                                distVec.m_data[j] = Math.abs(orthoCurvFunc.m_data[j]) * dist;
                                ++j;
                            }
                        } else {
                            distVec.setConstant(dist);
                        }
                        PwBary.translatePolygonOnElementSet((PgPolygonOnElementSet)polyES, (PdBaryDir[])normals, (PiVector)normalsElements, (PdVector)distVec);
                        m = this.m_elements[k].m_data.length;
                        j = 0;
                        while (j < nv) {
                            actElem = pES_elements.m_data[j];
                            actVert = this.m_polygons[k][i].m_data[j] + m;
                            polyVert[actVert].blend(pES_bary[j].m_data[0], vertices[elements[actElem].m_data[0]], pES_bary[j].m_data[1], vertices[elements[actElem].m_data[1]], pES_bary[j].m_data[2], vertices[elements[actElem].m_data[2]]);
                            ++j;
                        }
                    }
                    ++i;
                }
                this.m_dispFL[k].setNumPolygons(2 * npDispFL[k]);
                PiVector[] poly = this.m_dispFL[k].getPolygons();
                np = this.m_polygons[k].length;
                j = 0;
                i = 0;
                while (i < np) {
                    if (bIsFiltered[k][i]) {
                        poly[j].setSize(this.m_polygons[k][i].getSize());
                        poly[j].copyArray(this.m_polygons[k][i]);
                        ++j;
                    }
                    ++i;
                }
                nv = this.m_elements[k].m_data.length;
                i = 0;
                while (i < np) {
                    if (bIsFiltered[k][i]) {
                        poly[j].setSize(this.m_polygons[k][i].getSize());
                        m = 0;
                        while (m < this.m_polygons[k][i].m_data.length) {
                            poly[j].m_data[m] = this.m_polygons[k][i].m_data[m] + nv;
                            ++m;
                        }
                        ++j;
                    }
                    ++i;
                }
                this.m_dispFL[k].removeUnusedVertices();
            }
            ++k;
        }
    }

    private double computeOrthCurvGrad(PdBary initPos, int initElem, double h, int k, PgPolygonOnElementSet orthoGeod, PdBaryDir orthoDir) {
        PdBaryDir stretchedDir = (PdBaryDir)orthoDir.clone();
        stretchedDir.multScalar(h);
        initPos.m_elementInd = initElem;
        if (this.m_exp == null) {
            this.m_exp = new PnStraightestGeodesic(orthoGeod.getGeometry(), false);
            this.m_exp.setAccuracy(PnStraightestGeodesic.BARYEPS);
        }
        this.m_exp.eval(initPos, stretchedDir, orthoGeod, stretchedDir);
        double[] pc = this.m_pcVal[k].m_data;
        PiVector[] elements = this.m_geom.getElements();
        PdVector[] vertices = this.m_geom.getVertices();
        PiVector geodElem = orthoGeod.getVertexElemInd();
        PdBary[] geodBary = orthoGeod.getVertexBary();
        int dim = this.m_geom.getDimOfVertices();
        PdVector point = new PdVector(dim);
        PdVector edge = new PdVector(dim);
        int[] e = elements[initElem].m_data;
        double[] b = initPos.m_data;
        edge.blend(b[0], vertices[e[0]], b[1], vertices[e[1]], b[2], vertices[e[2]]);
        double k0 = pc[e[0]] * b[0] + pc[e[1]] * b[1] + pc[e[2]] * b[2];
        int nv = orthoGeod.getNumVertices();
        e = elements[geodElem.m_data[1]].m_data;
        b = geodBary[1].m_data;
        point.blend(b[0], vertices[e[0]], b[1], vertices[e[1]], b[2], vertices[e[2]]);
        edge.sub(point);
        double dist = edge.length();
        edge.copyArray(point);
        double k1 = pc[e[0]] * b[0] + pc[e[1]] * b[1] + pc[e[2]] * b[2];
        boolean increasing = k1 > k0;
        double kprev = k1;
        int i = 2;
        while (i < nv && k1 >= kprev == increasing) {
            e = elements[geodElem.m_data[i]].m_data;
            b = geodBary[i].m_data;
            kprev = k1;
            k1 = pc[e[0]] * b[0] + pc[e[1]] * b[1] + pc[e[2]] * b[2];
            point.blend(b[0], vertices[e[0]], b[1], vertices[e[1]], b[2], vertices[e[2]]);
            edge.sub(point);
            dist += edge.length();
            edge.copyArray(point);
            ++i;
        }
        return dist / (k1 - k0);
    }

    private PdVector smoothFunction(PdVector gaps, PdVector func) {
        if (this.m_tmpApproxSpline == null) {
            this.m_tmpApproxSpline = PdVector.realloc(null, (int)8, (int)0);
        }
        PdVector[] v = this.m_tmpApproxSpline;
        int i = 0;
        while (i < gaps.m_data.length) {
            if (gaps.m_data[i] < 1.0E-5) {
                gaps.m_data[i] = 1.0E-5;
            }
            ++i;
        }
        int nv = Math.min(gaps.m_data.length + 1, func.m_data.length);
        func = PnFunctionSmoother.approxCubicSpline(nv, func, gaps, false, 0.99, null, v[0], v[1], v[2], v[3], v[4], v[5], v[6], v[7]);
        return func;
    }

    protected void smoothFeatureLines() {
        int nv;
        int i;
        PiVector[] polys;
        int np;
        double constraint = this.m_cuSth_epsilon.getValue();
        int dim = this.m_dispFL[0].getDimOfVertices();
        PgPolygon polygon = new PgPolygon(dim);
        int maxVert = 0;
        int k = 0;
        while (k < 2) {
            if (!(this.m_mode == 2 && k == 0 || this.m_mode == 1 && k == 1)) {
                np = this.m_dispFL[k].getNumPolygons();
                polys = this.m_dispFL[k].getPolygons();
                i = 0;
                while (i < np) {
                    nv = polys[i].m_data.length;
                    if (nv > maxVert) {
                        maxVert = nv;
                    }
                    ++i;
                }
            }
            ++k;
        }
        polygon.setNumVertices(maxVert);
        boolean bDebug = false;
        k = 0;
        while (k < 2) {
            if (!(this.m_mode == 2 && k == 0 || this.m_mode == 1 && k == 1)) {
                PdVector[] vertPolySet = this.m_dispFL[k].getVertices();
                np = this.m_dispFL[k].getNumPolygons();
                int maxNumVertPolySet = this.m_dispFL[k].getMaxNumVertices();
                int numVertPolySet = this.m_dispFL[k].getNumVertices();
                polys = this.m_dispFL[k].getPolygons();
                i = 0;
                while (i < np) {
                    int m;
                    polys[i].clearTag(2);
                    nv = polys[i].getSize();
                    polygon.setNumVertices(nv);
                    PdVector[] vertOfPolygon = polygon.getVertices();
                    polygon.setClosed(polys[i].m_data[0] == polys[i].m_data[nv - 1]);
                    int j = 0;
                    while (j < nv) {
                        m = 0;
                        while (m < dim) {
                            vertOfPolygon[j].m_data[m] = vertPolySet[polys[i].m_data[j]].m_data[m];
                            ++m;
                        }
                        ++j;
                    }
                    if (polygon.getDiameter() < 3.0 * constraint) {
                        polys[i].setTag(2);
                    } else {
                        if (bDebug) {
                            this.m_display.addGeometry((PgGeometryIf)((PgGeometry)polygon.clone()));
                        }
                        int nvPolygon = polygon.getNumVertices();
                        vertOfPolygon = polygon.getVertices();
                        if (nvPolygon <= nv) {
                            polys[i].setSize(nvPolygon);
                            j = 0;
                            while (j < nvPolygon) {
                                m = 0;
                                while (m < dim) {
                                    vertPolySet[polys[i].m_data[j]].m_data[m] = vertOfPolygon[j].m_data[m];
                                    ++m;
                                }
                                ++j;
                            }
                        } else {
                            j = 0;
                            while (j < nv) {
                                m = 0;
                                while (m < dim) {
                                    vertPolySet[polys[i].m_data[j]].m_data[m] = vertOfPolygon[j].m_data[m];
                                    ++m;
                                }
                                ++j;
                            }
                            int vertDiff = nvPolygon - nv;
                            if (maxNumVertPolySet - numVertPolySet < vertDiff) {
                                this.m_dispFL[k].setNumVertices(maxNumVertPolySet *= 2);
                            }
                            int ind = numVertPolySet;
                            this.m_dispFL[k].setNumVertices(numVertPolySet += vertDiff);
                            vertPolySet = this.m_dispFL[k].getVertices();
                            polys[i].setSize(nvPolygon);
                            j = nv;
                            while (j < nvPolygon) {
                                polys[i].m_data[j] = ind;
                                m = 0;
                                while (m < dim) {
                                    vertPolySet[ind].m_data[m] = vertOfPolygon[j].m_data[m];
                                    ++m;
                                }
                                ++j;
                                ++ind;
                            }
                        }
                        this.m_dispFL[k].setClosed(i, polygon.isClosed());
                    }
                    ++i;
                }
                this.m_dispFL[k].removeMarkedPolygons();
                this.m_dispFL[k].removeUnusedVertices();
            }
            ++k;
        }
    }

    protected void saveToDiscAsPolygons() {
        try {
            FileWriter writer = new FileWriter(this.m_saveFileBaseName);
            PgPlyLoader loader = new PgPlyLoader();
            PgJvxSrc[] src = new PgJvxSrc[]{this.m_geom.getJvx()};
            loader.write((Writer)writer, src, this.m_extremalities, this.m_pcVal, this.m_pcDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PgPolyLoader.writePgPolygonSetAsMultipleFiles(this.m_dispFL[0], String.valueOf(this.m_saveFileBaseName) + "_red");
        PgPolyLoader.writePgPolygonSetAsMultipleFiles(this.m_dispFL[1], String.valueOf(this.m_saveFileBaseName) + "_blue");
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }

    public boolean isStopped() {
        return this.m_bStopped;
    }

    public void start() {
        if (!this.m_bStopped || this.m_bRunning) {
            return;
        }
        this.m_bRunning = true;
        this.m_thread = new Thread((Runnable)this, "JavaView: Shape Approximation");
        this.m_thread.setPriority(5);
        this.m_thread.start();
        PsDebug.notify((String)"Thread started");
    }

    public void stop() {
        if (this.m_bRunning) {
            this.m_bRunning = false;
            this.m_thread = null;
            PsDebug.notify((String)"Thread stopped");
        }
    }

    @Override
    public void run() {
        this.m_bStopped = false;
        this.smoothExtremalities();
        this.extractFeatureLines();
        this.filterFeatureLines();
        this.updateOrAddFeatureLines();
        this.stop();
        this.m_bStopped = true;
        this.update(this);
    }

    public static void smoothPolygonsInDisplay(PvDisplay disp, int numSteps, double spatialConstraint, double stepFactor, int numCoarsenSteps, double identifyEPS) {
        PgGeometryIf[] geom = disp.getGeometries();
        PgPolygon poly = new PgPolygon(3);
        int nog = geom.length;
        int i = 0;
        while (i < nog) {
            if (geom[i] instanceof PgPolygonSet) {
                PgPolygonSet polySet = (PgPolygonSet)geom[i];
                PuCleanMesh.identifyVertices((PgPointSet)polySet, (double)identifyEPS);
                PwCleanMesh.joinPolygons((PgPolygonSet)polySet);
                int j = 0;
                while (j < numCoarsenSteps) {
                    if (polySet.getNumVertices() > 50) {
                        PwRefinePolygon.coarsenChaikin((PgPolygonSet)polySet);
                    }
                    ++j;
                }
                PgJvxSrc jvx = polySet.getJvx();
                poly.setJvx(jvx);
                int nov = poly.getNumVertices();
                if (nov > 2) {
                    nov = poly.getNumVertices();
                    PdVector[] vertOld = polySet.getVertices();
                    PdVector[] vertNew = poly.getVertices();
                    int j2 = 0;
                    while (j2 < nov) {
                        int k = 0;
                        while (k < 3) {
                            vertOld[j2].m_data[k] = vertNew[j2].m_data[k];
                            ++k;
                        }
                        ++j2;
                    }
                }
            }
            ++i;
        }
    }

    public static int octantTest(PgElementSet geom, int curv) {
        int nov = geom.getNumVertices();
        PdMatrix[] shape = PdMatrix.realloc(null, (int)nov, (int)3, (int)3);
        PdVector[] pcValues = PdVector.realloc(null, (int)2, (int)nov);
        PdVector[][] pcVector = new PdVector[][]{PdVector.realloc(null, (int)nov, (int)3), PdVector.realloc(null, (int)nov, (int)3)};
        PwCurvature.getPrincipalCurvatures((PgElementSet)geom, (PdMatrix[])shape, (PdVector[])pcValues, (PdVector[][])pcVector);
        int noe = geom.getNumElements();
        PiVector[] elem = geom.getElements();
        int cnt = 0;
        int i = 0;
        while (i < noe) {
            elem[i].setTag(1);
            PdVector a = pcVector[curv][elem[i].m_data[0]];
            PdVector b = pcVector[curv][elem[i].m_data[1]];
            PdVector c = pcVector[curv][elem[i].m_data[2]];
            if (PdVector.dot((PdVector)a, (PdVector)b) < 0.0) {
                b.multScalar(-1.0);
            }
            if (PdVector.dot((PdVector)a, (PdVector)c) < 0.0) {
                c.multScalar(-1.0);
            }
            if (PdVector.dot((PdVector)b, (PdVector)c) > 0.0) {
                elem[i].clearTag(1);
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    public static void colorSelected(PgElementSet geom, Color color) {
        PdVector[] vert = geom.getVertices();
        int nov = geom.getNumVertices();
        int i = 0;
        while (i < nov) {
            if (vert[i].hasTag(1)) {
                geom.setVertexColor(i, color);
            }
            ++i;
        }
    }
}

