/*
 * Decompiled with CFR 0.152.
 */
package devFeature;

import devFeature.PwSmoothField;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.numeric.PnStiffDiriConforming;
import jvx.vector.PwScalarField;

public class PnExtremality {
    public static PdVector[] getExtremalities(PgElementSet geom, PdVector[] pcValues, PdVector[][] pcVector, PdVector[] extremality) {
        double dot;
        int k;
        int j;
        double area;
        int nov = geom.getNumVertices();
        int dim = geom.getDimOfVertices();
        int noe = geom.getNumElements();
        if (extremality == null || extremality.length < 2) {
            extremality = PdVector.realloc((PdVector[])extremality, (int)2, (int)nov);
        }
        PiVector[] elem = geom.getElements();
        PdVector[] kmaxDir = PdVector.realloc(null, (int)nov, (int)dim);
        PgVectorField grad = new PgVectorField(dim);
        grad.computeGradient(geom, pcValues[0]);
        int i = 0;
        while (i < nov) {
            kmaxDir[i].copyArray(pcVector[0][i]);
            kmaxDir[i].normalize();
            ++i;
        }
        PdVector[] gradVec = grad.getVectors();
        PdVector func = extremality[0];
        if (func.getSize() != nov) {
            func.setSize(nov);
        }
        func.setConstant(0.0);
        double[] areaStar = new double[nov];
        i = 0;
        while (i < noe) {
            area = geom.getAreaOfElement(i);
            j = 0;
            while (j < 3) {
                k = elem[i].m_data[j];
                dot = PdVector.dot((PdVector)kmaxDir[k], (PdVector)gradVec[i]);
                int n = k;
                func.m_data[n] = func.m_data[n] + area * dot;
                int n2 = k;
                areaStar[n2] = areaStar[n2] + area;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nov) {
            int n = i;
            func.m_data[n] = func.m_data[n] * (3.0 / areaStar[i]);
            ++i;
        }
        grad.computeGradient(geom, pcValues[1]);
        i = 0;
        while (i < nov) {
            kmaxDir[i].copyArray(pcVector[1][i]);
            kmaxDir[i].normalize();
            ++i;
        }
        func = extremality[1];
        if (func.getSize() != nov) {
            func.setSize(nov);
        }
        func.setConstant(0.0);
        i = 0;
        while (i < noe) {
            area = geom.getAreaOfElement(i);
            j = 0;
            while (j < 3) {
                k = elem[i].m_data[j];
                dot = -PdVector.dot((PdVector)kmaxDir[k], (PdVector)gradVec[i]);
                int n = k;
                func.m_data[n] = func.m_data[n] + area * dot;
                int n3 = k;
                areaStar[n3] = areaStar[n3] + area;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nov) {
            int n = i;
            func.m_data[n] = func.m_data[n] * (3.0 / areaStar[i]);
            ++i;
        }
        return extremality;
    }

    public static void smoothExtremality(PdVector featFunc, PdVector[] kappaMaxDir, PgElementSet geom, double stepWidth, int numSteps, boolean keepBoundary) {
        PwSmoothField smooth = new PwSmoothField();
        smooth.setGeometry(geom);
        PgVectorField scalarField = PwScalarField.array2ScalarField((PgPointSet)geom, (double[])featFunc.m_data, null);
        smooth.enableBiconjugateGradient(true);
        smooth.setField(scalarField);
        smooth.setEnableKeepBoundary(keepBoundary);
        smooth.setEnabledUpdate(false);
        PnStiffDiriConforming stiffMatrix = smooth.getStiffnessMatrix();
        PdVector[] stiff = stiffMatrix.getEntries();
        PiVector[] sindx = stiffMatrix.getColIndices();
        PiVector snoe = stiffMatrix.getNumEntries();
        int nov = stiff.length;
        int i = 0;
        while (i < nov) {
            int size = snoe.m_data[i];
            int j = 0;
            while (j < size) {
                if (i != sindx[i].m_data[j] && sindx[i].m_data[j] >= 0 && sindx[i].m_data[j] <= nov && PdVector.dot((PdVector)kappaMaxDir[i], (PdVector)kappaMaxDir[sindx[i].m_data[j]]) < 0.0) {
                    stiff[i].m_data[j] = -stiff[i].m_data[j];
                }
                ++j;
            }
            ++i;
        }
        smooth.backupStiff();
        smooth.setStepWidth(stepWidth);
        i = 0;
        while (i < numSteps) {
            smooth.smoothingStep();
            ++i;
        }
        PwScalarField.scalarField2Array((PgVectorField)scalarField, (double[])featFunc.m_data);
    }

    public static void smoothExtremality(PdVector featFunc, PdVector vertexWeightFunction, PdVector[] kappaMaxDir, PgElementSet geom, double stepWidth, int numSteps, boolean keepBoundary) {
        PwSmoothField smooth = new PwSmoothField();
        smooth.enableBiconjugateGradient(true);
        smooth.setGeometry(geom);
        PgVectorField scalarField = PwScalarField.array2ScalarField((PgPointSet)geom, (double[])featFunc.m_data, null);
        smooth.setField(scalarField);
        smooth.setEnableKeepBoundary(keepBoundary);
        smooth.setEnabledUpdate(false);
        PnStiffDiriConforming stiffMatrix = smooth.getStiffnessMatrix();
        PdVector[] stiff = stiffMatrix.getEntries();
        PiVector[] sindx = stiffMatrix.getColIndices();
        PiVector snoe = stiffMatrix.getNumEntries();
        int nov = stiff.length;
        int i = 0;
        while (i < nov) {
            int size = snoe.m_data[i];
            int j = 0;
            while (j < size) {
                int n = j;
                stiff[i].m_data[n] = stiff[i].m_data[n] * vertexWeightFunction.m_data[i];
                if (i != sindx[i].m_data[j] && sindx[i].m_data[j] >= 0 && sindx[i].m_data[j] <= nov && PdVector.dot((PdVector)kappaMaxDir[i], (PdVector)kappaMaxDir[sindx[i].m_data[j]]) < 0.0) {
                    stiff[i].m_data[j] = -stiff[i].m_data[j];
                }
                ++j;
            }
            ++i;
        }
        smooth.backupStiff();
        smooth.setStepWidth(stepWidth);
        i = 0;
        while (i < numSteps) {
            smooth.smoothingStep();
            ++i;
        }
        PwScalarField.scalarField2Array((PgVectorField)scalarField, (double[])featFunc.m_data);
    }

    public static PgVectorField getGradientOfFeatureFunction(PgElementSet domain, PdVector featureFunction, PdVector[] kappaMaxDir, PgVectorField gradFeatureFunction) {
        int dim = domain.getDimOfVertices();
        if (gradFeatureFunction == null) {
            gradFeatureFunction = new PgVectorField(dim, 1);
            gradFeatureFunction.setGeometry((PgPointSet)domain);
        } else {
            gradFeatureFunction.setBasedOn(1);
            if (gradFeatureFunction.getGeometry() != domain) {
                gradFeatureFunction.setGeometry((PgPointSet)domain);
            }
        }
        gradFeatureFunction.setName("Gradient Of Feature Function");
        int noe = domain.getNumElements();
        PiVector[] element = domain.getElements();
        PdVector[] vertex = domain.getVertices();
        double[] ctg = new double[3];
        PdVector[] edge = PdVector.realloc(null, (int)3, (int)dim);
        PdVector[] gradFi = PdVector.realloc(null, (int)3, (int)dim);
        PdVector[] vector = gradFeatureFunction.getVectors();
        int i = 0;
        while (i < noe) {
            int[] elem = element[i].m_data;
            double area = domain.getAreaOfElement(i);
            PuVectorGeom.ctg((double[])ctg, (PdVector)vertex[elem[0]], (PdVector)vertex[elem[1]], (PdVector)vertex[elem[2]]);
            int k = 0;
            while (k < 3) {
                edge[k].sub(vertex[elem[(k + 2) % 3]], vertex[elem[(k + 1) % 3]]);
                ++k;
            }
            k = 0;
            while (k < 3) {
                gradFi[k].blend(ctg[(k + 1) % 3], edge[(k + 1) % 3], -ctg[(k + 2) % 3], edge[(k + 2) % 3]);
                gradFi[k].multScalar(1.0 / (2.0 * area));
                ++k;
            }
            vector[i].setConstant(0.0);
            double d = featureFunction.m_data[elem[0]];
            gradFi[0].multScalar(d);
            vector[i].add(gradFi[0]);
            k = 1;
            while (k < 3) {
                d = featureFunction.m_data[elem[k]];
                if (PdVector.dot((PdVector)kappaMaxDir[elem[k]], (PdVector)kappaMaxDir[elem[0]]) < 0.0) {
                    d = -d;
                }
                gradFi[k].multScalar(d);
                vector[i].add(gradFi[k]);
                ++k;
            }
            ++i;
        }
        return gradFeatureFunction;
    }
}

