/*
 * Decompiled with CFR 0.152.
 */
package devCovering;

import devCovering.PgCovering;
import devCovering.PgFrameField;
import devCovering.PnFrameField;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgUtil;
import jvx.numeric.PnSparseMatrix;

public class PnStiffMatrixOnCovering {
    private static PdVector m_values = new PdVector(3);
    private static PdVector m_xValues = new PdVector(3);
    private static PdVector m_yValues = new PdVector(3);

    public static PnSparseMatrix computeStiffnessMatrix(PgElementSet geom, PgCovering covering, PiVector[] vertexRotation, boolean conforming, PdVector weights) {
        int numVariables = conforming ? 2 * geom.getNumVertices() : 2 * geom.getNumEdges();
        PnSparseMatrix stiff = new PnSparseMatrix(numVariables, numVariables, 5);
        PdVector[] vertex = geom.getVertices();
        PdVector[] edge = new PdVector[]{new PdVector(3), new PdVector(3), new PdVector(3)};
        PdMatrix entries = new PdMatrix(2);
        int numElements = geom.getNumElements();
        int numLayers = covering.getSymmetryOrder();
        int e = 0;
        while (e < numElements) {
            PiVector neighbour = geom.getNeighbours()[e];
            PiVector element = geom.getElement(e);
            PiVector edges = geom.getElementEdges()[e];
            double invArea = 0.5 / geom.getAreaOfElement(e);
            edge[0].sub(vertex[element.m_data[2]], vertex[element.m_data[1]]);
            edge[1].sub(vertex[element.m_data[0]], vertex[element.m_data[2]]);
            edge[2].sub(vertex[element.m_data[1]], vertex[element.m_data[0]]);
            double w = weights == null ? 1.0 : weights.m_data[e];
            int locInd = 0;
            while (locInd < 3) {
                block13: {
                    int r;
                    int i;
                    block12: {
                        block11: {
                            if (!conforming) break block11;
                            i = element.m_data[locInd];
                            r = vertexRotation[e].m_data[locInd];
                            if (r != Integer.MAX_VALUE) break block12;
                            break block13;
                        }
                        if (neighbour.m_data[locInd] < 0) break block13;
                        i = edges.m_data[locInd];
                        r = PnStiffMatrixOnCovering.getRotation(covering, e, neighbour.m_data[locInd], locInd);
                    }
                    int k = 0;
                    while (k < 3) {
                        block15: {
                            int rot;
                            int j;
                            block16: {
                                block14: {
                                    if (!conforming) break block14;
                                    if (vertexRotation[e].m_data[k] == Integer.MAX_VALUE) break block15;
                                    j = element.m_data[k];
                                    rot = vertexRotation[e].m_data[k] - r;
                                    break block16;
                                }
                                if (neighbour.m_data[k] < 0) break block15;
                                j = edges.m_data[k];
                                rot = PnStiffMatrixOnCovering.getRotation(covering, e, neighbour.m_data[k], k) - r;
                            }
                            double value = w * invArea * edge[locInd].dot(edge[k]);
                            if (!conforming) {
                                value *= 2.0;
                            }
                            entries.setIdentity();
                            entries.multScalar(value);
                            PnFrameField.rot(entries, -rot, numLayers);
                            if (entries.m_data[0][0] != 0.0) {
                                stiff.appendEntry(2 * j, 2 * i, entries.m_data[0][0]);
                            }
                            if (entries.m_data[0][1] != 0.0) {
                                stiff.appendEntry(2 * j, 2 * i + 1, entries.m_data[0][1]);
                            }
                            if (entries.m_data[1][0] != 0.0) {
                                stiff.appendEntry(2 * j + 1, 2 * i, entries.m_data[1][0]);
                            }
                            if (entries.m_data[1][1] != 0.0) {
                                stiff.appendEntry(2 * j + 1, 2 * i + 1, entries.m_data[1][1]);
                            }
                        }
                        ++k;
                    }
                }
                ++locInd;
            }
            ++e;
        }
        stiff.validate();
        return stiff;
    }

    public static PdVector computeRightVector(PgElementSet geom, PgFrameField field, PiVector[] vertexRotation, PdVector[][] potentialSummand, boolean bConforming, boolean bRotateGradient, PdVector weights) {
        if (geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Surface is not triangulated.");
            return null;
        }
        int numVariables = bConforming ? 2 * geom.getNumVertices() : 2 * geom.getNumEdges();
        PdVector gradient = new PdVector(numVariables);
        PdVector[] vertex = geom.getVertices();
        PiVector[] neighbour = geom.getNeighbours();
        PiVector[] edgeIndices = geom.getElementEdges();
        int numElements = geom.getNumElements();
        int numLayers = field.getCovering().getSymmetryOrder();
        PdVector vectorX = new PdVector(3);
        PdVector vectorY = new PdVector(3);
        PdVector edge = new PdVector(3);
        PdVector grad = new PdVector(2);
        int e = 0;
        while (e < numElements) {
            PiVector element = geom.getElement(e);
            if (bConforming) {
                PnStiffMatrixOnCovering.calcGradX(geom, e, vectorX, potentialSummand, bRotateGradient);
                PnStiffMatrixOnCovering.calcGradY(geom, e, vectorY, potentialSummand, bRotateGradient);
                vectorX.sub(field.getField(0).getVector(e));
                vectorY.sub(field.getField(1).getVector(e));
            } else {
                vectorX.multScalar(field.getField(0).getVector(e), -1.0);
                vectorY.multScalar(field.getField(1).getVector(e), -1.0);
            }
            double w = weights == null ? 1.0 : weights.m_data[e];
            int k = 0;
            while (k < 3) {
                block9: {
                    int i;
                    int r;
                    block10: {
                        block8: {
                            edge.sub(vertex[element.m_data[(k + 2) % 3]], vertex[element.m_data[(k + 1) % 3]]);
                            if (!bConforming) break block8;
                            r = vertexRotation[e].m_data[k];
                            if (r == Integer.MAX_VALUE) break block9;
                            i = element.m_data[k];
                            edge.cross(geom.getElementNormal(e), edge);
                            break block10;
                        }
                        int ne = neighbour[e].m_data[k];
                        if (ne == -1) break block9;
                        i = edgeIndices[e].m_data[k];
                        r = PnStiffMatrixOnCovering.getRotation(field.getCovering(), e, ne, k);
                    }
                    grad.set(vectorX.dot(edge), vectorY.dot(edge));
                    PnFrameField.rot(grad, -r, numLayers);
                    int n = 2 * i;
                    gradient.m_data[n] = gradient.m_data[n] - w * grad.m_data[0];
                    int n2 = 2 * i + 1;
                    gradient.m_data[n2] = gradient.m_data[n2] - w * grad.m_data[1];
                }
                ++k;
            }
            ++e;
        }
        return gradient;
    }

    private static PdVector calcGradX(PgElementSet geom, int elementIdx, PdVector vector, PdVector[][] potentialSummand, boolean rotateGradient) {
        if (potentialSummand == null) {
            vector.setConstant(0.0);
            return vector;
        }
        int i = 0;
        while (i < 3) {
            PnStiffMatrixOnCovering.m_values.m_data[i] = potentialSummand[elementIdx][i].m_data[0];
            ++i;
        }
        vector = PgUtil.calcLinearGradient((PgElementSet)geom, (int)elementIdx, (PdVector)m_values, (PdVector)vector);
        if (rotateGradient) {
            vector.cross(geom.getElementNormal(elementIdx), vector);
        }
        return vector;
    }

    private static PdVector calcGradY(PgElementSet geom, int elementIdx, PdVector vector, PdVector[][] potentialSummand, boolean rotateGradient) {
        if (potentialSummand == null) {
            vector.setConstant(0.0);
            return vector;
        }
        int i = 0;
        while (i < 3) {
            PnStiffMatrixOnCovering.m_values.m_data[i] = potentialSummand[elementIdx][i].m_data[1];
            ++i;
        }
        vector = PgUtil.calcLinearGradient((PgElementSet)geom, (int)elementIdx, (PdVector)m_values, (PdVector)vector);
        if (rotateGradient) {
            vector.cross(geom.getElementNormal(elementIdx), vector);
        }
        return vector;
    }

    public static int getRotation(PgCovering covering, int e, int ne, int locNeighbInd) {
        if (ne < 0) {
            return 0;
        }
        if (e < ne) {
            return 0;
        }
        return PuMath.modulo((int)(-covering.getMatching(e, locNeighbInd)), (int)covering.getSymmetryOrder());
    }

    public static void calcGrad(PgElementSet geom, PiVector[] vertexRotation, int numLayers, int elementIdx, PdVector coord, PdVector vectorX, PdVector vectorY, PdVector[][] potentialSummand, boolean rotateGradient) {
        PiVector element = geom.getElement(elementIdx);
        PdVector temp = new PdVector(2);
        int i = 0;
        while (i < 3) {
            double summandY;
            double summandX = potentialSummand != null ? potentialSummand[elementIdx][i].m_data[0] : 0.0;
            double d = summandY = potentialSummand != null ? potentialSummand[elementIdx][i].m_data[1] : 0.0;
            if (coord == null || vertexRotation[elementIdx].m_data[i] == Integer.MAX_VALUE) {
                PnStiffMatrixOnCovering.m_xValues.m_data[i] = summandX;
                PnStiffMatrixOnCovering.m_yValues.m_data[i] = summandY;
            } else {
                temp.m_data[0] = coord.m_data[2 * element.m_data[i]];
                temp.m_data[1] = coord.m_data[2 * element.m_data[i] + 1];
                PnFrameField.rot(temp, vertexRotation[elementIdx].m_data[i], numLayers);
                PnStiffMatrixOnCovering.m_xValues.m_data[i] = summandX + temp.m_data[0];
                PnStiffMatrixOnCovering.m_yValues.m_data[i] = summandY + temp.m_data[1];
            }
            ++i;
        }
        PgUtil.calcLinearGradient((PgElementSet)geom, (int)elementIdx, (PdVector)m_xValues, (PdVector)vectorX);
        PgUtil.calcLinearGradient((PgElementSet)geom, (int)elementIdx, (PdVector)m_yValues, (PdVector)vectorY);
        if (rotateGradient) {
            vectorX.cross(geom.getElementNormal(elementIdx), vectorX);
            vectorY.cross(geom.getElementNormal(elementIdx), vectorY);
        }
    }

    public static PdVector calcGradNonConf(PgElementSet geom, PgCovering covering, int elementIdx, PdVector coord, PdVector gradX, PdVector gradY, boolean rotateGradient) {
        PiVector edgeIndices = geom.getElementEdges()[elementIdx];
        PiVector neighbour = geom.getNeighbour(elementIdx);
        PdVector temp = new PdVector(2);
        int numLayers = covering.getSymmetryOrder();
        int i = 0;
        while (i < 3) {
            temp.m_data[0] = coord.m_data[2 * edgeIndices.m_data[i]];
            temp.m_data[1] = coord.m_data[2 * edgeIndices.m_data[i] + 1];
            int r = PnStiffMatrixOnCovering.getRotation(covering, elementIdx, neighbour.m_data[i], i);
            PnFrameField.rot(temp, r, numLayers);
            PnStiffMatrixOnCovering.m_xValues.m_data[i] = temp.m_data[0];
            PnStiffMatrixOnCovering.m_yValues.m_data[i] = temp.m_data[1];
            ++i;
        }
        gradX = PgUtil.calcLinearGradient((PgElementSet)geom, (int)elementIdx, (PdVector)m_xValues, (PdVector)gradX);
        gradY = PgUtil.calcLinearGradient((PgElementSet)geom, (int)elementIdx, (PdVector)m_yValues, (PdVector)gradY);
        gradX.multScalar(-2.0);
        gradY.multScalar(-2.0);
        if (rotateGradient) {
            PdVector normal = geom.getElementNormal(elementIdx);
            gradX.cross(normal, gradX);
            gradY.cross(normal, gradY);
        }
        return gradX;
    }
}

