/*
 * Decompiled with CFR 0.152.
 */
package devCovering;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgUtil;
import jvx.numeric.PnSparseMatrix;

public class PnStiffMatrix {
    private PgElementSet m_geom;
    private boolean m_conforming;
    private int m_numVertices;

    public PnStiffMatrix(PgElementSet geom, boolean conforming) {
        this.m_geom = geom;
        if (this.m_geom.getElementEdges() == null) {
            this.m_geom.setEnabledEdges(true);
            this.m_geom.makeEdgeStars();
        }
        this.m_conforming = conforming;
        this.m_numVertices = this.m_geom.getNumVertices();
    }

    public int getNumOfVariables() {
        if (this.m_conforming) {
            return this.m_numVertices;
        }
        return this.m_geom.getNumEdges();
    }

    public static PnSparseMatrix computeMatrixEntries(PgElementSet m_geom, boolean bConforming, boolean zeroAtBoundary) {
        int numElements = m_geom.getNumElements();
        int dim = bConforming ? m_geom.getNumVertices() : m_geom.getNumEdges();
        PnSparseMatrix stiff = new PnSparseMatrix(dim, dim);
        PdVector[] vertex = m_geom.getVertices();
        PdVector[] edge = new PdVector[]{new PdVector(3), new PdVector(3), new PdVector(3)};
        int e = 0;
        while (e < numElements) {
            PiVector neighbour = m_geom.getNeighbours()[e];
            PiVector element = m_geom.getElement(e);
            PiVector edges = m_geom.getElementEdges()[e];
            double invArea = 0.5 / m_geom.getAreaOfElement(e);
            edge[0].sub(vertex[element.m_data[2]], vertex[element.m_data[1]]);
            edge[1].sub(vertex[element.m_data[0]], vertex[element.m_data[2]]);
            edge[2].sub(vertex[element.m_data[1]], vertex[element.m_data[0]]);
            int locInd = 0;
            while (locInd < 3) {
                int i = bConforming ? element.m_data[locInd] : edges.m_data[locInd];
                int k = 0;
                while (k < 3) {
                    if (!zeroAtBoundary || bConforming || neighbour.m_data[k] >= 0) {
                        int j = bConforming ? element.m_data[k] : edges.m_data[k];
                        double value = invArea * edge[locInd].dot(edge[k]);
                        if (!bConforming) {
                            value *= 2.0;
                        }
                        stiff.appendEntry(j, i, value);
                    }
                    ++k;
                }
                ++locInd;
            }
            ++e;
        }
        stiff.validate();
        return stiff;
    }

    public static PnSparseMatrix computeJMatrixEntries(PgElementSet m_geom, boolean bConforming, boolean zeroAtBoundary) {
        int numElements = m_geom.getNumElements();
        int dim = bConforming ? m_geom.getNumVertices() : m_geom.getNumEdges();
        PnSparseMatrix stiff = new PnSparseMatrix(dim, dim);
        PdVector[] vertex = m_geom.getVertices();
        PdVector[] edge = new PdVector[]{new PdVector(3), new PdVector(3), new PdVector(3)};
        PdVector[] Jedge = new PdVector[]{new PdVector(3), new PdVector(3), new PdVector(3)};
        int e = 0;
        while (e < numElements) {
            PiVector neighbour = m_geom.getNeighbours()[e];
            PiVector element = m_geom.getElement(e);
            PiVector edges = m_geom.getElementEdges()[e];
            double invArea = 0.5 / m_geom.getAreaOfElement(e);
            PdVector normal = m_geom.getElementNormal(e);
            edge[0].sub(vertex[element.m_data[2]], vertex[element.m_data[1]]);
            edge[1].sub(vertex[element.m_data[0]], vertex[element.m_data[2]]);
            edge[2].sub(vertex[element.m_data[1]], vertex[element.m_data[0]]);
            Jedge[0].cross(normal, edge[0]);
            Jedge[1].cross(normal, edge[1]);
            Jedge[2].cross(normal, edge[2]);
            int locInd = 0;
            while (locInd < 3) {
                int i = bConforming ? element.m_data[locInd] : edges.m_data[locInd];
                int k = 0;
                while (k < 3) {
                    if (!zeroAtBoundary || bConforming || neighbour.m_data[k] >= 0) {
                        int j = bConforming ? element.m_data[k] : edges.m_data[k];
                        double value = invArea * edge[locInd].dot(Jedge[k]);
                        if (!bConforming) {
                            value *= 2.0;
                        }
                        stiff.appendEntry(j, i, value);
                    }
                    ++k;
                }
                ++locInd;
            }
            ++e;
        }
        stiff.validate();
        return stiff;
    }

    public static PdVector evalRightVectorConforming(PgElementSet geom, double[][] potentialSummand) {
        if (geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Surface is not triangulated.");
            return null;
        }
        PdVector gradient = new PdVector(geom.getNumVertices());
        PdVector vector = new PdVector(3);
        PdVector edge = new PdVector(3);
        PdVector values = new PdVector(3);
        PdVector[] vertex = geom.getVertices();
        int numElements = geom.getNumElements();
        int e = 0;
        while (e < numElements) {
            if (potentialSummand != null) {
                values.set(potentialSummand[e]);
            }
            PgUtil.calcLinearGradient((PgElementSet)geom, (int)e, (PdVector)values, (PdVector)vector);
            PiVector element = geom.getElement(e);
            int k = 0;
            while (k < 3) {
                int i = element.m_data[k];
                edge.sub(vertex[element.m_data[(k + 2) % 3]], vertex[element.m_data[(k + 1) % 3]]);
                edge.cross(geom.getElementNormal(e), edge);
                int n = i;
                gradient.m_data[n] = gradient.m_data[n] + 2.0 * vector.dot(edge);
                ++k;
            }
            ++e;
        }
        gradient.multScalar(-1.0);
        return gradient;
    }

    public static PdVector evalRightVectorNonConforming(PgElementSet geom, double[][] potentialSummand) {
        if (geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Surface is not triangulated.");
            return null;
        }
        PdVector gradient = new PdVector(geom.getNumEdges());
        PdVector edge = new PdVector(3);
        PdVector values = new PdVector(3);
        PdVector vector = new PdVector(3);
        PdVector[] vertex = geom.getVertices();
        PiVector[] neighbour = geom.getNeighbours();
        PiVector[] edgeIndices = geom.getElementEdges();
        int numElements = geom.getNumElements();
        int e = 0;
        while (e < numElements) {
            PiVector element = geom.getElement(e);
            if (potentialSummand != null) {
                values.m_data = potentialSummand[e];
            }
            PgUtil.calcLinearGradientNonConforming((PgElementSet)geom, (int)e, (PdVector)values, (PdVector)vector);
            vector.cross(geom.getElementNormal(e), vector);
            int i = 0;
            while (i < 3) {
                if (neighbour[e].m_data[i] >= 0) {
                    int ind;
                    edge.sub(vertex[element.m_data[(i + 2) % 3]], vertex[element.m_data[(i + 1) % 3]]);
                    int n = ind = edgeIndices[e].m_data[i];
                    gradient.m_data[n] = gradient.m_data[n] - vector.dot(edge);
                }
                ++i;
            }
            ++e;
        }
        return gradient;
    }
}

