/*
 * Decompiled with CFR 0.152.
 */
package devCovering;

import devCovering.PgCovering;
import devCovering.PgFrameField;
import devCovering.PnCovering;
import devGraph.PgGraphOnElementSet;
import devGraph.PnAbstractGraph;
import devGraph.PnGraphOnElementSet;
import devProjection.PgIntrinsicPolygon;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgVertexStar;
import jvx.geom.PwCurvature;
import jvx.vector.PwVectorField;

public class PnFrameField {
    public static String[] NAME_MATCHING_METHODS = new String[]{"Angle", "Stripes", "Length+Angle", "Potential", "Trivial"};
    public static final int METHOD_FRAME_ANGLE = 0;
    public static final int METHOD_FRAME_LENGTH = 2;
    public static final int METHOD_STRIPE = 1;
    public static final int METHOD_POTENTIAL_BASED = 3;
    public static final int METHOD_TRIVIAL = 4;
    private static PdVector m_edge = null;

    public static void makeCovering(PgFrameField field, PdVector[] curvatures, int method) {
        PgElementSet geom = field.getGeometry();
        if (geom == null) {
            PsDebug.warning((String)"No geometry set.");
            return;
        }
        if (field.getNumFields() == 0) {
            PsDebug.warning((String)"No vector fields set.");
            return;
        }
        int numElements = geom.getNumElements();
        PiVector[] neighb = geom.getNeighbours();
        PgCovering covering = field.getCovering();
        PiVector[] matching = covering.getMatching();
        int e = 0;
        while (e < numElements) {
            PiVector element = geom.getElement(e);
            int dim = element.getSize();
            int i = 0;
            while (i < dim) {
                int ne = neighb[e].m_data[i];
                if (ne < 0) {
                    matching[e].m_data[i] = Integer.MAX_VALUE;
                } else if (e <= ne) {
                    int m = 0;
                    switch (method) {
                        case 0: {
                            m = PnFrameField.calcMatchingFrameAngle(field.getField(0), field.getCovering().getSymmetryOrder(), e, ne);
                            break;
                        }
                        case 2: {
                            m = PnFrameField.calcMatchingFrameLength(field, e, ne);
                            break;
                        }
                        case 1: {
                            m = PnFrameField.calcMatchingStripe(field, e, ne);
                            break;
                        }
                        case 3: {
                            m = PnFrameField.calcMatchingPotentialBased(field, e, ne);
                            break;
                        }
                        case 4: {
                            m = 0;
                        }
                    }
                    covering.setMatching(e, i, m);
                }
                ++i;
            }
            ++e;
        }
        field.getCovering().updateBranchpoints();
    }

    public static void makeCovering(PgFrameField field, PgVectorField mField) {
        if (field == null) {
            PsDebug.warning((String)"No frame field.");
            return;
        }
        PnCovering.makeCoveringFromVectorField(field.getCovering(), mField);
    }

    public static PgFrameField makeFrameFieldFromVectorFields(PgElementSet geom, PgVectorField vf1, PgVectorField vf2, int symmetryOrder) {
        geom.allocateEdgeStars();
        PgVectorField[] fields = new PgVectorField[]{vf1, vf2};
        PgFrameField field = new PgFrameField(new PgCovering(geom, symmetryOrder));
        field.setFields(fields);
        return field;
    }

    public static PgFrameField makeFrameFieldFromVectorFields(PgElementSet geom, PgVectorField[] vf) {
        geom.allocateEdgeStars();
        PgFrameField field = new PgFrameField(new PgCovering(geom, 2 * vf.length));
        field.setFields(vf);
        return field;
    }

    public static int calcMatchingFrameAngle(PgVectorField field, int symmetryOrder, int e1, int e2) {
        double alpha = PwVectorField.calcAngle((PgVectorField)field, (int)e2, (int)e1);
        return (symmetryOrder + (int)Math.round(alpha * (double)symmetryOrder / (Math.PI * 2))) % symmetryOrder;
    }

    public static int calcMatchingFrameLength(PgFrameField field, int e1, int e2) {
        double THRESHOLD = 0.25;
        int numLayers = field.getCovering().getSymmetryOrder();
        if (e1 > e2) {
            return (numLayers - PnFrameField.calcMatchingFrameLength(field, e2, e1)) % numLayers;
        }
        double maxLenV = Double.MIN_VALUE;
        double minLenV = Double.MAX_VALUE;
        PdVector v = null;
        int vIdx = -1;
        int i = 0;
        while (i < 2) {
            PdVector vec = field.m_fields[i].getVector(e1);
            double l = vec.sqrLength();
            if (l > maxLenV) {
                maxLenV = l;
                v = vec;
                vIdx = i;
            }
            if (l < minLenV) {
                minLenV = l;
            }
            ++i;
        }
        int wIdx = -1;
        double maxLenW = Double.MIN_VALUE;
        double minLenW = Double.MAX_VALUE;
        int i2 = 0;
        while (i2 < 2) {
            PdVector vec = field.m_fields[i2].getVector(e2);
            double l = vec.sqrLength();
            if (l < minLenW) {
                minLenW = l;
            }
            if (vec.dot(v) > 0.0 && l > maxLenW) {
                maxLenW = l;
                wIdx = i2;
            }
            ++i2;
        }
        if (minLenV / maxLenV < 0.25 && minLenW / maxLenW < 0.25) {
            return (4 + wIdx - vIdx) % 4;
        }
        return PnFrameField.calcMatchingFrameAngle(field.getField(0), field.getCovering().getSymmetryOrder(), e1, e2);
    }

    public static int calcMatchingStripe(PgFrameField field, int e1, int e2) {
        int numLayers = field.getCovering().getSymmetryOrder();
        if (e1 > e2) {
            return (numLayers - PnFrameField.calcMatchingStripe(field, e2, e1)) % numLayers;
        }
        int max1 = 0;
        int max2 = 1;
        if (field.getField(max2).getVector(e2).dot(field.getField(max1).getVector(e1)) < 0.0) {
            return 2 + (max2 - max1);
        }
        return PuMath.modulo((int)(max2 - max1), (int)4);
    }

    public static int calcMatchingPotentialBased(PgFrameField field, int e1, int e2) {
        int numLayers = field.getCovering().getSymmetryOrder();
        if (e1 > e2) {
            return (numLayers - PnFrameField.calcMatchingPotentialBased(field, e2, e1)) % numLayers;
        }
        PgElementSet geom = field.getGeometry();
        PiVector element1 = geom.getElement(e1);
        int locInd = geom.getNeighbour(e1).getIndexOf(e2);
        if (locInd < 0) {
            PsDebug.warning((String)"e1 and e2 are not neighbours");
            return 0;
        }
        PdVector edge = new PdVector(3);
        edge.sub(geom.getVertex(element1.m_data[(locInd + 2) % 3]), geom.getVertex(element1.m_data[(locInd + 1) % 3]));
        PdVector texEdge1 = new PdVector(2);
        PdVector texEdge2 = new PdVector(2);
        texEdge1.set(edge.dot(field.getField(0).getVector(e1)), edge.dot(field.getField(1).getVector(e1)));
        texEdge2.set(edge.dot(field.getField(0).getVector(e2)), edge.dot(field.getField(1).getVector(e2)));
        if (texEdge1.sqrLength() <= 1.0E-10 || texEdge2.sqrLength() <= 1.0E-10) {
            return 0;
        }
        return PuMath.modulo((int)((int)Math.round(PdVector.angleWithOrientation((PdVector)texEdge1, (PdVector)texEdge2, (PdVector)new PdVector(1.0, 0.0, 0.0)) * 2.0 / Math.PI)), (int)4);
    }

    public static PiVector calcIndices(PgFrameField field, int numLayers, PiVector buffer) {
        PgVertexStar star = new PgVertexStar();
        PgElementSet geom = field.getGeometry();
        PgCovering covering = field.getCovering();
        int numV = geom.getNumVertices();
        if (buffer == null) {
            buffer = new PiVector(numV);
        } else {
            buffer.setSize(numV);
        }
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        PdVector gauss = new PdVector();
        PwCurvature.getGaussCurvature((PgElementSet)geom, (PdVector)gauss);
        int v = 0;
        while (v < numV) {
            star.makeVertexStar(geom, v, elementPerVertex.m_data[v]);
            if (!star.isClosed()) {
                buffer.m_data[v] = 0;
            } else {
                double angleSum = 0.0;
                PiVector elements = star.getElement();
                PiVector locInd = star.getVertexLocInd();
                int starSize = elements.getSize();
                int j = 0;
                while (j < starSize) {
                    PiVector elem = geom.getElement(elements.m_data[j]);
                    int idOfV = locInd.m_data[j];
                    int elSize = elem.getSize();
                    int e1 = elements.m_data[j];
                    int neighInd = (elSize + idOfV - 2) % elSize;
                    int e2 = geom.getNeighbour(e1).getEntry(neighInd);
                    int r = covering.getMatching(e1, neighInd);
                    double angle = (double)r * (Math.PI * 2) / (double)numLayers;
                    if ((angle -= PwVectorField.calcAngle((PgVectorField)field.getField(0), (int)e2, (int)e1)) > Math.PI) {
                        angle -= Math.PI * 2;
                    }
                    if (angle < -Math.PI) {
                        angle += Math.PI * 2;
                    }
                    angleSum += angle;
                    ++j;
                }
                buffer.m_data[v] = (int)Math.round((angleSum + gauss.m_data[v]) * (double)numLayers / (Math.PI * 2));
            }
            ++v;
        }
        return buffer;
    }

    public static int calcIndex(PgFrameField field, int numLayers, int vertexInd, int elemInd) {
        PgVertexStar star = new PgVertexStar();
        PgElementSet geom = field.getGeometry();
        PgCovering covering = field.getCovering();
        star.makeVertexStar(geom, vertexInd, elemInd);
        if (!star.isClosed()) {
            return 0;
        }
        double angleSum = 0.0;
        PiVector elements = star.getElement();
        PiVector locInd = star.getVertexLocInd();
        int starSize = elements.getSize();
        int j = 0;
        while (j < starSize) {
            PiVector elem = geom.getElement(elements.m_data[j]);
            int idOfV = locInd.m_data[j];
            int elSize = elem.getSize();
            int e1 = elements.m_data[j];
            int neighInd = (elSize + idOfV - 2) % elSize;
            int e2 = geom.getNeighbour(e1).getEntry(neighInd);
            int r = covering.getMatching(e1, neighInd);
            double angle = (double)r * (Math.PI * 2) / (double)numLayers;
            if ((angle -= PwVectorField.calcAngle((PgVectorField)field.getField(0), (int)e2, (int)e1)) > Math.PI) {
                angle -= Math.PI * 2;
            }
            if (angle < -Math.PI) {
                angle += Math.PI * 2;
            }
            angleSum += angle;
            ++j;
        }
        double gauss = PwCurvature.getGaussCurvature((PgElementSet)geom, (int)vertexInd, (int)elements.getFirstEntry());
        return (int)Math.round((angleSum + gauss) * (double)numLayers / (Math.PI * 2));
    }

    public static void alignVectors(PgFrameField field) {
        PnFrameField.alignVectors(field, null);
    }

    public static void alignVectors(PgFrameField field, PgGraphOnElementSet tree) {
        PgElementSet geom = field.getGeometry();
        PgCovering covering = field.getCovering();
        int symmOrder = covering.getSymmetryOrder();
        if (symmOrder != 4 && symmOrder != 6) {
            PsDebug.warning((String)"symmetry order of field must be 4 or 6.");
            return;
        }
        PdVector tmp = new PdVector(geom.getDimOfVectors());
        if (tree == null) {
            tree = new PgGraphOnElementSet(geom, 1);
            PnGraphOnElementSet.makeShortestPathTree(tree);
        }
        PiVector successors = PnAbstractGraph.makeSuccessors(tree);
        int e = tree.getRoots().m_data[0];
        while (e >= 0) {
            int pe = tree.getParent(e);
            if (pe >= 0) {
                int locInd = geom.getNeighbour(e).getIndexOf(pe);
                int r = covering.getMatching(e, locInd);
                if (symmOrder == 6) {
                    PdVector field0 = field.getVector(e, PuMath.modulo((int)(-r), (int)symmOrder), 0, null);
                    PdVector field1 = field.getVector(e, PuMath.modulo((int)(-r), (int)symmOrder), 1, null);
                    field.m_fields[0].getVector(e).copy(field0);
                    field.m_fields[1].getVector(e).copy(field1);
                } else {
                    switch (PuMath.modulo((int)r, (int)symmOrder)) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            tmp.copyArray(field.m_fields[0].getVector(e));
                            field.m_fields[0].getVector(e).multScalar(field.m_fields[1].getVector(e), -1.0);
                            field.m_fields[1].setVector(e, tmp);
                            break;
                        }
                        case 2: {
                            field.m_fields[0].getVector(e).multScalar(-1.0);
                            field.m_fields[1].getVector(e).multScalar(-1.0);
                            break;
                        }
                        case 3: {
                            tmp.copyArray(field.m_fields[0].getVector(e));
                            field.m_fields[0].setVector(e, field.m_fields[1].getVector(e));
                            field.m_fields[1].getVector(e).multScalar(tmp, -1.0);
                        }
                    }
                }
                if (r != 0) {
                    int i = 0;
                    while (i < 3) {
                        int m = covering.getMatching(e, i);
                        if (m != Integer.MAX_VALUE) {
                            covering.setMatching(e, i, m - r);
                        }
                        ++i;
                    }
                }
            }
            e = successors.m_data[e];
        }
    }

    public static PdVector[][] integrate(PgElementSet geom, PgFrameField field, PdVector[][] potential, PgGraphOnElementSet tree) {
        return PnFrameField.integrate(geom, field, potential, tree, -1, null);
    }

    public static PdVector[][] integrate(PgElementSet geom, PgFrameField field, PdVector[][] potential, PgGraphOnElementSet tree, int rootElement, PdBary bary) {
        int dim;
        int e;
        int numElements = geom.getNumElements();
        if (potential == null) {
            potential = new PdVector[numElements][];
            e = 0;
            while (e < numElements) {
                dim = geom.getDimOfElement(e);
                potential[e] = PdVector.realloc(null, (int)dim, (int)2);
                ++e;
            }
        } else {
            e = 0;
            while (e < numElements) {
                dim = geom.getDimOfElement(e);
                int i = 0;
                while (i < dim) {
                    potential[e][i].setConstant(0.0);
                    ++i;
                }
                ++e;
            }
        }
        PiVector roots = tree.getRoots();
        PiVector successors = PnAbstractGraph.makeSuccessors(tree);
        int numLayers = field.getCovering().getSymmetryOrder();
        int numRoots = roots.getSize();
        int rootIdx = 0;
        while (rootIdx < numRoots) {
            int e2 = roots.m_data[rootIdx];
            while (e2 >= 0) {
                PiVector element = geom.getElement(e2);
                int pe = tree.getParent(e2);
                int locIdx = 0;
                if (pe >= 0) {
                    PiVector pElement = geom.getElement(pe);
                    locIdx = geom.getNeighbour(e2).getIndexOf(pe);
                    int pLocIdx = geom.getNeighbour(pe).getIndexOf(e2);
                    int m = field.m_covering.getMatching(e2, locIdx);
                    int r = -m;
                    locIdx = (locIdx + 1) % element.getSize();
                    pLocIdx = (pLocIdx + 2) % pElement.getSize();
                    PnFrameField.rot(potential[pe][pLocIdx], r, numLayers, potential[e2][locIdx]);
                }
                if (rootElement == e2) {
                    PnFrameField.integrateElement(geom, e2, bary, field, potential[e2]);
                } else {
                    PnFrameField.integrateElement(geom, e2, locIdx, field, potential[e2]);
                }
                e2 = successors.m_data[e2];
            }
            ++rootIdx;
        }
        return potential;
    }

    public static PdVector rot(PdVector in, int r, int numLayers, PdVector out) {
        if (numLayers == 4) {
            switch (r & 3) {
                case 0: {
                    out.m_data[0] = in.m_data[0];
                    out.m_data[1] = in.m_data[1];
                    break;
                }
                case 1: {
                    out.m_data[0] = -in.m_data[1];
                    out.m_data[1] = in.m_data[0];
                    break;
                }
                case 2: {
                    out.m_data[0] = -in.m_data[0];
                    out.m_data[1] = -in.m_data[1];
                    break;
                }
                case 3: {
                    out.m_data[0] = in.m_data[1];
                    out.m_data[1] = -in.m_data[0];
                }
            }
            return out;
        }
        r = PuMath.modulo((int)r, (int)numLayers);
        double sin = Math.sin((double)r * 2.0 * Math.PI / (double)numLayers);
        double cos = Math.cos((double)r * 2.0 * Math.PI / (double)numLayers);
        out.m_data[0] = cos * in.m_data[0] - sin * in.m_data[1];
        out.m_data[1] = sin * in.m_data[0] + cos * in.m_data[1];
        return out;
    }

    public static PdVector rot(PdVector inOut, int r, int numLayers) {
        if (inOut.getSize() != 2) {
            PsDebug.warning((String)"Input vector has wrong dimension.");
            return null;
        }
        if (numLayers == 4) {
            switch (r & 3) {
                case 0: {
                    break;
                }
                case 1: {
                    double temp = inOut.m_data[0];
                    inOut.m_data[0] = -inOut.m_data[1];
                    inOut.m_data[1] = temp;
                    break;
                }
                case 2: {
                    inOut.m_data[0] = -inOut.m_data[0];
                    inOut.m_data[1] = -inOut.m_data[1];
                    break;
                }
                case 3: {
                    double temp = inOut.m_data[0];
                    inOut.m_data[0] = inOut.m_data[1];
                    inOut.m_data[1] = -temp;
                }
            }
            return inOut;
        }
        r = PuMath.modulo((int)r, (int)numLayers);
        double sin = Math.sin((double)r * 2.0 * Math.PI / (double)numLayers);
        double cos = Math.cos((double)r * 2.0 * Math.PI / (double)numLayers);
        double tmpX = cos * inOut.m_data[0] - sin * inOut.m_data[1];
        double tmpY = sin * inOut.m_data[0] + cos * inOut.m_data[1];
        inOut.m_data[0] = tmpX;
        inOut.m_data[1] = tmpY;
        return inOut;
    }

    public static PdMatrix rot(PdMatrix inOut, int r, int numLayers) {
        double cos;
        double sin;
        if (inOut.getSize() != 2) {
            PsDebug.warning((String)"Input vector has wrong dimension.");
            return null;
        }
        if ((r = PuMath.modulo((int)r, (int)numLayers)) == 0) {
            return inOut;
        }
        switch (numLayers) {
            case 4: {
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[3] = -1;
                sin = nArray[r];
                int[] nArray2 = new int[4];
                nArray2[0] = 1;
                nArray2[2] = -1;
                cos = nArray2[r];
                break;
            }
            default: {
                sin = Math.sin((double)r * 2.0 * Math.PI / (double)numLayers);
                cos = Math.cos((double)r * 2.0 * Math.PI / (double)numLayers);
            }
        }
        double a00 = inOut.m_data[0][0];
        double a01 = inOut.m_data[0][1];
        double a10 = inOut.m_data[1][0];
        double a11 = inOut.m_data[1][1];
        inOut.m_data[0][0] = cos * a00 - sin * a10;
        inOut.m_data[0][1] = cos * a01 - sin * a11;
        inOut.m_data[1][0] = sin * a00 + cos * a10;
        inOut.m_data[1][1] = sin * a01 + cos * a11;
        return inOut;
    }

    public static PiVector shift(PiVector inputVector, PiVector shiftedVector, int r) {
        int[] data = inputVector.m_data;
        switch (r & 3) {
            case 0: {
                shiftedVector.m_data[0] = data[0];
                shiftedVector.m_data[1] = data[1];
                break;
            }
            case 1: {
                shiftedVector.m_data[0] = -data[1];
                shiftedVector.m_data[1] = data[0];
                break;
            }
            case 2: {
                shiftedVector.m_data[0] = -data[0];
                shiftedVector.m_data[1] = -data[1];
                break;
            }
            case 3: {
                shiftedVector.m_data[0] = data[1];
                shiftedVector.m_data[1] = -data[0];
            }
        }
        return shiftedVector;
    }

    public static PiVector shift(PiVector vector, int r) {
        int[] data = vector.m_data;
        switch (r & 3) {
            case 0: {
                return vector;
            }
            case 1: {
                int temp = data[0];
                data[0] = -data[1];
                data[1] = temp;
                break;
            }
            case 2: {
                data[0] = -data[0];
                data[1] = -data[1];
                break;
            }
            case 3: {
                int temp = data[0];
                data[0] = data[1];
                data[1] = -temp;
            }
        }
        return vector;
    }

    public static void rotateFrames(PgFrameField field, double[] elementFun) {
        if (field == null) {
            PsDebug.warning((String)"Missing frame field.");
            return;
        }
        PgElementSet geom = field.getGeometry();
        if (geom == null) {
            PsDebug.warning((String)"Missing geometry.");
            return;
        }
        int numElements = geom.getNumElements();
        if (elementFun == null || elementFun.length != numElements) {
            PsDebug.warning((String)"Missing function or incorrect length.");
            return;
        }
        geom.assureElementNormals();
        int i = 0;
        while (i < field.getNumFields()) {
            PgVectorField vf = field.getField(i);
            int e = 0;
            while (e < numElements) {
                PdVector v = vf.getVector(e);
                PuVectorGeom.rotatePointAroundVector((PdVector)v, (PdVector)v, (PdVector)geom.getElementNormal(e), (double)elementFun[e]);
                ++e;
            }
            ++i;
        }
    }

    public static void integrateElement(PgElementSet geom, int elementIdx, int locIdx, PgFrameField field, PdVector[] texCoord) {
        if (m_edge == null) {
            m_edge = new PdVector(3);
        }
        PiVector element = geom.getElement(elementIdx);
        int dim = element.getSize();
        PdVector vec0 = field.getField(0).getVector(elementIdx);
        PdVector vec1 = field.getField(1).getVector(elementIdx);
        double u = texCoord[locIdx].m_data[0];
        double v = texCoord[locIdx].m_data[1];
        int i = 0;
        while (i < dim) {
            if (i != locIdx) {
                m_edge.sub(geom.getVertex(element.m_data[i]), geom.getVertex(element.m_data[locIdx]));
                texCoord[i].m_data[0] = u + m_edge.dot(vec0);
                texCoord[i].m_data[1] = v + m_edge.dot(vec1);
            }
            ++i;
        }
    }

    public static void integrateElement(PgElementSet geom, int elementIdx, PdBary bary, PgFrameField field, PdVector[] texCoord) {
        if (m_edge == null) {
            m_edge = new PdVector(3);
        }
        PiVector element = geom.getElement(elementIdx);
        PdVector origin = new PdVector(3);
        bary.getVertex(origin, geom.getVertex(element.m_data[0]), geom.getVertex(element.m_data[1]), geom.getVertex(element.m_data[2]));
        int dim = element.getSize();
        PdVector vec0 = field.getField(0).getVector(elementIdx);
        PdVector vec1 = field.getField(1).getVector(elementIdx);
        int i = 0;
        while (i < dim) {
            m_edge.sub(geom.getVertex(element.m_data[i]), origin);
            texCoord[i].m_data[0] = m_edge.dot(vec0);
            texCoord[i].m_data[1] = m_edge.dot(vec1);
            ++i;
        }
    }

    public static double integrateOnPath(PgElementSet geom, PgFrameField field, PgIntrinsicPolygon poly, int startLayer) {
        PiVector elements = poly.getElements();
        PdVector[] vertices = poly.getVertices();
        PiVector[] neighb = geom.getNeighbours();
        PgCovering cov = field.getCovering();
        int num = poly.getNumVertices();
        PdVector tmp = new PdVector(3);
        double value = 0.0;
        int layer = startLayer;
        int v = 0;
        while (v < num - 1) {
            int pe = elements.m_data[v];
            int e = elements.m_data[v + 1];
            if (pe != e) {
                int locInd = neighb[pe].getIndexOf(e);
                if (locInd < 0) {
                    PsDebug.warning((String)"Error in neighbours");
                    return 0.0;
                }
                layer = (layer + cov.getMatching(pe, locInd)) % 4;
            }
            field.getVector(e, layer, 0, tmp);
            value += Math.abs(tmp.dot(vertices[v + 1]) - tmp.dot(vertices[v]));
            ++v;
        }
        return value;
    }

    public static double calcAngle(PgFrameField field, int e, int locNeighbInd) {
        int ne = field.getGeometry().getNeighbour((int)e).m_data[locNeighbInd];
        if (ne < 0) {
            PsDebug.warning((String)"Neighbour does not exist.");
            return 0.0;
        }
        PdVector[] normals = field.getGeometry().getElementNormals();
        PgVectorField vfield = field.getField(0);
        double angle = PwVectorField.angleWithNormals((PdVector)vfield.getVector(e), (PdVector)normals[e], (PdVector)vfield.getVector(ne), (PdVector)normals[ne]);
        PgCovering cov = field.getCovering();
        if (cov != null) {
            angle += 1.5707963267948966 * (double)cov.getMatching(e, locNeighbInd);
        }
        return angle;
    }
}

